/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.database.DatabaseTableModel;
import com.jidesoft.grid.AbstractPageTableModel;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.DefaultTableModelWrapper;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.IndexChangeEvent;
import com.jidesoft.grid.IndexChangeEventGenerator;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.IndexedRowTableModelWrapper;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.WrapperOfIndexdRowTableModelWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.EventListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DefaultPageTableModel
extends AbstractPageTableModel
implements IndexChangeEventGenerator,
ColumnIdentifierTableModel,
IndexedRowTableModelWrapper,
ITreeTableModel,
WrapperOfIndexdRowTableModelWrapper {
    private DefaultTableModelWrapper _tableModelWrapper;
    private TableModelListener _tableModelListener;
    private IndexChangeListener _indexChangeListener;
    private static final long serialVersionUID = 4687847383669027444L;

    public DefaultPageTableModel(TableModel tableModel) {
        this(tableModel, 10);
    }

    public DefaultPageTableModel(TableModel tableModel, int n) {
        super(n);
        this.setTableModel(tableModel);
    }

    public void setTableModel(TableModel tableModel) {
        boolean bl = false;
        if (this._tableModelWrapper != null) {
            if (this._tableModelListener != null) {
                this._tableModelWrapper.removeTableModelListener(this._tableModelListener);
            }
            if (this._indexChangeListener != null) {
                this._tableModelWrapper.removeIndexChangeListener(this._indexChangeListener);
            }
            bl = true;
        }
        this._tableModelWrapper = new DefaultTableModelWrapper(tableModel){
            private static final long serialVersionUID = -7700078970515821582L;
            private int _previousPageCount;

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                this._previousPageCount = DefaultPageTableModel.this.getPageCount();
                DefaultPageTableModel.this.updatePageCount(tableModelEvent);
                super.tableChanged(tableModelEvent);
                if (this._previousPageCount == DefaultPageTableModel.this.getPageCount()) {
                    DefaultPageTableModel.this.setCurrentPage(Math.min(DefaultPageTableModel.this.getCurrentPage(), DefaultPageTableModel.this.getPageCount() - 1), true);
                }
            }

            @Override
            protected void tableDataChanged(CompoundTableModelEvent compoundTableModelEvent) {
                if (compoundTableModelEvent == null || compoundTableModelEvent.getEvents() == null || compoundTableModelEvent.getEvents().length <= 0) {
                    this.tableDataChanged();
                    return;
                }
                CompoundTableModelEvent compoundTableModelEvent2 = this.createCompoundTableModelEvent();
                block5: for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
                    switch (tableModelEvent.getType()) {
                        case 1: {
                            this.internalTableRowsInserted(compoundTableModelEvent2, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                            continue block5;
                        }
                        case -1: {
                            this.internalTableRowsDeleted(compoundTableModelEvent2, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                            continue block5;
                        }
                        case 0: {
                            if (tableModelEvent.getColumn() == -1) {
                                this.internalTableRowsUpdated(compoundTableModelEvent2, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                                continue block5;
                            }
                            this.internalTableCellsUpdated(compoundTableModelEvent2, tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                            continue block5;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown Embedded TableModelEvent type: " + tableModelEvent.getType());
                        }
                    }
                }
                CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent2);
                DefaultPageTableModel.this.setCurrentPage(Math.min(DefaultPageTableModel.this.getCurrentPage(), DefaultPageTableModel.this.getPageCount() - 1), true);
            }

            @Override
            protected void tableRowsUpdated(int n, int n2) {
                CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
                this.internalTableRowsUpdated(compoundTableModelEvent, n, n2);
                CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
            }

            private void internalTableRowsUpdated(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
                if (this._indexes != null && this._indexes.length > 0) {
                    n = Math.max(n, this._indexes[0]);
                    if (this._indexes[this._indexes.length - 1] >= 0) {
                        n2 = Math.min(n2, this._indexes[this._indexes.length - 1]);
                    }
                }
                if (n <= n2) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, this.getVisualRowAt(n), this.getVisualRowAt(n2), -1, 0));
                }
            }

            @Override
            protected void tableCellsUpdated(int n, int n2, int n3) {
                CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
                this.internalTableCellsUpdated(compoundTableModelEvent, n, n2, n3);
                CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
            }

            private void internalTableCellsUpdated(CompoundTableModelEvent compoundTableModelEvent, int n, int n2, int n3) {
                if (this._indexes != null && this._indexes.length > 0) {
                    n2 = Math.max(n2, this._indexes[0]);
                    if (this._indexes[this._indexes.length - 1] >= 0) {
                        n3 = Math.min(n3, this._indexes[this._indexes.length - 1]);
                    }
                }
                if (n2 <= n3) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, this.getVisualRowAt(n2), this.getVisualRowAt(n3), n, 0));
                }
            }

            @Override
            protected void tableRowsInserted(int n, int n2) {
                CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
                this.internalTableRowsInserted(compoundTableModelEvent, n, n2);
                CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
                DefaultPageTableModel.this.setCurrentPage(Math.min(DefaultPageTableModel.this.getCurrentPage(), DefaultPageTableModel.this.getPageCount() - 1), true);
            }

            private void internalTableRowsInserted(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
                DefaultPageTableModel.this.reallocateIndexes();
                while (n <= n2 && this.getVisualRowAt(n) < 0) {
                    ++n;
                }
                while (n2 >= n && this.getVisualRowAt(n2) < 0) {
                    --n2;
                }
                if (n <= n2) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, this.getVisualRowAt(n), this.getVisualRowAt(n2), -1, 1));
                }
            }

            @Override
            protected void tableRowsDeleted(int n, int n2) {
                CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
                this.internalTableRowsDeleted(compoundTableModelEvent, n, n2);
                CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
                DefaultPageTableModel.this.setCurrentPage(Math.min(DefaultPageTableModel.this.getCurrentPage(), DefaultPageTableModel.this.getPageCount() - 1), true);
            }

            private void internalTableRowsDeleted(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
                int n3 = DefaultPageTableModel.this.getPageSize();
                int n4 = DefaultPageTableModel.this.getCurrentPage();
                int n5 = n3 > 0 ? n3 * n4 : 0;
                int n6 = Math.min(n5 + n3 - 1, DefaultPageTableModel.this.getTotalRecordCount() - 1 + (n2 - n + 1));
                int n7 = -1;
                boolean bl = false;
                if (n5 <= n && n <= n6) {
                    n7 = Math.min(n6, n2) - n + 1;
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, this.getVisualRowAt(n), this.getVisualRowAt(Math.min(n6, n2)), -1, -1));
                }
                if (n7 > 0 && n4 < this._previousPageCount - 1) {
                    bl = true;
                }
                DefaultPageTableModel.this.reallocateIndexes();
                if (bl && (n = DefaultPageTableModel.this.getActualRowAt(n3 - n7)) >= 0) {
                    int n8;
                    n2 = n;
                    for (int i = n3 - n7 + 1; i < n3 && (n8 = DefaultPageTableModel.this.getActualRowAt(i)) >= 0; ++i) {
                        n2 = n8;
                    }
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, this.getVisualRowAt(n), this.getVisualRowAt(n2), -1, 1));
                }
            }

            @Override
            protected void tableDataChanged() {
                DefaultPageTableModel.this.reallocateIndexes();
                super.tableDataChanged();
            }

            @Override
            protected void tableStructureChanged() {
                DefaultPageTableModel.this.reallocateIndexes();
                super.tableStructureChanged();
            }
        };
        this._tableModelWrapper.setCacheEnabled(false);
        this._tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                CompoundTableModelEvent compoundTableModelEvent = DefaultPageTableModel.this.createCompoundTableModelEvent();
                if (tableModelEvent instanceof CompoundTableModelEvent) {
                    compoundTableModelEvent.setOriginalEvent(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent());
                }
                if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getEvents() != null && ((CompoundTableModelEvent)tableModelEvent).getEvents().length > 0) {
                    for (TableModelEvent tableModelEvent2 : ((CompoundTableModelEvent)tableModelEvent).getEvents()) {
                        compoundTableModelEvent.addEvent(new TableModelEvent(DefaultPageTableModel.this, tableModelEvent2.getFirstRow(), tableModelEvent2.getLastRow(), tableModelEvent2.getColumn(), tableModelEvent2.getType()));
                    }
                } else {
                    compoundTableModelEvent.addEvent(new TableModelEvent(DefaultPageTableModel.this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
                }
                CompoundTableModelEvent.fireTableModelEvent(DefaultPageTableModel.this, compoundTableModelEvent);
            }
        };
        this._tableModelWrapper.addTableModelListener(this._tableModelListener);
        this._indexChangeListener = new IndexChangeListener(){

            @Override
            public void indexChanged(IndexChangeEvent indexChangeEvent) {
                EventListener[] eventListenerArray = DefaultPageTableModel.this.listenerList.getListeners(IndexChangeListener.class);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    ((IndexChangeListener)eventListenerArray[i]).indexChanged(indexChangeEvent);
                }
            }
        };
        this._tableModelWrapper.addIndexChangeListener(this._indexChangeListener);
        this.pageSizeChanged(-1, this.getPageSize());
        this.fireTableStructureChanged();
    }

    private void updatePageCount(TableModelEvent tableModelEvent) {
        int n = ((TableModel)tableModelEvent.getSource()).getRowCount();
        int n2 = n / this.getPageSize() + (n % this.getPageSize() == 0 ? 0 : 1);
        this.setPageCount(n2);
    }

    @Override
    public int getActualRowAt(int n) {
        return this._tableModelWrapper.getActualRowAt(n);
    }

    @Override
    public int getVisualRowAt(int n) {
        return this._tableModelWrapper.getVisualRowAt(n);
    }

    @Override
    public TableModel getActualModel() {
        return this._tableModelWrapper.getActualModel();
    }

    @Override
    public void addIndexChangeListener(IndexChangeListener indexChangeListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, IndexChangeListener.class, (EventListener)indexChangeListener)) {
            this.listenerList.add(IndexChangeListener.class, indexChangeListener);
        }
    }

    @Override
    public void removeIndexChangeListener(IndexChangeListener indexChangeListener) {
        this.listenerList.remove(IndexChangeListener.class, indexChangeListener);
    }

    @Override
    public IndexChangeListener[] getIndexChangeListeners() {
        return new IndexChangeListener[0];
    }

    int fireIndexChanging(boolean bl) {
        IndexChangeListener[] indexChangeListenerArray = (IndexChangeListener[])this.getListeners(IndexChangeListener.class);
        int n = Double.valueOf(Math.random() * 10000.0).intValue();
        for (IndexChangeListener indexChangeListener : indexChangeListenerArray) {
            indexChangeListener.indexChanged(new IndexChangeEvent(this, 0, n, false, bl));
        }
        return n;
    }

    void fireIndexChanged(int n) {
        IndexChangeListener[] indexChangeListenerArray;
        for (IndexChangeListener indexChangeListener : indexChangeListenerArray = (IndexChangeListener[])this.getListeners(IndexChangeListener.class)) {
            indexChangeListener.indexChanged(new IndexChangeEvent(this, 1, n, false, false));
        }
    }

    @Override
    protected void pageCountChanged(int n, int n2) {
    }

    @Override
    protected void pageIndexChanged(int n, int n2) {
        int n3 = this.fireIndexChanging(false);
        this.reallocateIndexes();
        this.fireTableDataChanged();
        this.fireIndexChanged(n3);
    }

    @Override
    public int getColumnCount() {
        return this._tableModelWrapper.getColumnCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._tableModelWrapper.getValueAt(n, n2);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this._tableModelWrapper.getColumnClass(n);
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        return this._tableModelWrapper.getConverterContextAt(n, n2);
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        return this._tableModelWrapper.getEditorContextAt(n, n2);
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        return this._tableModelWrapper.getCellClassAt(n, n2);
    }

    @Override
    public String getColumnName(int n) {
        return this._tableModelWrapper.getColumnName(n);
    }

    @Override
    public Object getColumnIdentifier(int n) {
        return this._tableModelWrapper.getColumnIdentifier(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this._tableModelWrapper.setValueAt(object, n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this._tableModelWrapper.isCellEditable(n, n2);
    }

    @Override
    public int getTotalRecordCount() {
        return this._tableModelWrapper.getActualModel().getRowCount();
    }

    @Override
    public void setTotalRecordCount(int n) {
    }

    @Override
    public int[] getIndexes() {
        return this._tableModelWrapper.getIndexes();
    }

    @Override
    public void setIndexes(int[] nArray) {
        this._tableModelWrapper.setIndexes(nArray);
    }

    protected void reallocateIndexes() {
        int[] nArray = this._tableModelWrapper.getIndexes();
        if (nArray == null || nArray.length != this.getPageSize()) {
            nArray = new int[this.getPageSize()];
        }
        int n = this.getCurrentPage() * this.getPageSize();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = n + i;
            nArray[i] = n2 >= this.getTotalRecordCount() ? -1 : n2;
        }
        this._tableModelWrapper.setIndexes(nArray);
    }

    public boolean isUpdatable() {
        return this._tableModelWrapper.getActualModel() instanceof DatabaseTableModel && ((DatabaseTableModel)this._tableModelWrapper.getActualModel()).isUpdatable();
    }

    @Override
    public int getColumnType(int n) {
        TableModel tableModel = this._tableModelWrapper.getActualModel();
        if (tableModel instanceof MultiTableModel) {
            return ((MultiTableModel)tableModel).getColumnType(n);
        }
        return super.getColumnType(n);
    }

    @Override
    public int getTableIndex(int n) {
        TableModel tableModel = this._tableModelWrapper.getActualModel();
        if (tableModel instanceof MultiTableModel) {
            return ((MultiTableModel)tableModel).getTableIndex(n);
        }
        return super.getTableIndex(n);
    }

    @Override
    public Row getRowAt(int n) {
        if (this._tableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            return ((ITreeTableModel)((Object)this._tableModelWrapper.getActualModel())).getRowAt(n);
        }
        return null;
    }

    public int getRowIndex(Row row) {
        if (this._tableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            return ((ITreeTableModel)((Object)this._tableModelWrapper.getActualModel())).getRowIndex(row);
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        if (this._tableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            return ((ITreeTableModel)((Object)this._tableModelWrapper.getActualModel())).getRoot();
        }
        return null;
    }

    @Override
    public IndexedRowTableModelWrapper getIndexedRowTableModelWrapper() {
        return this._tableModelWrapper;
    }
}

