/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.Cacheable;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.GroupCondition;
import com.jidesoft.grid.GroupRow;
import com.jidesoft.grid.GroupableTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.grid.TreeTableUtils;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.ObjectGrouperManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;

public class DefaultGroupRow
extends DefaultExpandableRow
implements GroupRow,
GroupCondition,
Comparable,
Cacheable {
    private List<Condition> _conditions;
    private Object _filtered = INVALID_VALUE;

    public DefaultGroupRow() {
        this._conditions = new ArrayList<Condition>();
    }

    public void addCondition(int n, Object object) {
        this.addCondition(n, object, null);
    }

    public void addCondition(int n, Object object, ObjectGrouper objectGrouper) {
        for (Condition condition : this._conditions) {
            if (condition.columnIndex != n) continue;
            condition.grouper = objectGrouper;
            condition.value = object;
            return;
        }
        this._conditions.add(new Condition(n, object, objectGrouper));
    }

    public void removeCondition(int n) {
        for (int i = 0; i < this._conditions.size(); ++i) {
            Condition condition = this._conditions.get(i);
            if (condition.columnIndex != n) continue;
            this._conditions.remove(condition);
        }
    }

    public void clearConditions() {
        this._conditions.clear();
    }

    public Object getConditionValueAsString(int n) {
        try {
            Condition condition = this._conditions.get(n);
            if (condition.grouper != null) {
                return ObjectConverterManager.toString(condition.value, condition.grouper.getType(), condition.grouper.getConverterContext());
            }
            if (condition.value != null) {
                return ObjectConverterManager.toString(condition.value, condition.value.getClass());
            }
            return "";
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ConverterContext getConverterContextAt(int n) {
        TreeTableModel treeTableModel = this.getTreeTableModel();
        if (treeTableModel instanceof DefaultGroupTableModel) {
            boolean bl = ((DefaultGroupTableModel)treeTableModel).isDisplayGroupColumns();
            boolean bl2 = ((DefaultGroupTableModel)treeTableModel).isDisplayCountColumn();
            boolean bl3 = ((DefaultGroupTableModel)treeTableModel).isKeepColumnOrder();
            boolean bl4 = ((DefaultGroupTableModel)treeTableModel).isSummaryMode();
            if (bl && (!bl2 || n != 0)) {
                int n2;
                int n3 = n - (bl2 ? 1 : 0);
                if (bl3) {
                    n2 = n3;
                    n3 = -1;
                    for (int i = 0; i < this.getNumberOfConditions(); ++i) {
                        if (this.getConditionColumn(i) != n2) continue;
                        n3 = i;
                        break;
                    }
                } else if (bl4) {
                    n2 = ((DefaultGroupTableModel)treeTableModel).getActualColumnAt(n);
                    n3 = -1;
                    for (int i = 0; i < this.getNumberOfConditions(); ++i) {
                        if (this.getConditionColumn(i) != n2) continue;
                        n3 = i;
                        break;
                    }
                }
                if (n3 >= 0 && n3 < this.getNumberOfConditions()) {
                    try {
                        ObjectGrouper objectGrouper = this._conditions.get((int)n3).grouper;
                        if (objectGrouper != null) {
                            return objectGrouper.getConverterContext();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return super.getConverterContextAt(n);
    }

    @Override
    public Class<?> getCellClassAt(int n) {
        TreeTableModel treeTableModel = this.getTreeTableModel();
        if (treeTableModel instanceof DefaultGroupTableModel) {
            boolean bl = ((DefaultGroupTableModel)treeTableModel).isDisplayGroupColumns();
            boolean bl2 = ((DefaultGroupTableModel)treeTableModel).isDisplayCountColumn();
            boolean bl3 = ((DefaultGroupTableModel)treeTableModel).isKeepColumnOrder();
            boolean bl4 = ((DefaultGroupTableModel)treeTableModel).isSummaryMode();
            if (bl && (!bl2 || n != 0)) {
                int n2;
                int n3;
                int n4 = n - (bl2 ? 1 : 0);
                if (bl3) {
                    n3 = n4;
                    n4 = -1;
                    for (n2 = 0; n2 < this.getNumberOfConditions(); ++n2) {
                        if (this.getConditionColumn(n2) != n3) continue;
                        n4 = n2;
                        break;
                    }
                } else if (bl4) {
                    n3 = ((DefaultGroupTableModel)treeTableModel).getActualColumnAt(n);
                    n4 = -1;
                    for (n2 = 0; n2 < this.getNumberOfConditions(); ++n2) {
                        if (this.getConditionColumn(n2) != n3) continue;
                        n4 = n2;
                        break;
                    }
                }
                if (n4 >= 0 && n4 < this.getNumberOfConditions()) {
                    try {
                        ObjectGrouper objectGrouper = this._conditions.get((int)n4).grouper;
                        if (objectGrouper != null) {
                            return objectGrouper.getType();
                        }
                        TableModel tableModel = ((DefaultGroupTableModel)treeTableModel).getActualModel();
                        if (tableModel != null) {
                            return tableModel.getColumnClass(this._conditions.get((int)n4).columnIndex);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return super.getCellClassAt(n);
    }

    @Override
    public Object getConditionValue(int n) {
        try {
            return this._conditions.get((int)n).value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getConditionColumn(int n) {
        try {
            return this._conditions.get((int)n).columnIndex;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public int getNumberOfConditions() {
        return this._conditions == null ? 0 : this._conditions.size();
    }

    @Override
    public boolean satisfies(TableModel tableModel, int n) {
        if (this._conditions != null) {
            for (Condition condition : this._conditions) {
                if (!(condition.grouper != null ? !DefaultGroupRow.equals(condition.value, condition.grouper.getValue(tableModel.getValueAt(n, condition.columnIndex))) : !DefaultGroupRow.equals(condition.value, tableModel.getValueAt(n, condition.columnIndex)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public GroupCondition configureParentCondition(GroupCondition groupCondition) {
        if (this.getNumberOfConditions() > 1) {
            for (int i = 0; i < this._conditions.size() - 1; ++i) {
                Condition condition = this._conditions.get(i);
                ((DefaultGroupRow)groupCondition).addCondition(condition.columnIndex, condition.value, condition.grouper);
            }
            return groupCondition;
        }
        return null;
    }

    @Override
    public boolean contains(GroupCondition groupCondition) {
        for (int i = 0; i < this._conditions.size(); ++i) {
            Condition condition = this._conditions.get(i);
            if (i >= groupCondition.getNumberOfConditions()) {
                return false;
            }
            if (DefaultGroupRow.equals(groupCondition.getConditionValue(i), condition.value)) continue;
            return false;
        }
        return true;
    }

    private static synchronized boolean equals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object2 != null && object.equals(object2);
    }

    @Override
    public Object getValueAt(int n) {
        TreeTableModel treeTableModel = this.getTreeTableModel();
        if (treeTableModel instanceof DefaultGroupTableModel) {
            boolean bl = ((DefaultGroupTableModel)treeTableModel).isDisplayGroupColumns();
            boolean bl2 = ((DefaultGroupTableModel)treeTableModel).isDisplaySeparateGroupColumn();
            boolean bl3 = ((DefaultGroupTableModel)treeTableModel).isDisplayCountColumn();
            boolean bl4 = ((DefaultGroupTableModel)treeTableModel).isKeepColumnOrder();
            boolean bl5 = ((DefaultGroupTableModel)treeTableModel).isSummaryMode();
            if (bl3 && n == 0) {
                return TreeTableUtils.getDescendantCount(treeTableModel, this, true, true);
            }
            if (bl) {
                if (!bl4 && !bl5) {
                    int n2 = n - (bl3 ? 1 : 0);
                    if (n2 >= 0 && n2 < this.getNumberOfConditions()) {
                        return this.getConditionValue(n2);
                    }
                } else if (bl4) {
                    int n3 = n - (bl3 ? 1 : 0);
                    for (int i = 0; i < this.getNumberOfConditions(); ++i) {
                        if (this.getConditionColumn(i) != n3) continue;
                        return this.getConditionValue(i);
                    }
                } else {
                    int n4 = ((DefaultGroupTableModel)treeTableModel).getActualColumnAt(n);
                    for (int i = 0; i < this.getNumberOfConditions(); ++i) {
                        if (this.getConditionColumn(i) != n4) continue;
                        return this.getConditionValue(i);
                    }
                }
            } else {
                return this;
            }
        }
        return null;
    }

    @Override
    public boolean removeChild(Object object) {
        Expandable expandable = this.getParent();
        boolean bl = super.removeChild(object);
        if (bl && this.getChildrenCount() == 0 && expandable != null) {
            expandable.removeChild(this);
        }
        return bl;
    }

    @Override
    public IExpandableTreeTableModel getExpandableTreeTableModel() {
        Expandable expandable = this.getParent();
        if (expandable instanceof RootExpandableRow) {
            return ((RootExpandableRow)expandable).getExpandableTreeTableModel();
        }
        if (expandable instanceof GroupRow) {
            return ((GroupRow)((Object)expandable)).getTreeTableModel();
        }
        return null;
    }

    public int compareTo(Object object) {
        if (object instanceof DefaultGroupRow) {
            DefaultGroupRow defaultGroupRow = (DefaultGroupRow)object;
            if (defaultGroupRow.contains(this)) {
                return -1;
            }
            if (this.contains(defaultGroupRow)) {
                return 1;
            }
            int n = Math.max(this.getNumberOfConditions(), defaultGroupRow.getNumberOfConditions());
            for (int i = 0; i < n; ++i) {
                Object object2;
                Object object3 = i >= this.getNumberOfConditions() ? null : this.getConditionValue(i);
                int n2 = ObjectComparatorManager.compare(object3, object2 = i > defaultGroupRow.getNumberOfConditions() ? null : defaultGroupRow.getConditionValue(i));
                if (n2 == 0) continue;
                return n2;
            }
        }
        return 0;
    }

    @Override
    public Object getCachedValue() {
        return this._filtered;
    }

    @Override
    public void setCachedValue(Object object) {
        this._filtered = object;
    }

    @Override
    public boolean isCacheValid() {
        return this._filtered != INVALID_VALUE;
    }

    @Override
    public void invalidateCache() {
        this._filtered = INVALID_VALUE;
        if (this.isExpanded() && this.getChildren() != null) {
            for (Object obj : this.getChildren()) {
                if (!(obj instanceof Cacheable)) continue;
                ((Cacheable)obj).invalidateCache();
            }
        }
    }

    @Override
    public void invalidateCache(Object object) {
        if (this._filtered == object) {
            this._filtered = INVALID_VALUE;
            if (this.isExpanded() && this.getChildren() != null) {
                for (Object obj : this.getChildren()) {
                    if (!(obj instanceof Cacheable)) continue;
                    ((Cacheable)obj).invalidateCache(object);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        DefaultGroupTableModel defaultGroupTableModel = (DefaultGroupTableModel)this.getTreeTableModel();
        for (int i = 0; i < this.getNumberOfConditions(); ++i) {
            stringBuffer.append(" ");
            if (!defaultGroupTableModel.isSingleLevelGrouping() && i != this.getNumberOfConditions() - 1) continue;
            int n = this.getConditionColumn(i);
            TableModel tableModel = defaultGroupTableModel.getActualModel();
            stringBuffer.append(tableModel.getColumnName(n));
            stringBuffer.append(": ");
            ObjectGrouper objectGrouper = null;
            if (tableModel instanceof GroupableTableModel) {
                objectGrouper = ObjectGrouperManager.getGrouper(tableModel.getColumnClass(n), ((GroupableTableModel)tableModel).getGrouperContext(n));
            }
            if (tableModel instanceof ContextSensitiveTableModel) {
                try {
                    stringBuffer.append(ObjectConverterManager.toString(this.getConditionValue(i), objectGrouper == null ? ((ContextSensitiveTableModel)tableModel).getCellClassAt(0, n) : objectGrouper.getType(), objectGrouper == null ? ((ContextSensitiveTableModel)tableModel).getConverterContextAt(0, n) : objectGrouper.getConverterContext()));
                }
                catch (Exception exception) {
                    stringBuffer.append(ObjectConverterManager.toString(this.getConditionValue(i), tableModel.getColumnClass(n), null));
                }
                continue;
            }
            stringBuffer.append(ObjectConverterManager.toString(this.getConditionValue(i), objectGrouper == null ? tableModel.getColumnClass(n) : objectGrouper.getType(), objectGrouper == null ? null : objectGrouper.getConverterContext()));
        }
        return stringBuffer.toString();
    }

    private static class Condition {
        Object value;
        int columnIndex;
        ObjectGrouper grouper;

        public Condition(int n, Object object, ObjectGrouper objectGrouper) {
            this.columnIndex = n;
            this.grouper = objectGrouper;
            this.value = object;
        }
    }
}

