/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.ValueConverter;
import com.jidesoft.grid.ValueStringAdjustProvider;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class CsvTableUtils {
    public static boolean export(JTable jTable, String string) throws IOException {
        return CsvTableUtils.export(jTable, string, true);
    }

    public static boolean export(JTable jTable, String string, boolean bl) throws IOException {
        return CsvTableUtils.export(jTable, string, bl, null);
    }

    public static boolean export(JTable jTable, String string, boolean bl, ValueConverter valueConverter) throws IOException {
        return CsvTableUtils.export(jTable, string, bl, valueConverter, null);
    }

    public static boolean export(JTable jTable, String string, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableUtils.export(jTable, 0, 0, -1, -1, string, bl, valueConverter, stringConverter);
    }

    public static boolean export(JTable jTable, int n, int n2, int n3, int n4, String string, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableUtils.export(jTable, n, n2, n3, n4, string, bl, valueConverter, stringConverter, ',');
    }

    public static boolean export(JTable jTable, int n, int n2, int n3, int n4, String string, boolean bl, ValueConverter valueConverter, StringConverter stringConverter, char c) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        CsvTableUtils.exportToCsv(jTable, fileOutputStream, n, n2, n3, n4, bl, valueConverter, stringConverter, c, Charset.defaultCharset().name());
        fileOutputStream.close();
        return true;
    }

    public static boolean export(JTable jTable, String string, CsvTableExportConfig csvTableExportConfig) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        CsvTableUtils.exportToCsv(jTable, fileOutputStream, csvTableExportConfig);
        fileOutputStream.close();
        return true;
    }

    private static void exportToCsv(JTable jTable, OutputStream outputStream, int n, int n2, int n3, int n4, boolean bl, ValueConverter valueConverter, StringConverter stringConverter, char c, String string) {
        int n5;
        int n6;
        StringBuffer stringBuffer = new StringBuffer();
        TableModel tableModel = jTable.getModel();
        if (n4 == -1) {
            n4 = jTable.getColumnCount();
        }
        if (n3 == -1) {
            n3 = jTable.getRowCount();
        }
        if (bl) {
            if (jTable.getTableHeader() instanceof NestedTableHeader) {
                NestedTableHeader nestedTableHeader = (NestedTableHeader)jTable.getTableHeader();
                n6 = nestedTableHeader.getRowCount();
                for (n5 = 0; n5 < n6; ++n5) {
                    for (int i = 0; i < n4 && n2 + i < jTable.getColumnCount(); ++i) {
                        String string2 = n5 == n6 - 1 ? jTable.getColumnName(n2 + i) : "" + nestedTableHeader.getHeaderValueAt(n + n5, n2 + i);
                        StyledLabel styledLabel = StyledLabelBuilder.createStyledLabel(string2);
                        if (styledLabel != null) {
                            string2 = styledLabel.getText();
                        }
                        CsvTableUtils.addCellValue(stringBuffer, stringConverter != null ? stringConverter.convert(string2) : string2, c);
                    }
                    CsvTableUtils.addLineBreak(stringBuffer);
                }
            } else {
                for (int i = 0; i < n4 && n2 + i < jTable.getColumnCount(); ++i) {
                    String string3 = jTable.getColumnName(n2 + i);
                    StyledLabel styledLabel = StyledLabelBuilder.createStyledLabel(string3);
                    if (styledLabel != null) {
                        string3 = styledLabel.getText();
                    }
                    CsvTableUtils.addCellValue(stringBuffer, stringConverter != null ? stringConverter.convert(string3) : string3, c);
                }
                CsvTableUtils.addLineBreak(stringBuffer);
            }
        }
        for (int i = 0; i < n3 && n + i < jTable.getRowCount(); ++i) {
            for (n6 = 0; n6 < n4 && n2 + n6 < jTable.getColumnCount(); ++n6) {
                Object object;
                n5 = jTable.convertColumnIndexToModel(n2 + n6);
                if (n5 == -1) continue;
                if (jTable instanceof ValueStringAdjustProvider && ((ValueStringAdjustProvider)((Object)jTable)).needAdjustCellValueString(n + i, n2 + n6)) {
                    object = ((ValueStringAdjustProvider)((Object)jTable)).getValueAtInString(n + i, n2 + n6, valueConverter);
                } else {
                    object = tableModel.getValueAt(n + i, n5);
                    if (valueConverter != null) {
                        object = valueConverter.convert(jTable, object, i, n2 + n6);
                    }
                }
                CsvTableUtils.addCellValue(stringBuffer, object == null ? "" : object.toString(), c);
            }
            CsvTableUtils.addLineBreak(stringBuffer);
        }
        try {
            outputStream.write(stringBuffer.toString().getBytes(string));
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void exportToCsv(JTable jTable, OutputStream outputStream, CsvTableExportConfig csvTableExportConfig) {
        int n = csvTableExportConfig.getFirstRow();
        int n2 = csvTableExportConfig.getFirstColumn();
        int n3 = csvTableExportConfig.getNumOfRows();
        int n4 = csvTableExportConfig.getNumOfColumns();
        boolean bl = csvTableExportConfig.isHeaderIncluded();
        ValueConverter valueConverter = csvTableExportConfig.getCellValueConverter();
        StringConverter stringConverter = csvTableExportConfig.getColumnNameConverter();
        char c = csvTableExportConfig.getSeparator();
        String string = csvTableExportConfig.getCharsetName();
        CsvTableUtils.exportToCsv(jTable, outputStream, n, n2, n3, n4, bl, valueConverter, stringConverter, c, string);
    }

    public static void addCellValue(StringBuffer stringBuffer, String string, char c) {
        if (string.contains("" + c) || string.contains("\"") || string.contains("\r\n")) {
            String string2 = string.replaceAll("\"", "\"\"");
            stringBuffer.append("\"").append(string2).append("\"").append(c);
        } else {
            stringBuffer.append(string).append(c);
        }
    }

    public static void addLineBreak(StringBuffer stringBuffer) {
        stringBuffer.append("\r\n");
    }

    public static boolean export(JTable jTable, OutputStream outputStream) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, true);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, boolean bl) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, bl, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, boolean bl, ValueConverter valueConverter) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, bl, valueConverter, null);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, 0, 0, -1, -1, bl, valueConverter, stringConverter);
    }

    public static boolean export(JTable jTable, OutputStream outputStream, int n, int n2, int n3, int n4, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableUtils.export(jTable, outputStream, n, n2, n3, n4, bl, valueConverter, stringConverter, ',');
    }

    public static boolean export(JTable jTable, OutputStream outputStream, int n, int n2, int n3, int n4, boolean bl, ValueConverter valueConverter, StringConverter stringConverter, char c) throws IOException {
        CsvTableUtils.exportToCsv(jTable, outputStream, n, n2, n3, n4, bl, valueConverter, stringConverter, c, Charset.defaultCharset().name());
        return true;
    }

    public static boolean export(JTable jTable, OutputStream outputStream, CsvTableExportConfig csvTableExportConfig) throws IOException {
        CsvTableUtils.exportToCsv(jTable, outputStream, csvTableExportConfig);
        return true;
    }

    public static class CsvTableExportConfig {
        private boolean _headerIncluded = true;
        private ValueConverter _cellValueConverter = null;
        private StringConverter _columnNameConverter = null;
        private int _firstRow = 0;
        private int _firstColumn = 0;
        private int _numOfRows = -1;
        private int _numOfColumns = -1;
        private char _separator = (char)44;
        private String _charsetName = Charset.defaultCharset().name();

        public boolean isHeaderIncluded() {
            return this._headerIncluded;
        }

        public void setHeaderIncluded(boolean bl) {
            this._headerIncluded = bl;
        }

        public ValueConverter getCellValueConverter() {
            return this._cellValueConverter;
        }

        public void setCellValueConverter(ValueConverter valueConverter) {
            this._cellValueConverter = valueConverter;
        }

        public StringConverter getColumnNameConverter() {
            return this._columnNameConverter;
        }

        public void setColumnNameConverter(StringConverter stringConverter) {
            this._columnNameConverter = stringConverter;
        }

        public int getFirstRow() {
            return this._firstRow;
        }

        public void setFirstRow(int n) {
            this._firstRow = n;
        }

        public int getFirstColumn() {
            return this._firstColumn;
        }

        public void setFirstColumn(int n) {
            this._firstColumn = n;
        }

        public int getNumOfRows() {
            return this._numOfRows;
        }

        public void setNumOfRows(int n) {
            this._numOfRows = n;
        }

        public int getNumOfColumns() {
            return this._numOfColumns;
        }

        public void setNumOfColumns(int n) {
            this._numOfColumns = n;
        }

        public char getSeparator() {
            return this._separator;
        }

        public void setSeparator(char c) {
            this._separator = c;
        }

        public String getCharsetName() {
            return this._charsetName;
        }

        public void setCharsetName(String string) {
            this._charsetName = string;
        }
    }
}

