/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CsvTableUtils;
import com.jidesoft.grid.Field;
import com.jidesoft.grid.ValueConverter;
import com.jidesoft.grid.ValueStringAdjustProvider;
import com.jidesoft.pivot.HeaderTable;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class CsvPivotTableUtils {
    public static boolean export(PivotTablePane pivotTablePane, String string) throws IOException {
        return CsvPivotTableUtils.export(pivotTablePane, string, null);
    }

    public static boolean export(PivotTablePane pivotTablePane, String string, ValueConverter valueConverter) throws IOException {
        return CsvPivotTableUtils.export(pivotTablePane, string, valueConverter, ',');
    }

    public static boolean export(PivotTablePane pivotTablePane, String string, ValueConverter valueConverter, char c) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        CsvPivotTableUtils.exportToCsv(pivotTablePane, fileOutputStream, valueConverter, c, Charset.defaultCharset().name());
        fileOutputStream.close();
        return true;
    }

    private static Object getStringValue(JTable jTable, int n, int n2) {
        if (!(jTable instanceof HeaderTable)) {
            return jTable.getValueAt(n, n2);
        }
        return ((HeaderTable)jTable).getValueAtInString(n, n2, null);
    }

    private static void exportToCsv(PivotTablePane pivotTablePane, OutputStream outputStream, ValueConverter valueConverter, char c, String string) {
        Object object;
        int n;
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        JTable jTable = pivotTablePane.getColumnHeaderTable();
        JTable jTable2 = pivotTablePane.getRowHeaderTable();
        JTable jTable3 = pivotTablePane.getDataTable();
        ValueConverter valueConverter2 = new ValueConverter(){

            @Override
            public Object convert(JTable jTable, Object object, int n, int n2) {
                return CsvPivotTableUtils.getStringValue(jTable, n, n2);
            }
        };
        HashSet<Integer> hashSet = new HashSet<Integer>();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = jTable.getColumnCount() - 1; i >= 0; --i) {
            if (tableColumnModel.getColumn(i).getWidth() != 0) continue;
            hashSet.add(i);
        }
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        TableColumnModel tableColumnModel2 = jTable2.getColumnModel();
        for (n3 = tableColumnModel2.getColumnCount() - 1; n3 >= 0; --n3) {
            if (tableColumnModel2.getColumn(n3).getWidth() != 0) continue;
            hashSet2.add(n3);
        }
        n3 = jTable2.getColumnCount() - hashSet2.size();
        String string2 = "";
        if (jTable2.isVisible()) {
            for (int i = 0; i < n3; ++i) {
                string2 = string2 + c;
            }
        }
        if (string2.length() > 0 && pivotTablePane.getPivotDataModel().getDataFields().length == 1) {
            CsvTableUtils.addCellValue(stringBuffer, pivotTablePane.getPivotDataModel().getDataFields()[0].getTitle(), c);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append(string2);
        PivotField[] pivotFieldArray = pivotTablePane.getPivotDataModel().getColumnFields();
        if (pivotFieldArray.length > 0) {
            PivotField[] pivotFieldArray2 = pivotFieldArray;
            n2 = pivotFieldArray2.length;
            for (n = 0; n < n2; ++n) {
                object = pivotFieldArray2[n];
                CsvTableUtils.addCellValue(stringBuffer, ((Field)object).getTitle(), c);
            }
        }
        CsvTableUtils.addLineBreak(stringBuffer);
        if (jTable.isVisible()) {
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                if (i == jTable.getRowCount() - 1 && jTable2.isVisible()) {
                    for (n2 = 0; n2 < jTable2.getColumnCount(); ++n2) {
                        n = jTable2.convertColumnIndexToModel(n2);
                        if (n == -1 || hashSet2.contains(n2)) continue;
                        object = pivotTablePane.getPivotDataModel().getRowFields();
                        if (((PivotField[])object).length == 0 || n >= ((PivotField[])object).length) {
                            CsvTableUtils.addCellValue(stringBuffer, "", c);
                            continue;
                        }
                        PivotField pivotField = object[n];
                        CsvTableUtils.addCellValue(stringBuffer, pivotField.getTitle(), c);
                    }
                } else {
                    stringBuffer.append(string2);
                }
                for (n2 = 0; n2 < jTable.getColumnCount(); ++n2) {
                    n = jTable.convertColumnIndexToModel(n2);
                    if (n == -1 || hashSet.contains(n2)) continue;
                    if (jTable instanceof ValueStringAdjustProvider && ((ValueStringAdjustProvider)((Object)jTable)).needAdjustCellValueString(i, n2)) {
                        object = ((ValueStringAdjustProvider)((Object)jTable)).getValueAtInString(i, n2, valueConverter);
                    } else {
                        object = jTable.getModel().getValueAt(i, n);
                        object = valueConverter2.convert(jTable, object, i, n2);
                    }
                    CsvTableUtils.addCellValue(stringBuffer, object == null ? "" : object.toString(), c);
                }
                CsvTableUtils.addLineBreak(stringBuffer);
            }
        }
        for (int i = 0; i < jTable2.getRowCount(); ++i) {
            if (jTable2.isVisible()) {
                for (n2 = 0; n2 < jTable2.getColumnCount(); ++n2) {
                    n = jTable2.convertColumnIndexToModel(n2);
                    if (n == -1 || hashSet2.contains(n2)) continue;
                    if (jTable2 instanceof ValueStringAdjustProvider && ((ValueStringAdjustProvider)((Object)jTable2)).needAdjustCellValueString(i, n2)) {
                        object = ((ValueStringAdjustProvider)((Object)jTable2)).getValueAtInString(i, n2, valueConverter);
                    } else {
                        object = jTable2.getModel().getValueAt(i, n);
                        object = valueConverter2.convert(jTable2, object, i, n2);
                    }
                    CsvTableUtils.addCellValue(stringBuffer, object == null ? "" : object.toString(), c);
                }
            }
            for (n2 = 0; n2 < jTable3.getColumnCount(); ++n2) {
                n = jTable3.convertColumnIndexToModel(n2);
                if (n == -1 || hashSet.contains(n2)) continue;
                if (jTable3 instanceof ValueStringAdjustProvider && ((ValueStringAdjustProvider)((Object)jTable3)).needAdjustCellValueString(i, n2)) {
                    object = ((ValueStringAdjustProvider)((Object)jTable3)).getValueAtInString(i, n2, valueConverter);
                } else {
                    object = jTable3.getModel().getValueAt(i, n);
                    if (valueConverter != null) {
                        object = valueConverter.convert(jTable3, object, i, n2);
                    }
                }
                CsvTableUtils.addCellValue(stringBuffer, object == null ? "" : object.toString(), c);
            }
            CsvTableUtils.addLineBreak(stringBuffer);
        }
        try {
            outputStream.write(stringBuffer.toString().getBytes(string));
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean export(PivotTablePane pivotTablePane, OutputStream outputStream) throws IOException {
        return CsvPivotTableUtils.export(pivotTablePane, outputStream, new CsvPivotTableExportConfig());
    }

    public static boolean export(PivotTablePane pivotTablePane, OutputStream outputStream, ValueConverter valueConverter) throws IOException {
        return CsvPivotTableUtils.export(pivotTablePane, outputStream, valueConverter, ',');
    }

    public static boolean export(PivotTablePane pivotTablePane, OutputStream outputStream, ValueConverter valueConverter, char c) throws IOException {
        CsvPivotTableUtils.exportToCsv(pivotTablePane, outputStream, valueConverter, c, Charset.defaultCharset().name());
        return true;
    }

    public static boolean export(PivotTablePane pivotTablePane, OutputStream outputStream, CsvPivotTableExportConfig csvPivotTableExportConfig) throws IOException {
        CsvPivotTableUtils.exportToCsv(pivotTablePane, outputStream, csvPivotTableExportConfig);
        return true;
    }

    private static void exportToCsv(PivotTablePane pivotTablePane, OutputStream outputStream, CsvPivotTableExportConfig csvPivotTableExportConfig) {
        ValueConverter valueConverter = csvPivotTableExportConfig.getCellValueConverter();
        char c = csvPivotTableExportConfig.getSeparator();
        String string = csvPivotTableExportConfig.getCharsetName();
        CsvPivotTableUtils.exportToCsv(pivotTablePane, outputStream, valueConverter, c, string);
    }

    public static class CsvPivotTableExportConfig {
        private ValueConverter _cellValueConverter = null;
        private char _separator = (char)44;
        private String _charsetName = Charset.defaultCharset().name();

        public ValueConverter getCellValueConverter() {
            return this._cellValueConverter;
        }

        public void setCellValueConverter(ValueConverter valueConverter) {
            this._cellValueConverter = valueConverter;
        }

        public char getSeparator() {
            return this._separator;
        }

        public void setSeparator(char c) {
            this._separator = c;
        }

        public String getCharsetName() {
            return this._charsetName;
        }

        public void setCharsetName(String string) {
            this._charsetName = string;
        }
    }
}

