/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.FilterableComboBoxModel;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.RegexFilter;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.ShrinkSearchableSupport;
import com.jidesoft.swing.ComboBoxSearchable;
import com.jidesoft.swing.Searchable;
import java.beans.PropertyChangeEvent;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class ComboBoxShrinkSearchableSupport
extends ShrinkSearchableSupport {
    private FilterableComboBoxModel _filterableComboBoxModel;

    public ComboBoxShrinkSearchableSupport(Searchable searchable) {
        super(searchable);
        if (this._searchable == null || !(this._searchable instanceof ComboBoxSearchable)) {
            throw new IllegalArgumentException("The searchable instance should be ComboBoxSearchable for ComboBoxShrinkSearchableSupport");
        }
        ((ComboBoxSearchable)this._searchable).setRefreshPopupDuringSearching(true);
    }

    @Override
    protected boolean needReinstallFilterableModel(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getSource() == this._searchable.getComponent() && propertyChangeEvent.getNewValue() != this._filterableComboBoxModel;
    }

    @Override
    public void installFilterableModel() {
        if (this._searchable.getComponent() instanceof JComboBox) {
            if (!this._searchable.isSearchableListenerInstalled(this)) {
                this._searchable.addSearchableListener(this);
            }
            this._filterableComboBoxModel = this.createFilterableComboBoxModel(((JComboBox)this._searchable.getComponent()).getModel());
            this._filterableComboBoxModel.setReselectItemOnFiltering(false);
            this._searchable.getComponent().removePropertyChangeListener("model", this);
            ((JComboBox)this._searchable.getComponent()).setModel(this._filterableComboBoxModel);
            this._searchable.getComponent().addPropertyChangeListener("model", this);
        }
    }

    protected FilterableComboBoxModel createFilterableComboBoxModel(ComboBoxModel comboBoxModel) {
        return new FilterableComboBoxModel(comboBoxModel);
    }

    @Override
    public void uninstallFilterableModel() {
        this._searchable.getComponent().removePropertyChangeListener("model", this);
        if (this._filterableComboBoxModel != null) {
            this._searchable.removeSearchableListener(this);
            ((JComboBox)this._searchable.getComponent()).setModel(this._filterableComboBoxModel.getActualModel());
            this._filterableComboBoxModel = null;
        }
    }

    @Override
    protected void applyFilter(String string) {
        Object object;
        if (this._filterableComboBoxModel == null) {
            return;
        }
        this._filterableComboBoxModel.clearFilters();
        if (this._searchable.isWildcardEnabled() && (object = this._searchable.getWildcardSupport()) != null) {
            string = object.convert(string);
        }
        object = new WildcardFilter(string){
            private static final long serialVersionUID = -8652296146175471649L;

            @Override
            protected String convertElementToString(Object object) {
                Object object2 = this.getObjectGrouper() == null ? object : this.getObjectGrouper().getValue(object);
                String string = ComboBoxShrinkSearchableSupport.this.convertElementToString(object2);
                if (string == null) {
                    string = super.convertElementToString(object);
                }
                return string != null ? string : ObjectConverterManager.toString(object2);
            }

            @Override
            protected Pattern createRegexPattern() {
                return Pattern.compile(this.isBeginWith() ? "^" + this.getPattern() : this.getPattern(), this.isCaseSensitive() ? 0 : 2);
            }
        };
        ((RegexFilter)object).setBeginWith(this._searchable.isFromStart());
        ((RegexFilter)object).setEndWith(false);
        this._filterableComboBoxModel.addFilter(object);
        boolean bl = this._searchable.isHideSearchPopupOnEvent();
        this._searchable.setHideSearchPopupOnEvent(false);
        this._filterableComboBoxModel.setFiltersApplied(true);
        this._searchable.setHideSearchPopupOnEvent(bl);
    }

    @Override
    protected int getActualIndexAt(int n) {
        if (this._filterableComboBoxModel == null || n < 0) {
            return n;
        }
        return this._filterableComboBoxModel.getActualIndexAt(n);
    }

    @Override
    protected int getVisualIndexAt(int n) {
        if (this._filterableComboBoxModel == null || n < 0) {
            return n;
        }
        return this._filterableComboBoxModel.getIndexAt(n);
    }
}

