/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AutoFilterBox;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleCustomizer;
import com.jidesoft.grid.DraggingTableHeader;
import com.jidesoft.grid.HeaderStyleModel;
import com.jidesoft.grid.RendererWrapper;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import com.jidesoft.swing.AlignmentSupport;
import com.jidesoft.swing.StyledToolTip;
import com.jidesoft.utils.SortedList;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CellStyleTableHeader
extends DraggingTableHeader {
    private static final String uiClassID = "CellStyleTableHeaderUI";
    private static final String uiDelegateClassID = "TableHeader.cellStyleTableHeaderUIDelegate";
    private ComponentOrientation _savedOrientation;
    private List<TableHeaderCellDecorator> _cellDecorators;
    private Cursor _defaultCursor;
    private Set<Integer> _fixedColumns;
    protected final List<CellStyle> _cellStyleList = new SortedList<CellStyle>(new ArrayList(), new Comparator<CellStyle>(){

        @Override
        public int compare(CellStyle cellStyle, CellStyle cellStyle2) {
            int n;
            if (cellStyle == null) {
                return -1;
            }
            if (cellStyle2 == null) {
                return 1;
            }
            int n2 = cellStyle.getPriority();
            if (n2 < (n = cellStyle2.getPriority())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    });
    private List<CellStyleCustomizer> _cellStyleCustomizers;
    private boolean _saveOpaque = false;
    private Color _saveBackground = null;
    private Color _saveForeground = null;
    private Font _saveFont = null;
    private Border _saveBorder = null;
    private Icon _saveIcon = null;
    private int _saveHorizontalAlignment = -1;
    private int _saveVerticalAlignment = -1;
    private int _saveHorizontalTextPosition = -1;
    private int _saveVerticalTextPosition = -1;
    private String _saveText = null;
    private String _saveToolTipText = null;

    public CellStyleTableHeader() {
    }

    public CellStyleTableHeader(JTable jTable) {
        super(jTable);
    }

    public CellStyleTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    public String getUIDelegateClassID() {
        return uiDelegateClassID;
    }

    public String getActualUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        Object object;
        if (UIDefaultsLookup.get(this.getActualUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        try {
            object = Class.forName(UIManager.getString(this.getActualUIClassID()));
            Class<JComponent> clazz = JComponent.class;
            Method method = ((Class)object).getMethod("createUI", clazz);
            if (method != null) {
                Object object2 = method.invoke(null, this);
                this.setUI((ComponentUI)object2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = this.getDefaultRenderer();
        if (object instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)object);
        }
    }

    @Override
    public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
        super.setDefaultRenderer(tableCellRenderer);
        if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicCellStyleTableHeaderUIDelegate) {
            ((BasicCellStyleTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).invalidateCache(true);
        }
    }

    @Override
    public JToolTip createToolTip() {
        if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicCellStyleTableHeaderUIDelegate && ((BasicCellStyleTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).hasStyledLabelColumn()) {
            return new StyledToolTip();
        }
        return super.createToolTip();
    }

    public int getActualHeaderY() {
        return 0;
    }

    public void addCellDecorator(TableHeaderCellDecorator tableHeaderCellDecorator) {
        this.addCellDecorator(this._cellDecorators == null ? 0 : this._cellDecorators.size(), tableHeaderCellDecorator);
    }

    public void addCellDecorator(int n, TableHeaderCellDecorator tableHeaderCellDecorator) {
        if (this._cellDecorators == null) {
            this._cellDecorators = new ArrayList<TableHeaderCellDecorator>();
        }
        if (n >= 0 && n <= this._cellDecorators.size() && !this._cellDecorators.contains(tableHeaderCellDecorator)) {
            this._cellDecorators.add(n, tableHeaderCellDecorator);
        }
    }

    public void removeCellDecorator(TableHeaderCellDecorator tableHeaderCellDecorator) {
        if (this._cellDecorators == null) {
            return;
        }
        this._cellDecorators.remove(tableHeaderCellDecorator);
        if (this._cellDecorators.size() <= 0) {
            this._cellDecorators = null;
        }
    }

    public TableHeaderCellDecorator[] getCellDecorators() {
        return this._cellDecorators == null ? new TableHeaderCellDecorator[]{} : this._cellDecorators.toArray(new TableHeaderCellDecorator[this._cellDecorators.size()]);
    }

    public int originalColumnAtPoint(Point point) {
        return this.columnAtPoint(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellStyle getCellStyleAt(int n, int n2) {
        List<CellStyle> list = this._cellStyleList;
        synchronized (list) {
            CellStyle cellStyle = null;
            this.collectCellStyles(n, n2);
            if (this._cellStyleList != null) {
                cellStyle = CellStyleTableHeader.mergeCellStyles(this._cellStyleList);
                this._cellStyleList.clear();
            }
            return cellStyle;
        }
    }

    int getRowCount() {
        return 1;
    }

    protected static CellStyle mergeCellStyles(List<CellStyle> list) {
        CellStyle cellStyle;
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() == 1 || list.get(0) == null) {
            return list.get(0);
        }
        try {
            cellStyle = list.get(0).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        for (int i = 1; i < list.size(); ++i) {
            CellStyle.mergeCellStyle(cellStyle, list.get(i));
        }
        return cellStyle;
    }

    protected void collectCellStyles(int n, int n2) {
        JTable jTable = this.getTable();
        int n3 = jTable.convertColumnIndexToModel(n2);
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), HeaderStyleModel.class);
        while (tableModel instanceof HeaderStyleModel) {
            if (((HeaderStyleModel)((Object)tableModel)).isHeaderStyleOn()) {
                int n4 = TableModelWrapperUtils.getActualColumnAt(jTable.getModel(), n3, tableModel);
                if (n4 == -1) break;
                CellStyle cellStyle = ((HeaderStyleModel)((Object)tableModel)).getHeaderStyleAt(n, n4);
                if (cellStyle != null) {
                    this._cellStyleList.add(cellStyle);
                }
            }
            if (tableModel instanceof TableModelWrapper) {
                tableModel = TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)tableModel)).getActualModel(), HeaderStyleModel.class);
                continue;
            }
            tableModel = null;
        }
    }

    public void customizeRendererComponent(Component component, int n, int n2, Rectangle rectangle) {
        if (component == null) {
            return;
        }
        this._savedOrientation = component.getComponentOrientation();
        component.applyComponentOrientation(this.getComponentOrientation());
        CellStyle cellStyle = this.getCellStyleAt(n, n2);
        if (cellStyle == null) {
            return;
        }
        Component component2 = component;
        boolean bl = false;
        if (component2 instanceof RendererWrapper) {
            if ((component2 = ((RendererWrapper)((Object)component2)).getActualRenderer()) != null) {
                bl = true;
            } else {
                component2 = component;
            }
        }
        Color color = cellStyle.getBackground();
        Color color2 = cellStyle.getForeground();
        if (!(color == null || color.equals(component2.getBackground()) && color.equals(component.getBackground()))) {
            if (this._saveBackground == null) {
                this._saveBackground = component2.getBackground();
                if (this._saveBackground == null) {
                    this._saveBackground = CellStyle.EMPTY_COLOR;
                }
            }
            component2.setBackground(color);
            if (component2 instanceof JComponent) {
                this._saveOpaque = component2.isOpaque();
                ((JComponent)component2).setOpaque(true);
            }
            if (bl) {
                component.setBackground(color);
            }
        }
        if (!(color2 == null || color2.equals(component2.getForeground()) && color2.equals(component.getForeground()))) {
            if (this._saveForeground == null) {
                this._saveForeground = component2.getForeground();
            }
            component2.setForeground(color2);
            if (bl) {
                component.setForeground(color2);
            }
        }
        if (!(cellStyle.getFont() == null || cellStyle.getFont().equals(component2.getFont()) && cellStyle.getFont().equals(component.getFont()))) {
            if (this._saveFont == null) {
                this._saveFont = component2.getFont();
                if (this._saveFont == null) {
                    this._saveFont = CellStyle.EMPTY_FONT;
                }
            }
            component2.setFont(cellStyle.getFont());
            if (bl) {
                component.setFont(cellStyle.getFont());
            }
        } else if (cellStyle.getFontStyle() != -1 && cellStyle.getFontStyle() != (component2.getFont() == null ? 0 : component2.getFont().getStyle())) {
            Object object = null;
            if (this._saveFont == null) {
                this._saveFont = component2.getFont();
                object = this._saveFont;
                if (this._saveFont == null) {
                    this._saveFont = CellStyle.EMPTY_FONT;
                }
            }
            if (object != null) {
                int n3 = cellStyle.getFontStyle();
                Font font = ((Font)object).deriveFont(n3);
                component2.setFont(font);
                if (bl) {
                    component.setFont(font);
                }
            }
        }
        if (cellStyle.getBorder() != null && component2 instanceof JComponent) {
            if (this._saveBorder == null) {
                this._saveBorder = ((JComponent)component2).getBorder();
                if (this._saveBorder == null) {
                    this._saveBorder = CellStyle.EMPTY_BORDER;
                }
            }
            if (!cellStyle.getBorder().equals(((JComponent)component2).getBorder())) {
                ((JComponent)component2).setBorder(cellStyle.getBorder());
            }
            if (bl && component instanceof JComponent) {
                ((JComponent)component).setBorder(cellStyle.getBorder());
            }
        }
        if (component2 instanceof JLabel) {
            if (cellStyle.getIcon() != null) {
                if (this._saveIcon == null) {
                    this._saveIcon = ((JLabel)component2).getIcon();
                    if (this._saveIcon == null) {
                        this._saveIcon = CellStyle.EMPTY_ICON;
                    }
                }
                ((JLabel)component2).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this._saveHorizontalAlignment == -1) {
                    this._saveHorizontalAlignment = ((JLabel)component2).getHorizontalAlignment();
                }
                ((JLabel)component2).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                if (this._saveVerticalAlignment == -1) {
                    this._saveVerticalAlignment = ((JLabel)component2).getVerticalAlignment();
                }
                ((JLabel)component2).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                if (this._saveHorizontalTextPosition == -1) {
                    this._saveHorizontalTextPosition = ((JLabel)component2).getHorizontalTextPosition();
                }
                ((JLabel)component2).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                if (this._saveVerticalTextPosition == -1) {
                    this._saveVerticalTextPosition = ((JLabel)component2).getVerticalTextPosition();
                }
                ((JLabel)component2).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
            if (cellStyle.getText() != null) {
                this._saveText = ((JLabel)component2).getText();
                if (this._saveText == null) {
                    this._saveText = "AN_EMPTY_STRING";
                }
                ((JLabel)component2).setText(cellStyle.getText());
            }
        } else if (component2 instanceof AbstractButton) {
            if (cellStyle.getIcon() != null) {
                if (this._saveIcon == null) {
                    this._saveIcon = ((AbstractButton)component2).getIcon();
                    if (this._saveIcon == null) {
                        this._saveIcon = CellStyle.EMPTY_ICON;
                    }
                }
                ((AbstractButton)component2).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this._saveHorizontalAlignment == -1) {
                    this._saveHorizontalAlignment = ((AbstractButton)component2).getHorizontalAlignment();
                }
                ((AbstractButton)component2).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                if (this._saveVerticalAlignment == -1) {
                    this._saveVerticalAlignment = ((AbstractButton)component2).getVerticalAlignment();
                }
                ((AbstractButton)component2).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                if (this._saveHorizontalTextPosition == -1) {
                    this._saveHorizontalTextPosition = ((AbstractButton)component2).getHorizontalTextPosition();
                }
                ((AbstractButton)component2).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                if (this._saveVerticalTextPosition == -1) {
                    this._saveVerticalTextPosition = ((AbstractButton)component2).getVerticalTextPosition();
                }
                ((AbstractButton)component2).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
            if (cellStyle.getText() != null) {
                this._saveText = ((AbstractButton)component2).getText();
                if (this._saveText == null) {
                    this._saveText = "AN_EMPTY_STRING";
                }
                ((AbstractButton)component2).setText(cellStyle.getText());
            }
        } else if (component2 instanceof JTextField) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this._saveHorizontalAlignment == -1) {
                    this._saveHorizontalAlignment = ((JTextField)component2).getHorizontalAlignment();
                }
                ((JTextField)component2).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getText() != null) {
                this._saveText = ((JTextField)component2).getText();
                if (this._saveText == null) {
                    this._saveText = "AN_EMPTY_STRING";
                }
                ((JTextField)component2).setText(cellStyle.getText());
            }
        } else if (component2 instanceof AlignmentSupport) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this._saveHorizontalAlignment == -1) {
                    this._saveHorizontalAlignment = ((AlignmentSupport)((Object)component2)).getHorizontalAlignment();
                }
                ((AlignmentSupport)((Object)component2)).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                if (this._saveVerticalAlignment == -1) {
                    this._saveVerticalAlignment = ((AlignmentSupport)((Object)component2)).getVerticalAlignment();
                }
                ((AlignmentSupport)((Object)component2)).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        }
        if (cellStyle.getToolTipText() != null && component2 instanceof JComponent) {
            this._saveToolTipText = ((JComponent)component2).getToolTipText();
            if (this._saveToolTipText == null) {
                this._saveToolTipText = "AN_EMPTY_STRING";
            }
            ((JComponent)component2).setToolTipText(cellStyle.getToolTipText());
        }
        if (this._cellStyleCustomizers != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this._cellStyleCustomizers) {
                cellStyleCustomizer.customizeRendererComponent(n, n2, component, cellStyle);
            }
        }
    }

    public void releaseRendererComponent(Component component, int n, int n2, Rectangle rectangle) {
        if (component == null) {
            return;
        }
        if (this._savedOrientation != null) {
            component.applyComponentOrientation(this._savedOrientation);
            this._savedOrientation = null;
        }
        Component component2 = component;
        boolean bl = false;
        if (component2 instanceof RendererWrapper) {
            if ((component2 = ((RendererWrapper)((Object)component2)).getActualRenderer()) != null) {
                bl = true;
            } else {
                component2 = component;
            }
        }
        if (this._saveBackground != null) {
            component2.setBackground(this._saveBackground == CellStyle.EMPTY_COLOR ? null : this._saveBackground);
            if (bl) {
                component.setBackground(this._saveBackground == CellStyle.EMPTY_COLOR ? null : this._saveBackground);
            }
            if (component2 instanceof JComponent) {
                ((JComponent)component2).setOpaque(this._saveOpaque);
            }
            this._saveBackground = null;
        }
        if (this._saveForeground != null) {
            component2.setForeground(this._saveForeground);
            if (bl) {
                component.setForeground(this._saveForeground);
            }
            this._saveForeground = null;
        }
        if (this._saveFont != null) {
            component2.setFont(this._saveFont == CellStyle.EMPTY_FONT ? null : this._saveFont);
            if (bl) {
                component.setFont(this._saveFont == CellStyle.EMPTY_FONT ? null : this._saveFont);
            }
            this._saveFont = null;
        }
        if (this._saveBorder != null) {
            if (component2 instanceof JComponent) {
                ((JComponent)component2).setBorder(this._saveBorder == CellStyle.EMPTY_BORDER ? null : this._saveBorder);
            }
            if (bl && component instanceof JComponent) {
                ((JComponent)component).setBorder(this._saveBorder == CellStyle.EMPTY_BORDER ? null : this._saveBorder);
            }
            this._saveBorder = null;
        }
        if (component2 instanceof JLabel) {
            if (this._saveIcon != null) {
                ((JLabel)component2).setIcon(this._saveIcon == CellStyle.EMPTY_ICON ? null : this._saveIcon);
                this._saveIcon = null;
            }
            if (this._saveHorizontalAlignment != -1) {
                ((JLabel)component2).setHorizontalAlignment(this._saveHorizontalAlignment);
                this._saveHorizontalAlignment = -1;
            }
            if (this._saveVerticalAlignment != -1) {
                ((JLabel)component2).setVerticalAlignment(this._saveVerticalAlignment);
                this._saveVerticalAlignment = -1;
            }
            if (this._saveHorizontalTextPosition != -1) {
                ((JLabel)component2).setHorizontalTextPosition(this._saveHorizontalTextPosition);
                this._saveHorizontalTextPosition = -1;
            }
            if (this._saveVerticalTextPosition != -1) {
                ((JLabel)component2).setVerticalTextPosition(this._saveVerticalTextPosition);
                this._saveVerticalTextPosition = -1;
            }
            if (this._saveText != null) {
                ((JLabel)component2).setText("AN_EMPTY_STRING".equals(this._saveText) ? null : this._saveText);
                this._saveText = null;
            }
        } else if (component2 instanceof AbstractButton) {
            if (this._saveIcon != null) {
                ((AbstractButton)component2).setIcon(this._saveIcon == CellStyle.EMPTY_ICON ? null : this._saveIcon);
                this._saveIcon = null;
            }
            if (this._saveHorizontalAlignment != -1) {
                ((AbstractButton)component2).setHorizontalAlignment(this._saveHorizontalAlignment);
                this._saveHorizontalAlignment = -1;
            }
            if (this._saveVerticalAlignment != -1) {
                ((AbstractButton)component2).setVerticalAlignment(this._saveVerticalAlignment);
                this._saveVerticalAlignment = -1;
            }
            if (this._saveHorizontalTextPosition != -1) {
                ((AbstractButton)component2).setHorizontalTextPosition(this._saveHorizontalTextPosition);
                this._saveHorizontalTextPosition = -1;
            }
            if (this._saveVerticalTextPosition != -1) {
                ((AbstractButton)component2).setVerticalTextPosition(this._saveVerticalTextPosition);
                this._saveVerticalTextPosition = -1;
            }
            if (this._saveText != null) {
                ((AbstractButton)component2).setText("AN_EMPTY_STRING".equals(this._saveText) ? null : this._saveText);
                this._saveText = null;
            }
        } else if (component2 instanceof JTextField) {
            if (this._saveHorizontalAlignment != -1) {
                ((JTextField)component2).setHorizontalAlignment(this._saveHorizontalAlignment);
                this._saveHorizontalAlignment = -1;
            }
            if (this._saveText != null) {
                ((JTextField)component2).setText("AN_EMPTY_STRING".equals(this._saveText) ? null : this._saveText);
                this._saveText = null;
            }
        }
        if (this._saveToolTipText != null && component2 instanceof JComponent) {
            ((JComponent)component2).setToolTipText("AN_EMPTY_STRING".equals(this._saveToolTipText) ? null : this._saveToolTipText);
            this._saveToolTipText = null;
        }
        if (this._cellStyleCustomizers != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this._cellStyleCustomizers) {
                cellStyleCustomizer.releaseRendererComponent(n, n2, component);
            }
        }
        if (component instanceof AutoFilterBox) {
            ((AutoFilterBox)component).uninstallListeners();
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (cursor != Cursor.getPredefinedCursor(11)) {
            this._defaultCursor = cursor;
        }
    }

    public Cursor getDefaultCursor() {
        return this._defaultCursor == null ? Cursor.getDefaultCursor() : this._defaultCursor;
    }

    public void addCellStyleCustomizer(CellStyleCustomizer cellStyleCustomizer) {
        if (this._cellStyleCustomizers == null) {
            this._cellStyleCustomizers = new ArrayList<CellStyleCustomizer>();
        }
        if (!this._cellStyleCustomizers.contains(cellStyleCustomizer)) {
            this._cellStyleCustomizers.add(cellStyleCustomizer);
        }
    }

    public void removeCellStyleCustomizer(CellStyleCustomizer cellStyleCustomizer) {
        if (this._cellStyleCustomizers != null) {
            this._cellStyleCustomizers.remove(cellStyleCustomizer);
        }
    }

    public CellStyleCustomizer[] getCellStyleCustomizers() {
        if (this._cellStyleCustomizers == null) {
            return new CellStyleCustomizer[0];
        }
        return this._cellStyleCustomizers.toArray(new CellStyleCustomizer[this._cellStyleCustomizers.size()]);
    }

    public void clearCellStyleCustomizers() {
        if (this._cellStyleCustomizers != null) {
            this._cellStyleCustomizers.clear();
            this._cellStyleCustomizers = null;
        }
    }
}

