/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.BooleanCellEditor;
import com.jidesoft.grid.BooleanCheckBoxCellEditor;
import com.jidesoft.grid.ByteCellEditor;
import com.jidesoft.grid.CalculatorCellEditor;
import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.ColorCellEditor;
import com.jidesoft.grid.ContextSensitiveCellEditorFactory;
import com.jidesoft.grid.DateCellEditor;
import com.jidesoft.grid.DimensionCellEditor;
import com.jidesoft.grid.DoubleCellEditor;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.FileCellEditor;
import com.jidesoft.grid.FileNameCellEditor;
import com.jidesoft.grid.FloatCellEditor;
import com.jidesoft.grid.FolderCellEditor;
import com.jidesoft.grid.FolderNameCellEditor;
import com.jidesoft.grid.FontCellEditor;
import com.jidesoft.grid.FontNameCellEditor;
import com.jidesoft.grid.IPAddressCellEditor;
import com.jidesoft.grid.InsetsCellEditor;
import com.jidesoft.grid.IntegerCellEditor;
import com.jidesoft.grid.LongCellEditor;
import com.jidesoft.grid.MonthCellEditor;
import com.jidesoft.grid.MultilineStringCellEditor;
import com.jidesoft.grid.MultilineTableCellEditor;
import com.jidesoft.grid.NumberCellEditor;
import com.jidesoft.grid.PasswordCellEditor;
import com.jidesoft.grid.PointCellEditor;
import com.jidesoft.grid.RectangleCellEditor;
import com.jidesoft.grid.ShortCellEditor;
import com.jidesoft.grid.SliderCellEditor;
import com.jidesoft.grid.SpinnerCellEditor;
import com.jidesoft.grid.StringArrayCellEditor;
import com.jidesoft.grid.StringCellEditor;
import com.jidesoft.grid.TristateCheckBoxCellEditor;
import com.jidesoft.utils.CacheMap;
import com.jidesoft.utils.RegistrationListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

public class CellEditorManager {
    private static CacheMap<Object, EditorContext> _cache = new CacheMap(EditorContext.DEFAULT_CONTEXT);
    private static CellEditorFactory _defaultCellEditorFactory = new CellEditorFactory(){

        @Override
        public CellEditor create() {
            JTextField jTextField = new JTextField();
            jTextField.setOpaque(false);
            return new DefaultCellEditor(jTextField);
        }
    };
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;
    private static List<CellEditorCustomizer> _cellEditorCustomizers = new Vector<CellEditorCustomizer>();

    @Deprecated
    public static void registerEditor(Class<?> clazz, CellEditor cellEditor, EditorContext editorContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        if (editorContext == null) {
            editorContext = EditorContext.DEFAULT_CONTEXT;
        }
        if (CellEditorManager.isAutoInit() && !_inited && !_initing) {
            CellEditorManager.initDefaultEditor();
        }
        _cache.register(clazz, cellEditor, editorContext);
    }

    @Deprecated
    public static void registerEditor(Class<?> clazz, final CellEditor cellEditor) {
        CellEditorManager.registerEditor(clazz, new CellEditorFactory(){

            @Override
            public CellEditor create() {
                return cellEditor;
            }
        }, EditorContext.DEFAULT_CONTEXT);
    }

    public static void registerEditor(Class<?> clazz, CellEditorFactory cellEditorFactory, EditorContext editorContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        if (editorContext == null) {
            editorContext = EditorContext.DEFAULT_CONTEXT;
        }
        if (CellEditorManager.isAutoInit() && !_inited && !_initing) {
            CellEditorManager.initDefaultEditor();
        }
        _cache.register(clazz, cellEditorFactory, editorContext);
    }

    public static void registerEditor(Class<?> clazz, CellEditorFactory cellEditorFactory) {
        CellEditorManager.registerEditor(clazz, cellEditorFactory, EditorContext.DEFAULT_CONTEXT);
    }

    public static void unregisterEditor(Class<?> clazz, EditorContext editorContext) {
        if (editorContext == null) {
            editorContext = EditorContext.DEFAULT_CONTEXT;
        }
        if (CellEditorManager.isAutoInit() && !_inited && !_initing) {
            CellEditorManager.initDefaultEditor();
        }
        _cache.unregister(clazz, editorContext);
    }

    public static void unregisterEditor(Class<?> clazz) {
        CellEditorManager.unregisterEditor(clazz, EditorContext.DEFAULT_CONTEXT);
    }

    public static void unregisterAllEditors(Class<?> clazz) {
        _cache.remove(clazz);
    }

    public static void unregisterAllEditors() {
        _cache.clear();
    }

    public static CellEditor getEditor(Class<?> clazz, EditorContext editorContext) {
        Object object;
        if (CellEditorManager.isAutoInit() && !_inited && !_initing) {
            CellEditorManager.initDefaultEditor();
        }
        if (editorContext == null) {
            editorContext = EditorContext.DEFAULT_CONTEXT;
        }
        if ((object = _cache.getRegisteredObject(clazz, editorContext)) != null && object instanceof ContextSensitiveCellEditorFactory) {
            CellEditor cellEditor = ((ContextSensitiveCellEditorFactory)object).create(editorContext);
            if (cellEditor == null) {
                cellEditor = ((ContextSensitiveCellEditorFactory)object).create();
            }
            CellEditorManager.customizeCellEditor(cellEditor);
            return cellEditor;
        }
        if (object != null && object instanceof CellEditorFactory) {
            CellEditor cellEditor = ((CellEditorFactory)object).create();
            CellEditorManager.customizeCellEditor(cellEditor);
            return cellEditor;
        }
        if (object != null && object instanceof CellEditor) {
            CellEditorManager.customizeCellEditor((CellEditor)object);
            return (CellEditor)object;
        }
        if (editorContext.equals(EditorContext.DEFAULT_CONTEXT)) {
            return null;
        }
        return CellEditorManager.getEditor(clazz, EditorContext.DEFAULT_CONTEXT);
    }

    public static CellEditor getEditor(Class<?> clazz) {
        return CellEditorManager.getEditor(clazz, EditorContext.DEFAULT_CONTEXT);
    }

    public static void updateUI() {
        CellEditorManager.updateUI0(_defaultCellEditorFactory);
        List<Object> list = _cache.getValues();
        for (Object object : list) {
            CellEditorManager.updateUI0(object);
        }
    }

    private static void updateUI0(Object object) {
        if (object == null) {
            return;
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        if (object instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)object).getComponent();
        } else if (object instanceof TableCellEditor) {
            component = ((TableCellEditor)object).getTableCellEditorComponent(null, null, false, 0, 0);
        }
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
    }

    public static boolean isAutoInit() {
        return _autoInit;
    }

    public static void setAutoInit(boolean bl) {
        _autoInit = bl;
    }

    public static void addRegistrationListener(RegistrationListener registrationListener) {
        _cache.addRegistrationListener(registrationListener);
    }

    public static void removeRegistrationListener(RegistrationListener registrationListener) {
        _cache.removeRegistrationListener(registrationListener);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return _cache.getRegistrationListeners();
    }

    private static void customizeCellEditor(CellEditor cellEditor) {
        for (CellEditorCustomizer cellEditorCustomizer : _cellEditorCustomizers) {
            if (cellEditorCustomizer == null) continue;
            cellEditorCustomizer.customize(cellEditor);
        }
    }

    public static CellEditorCustomizer[] getCellEditorCustomizers() {
        return _cellEditorCustomizers.toArray(new CellEditorCustomizer[_cellEditorCustomizers.size()]);
    }

    public static void addCellEditorCustomizer(CellEditorCustomizer cellEditorCustomizer) {
        if (!_cellEditorCustomizers.contains(cellEditorCustomizer)) {
            _cellEditorCustomizers.add(cellEditorCustomizer);
        }
    }

    public static void removeCellEditorCustomizer(CellEditorCustomizer cellEditorCustomizer) {
        if (_cellEditorCustomizers.contains(cellEditorCustomizer)) {
            _cellEditorCustomizers.remove(cellEditorCustomizer);
        }
    }

    public static EditorContext[] getEditorContexts(Class<?> clazz) {
        return _cache.getKeys(clazz, (EditorContext[])new EditorContext[0]);
    }

    public static void initDefaultEditor() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                        CellEditorManager.updateUI();
                    }
                }
            });
            CellEditorManager.registerEditor(Number.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new NumberCellEditor();
                }
            });
            CellEditorManager.registerEditor(Number.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new SpinnerCellEditor();
                }
            }, SpinnerCellEditor.CONTEXT);
            CellEditorManager.registerEditor(Byte.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new ByteCellEditor();
                }
            });
            CellEditorManager.registerEditor(Byte.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new ByteCellEditor();
                }
            });
            CellEditorManager.registerEditor(Short.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new ShortCellEditor();
                }
            });
            CellEditorManager.registerEditor(Short.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new ShortCellEditor();
                }
            });
            CellEditorManager.registerEditor(Integer.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new IntegerCellEditor();
                }
            });
            CellEditorManager.registerEditor(Integer.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new IntegerCellEditor();
                }
            });
            CellEditorManager.registerEditor(Long.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new LongCellEditor();
                }
            });
            CellEditorManager.registerEditor(Long.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new LongCellEditor();
                }
            });
            CellEditorManager.registerEditor(Double.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new DoubleCellEditor();
                }
            });
            CellEditorManager.registerEditor(Double.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new DoubleCellEditor();
                }
            });
            CellEditorManager.registerEditor(Float.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new FloatCellEditor();
                }
            });
            CellEditorManager.registerEditor(Float.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new FloatCellEditor();
                }
            });
            CellEditorManager.registerEditor(Boolean.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new BooleanCellEditor();
                }
            });
            CellEditorManager.registerEditor(Boolean.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new BooleanCellEditor();
                }
            });
            CellEditorManager.registerEditor(Boolean.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new BooleanCheckBoxCellEditor();
                }
            }, BooleanCheckBoxCellEditor.CONTEXT);
            CellEditorManager.registerEditor(Boolean.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new BooleanCheckBoxCellEditor();
                }
            }, BooleanCheckBoxCellEditor.CONTEXT);
            CellEditorManager.registerEditor(File.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new FileCellEditor();
                }
            });
            CellEditorManager.registerEditor(File.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new FolderCellEditor();
                }
            }, FolderCellEditor.CONTEXT);
            CellEditorManager.registerEditor(Rectangle.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new RectangleCellEditor();
                }
            });
            CellEditorManager.registerEditor(Dimension.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new DimensionCellEditor();
                }
            });
            CellEditorManager.registerEditor(Point.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new PointCellEditor();
                }
            });
            CellEditorManager.registerEditor(Color.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new ColorCellEditor();
                }
            });
            CellEditorManager.registerEditor(Date.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new DateCellEditor(true);
                }
            });
            CellEditorManager.registerEditor(Date.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    DateCellEditor dateCellEditor = new DateCellEditor(true);
                    dateCellEditor.setTimeDisplayed(true);
                    return dateCellEditor;
                }
            }, DateCellEditor.DATETIME_CONTEXT);
            CellEditorManager.registerEditor(Calendar.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new DateCellEditor();
                }
            });
            CellEditorManager.registerEditor(Calendar.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    DateCellEditor dateCellEditor = new DateCellEditor();
                    dateCellEditor.setTimeDisplayed(true);
                    return dateCellEditor;
                }
            }, DateCellEditor.DATETIME_CONTEXT);
            CellEditorManager.registerEditor(Calendar.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new MonthCellEditor();
                }
            }, MonthCellEditor.CONTEXT);
            CellEditorManager.registerEditor(Insets.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new InsetsCellEditor();
                }
            });
            CellEditorManager.registerEditor(String.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new StringCellEditor();
                }
            });
            CellEditorManager.registerEditor(String.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new FontNameCellEditor();
                }
            }, FontNameCellEditor.CONTEXT);
            CellEditorManager.registerEditor(String.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new MultilineTableCellEditor();
                }
            }, MultilineTableCellEditor.CONTEXT);
            CellEditorManager.registerEditor(String.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new MultilineStringCellEditor();
                }
            }, MultilineStringCellEditor.CONTEXT);
            CellEditorManager.registerEditor(String.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new FileNameCellEditor();
                }
            }, FileNameCellEditor.CONTEXT);
            CellEditorManager.registerEditor(String.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new FolderNameCellEditor();
                }
            }, FolderNameCellEditor.CONTEXT);
            CellEditorManager.registerEditor(char[].class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new PasswordCellEditor();
                }
            }, PasswordCellEditor.CONTEXT);
            CellEditorManager.registerEditor(String[].class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new StringArrayCellEditor();
                }
            });
            CellEditorManager.registerEditor(Font.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new FontCellEditor();
                }
            });
            CellEditorManager.registerEditor(Double.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new CalculatorCellEditor();
                }
            }, CalculatorCellEditor.CONTEXT);
            CellEditorManager.registerEditor(Double.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new CalculatorCellEditor();
                }
            }, CalculatorCellEditor.CONTEXT);
            CellEditorManager.registerEditor(Integer.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new SliderCellEditor();
                }
            }, SliderCellEditor.CONTEXT);
            CellEditorManager.registerEditor(Integer.TYPE, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new SliderCellEditor();
                }
            }, SliderCellEditor.CONTEXT);
            CellEditorManager.registerEditor(String.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new IPAddressCellEditor();
                }
            }, IPAddressCellEditor.CONTEXT);
            CellEditorFactory cellEditorFactory = new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new TristateCheckBoxCellEditor();
                }
            };
            CellEditorManager.registerEditor(Integer.TYPE, cellEditorFactory, TristateCheckBoxCellEditor.CONTEXT);
            CellEditorManager.registerEditor(Integer.class, cellEditorFactory, TristateCheckBoxCellEditor.CONTEXT);
            CellEditorManager.registerEditor(BigDecimal.class, new CellEditorFactory(){

                @Override
                public CellEditor create() {
                    return new NumberCellEditor((Class)BigDecimal.class);
                }
            });
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }

    public static void resetInit() {
        _inited = false;
    }

    public static void clear() {
        CellEditorManager.resetInit();
        _cache.clear();
    }

    public static interface CellEditorCustomizer {
        public void customize(CellEditor var1);
    }
}

