/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.grid.AutoFilterBox;
import com.jidesoft.grid.AutoFilterTableHeaderAdapter;
import com.jidesoft.grid.AutoFilterTableHeaderEditor;
import com.jidesoft.grid.AutoFilterTableHeaderRenderer;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.EditableTableHeader;
import com.jidesoft.grid.FilterableTableHeaderCellDecorator;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.FilterableTableModelEvent;
import com.jidesoft.grid.FilterableTableModelListener;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.GroupTable;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AutoFilterTableHeader
extends EditableTableHeader
implements FilterableTableModelListener,
PropertyChangeListener {
    protected IFilterableTableModel _filterableTableModel;
    protected boolean _autoFilterEnabled = false;
    private boolean _useNativeHeaderRenderer = false;
    private boolean _showFilterName = false;
    private boolean _showFilterNameAsToolTip = false;
    private boolean _showFilterIcon = false;
    private boolean _allowMultipleValues = false;
    private boolean _preferSelectedValues = true;
    private boolean _acceptTextInput = false;
    private boolean _filterableTableModelInitialized = false;
    private TableCellRenderer _autoFilterTableHeaderRenderer;
    private TableHeaderCellDecorator _filterableTableHeaderCellDecorator;
    private boolean _selfCreatedFilterableTableModel = false;
    static final String CLIENT_PROPERTY_FILTER_CELL_DECORATOR_PROPERTIES = "TableHeaderUIDelegate.filterCellDecoratorProperties";
    static final String CLIENT_PROPERTY_DELEGATE_INSTANCE = "TableHeaderUIDelegate.instance";
    public static final String PROPERTY_ACCEPT_TEXT_INPUT = "acceptTextInput";
    public static final String PROPERTY_USE_NATIVE_CELL_RENDERER = "useNativeCellRenderer";
    public static final String PROPERTY_AUTO_FILTER_ENABLED = "autoFilterEnabled";
    public static final String PROPERTY_FILTER_FACTORY_MANAGER = "filterFactoryManager";
    private static final String uiClassID = "AutoFilterTableHeaderUI";
    private static final String uiDelegateClassID = "TableHeader.autoFilterTableHeaderUIDelegate";
    public static final String CLIENT_PROPERTY_CUSTOM_FILTER_EDITOR_TYPE = "customFilterEditorType";
    public static final String CUSTOM_FILTER_EDITOR_TYPE_TABLE_CUSTOM_FILTER_EDITOR = "TableCustomFilterEditor";

    protected AutoFilterTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.setRolloverEnabled(true);
        this.setClickToStartEditing(false);
        this.addCellDecorator(0, this.getFilterableTableHeaderCellDecorator());
        this.initRenderer();
    }

    public AutoFilterTableHeader(JTable jTable) {
        super(jTable.getColumnModel());
        this.setRolloverEnabled(true);
        this.setClickToStartEditing(false);
        this.initRenderer();
        this.addCellDecorator(0, this.getFilterableTableHeaderCellDecorator());
        this.setTable(jTable);
    }

    protected TableHeaderCellDecorator createFilterableTableHeaderCellDecorator() {
        return new FilterableTableHeaderCellDecorator();
    }

    public TableHeaderCellDecorator getFilterableTableHeaderCellDecorator() {
        if (this._filterableTableHeaderCellDecorator == null) {
            this._filterableTableHeaderCellDecorator = this.createFilterableTableHeaderCellDecorator();
        }
        return this._filterableTableHeaderCellDecorator;
    }

    @Override
    public void setTable(JTable jTable) {
        if (jTable != null) {
            this.initTable(jTable);
        }
        super.setTable(jTable);
    }

    @Override
    public String getUIDelegateClassID() {
        return uiDelegateClassID;
    }

    @Override
    public String getActualUIClassID() {
        return uiClassID;
    }

    private void initRenderer() {
        if (this._autoFilterTableHeaderRenderer == null) {
            boolean bl = this._autoFilterEnabled;
            boolean bl2 = this._useNativeHeaderRenderer;
            try {
                this.setAutoFilterEnabled(true);
                this.setUseNativeHeaderRenderer(false);
                this._autoFilterTableHeaderRenderer = this.createDefaultRenderer();
            }
            finally {
                this.setAutoFilterEnabled(bl);
                this.setUseNativeHeaderRenderer(bl2);
            }
        }
    }

    public TableCellRenderer getAutoFilterTableHeaderRenderer() {
        return this.isUseNativeHeaderRenderer() ? this.getDefaultRenderer() : this._autoFilterTableHeaderRenderer;
    }

    @Override
    protected TableCellRenderer createDefaultRenderer() {
        if (this.isAutoFilterEnabled() && !this._useNativeHeaderRenderer) {
            return new AutoFilterTableHeaderRenderer(){

                @Override
                protected void customizeAutoFilterBox(AutoFilterBox autoFilterBox) {
                    super.customizeAutoFilterBox(autoFilterBox);
                    AutoFilterTableHeader.this.customizeAutoFilterBox(autoFilterBox);
                    autoFilterBox.applyComponentOrientation(AutoFilterTableHeader.this.getComponentOrientation());
                }
            };
        }
        return super.createDefaultRenderer();
    }

    @Override
    protected TableCellEditor createDefaultEditor() {
        if (this.isAutoFilterEnabled() && !this._useNativeHeaderRenderer) {
            return new AutoFilterTableHeaderEditor(){
                private static final long serialVersionUID = 8656928681639076184L;

                @Override
                protected void customizeAutoFilterBox(AutoFilterBox autoFilterBox) {
                    autoFilterBox.applyComponentOrientation(AutoFilterTableHeader.this.getComponentOrientation());
                    super.customizeAutoFilterBox(autoFilterBox);
                    AutoFilterTableHeader.this.customizeAutoFilterBox(autoFilterBox);
                }
            };
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n) {
        return super.isCellEditable(n) && !this.isUseNativeHeaderRenderer();
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            int n;
            if (tableCellEditor instanceof AutoFilterTableHeaderEditor) {
                ((AutoFilterTableHeaderEditor)tableCellEditor).commitEdit();
            }
            if ((n = this.getEditingColumn()) >= 0 && n < this.columnModel.getColumnCount() && this.columnModel.getColumn(n).getHeaderValue() instanceof Icon) {
                this.removeEditor();
                return;
            }
        }
        super.editingStopped(changeEvent);
    }

    protected void customizeAutoFilterBox(AutoFilterBox autoFilterBox) {
        String string;
        autoFilterBox.setShowFilterName(this.isShowFilterName());
        autoFilterBox.setShowFilterNameAsToolTip(this.isShowFilterNameAsToolTip());
        autoFilterBox.setShowFilterIcon(this.isShowFilterIcon());
        autoFilterBox.setShowSortArrow(this.isShowSortArrow());
        autoFilterBox.setAllowMultipleValues(this.isAllowMultipleValues(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setPreferSelectedValues(this.isPreferSelectedValues());
        autoFilterBox.setMultiLineMode(this.isAcceptTextInput());
        autoFilterBox.setAllowCustomFilter(this.isAllowCustomFilter(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setTitleConverter(this.getTitleConverter(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setFilterTitleFormatter(this.getFilterTitleFormatter(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setListCellRenderer(this.getListCellRenderer(autoFilterBox.getTableColumnIndex()));
        autoFilterBox.setUseTableCellRenderer(this.isUseTableCellRenderer(autoFilterBox.getTableColumnIndex()));
        if (this.getTable() instanceof JideTable && (string = ((JideTable)this.getTable()).getTableHeaderToolTipText(autoFilterBox.getModelColumnIndex())) != null) {
            autoFilterBox.setToolTipText(string);
        }
    }

    protected void initTable(JTable jTable) {
        if (jTable instanceof GroupTable) {
            this.setPreferSelectedValues(true);
        }
        if (!JideSwingUtilities.isPropertyChangeListenerRegistered(jTable, "model", this)) {
            jTable.addPropertyChangeListener("model", this);
        }
        if (this._filterableTableModel == null || !TableModelWrapperUtils.isActualTableModel(jTable.getModel(), this._filterableTableModel)) {
            this.tableModelChanged(jTable);
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (!this.isAcceptTextInput()) {
            super.columnMarginChanged(changeEvent);
        } else {
            this.originalResizeAndRepaint();
            if (this.isEditing()) {
                int n = this.getEditingColumn();
                Component component = this.getEditorComponent();
                if (n >= 0 && n < this.getColumnModel().getColumnCount() && component != null) {
                    component.setBounds(this.getHeaderRect(n));
                }
            }
        }
    }

    protected void tableModelChanged(JTable jTable) {
        if (this._filterableTableModel != null && TableModelWrapperUtils.isActualTableModel(jTable.getModel(), this._filterableTableModel)) {
            return;
        }
        this._selfCreatedFilterableTableModel = false;
        if (this._filterableTableModel != null) {
            this._filterableTableModel.removeFilterableTableModelListener(this);
            this._filterableTableModel = null;
        }
        this._filterableTableModelInitialized = false;
        if (!this.isAutoFilterEnabled() || jTable == null) {
            return;
        }
        TableModel tableModel = jTable.getModel();
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, IExpandableTreeTableModel.class);
        TableModel tableModel3 = this.createFilterableTableModel(tableModel);
        boolean bl = true;
        if (tableModel3 == null) {
            tableModel3 = TableModelWrapperUtils.getActualTableModel(tableModel, IFilterableTableModel.class);
            if (tableModel3 != null) {
                bl = false;
            }
        } else {
            TableModel tableModel4 = TableModelWrapperUtils.getActualTableModel(tableModel, IFilterableTableModel.class);
            while (tableModel4 instanceof IFilterableTableModel && tableModel4 instanceof TableModelWrapper && tableModel4 != tableModel3) {
                tableModel4 = TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)tableModel4)).getActualModel(), IFilterableTableModel.class);
            }
            if (tableModel4 == tableModel3) {
                bl = false;
            }
        }
        if (tableModel2 != null && (tableModel3 instanceof FilterableTreeTableModel || tableModel3 != null && TableModelWrapperUtils.getActualTableModel(tableModel2, IFilterableTableModel.class) == tableModel3)) {
            this._filterableTableModel = tableModel3;
        } else if (tableModel2 == null && tableModel3 instanceof IFilterableTableModel) {
            this._filterableTableModel = tableModel3;
        } else {
            this._filterableTableModel = this.createDefaultFilterableTableModel(tableModel);
            boolean bl2 = bl = this._filterableTableModel != null;
        }
        if (bl) {
            jTable.removePropertyChangeListener("model", this);
            jTable.setModel(this._filterableTableModel);
            jTable.addPropertyChangeListener("model", this);
            this._selfCreatedFilterableTableModel = true;
        }
        if (this._filterableTableModel != null) {
            this._filterableTableModelInitialized = true;
            this._filterableTableModel.addFilterableTableModelListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof JTable) {
            TableModel tableModel;
            TableModel tableModel2;
            if (this._selfCreatedFilterableTableModel && (tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel = ((JTable)propertyChangeEvent.getSource()).getModel(), FilterableTableModel.class)) instanceof TableModelWrapperImpl && !TableModelWrapperUtils.isActualTableModel(tableModel2, tableModel) && !TableModelWrapperUtils.isActualTableModel(tableModel, tableModel2)) {
                ((TableModelWrapperImpl)tableModel2).setActualModel(null, false);
            }
            this.tableModelChanged((JTable)propertyChangeEvent.getSource());
        }
    }

    @Override
    public void filterableTableModelChanged(FilterableTableModelEvent filterableTableModelEvent) {
        if (this.isShowFilterIcon() || this.isShowFilterName() || this.isAcceptTextInput()) {
            this.repaint();
        }
    }

    protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
        return null;
    }

    protected IFilterableTableModel createDefaultFilterableTableModel(TableModel tableModel) {
        if (TableModelWrapperUtils.getActualTableModel(tableModel, IExpandableTreeTableModel.class) != null) {
            return new FilterableTreeTableModel(tableModel);
        }
        return new FilterableTableModel(tableModel);
    }

    public IFilterableTableModel getFilterableTableModel() {
        return this._filterableTableModel;
    }

    public void clearFilters() {
        if (this._filterableTableModel != null) {
            for (int i = 0; i < this._filterableTableModel.getColumnCount(); ++i) {
                Filter[] filterArray = this._filterableTableModel.getFilters(i);
                if (filterArray == null) continue;
                for (Filter filter : filterArray) {
                    if (filter instanceof SingleValueFilter) {
                        this._filterableTableModel.removeFilter(i, filter);
                        continue;
                    }
                    if (filter instanceof MultipleValuesFilter) {
                        this._filterableTableModel.removeFilter(i, filter);
                        continue;
                    }
                    if (filter instanceof NotFilter && ((NotFilter)filter).getFilter() instanceof MultipleValuesFilter) {
                        this._filterableTableModel.removeFilter(i, filter);
                        continue;
                    }
                    if (filter instanceof DynamicTableFilter) {
                        this._filterableTableModel.removeFilter(i, filter);
                        continue;
                    }
                    if (filter.getFilterFactory() == null) continue;
                    this._filterableTableModel.removeFilter(i, filter);
                }
            }
        }
    }

    public boolean isAutoFilterEnabled() {
        return this._autoFilterEnabled;
    }

    public void setAutoFilterEnabled(boolean bl) {
        boolean bl2 = this._autoFilterEnabled;
        if (bl2 != bl) {
            this.stopEditing();
            this.setCursor(Cursor.getDefaultCursor());
            this._autoFilterEnabled = bl;
            JTable jTable = this.getTable();
            if (!this._filterableTableModelInitialized && jTable != null) {
                String string = TableUtils.getTablePreferenceByName(jTable);
                this.tableModelChanged(jTable);
                TableUtils.setTablePreferenceByName(jTable, string);
            }
            this.updateDefaultRendererAndEditor();
            this.firePropertyChange(PROPERTY_AUTO_FILTER_ENABLED, bl2, this._autoFilterEnabled);
        }
    }

    private void updateDefaultRendererAndEditor() {
        this.removeCellDecorator(this.getSortableTableHeaderCellDecorator());
        if (!this.isUseNativeHeaderRenderer()) {
            this.cancelEditing();
            this.setDefaultRenderer(this.createDefaultRenderer());
            this.setDefaultEditor(this.createDefaultEditor());
            this.updateUI();
        } else {
            this.invalidate();
            this.repaint();
        }
        if ((this._useNativeHeaderRenderer || !this.isAutoFilterEnabled()) && this.isShowSortArrow() && this.getDefaultEditor() == null) {
            this.addCellDecorator(this.getSortableTableHeaderCellDecorator());
        }
    }

    public boolean isShowFilterName() {
        return this._showFilterName;
    }

    public void setShowFilterName(boolean bl) {
        boolean bl2 = this._showFilterName;
        if (bl2 != bl) {
            this._showFilterName = bl;
            this.updateDefaultRendererAndEditor();
        }
    }

    public boolean isShowFilterNameAsToolTip() {
        return this._showFilterNameAsToolTip;
    }

    public void setShowFilterNameAsToolTip(boolean bl) {
        boolean bl2 = this._showFilterNameAsToolTip;
        if (bl2 != bl) {
            this._showFilterNameAsToolTip = bl;
            this.updateDefaultRendererAndEditor();
        }
    }

    public boolean isShowFilterIcon() {
        return this._showFilterIcon;
    }

    public void setShowFilterIcon(boolean bl) {
        boolean bl2 = this._showFilterIcon;
        if (bl2 != bl) {
            this._showFilterIcon = bl;
            this.updateDefaultRendererAndEditor();
        }
    }

    @Override
    public void setShowSortArrow(boolean bl) {
        boolean bl2 = this.isShowSortArrow();
        super.setShowSortArrow(bl);
        if (bl2 != bl) {
            this.updateDefaultRendererAndEditor();
        }
    }

    public boolean isAllowMultipleValues(int n) {
        if (n < 0 || this.getColumnModel() == null || n >= this.getColumnModel().getColumnCount()) {
            return this.isAllowMultipleValues();
        }
        return this.isAllowMultipleValues() && this._filterableTableModel != null && (this.getTable() == null || this._filterableTableModel.isAllowMultipleValues(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n), this._filterableTableModel)));
    }

    public boolean isAllowMultipleValues() {
        return this._allowMultipleValues;
    }

    public void setAllowMultipleValues(boolean bl) {
        boolean bl2 = this._allowMultipleValues;
        if (bl2 != bl) {
            this._allowMultipleValues = bl;
            IFilterableTableModel iFilterableTableModel = this.getFilterableTableModel();
            if (iFilterableTableModel != null) {
                iFilterableTableModel.clearFilters();
                if (iFilterableTableModel.isFiltersApplied()) {
                    iFilterableTableModel.setFiltersApplied(true);
                }
            }
            this.updateDefaultRendererAndEditor();
        }
    }

    private boolean isAllowCustomFilter(int n) {
        if (n < 0 || this.getColumnModel() == null || n >= this.getColumnModel().getColumnCount()) {
            return !this.isAllowMultipleValues();
        }
        return this._filterableTableModel != null && (this.getTable() == null || this._filterableTableModel.isAllowCustomFilter(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n), this._filterableTableModel)));
    }

    public boolean isPreferSelectedValues() {
        return this._preferSelectedValues;
    }

    public void setPreferSelectedValues(boolean bl) {
        this._preferSelectedValues = bl;
    }

    @Override
    protected boolean isAutoRequestFocus() {
        return false;
    }

    protected IFilterableTableModel getFilterableTableModel(AutoFilterBox autoFilterBox) {
        return this.getFilterableTableModel();
    }

    public boolean isAcceptTextInput() {
        return this._acceptTextInput && !this.isUseNativeHeaderRenderer();
    }

    public void setAcceptTextInput(boolean bl) {
        if (this._acceptTextInput != bl) {
            boolean bl2 = this._acceptTextInput;
            this._acceptTextInput = bl;
            if (this.isEditing()) {
                this.stopEditing();
            }
            this.updateDefaultRendererAndEditor();
            this.firePropertyChange(PROPERTY_ACCEPT_TEXT_INPUT, bl2, this._acceptTextInput);
        }
    }

    public boolean isUseNativeHeaderRenderer() {
        return this._useNativeHeaderRenderer && !(this.getDefaultRenderer() instanceof AutoFilterTableHeaderRenderer) && !(this.getDefaultEditor() instanceof AutoFilterTableHeaderEditor);
    }

    public void setUseNativeHeaderRenderer(boolean bl) {
        if (this._useNativeHeaderRenderer != bl) {
            boolean bl2 = this._useNativeHeaderRenderer;
            this._useNativeHeaderRenderer = bl;
            if (this.isEditing()) {
                this.stopEditing();
            }
            this.updateDefaultRendererAndEditor();
            this.firePropertyChange(PROPERTY_USE_NATIVE_CELL_RENDERER, bl2, this._useNativeHeaderRenderer);
        }
    }

    @Override
    public boolean isRolloverEnabled() {
        return super.isRolloverEnabled() && (!this.isAutoFilterEnabled() || !this.isUseNativeHeaderRenderer());
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string;
        Point point;
        int n;
        if (this.isShowFilterNameAsToolTip() && (n = this.columnAtPoint(point = mouseEvent.getPoint())) >= 0 && n < this.getColumnModel().getColumnCount() && (string = this.getFormattedColumnName(n)) != null) {
            return string;
        }
        return super.getToolTipText(mouseEvent);
    }

    public String getFormattedColumnName(int n) {
        if (this.getTable() == null || n < 0 || n >= this.getTable().getColumnModel().getColumnCount()) {
            return "";
        }
        Object object = this.table.getColumnModel().getColumn(n).getHeaderValue();
        if (this._filterableTableModel == null) {
            return null;
        }
        int n2 = this.getTable().convertColumnIndexToModel(n);
        int n3 = TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), n2, this._filterableTableModel);
        Filter[] filterArray = this._filterableTableModel.getFilters(n3);
        if (filterArray == null || filterArray.length == 0) {
            return null;
        }
        String string = object != null && !(object instanceof Icon) ? "" + object : "";
        StringConverter stringConverter = this.getTitleConverter(n);
        string = stringConverter != null ? stringConverter.convert(string) : string;
        return this.formatColumnTitle(n2, string, filterArray);
    }

    protected String formatColumnTitle(int n, String string, Filter[] filterArray) {
        if (this.getTable() == null) {
            return string;
        }
        AutoFilterTableHeaderAdapter.FilterTitleFormatter filterTitleFormatter = this.getFilterTitleFormatter(this.getTable().convertColumnIndexToView(n));
        if (filterTitleFormatter != null) {
            return filterTitleFormatter.formatColumnTitle(string, filterArray);
        }
        if (filterArray == null || filterArray.length == 0) {
            return string;
        }
        if (filterArray[0] instanceof QuickTableFilterField.FieldTableFilter) {
            return string + ": " + ((QuickTableFilterField.FieldTableFilter)filterArray[0]).getSearchingText();
        }
        if (filterArray[0] instanceof NotFilter && ((NotFilter)filterArray[0]).getFilter() instanceof MultipleValuesFilter) {
            return string + ": ~" + ((NotFilter)filterArray[0]).getFilter().getName();
        }
        return string + ": " + filterArray[0].getName();
    }

    protected ImageIcon getFilterIcon(int n, boolean bl, boolean bl2) {
        return IconsFactory.getImageIcon(AutoFilterTableHeader.class, bl ? (bl2 ? "icons/filterYes_over.png" : "icons/filterNo_over.png") : (bl2 ? "icons/filterYes.png" : "icons/filterNo.png"));
    }

    private StringConverter getTitleConverter(int n) {
        if (n < 0 || this.getColumnModel() == null || n >= this.getColumnModel().getColumnCount()) {
            return null;
        }
        return this._filterableTableModel == null || this.getTable() == null ? null : this._filterableTableModel.getTitleConverter(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n), this._filterableTableModel));
    }

    private AutoFilterTableHeaderAdapter.FilterTitleFormatter getFilterTitleFormatter(int n) {
        if (n < 0 || this.getColumnModel() == null || n >= this.getColumnModel().getColumnCount()) {
            return null;
        }
        return this._filterableTableModel == null || this.getTable() == null ? null : this._filterableTableModel.getFilterTitleFormatter(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n), this._filterableTableModel));
    }

    private ListCellRenderer getListCellRenderer(int n) {
        if (n < 0 || this.getColumnModel() == null || n >= this.getColumnModel().getColumnCount()) {
            return null;
        }
        return this._filterableTableModel == null || this.getTable() == null ? null : this._filterableTableModel.getListCellRenderer(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n), this._filterableTableModel));
    }

    private boolean isUseTableCellRenderer(int n) {
        if (n < 0 || this.getColumnModel() == null || n >= this.getColumnModel().getColumnCount()) {
            return false;
        }
        return this._filterableTableModel != null && this.getTable() != null && this._filterableTableModel.isUseTableCellRenderer(TableModelWrapperUtils.getActualColumnAt(this.getTable().getModel(), this.getTable().convertColumnIndexToModel(n), this._filterableTableModel));
    }

    public void adjustPopupDialogBounds(JDialog jDialog, int n) {
        jDialog.setLocationRelativeTo(this);
        jDialog.pack();
        Rectangle rectangle = jDialog.getBounds();
        int n2 = n >= 0 ? n : -n + -2;
        Point point = this.getLocation();
        SwingUtilities.convertPointToScreen(point, this.getParent());
        Rectangle rectangle2 = this.getHeaderRect(n2);
        int n3 = rectangle2.x + point.x - (rectangle.width - rectangle2.width) / 2;
        int n4 = Math.max(point.y + this.getHeight() + 5, rectangle.y);
        jDialog.setBounds(new Rectangle(n3, n4, rectangle.width, rectangle.height));
    }

    public void adjustPopupPanelSize(JidePopup jidePopup, PopupPanel popupPanel, int n) {
        if (popupPanel.isStretchToFit() && popupPanel.getActualPreferredSize().width != this.getHeaderRect((int)n).width) {
            Insets insets;
            Border border = jidePopup.getPopupBorder();
            int n2 = 0;
            if (border != null && (insets = border.getBorderInsets(popupPanel)) != null) {
                n2 = insets.left + insets.right;
            }
            int n3 = Math.max(popupPanel.getActualPreferredSize().width, this.getHeaderRect((int)n).width - n2);
            popupPanel.setPreferredSize(new Dimension(n3, popupPanel.getPreferredSize().height));
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(AutoFilterTableHeader.class.getName(), 4);
        }
    }
}

