/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Node;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractNode
implements Node {
    protected Expandable _parent;
    private PropertyChangeSupport changeSupport;
    public static final String PROPERTY_PARENT = "parent";

    @Override
    public int getLevel() {
        return this.getParent() != null ? this.getParent().getLevel() + 1 : 0;
    }

    @Override
    public Expandable getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Expandable expandable) {
        if (this._parent != expandable) {
            Expandable expandable2 = this._parent;
            this._parent = expandable;
            this.firePropertyChange(PROPERTY_PARENT, expandable2, expandable);
        }
    }

    @Override
    public Node getNextSibling() {
        if (this.getParent() == null) {
            return null;
        }
        int n = this.getParent().getChildIndex(this);
        if (n < this.getParent().getChildrenCount()) {
            return (Node)this.getParent().getChildAt(n + 1);
        }
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        if (this.getParent() == null) {
            return null;
        }
        int n = this.getParent().getChildIndex(this);
        if (n > 0) {
            return (Node)this.getParent().getChildAt(n - 1);
        }
        return null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected synchronized void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected synchronized void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected synchronized void firePropertyChange(String string, int n, int n2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n, n2);
    }
}

