/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.EditingNotStoppedException;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public abstract class AbstractComboBoxCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor,
ActionListener,
PopupMenuListener,
ItemListener {
    private static final long serialVersionUID = 6651517069720671794L;
    protected AbstractComboBox _comboBox;
    private static final String CLIENT_PROPERTY_IS_CELL_EDITOR = "JComboBox.isTableCellEditor";

    public AbstractComboBoxCellEditor() {
        this._comboBox = this.createAbstractComboBox();
    }

    public AbstractComboBoxCellEditor(ComboBoxModel comboBoxModel, Class<?> clazz) {
        this._comboBox = this.createAbstractComboBox(comboBoxModel, clazz);
    }

    protected void customizeAbstractComboBox() {
        this._comboBox.putClientProperty("AbstractComboBox.isTableCellEditor", this);
        this._comboBox.setBorder(ContextSensitiveCellEditor.DEFAULT_CELL_EDITOR_BORDER);
        ((JComponent)this._comboBox.getEditor().getEditorComponent()).setBorder(BorderFactory.createEmptyBorder());
    }

    public abstract AbstractComboBox createAbstractComboBox();

    public AbstractComboBox createAbstractComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
        return this.createAbstractComboBox();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        int n3;
        if (jTable != null) {
            this.customizeAbstractComboBox();
            JideSwingUtilities.installColorsAndFont(this._comboBox, jTable.getBackground(), jTable.getForeground(), jTable.getFont());
        }
        this._comboBox.setConverter(this.getConverter());
        this._comboBox.setConverterContext(this.getConverterContext());
        this.setCellEditorValue(object);
        boolean bl2 = false;
        ActionListener[] actionListenerArray = this._comboBox.getActionListeners();
        EventListener[] eventListenerArray = actionListenerArray;
        int n4 = eventListenerArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            ActionListener actionListener = eventListenerArray[n3];
            if (actionListener != this) continue;
            bl2 = true;
        }
        if (!bl2) {
            this._comboBox.addActionListener(this);
        }
        EventListener[] eventListenerArray2 = eventListenerArray = this._comboBox.getItemListeners();
        n3 = eventListenerArray2.length;
        for (int i = 0; i < n3; ++i) {
            EventListener eventListener = eventListenerArray2[i];
            if (eventListener != this) continue;
            bl2 = true;
        }
        if (!bl2) {
            this._comboBox.addItemListener(this);
        }
        bl2 = false;
        for (EventListener eventListener : eventListenerArray2 = this._comboBox.getPopupMenuListeners()) {
            if (eventListener != this) continue;
            bl2 = true;
        }
        if (!bl2) {
            this._comboBox.addPopupMenuListener(this);
        }
        this._comboBox.putClientProperty(CLIENT_PROPERTY_IS_CELL_EDITOR, Boolean.TRUE);
        this.configureComboBox();
        return this._comboBox;
    }

    void configureComboBox() {
        if (this._comboBox != null) {
            switch (this.getEditorStyle()) {
                case 1: {
                    this._comboBox.setEditable(false);
                    this._comboBox.setButtonVisible(true);
                    break;
                }
                case 2: {
                    Component component;
                    this._comboBox.setEditable(true);
                    if (this._comboBox.getEditor() != null && (component = this._comboBox.getEditor().getEditorComponent()) instanceof JTextComponent) {
                        ((JTextComponent)component).setEditable(false);
                    }
                    this._comboBox.setButtonVisible(false);
                    break;
                }
                case 3: {
                    Component component;
                    this._comboBox.setEditable(true);
                    if (this._comboBox.getEditor() != null && (component = this._comboBox.getEditor().getEditorComponent()) instanceof JTextComponent) {
                        ((JTextComponent)component).setEditable(true);
                    }
                    this._comboBox.setButtonVisible(true);
                    break;
                }
            }
        }
    }

    public void setCellEditorValue(Object object) {
        this._comboBox.setSelectedItem(object);
    }

    @Override
    public Object getCellEditorValue() {
        return this._comboBox.getEditor().getItem();
    }

    @Override
    public boolean stopCellEditing() {
        boolean bl;
        if (this._comboBox != null) {
            this._comboBox.commitEdit();
        }
        try {
            bl = super.stopCellEditing();
            if (bl) {
                this._comboBox.removeActionListener(this);
                this._comboBox.removeItemListener(this);
                this._comboBox.removePopupMenuListener(this);
                this._comboBox.setPopupVisible(false);
            }
        }
        catch (EditingNotStoppedException editingNotStoppedException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isAutoStopCellEditing()) {
            this.stopCellEditing();
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        if (this.isAutoStopCellEditing()) {
            if (this.getComboBox().getPopupCancelBehavior() == 3) {
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }

    public AbstractComboBox getComboBox() {
        return this._comboBox;
    }

    @Override
    public void setConverter(ObjectConverter objectConverter) {
        super.setConverter(objectConverter);
        this._comboBox.setConverter(objectConverter);
    }

    @Override
    public boolean isEditorStyleSupported(int n) {
        return true;
    }
}

