/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.AbstractIndicatorRenderer;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import com.jidesoft.gauge.IndicatorStyle;
import com.jidesoft.gauge.LineLabelPlacement;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class LineIndicatorRenderer
extends AbstractIndicatorRenderer<Bullet> {
    private double breadth = 0.75;
    private double length = 0.1;
    private Border border = null;
    private LineLabelPlacement labelPlacement = LineLabelPlacement.ABOVE;
    private BufferedImage indicatorImage = null;
    private double linePosition = 0.5;

    public double getBreadth() {
        return this.breadth;
    }

    public void setBreadth(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The breadth proportion should be a value in the range [0,1]");
        }
        this.breadth = d;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double d) {
        this.length = d;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public LineLabelPlacement getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(LineLabelPlacement lineLabelPlacement) {
        this.labelPlacement = lineLabelPlacement;
    }

    public double getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The linePosition property must be a value between 0 and 1");
        }
        this.linePosition = d;
    }

    @Override
    protected Shape calculateShape(Bullet bullet, Double d) {
        if (d == null) {
            return null;
        }
        BulletAxis bulletAxis = bullet.getAxis();
        Point2D point2D = bullet.calculatePixelPoint2D(bulletAxis, (double)d);
        Rectangle2D.Double double_ = null;
        if (point2D != null) {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7 = bullet.getMidY();
            double d8 = bullet.getMidX();
            double d9 = bullet.getBulletBreadth();
            double d10 = this.breadth * d9;
            double d11 = d10 * this.length;
            Orientation orientation = bullet.getOrientation();
            if (orientation == Orientation.horizontal) {
                d6 = d7 + (this.linePosition - 0.5) * d9;
                d5 = point2D.getX() - d11 / 2.0;
                d4 = d6 - d10 / 2.0;
                d3 = d11;
                d2 = d10;
            } else {
                d6 = d8 + (this.linePosition - 0.5) * d9;
                d5 = d6 - d10 / 2.0;
                d4 = point2D.getY() - d11 / 2.0;
                d3 = d10;
                d2 = d11;
            }
            int n = (int)Math.floor(d5);
            int n2 = (int)Math.floor(d4);
            int n3 = (int)Math.ceil(d3);
            int n4 = (int)Math.ceil(d2);
            double_ = new Rectangle2D.Double(n, n2, n3, n4);
        }
        return double_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawIndicator(Graphics2D graphics2D, Bullet bullet, Shape shape, IndicatorStyle indicatorStyle) {
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        try {
            Rectangle rectangle = shape.getBounds();
            double d = this.breadth * bullet.getBulletBreadth();
            Object object = graphics2D2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Paint paint = indicatorStyle.getFill();
            if (paint != null) {
                graphics2D2.setPaint(paint);
                graphics2D2.fill(rectangle);
                graphics2D2.draw(rectangle);
            }
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            if (this.border == null) {
                Color color = indicatorStyle.getOutline();
                if (color != null) {
                    float f = indicatorStyle.getOutlineWidth();
                    float f2 = (float)((double)f * d / 100.0);
                    if (f2 < 1.0f) {
                        f2 = 1.0f;
                    }
                    BasicStroke basicStroke = new BasicStroke(f2);
                    Stroke stroke = graphics2D2.getStroke();
                    graphics2D2.setStroke(basicStroke);
                    graphics2D2.setColor(color);
                    graphics2D2.draw(rectangle);
                    graphics2D2.setStroke(stroke);
                }
            } else {
                this.border.paintBorder(bullet, graphics2D2, rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
            }
        }
        finally {
            if (graphics2D2 != null) {
                graphics2D2.dispose();
            }
        }
    }

    @Override
    public void paintLabel(Graphics2D graphics2D, Bullet bullet, Double d, IndicatorStyle indicatorStyle) {
        String string = this.generateLabel(d);
        if (string != null && this.labelPlacement != null && this.labelVisible) {
            BulletAxis bulletAxis = bullet.getAxis();
            Point2D point2D = bullet.calculatePixelPoint2D(bulletAxis, (double)d);
            double d2 = this.breadth * bullet.getBulletBreadth();
            double d3 = d2 * this.length;
            Orientation orientation = bullet.getOrientation();
            double d4 = orientation == Orientation.horizontal ? point2D.getX() - d3 / 2.0 : point2D.getX() - d2 / 2.0;
            double d5 = orientation == Orientation.horizontal ? point2D.getY() - d2 / 2.0 : point2D.getY() - d3 / 2.0;
            double d6 = orientation == Orientation.horizontal ? d3 : d2;
            double d7 = orientation == Orientation.horizontal ? d2 : d3;
            Font font = this.getLabelFont() == null ? UIManager.getFont("Label.font") : this.getLabelFont();
            Dimension dimension = bullet.getFontComparisonSize();
            Font font2 = ChartUtils.deriveResizedFont(font, dimension, bullet);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.charWidth('o');
            graphics2D.setColor(this.getLabelColor());
            graphics2D.setFont(font2);
            Float f = null;
            Float f2 = null;
            if (this.labelPlacement == LineLabelPlacement.ABOVE) {
                f = Float.valueOf((float)(d4 + d6 / 2.0 - (double)n / 2.0));
                f2 = Float.valueOf((float)(d5 - (double)fontMetrics.getDescent()));
            } else if (this.labelPlacement == LineLabelPlacement.BELOW) {
                f = Float.valueOf((float)(d4 + d6 / 2.0 - (double)n / 2.0));
                f2 = Float.valueOf((float)(d5 + d7 + (double)fontMetrics.getAscent()));
            } else if (this.labelPlacement == LineLabelPlacement.LEFT) {
                f = Float.valueOf((float)(d4 - (double)n2 / 2.0 - (double)n));
                f2 = Float.valueOf((float)(d5 + d7 / 2.0 + (double)fontMetrics.getAscent() / 2.0));
            } else if (this.labelPlacement == LineLabelPlacement.RIGHT) {
                f = Float.valueOf((float)(d4 + d6 + (double)n2 / 2.0));
                f2 = Float.valueOf((float)(d5 + d7 / 2.0 + (double)fontMetrics.getAscent() / 2.0));
            }
            if (f != null && f2 != null) {
                Color color = this.getLabelColor();
                graphics2D.setColor(color == null ? Color.BLACK : color);
                graphics2D.setFont(font2);
                graphics2D.drawString(string, f.floatValue(), f2.floatValue());
            }
        }
    }

    @Override
    public Shape paintLegendItem(Graphics graphics, Bullet bullet, IndicatorStyle indicatorStyle, int n, int n2) {
        Object object;
        Rectangle rectangle;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Paint paint = indicatorStyle.getFill();
        graphics2D.setPaint(paint);
        int n3 = n2 - 4;
        int n4 = n - 4;
        if (bullet.getOrientation() == Orientation.horizontal) {
            n4 = n3 / 4;
            rectangle = new Rectangle(n / 2 - n4 / 2, 2, n4, n3);
        } else {
            n3 = n4 / 4;
            rectangle = new Rectangle(3, n2 / 2 - n3 / 2, n4 - 2, n3);
        }
        graphics2D.fill(rectangle);
        Color color = indicatorStyle.getOutline();
        if (color != null) {
            float f = indicatorStyle.getOutlineWidth();
            object = new BasicStroke(f);
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(color);
            graphics2D.draw(rectangle);
        }
        ShadowRenderer shadowRenderer = this.getShadowRenderer();
        if (bullet.isShadowVisible()) {
            object = shadowRenderer.createShadow(bufferedImage);
            graphics.drawImage((Image)object, 0, 0, bullet);
        }
        graphics.drawImage(bufferedImage, 0, 0, bullet);
        graphics2D.dispose();
        return null;
    }
}

