/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.gauge.Dial;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.Arrays;

public class DialRadialPaint
implements Paint {
    private Dial dial;
    private float[] fractions;
    private Color[] colors;
    private float offsetRadius = 0.0f;
    private float offsetAngle = 0.0f;
    private Float radiusProportion = null;

    public DialRadialPaint(Dial dial, float[] fArray, Color[] colorArray) {
        this(dial, fArray, colorArray, 0.0f, 0.0f);
    }

    public DialRadialPaint(Dial dial, float[] fArray, Color[] colorArray, float f, float f2) {
        this.dial = dial;
        this.fractions = Arrays.copyOf(fArray, fArray.length);
        this.colors = Arrays.copyOf(colorArray, colorArray.length);
        this.offsetRadius = f;
        this.offsetAngle = f2;
    }

    public float getRadiusProportion() {
        return this.radiusProportion.floatValue();
    }

    public void setRadiusProportion(Float f) {
        this.radiusProportion = f;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        float f = this.dial.getPivotX();
        float f2 = this.dial.getPivotY();
        float f3 = this.radiusProportion == null ? this.dial.getRadius() : this.radiusProportion.floatValue() * this.dial.getRadius();
        float f4 = (float)((double)f + (double)(this.offsetRadius * f3) * Math.cos(Math.toRadians(this.offsetAngle)));
        float f5 = (float)((double)f2 - (double)(this.offsetRadius * f3) * Math.sin(Math.toRadians(this.offsetAngle)));
        Paint paint = JideSwingUtilities.getRadialGradientPaint(f4, f5, f3, this.fractions, this.colors);
        return paint.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    @Override
    public int getTransparency() {
        return 3;
    }
}

