/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.gauge.Dial;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.Arrays;

public class DialLinearPaint
implements Paint {
    public static final MultipleGradientPaint.CycleMethod NO_CYCLE = MultipleGradientPaint.CycleMethod.NO_CYCLE;
    public static final MultipleGradientPaint.CycleMethod REFLECT = MultipleGradientPaint.CycleMethod.REFLECT;
    public static final MultipleGradientPaint.CycleMethod REPEAT = MultipleGradientPaint.CycleMethod.REPEAT;
    private Dial dial;
    private float[] fractions;
    private Color[] colors;
    private float startRadius;
    private float startAngle;
    private float endRadius;
    private float endAngle;
    private float offsetAngle = 0.0f;
    private float offsetRadius = 0.0f;
    private MultipleGradientPaint.CycleMethod cycleMethod = null;

    public DialLinearPaint(Dial dial, float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        this(dial, f, f2, f3, f4, fArray, colorArray, null);
    }

    public DialLinearPaint(Dial dial, float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethod cycleMethod) {
        this.dial = dial;
        this.fractions = Arrays.copyOf(fArray, fArray.length);
        this.colors = Arrays.copyOf(colorArray, colorArray.length);
        this.startRadius = f;
        this.startAngle = f2;
        this.endRadius = f3;
        this.endAngle = f4;
        this.cycleMethod = cycleMethod;
    }

    public float getOffsetAngle() {
        return this.offsetAngle;
    }

    public void setOffsetAngle(float f) {
        this.offsetAngle = f;
    }

    public float getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(float f) {
        this.offsetRadius = f;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        float f = this.dial.getPivotX();
        float f2 = this.dial.getPivotY();
        float f3 = this.dial.getRadius();
        float f4 = (float)((double)f + (double)(this.offsetRadius * f3) * Math.cos(Math.toRadians(this.offsetAngle)));
        float f5 = (float)((double)f2 - (double)(this.offsetRadius * f3) * Math.sin(Math.toRadians(this.offsetAngle)));
        float f6 = (float)((double)f4 + (double)(this.startRadius * f3) * Math.cos(Math.toRadians(this.startAngle)));
        float f7 = (float)((double)f5 - (double)(this.startRadius * f3) * Math.sin(Math.toRadians(this.startAngle)));
        float f8 = (float)((double)f4 + (double)(this.endRadius * f3) * Math.cos(Math.toRadians(this.endAngle)));
        float f9 = (float)((double)f5 - (double)(this.endRadius * f3) * Math.sin(Math.toRadians(this.endAngle)));
        LinearGradientPaint linearGradientPaint = this.cycleMethod == null ? new LinearGradientPaint(f6, f7, f8, f9, this.fractions, this.colors) : new LinearGradientPaint(f6, f7, f8, f9, this.fractions, this.colors, this.cycleMethod);
        return linearGradientPaint.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    @Override
    public int getTransparency() {
        return 3;
    }
}

