/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.gauge.AbstractNumericGaugeAxis;
import com.jidesoft.gauge.DialLabelOrientation;
import com.jidesoft.gauge.DialTickStyle;
import com.jidesoft.range.NumericRange;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;

public class DialAxis
extends AbstractNumericGaugeAxis<DialTickStyle> {
    public static final String PROPERTY_INNER_RADIUS = "InnerRadius";
    public static final String PROPERTY_OUTER_RADIUS = "OuterRadius";
    public static final String PROPERTY_LABEL_RADIUS = "LabelRadius";
    private double innerRadius = 0.85;
    private double outerRadius = 0.95;
    private double labelRadius = 0.75;
    private DialLabelOrientation labelOrientation;
    private Paint fill;
    private Color borderColor = null;
    private BasicStroke borderStroke = new BasicStroke(1.0f);
    private boolean tickLabelsVisible = true;
    private double startAngle = 225.0;
    private double endAngle = -45.0;

    public DialAxis() {
        this.setMajorTickStyle(new DialTickStyle());
        this.setMinorTickStyle(new DialTickStyle(0.4));
    }

    public DialAxis(double d, double d2) {
        super(d, d2);
        this.setMajorTickStyle(new DialTickStyle());
        this.setMinorTickStyle(new DialTickStyle(0.4));
    }

    public DialAxis(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.setMajorTickStyle(new DialTickStyle());
        this.setMinorTickStyle(new DialTickStyle(0.4));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public void setEndAngle(double d) {
        this.endAngle = d;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double d) {
        double d2 = this.innerRadius;
        this.innerRadius = d;
        this.support.firePropertyChange(PROPERTY_INNER_RADIUS, d2, d);
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double d) {
        double d2 = this.outerRadius;
        this.outerRadius = d;
        this.support.firePropertyChange(PROPERTY_OUTER_RADIUS, d2, d);
    }

    public DialLabelOrientation getLabelOrientation() {
        return this.labelOrientation;
    }

    public void setLabelOrientation(DialLabelOrientation dialLabelOrientation) {
        this.labelOrientation = dialLabelOrientation;
    }

    public double getLabelRadius() {
        return this.labelRadius;
    }

    public void setLabelRadius(double d) {
        double d2 = this.labelRadius;
        this.labelRadius = d;
        this.support.firePropertyChange(PROPERTY_LABEL_RADIUS, d2, d);
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public BasicStroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(BasicStroke basicStroke) {
        this.borderStroke = basicStroke;
    }

    public double getRangeStart() {
        return this.range.minimum();
    }

    public void setRangeStart(double d) {
        NumericRange numericRange = new NumericRange(this.range.minimum(), this.range.maximum());
        this.range.setMin(d);
        this.updateTicks();
        this.support.firePropertyChange("Range", numericRange, this.range);
    }

    public double getRangeEnd() {
        return this.range.maximum();
    }

    public void setRangeEnd(double d) {
        NumericRange numericRange = new NumericRange(this.range.minimum(), this.range.maximum());
        this.range.setMax(d);
        this.updateTicks();
        this.support.firePropertyChange("Range", numericRange, this.range);
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        this.tickLabelsVisible = bl;
    }
}

