/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.Bullet;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Icon;
import javax.swing.JLabel;

public class BulletLabel
extends JLabel {
    private Bullet bullet;
    private ResizeListener resizeListener = new ResizeListener();
    private Font initialFont = null;
    private boolean alignToBullet = true;

    public BulletLabel(Bullet bullet) {
        this.bullet = bullet;
        bullet.addComponentListener(this.resizeListener);
    }

    public BulletLabel(Bullet bullet, Icon icon) {
        super(icon);
        this.bullet = bullet;
        bullet.addComponentListener(this.resizeListener);
    }

    public BulletLabel(Bullet bullet, Icon icon, int n) {
        super(icon, n);
        this.bullet = bullet;
        bullet.addComponentListener(this.resizeListener);
    }

    public BulletLabel(Bullet bullet, String string) {
        super(string);
        this.bullet = bullet;
        bullet.addComponentListener(this.resizeListener);
    }

    public BulletLabel(Bullet bullet, String string, int n) {
        super(string, n);
        this.bullet = bullet;
        bullet.addComponentListener(this.resizeListener);
    }

    public BulletLabel(Bullet bullet, String string, Icon icon, int n) {
        super(string, icon, n);
        this.bullet = bullet;
        bullet.addComponentListener(this.resizeListener);
    }

    public boolean isAlignToBullet() {
        return this.alignToBullet;
    }

    public void setAlignToBullet(boolean bl) {
        this.alignToBullet = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.initialFont == null) {
            this.initialFont = this.getFont();
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle rectangle = graphics2D.getClipBounds();
        Orientation orientation = this.bullet.getOrientation();
        if (this.alignToBullet && orientation == Orientation.horizontal) {
            double d = this.bullet.getMidY();
            double d2 = (double)(this.bullet.getYEnd() + this.bullet.getYStart()) / 2.0;
            Font font = this.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            double d3 = d - d2 + (double)this.getHeight() / 2.0 - (double)n / 2.0;
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + (int)d3, rectangle.width, rectangle.height);
            graphics2D.setClip(rectangle2);
            graphics2D.translate(0.0, d3);
        }
        super.paintComponent(graphics2D);
        graphics2D.dispose();
    }

    private class ResizeListener
    implements ComponentListener {
        private long fontChangeTimestamp = 0L;

        private ResizeListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (BulletLabel.this.initialFont != null && BulletLabel.this.bullet.isResizeFonts()) {
                Dimension dimension = BulletLabel.this.bullet.getFontComparisonSize();
                Font font = ChartUtils.deriveResizedFont(BulletLabel.this.initialFont, dimension, BulletLabel.this.bullet);
                Font font2 = BulletLabel.this.getFont();
                int n = Math.abs(font2.getSize() - font.getSize());
                long l = System.currentTimeMillis();
                if (n > 1 && (n > 2 || l - this.fontChangeTimestamp > 500L)) {
                    BulletLabel.this.setFont(font);
                    this.fontChangeTimestamp = l;
                }
            }
        }
    }
}

