/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.awt.geom.Insets2D;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.ZOrderComparator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.gauge.AbstractGauge;
import com.jidesoft.gauge.AbstractIndicatorRenderer;
import com.jidesoft.gauge.BarIndicatorRenderer;
import com.jidesoft.gauge.BulletAxis;
import com.jidesoft.gauge.BulletAxisPlacement;
import com.jidesoft.gauge.BulletTickStyle;
import com.jidesoft.gauge.DefaultGaugeModel;
import com.jidesoft.gauge.GaugeModel;
import com.jidesoft.gauge.IndicatorRenderer;
import com.jidesoft.gauge.IndicatorStyle;
import com.jidesoft.range.Positionable;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.border.Border;

public class Bullet
extends AbstractGauge<BulletAxis> {
    private static final long serialVersionUID = 1091447730522337997L;
    private final double DEFAULT_MINOR_TICK_LENGTH = 0.1;
    private final double DEFAULT_MAJOR_TICK_LENGTH = 0.2;
    private final double DEFAULT_TICK_WIDTH = 0.05;
    public static final int INDICATOR_Z_ORDER = 100;
    public static final String DEFAULT_INDICATOR_NAME = "default";
    public static final String PROPERTY_BULLET_FOREGROUND = "Bullet Foreground";
    public static final String PROPERTY_BULLET_BACKGROUND = "Bullet Background";
    private Orientation orientation = Orientation.horizontal;
    private Paint bulletBackground = new Color(216, 216, 216);
    private Border bulletBorder = null;
    private List<BulletAxis> axes = new ArrayList<BulletAxis>();
    private double breadthProportion = 0.1;
    private List<Drawable> drawables = new CopyOnWriteArrayList<Drawable>();
    private int xStart;
    private int yStart;
    private int xEnd;
    private int yEnd;
    private int bulletPixelLength;
    private double bulletPixelBreadth;
    private double barPixelBreadth;
    private double bulletBottom;
    private double bulletTop;
    private double bulletLeft;
    private double bulletRight;
    private double midY;
    private double midX;
    private IndicatorRenderer renderer = new BarIndicatorRenderer();
    private List<String> valueNames = new CopyOnWriteArrayList<String>();
    private Map<String, IndicatorRenderer> renderers = new HashMap<String, IndicatorRenderer>();
    private Map<String, IndicatorStyle> styles = new HashMap<String, IndicatorStyle>();
    private Map<String, Shape> shapes = new HashMap<String, Shape>();
    private Insets2D insets2D = null;

    public Bullet() {
        this(new Dimension(300, 300));
    }

    public Bullet(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.setModel(new DefaultGaugeModel());
        this.setAxis(new BulletAxis());
        this.setOpaque(true);
        this.updateCoordinates(this.getGraphics());
    }

    public BulletAxis getAxis() {
        if (this.axes == null || this.axes.size() == 0) {
            throw new IllegalStateException("No axes are currently defined for this Bullet object");
        }
        return this.axes.get(0);
    }

    public void setAxis(BulletAxis bulletAxis) {
        this.axes.clear();
        this.axes.add(bulletAxis);
    }

    public void addAxis(BulletAxis bulletAxis) {
        if (this.axes.size() >= 2) {
            throw new IllegalStateException("The Bullet class currently has a limit of two axes and this object has already reached the limit");
        }
        this.axes.add(bulletAxis);
    }

    public Insets2D getProportionalInsets() {
        return this.insets2D;
    }

    public void setProportionalInsets(Insets2D insets2D) {
        this.insets2D = insets2D;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public IndicatorRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(IndicatorRenderer indicatorRenderer) {
        this.renderer = indicatorRenderer;
    }

    public IndicatorRenderer getRenderer(String string) {
        return this.renderers.get(string);
    }

    public void setRenderer(String string, IndicatorRenderer indicatorRenderer) {
        if (!this.valueNames.contains(string)) {
            this.valueNames.add(string);
        }
        if (indicatorRenderer == null) {
            this.renderers.remove(string);
        } else {
            this.renderers.put(string, indicatorRenderer);
        }
    }

    public void addDrawable(Drawable drawable) {
        this.drawables.add(drawable);
        this.repaint();
    }

    public void removeDrawable(Drawable drawable) {
        this.drawables.remove(drawable);
        this.repaint();
    }

    boolean hasDrawable(Drawable drawable) {
        return this.drawables.contains(drawable);
    }

    public void removeDrawables() {
        this.drawables.clear();
        this.repaint();
    }

    public Paint getBulletBackground() {
        return this.bulletBackground;
    }

    public void setBulletBackground(Paint paint) {
        Paint paint2 = this.bulletBackground;
        this.bulletBackground = paint;
        this.repaint();
        this.firePropertyChange(PROPERTY_BULLET_BACKGROUND, paint2, paint);
    }

    public Border getBulletBorder() {
        return this.bulletBorder;
    }

    public void setBulletBorder(Border border) {
        this.bulletBorder = border;
    }

    public Shape renderedAs(String string) {
        return this.shapes.get(string);
    }

    public List<String> containingShapes(Point point) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Shape> entry : this.shapes.entrySet()) {
            Shape shape = entry.getValue();
            String string = entry.getKey();
            if (!shape.contains(point)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> renderedValues() {
        Set<String> set = this.shapes.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList);
        return arrayList;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public int getXStart() {
        return this.xStart;
    }

    public int getYEnd() {
        return this.yEnd;
    }

    public int getYStart() {
        return this.yStart;
    }

    public double getMidY() {
        return this.midY;
    }

    public double getMidX() {
        return this.midX;
    }

    @Override
    public void setValue(String string, Positionable positionable, boolean bl) {
        GaugeModel gaugeModel = this.getModel();
        if (gaugeModel == null) {
            throw new IllegalStateException("Model is not set");
        }
        Positionable positionable2 = gaugeModel.getValue(string);
        Double d = positionable2 == null ? null : Double.valueOf(positionable2.position());
        Double d2 = positionable == null ? null : Double.valueOf(positionable.position());
        gaugeModel.setValue(string, positionable, bl);
        if (!this.valueNames.contains(string)) {
            this.valueNames.add(string);
        }
        this.firePropertyChange(string, d, d2);
    }

    public Bullet addIndicator(String string, IndicatorStyle indicatorStyle) {
        this.setIndicatorStyle(string, indicatorStyle);
        return this;
    }

    public void removeIndicator(String string) {
        this.styles.remove(string);
        if (this.valueNames != null) {
            this.valueNames.remove(string);
        }
    }

    public void removeIndicators() {
        if (this.styles != null) {
            this.styles.clear();
        }
        if (this.valueNames != null) {
            this.valueNames.clear();
        }
    }

    public void setIndicatorStyle(IndicatorStyle indicatorStyle) {
        this.setIndicatorStyle(DEFAULT_INDICATOR_NAME, indicatorStyle);
    }

    public void setIndicatorStyle(String string, IndicatorStyle indicatorStyle) {
        if (!this.valueNames.contains(string)) {
            this.valueNames.add(string);
        }
        if (indicatorStyle == null) {
            this.styles.remove(string);
        } else {
            this.styles.put(string, indicatorStyle);
        }
    }

    public IndicatorStyle getIndicatorStyle(String string) {
        return this.styles.get(string);
    }

    public void removeStyles() {
        this.styles.clear();
    }

    protected double calculatePixelCoordinate(BulletAxis bulletAxis, double d) {
        double d2 = this.proportionOfRange(d, bulletAxis);
        if (this.orientation == Orientation.horizontal) {
            return (double)this.xStart + d2 * (double)(this.xEnd - this.xStart);
        }
        return (double)this.yStart - d2 * (double)(this.yStart - this.yEnd);
    }

    @Override
    protected Point2D calculatePixelPoint2D(BulletAxis bulletAxis, double d) {
        double d2 = this.proportionOfRange(d, bulletAxis);
        if (this.orientation == Orientation.horizontal) {
            double d3 = (double)this.xStart + d2 * (double)(this.xEnd - this.xStart);
            return new Point2D.Double(d3, this.midY);
        }
        double d4 = (double)this.yStart - d2 * (double)(this.yStart - this.yEnd);
        return new Point2D.Double(this.midX, d4);
    }

    private double proportionOfRange(Double d, BulletAxis bulletAxis) {
        double d2 = bulletAxis.minimum();
        double d3 = bulletAxis.maximum();
        if (d == null || d < d2) {
            return 0.0;
        }
        if (d > d3) {
            return 1.0;
        }
        return (d - d2) / (d3 - d2);
    }

    private Pair<String, String> longestTickLabels() {
        String string = null;
        String string2 = null;
        for (BulletAxis bulletAxis : this.axes) {
            String string3;
            List<Tick> list = bulletAxis.ticks();
            if (list == null || list.size() < 1) continue;
            Tick tick = list.get(0);
            Tick tick2 = list.get(list.size() - 1);
            String string4 = tick.getLabel();
            if (string4 != null && (string == null || string.length() < string4.length())) {
                string = tick.getLabel();
            }
            if ((string3 = tick2.getLabel()) == null || string2 != null && string2.length() >= string3.length()) continue;
            string2 = tick2.getLabel();
        }
        return new Pair<Object, Object>(string, string2);
    }

    public void update() {
        this.updateCoordinates(this.getGraphics());
    }

    void updateCoordinates(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension == null) {
            return;
        }
        Insets insets = this.getInsets();
        BulletAxis bulletAxis = this.getAxis();
        this.xStart = insets.left;
        this.xEnd = dimension.width - insets.right;
        this.yStart = dimension.height - insets.bottom;
        this.yEnd = insets.top;
        if (this.insets2D != null) {
            this.xStart = (int)((long)this.xStart + Math.round(this.insets2D.getLeft() * (double)dimension.width));
            this.xEnd = (int)((long)this.xEnd - Math.round(this.insets2D.getRight() * (double)dimension.width));
            this.yStart = (int)((long)this.yStart - Math.round(this.insets2D.getBottom() * (double)dimension.height));
            this.yEnd = (int)((long)this.yEnd + Math.round(this.insets2D.getTop() * (double)dimension.height));
        } else {
            Iterator<BulletAxis> iterator;
            Object object;
            FontMetrics fontMetrics;
            Pair<String, String> pair = this.longestTickLabels();
            Font font = this.tickLabelFontForAxis(bulletAxis);
            FontMetrics fontMetrics2 = fontMetrics = graphics == null ? null : graphics.getFontMetrics(font);
            if (fontMetrics == null) {
                object = new BufferedImage(1, 1, 2);
                iterator = ((BufferedImage)object).getGraphics();
                fontMetrics = ((Graphics)((Object)iterator)).getFontMetrics();
            }
            if (bulletAxis.isVisible()) {
                if (this.orientation == Orientation.horizontal) {
                    object = pair.getFirst();
                    this.xStart = (int)((long)this.xStart + (object == null ? 0L : 1L + Math.round((double)(fontMetrics.stringWidth((String)object) + 1) / 2.0)));
                    iterator = pair.getSecond();
                    this.xEnd = (int)((double)this.xEnd - (iterator == null ? 0.0 : (double)fontMetrics.stringWidth((String)((Object)iterator)) / 2.0));
                } else {
                    this.yStart -= fontMetrics.getDescent() + fontMetrics.getDescent();
                    this.yEnd += fontMetrics.getAscent() - fontMetrics.getDescent();
                }
            }
        }
        this.bulletPixelLength = this.orientation == Orientation.horizontal ? this.xEnd - this.xStart : this.yStart - this.yEnd;
        this.bulletPixelBreadth = this.breadthProportion * (double)this.bulletPixelLength;
        double d = 0.0;
        double d2 = 0.0;
        for (BulletAxis bulletAxis2 : this.axes) {
            double d3 = this.axisBreadth(graphics, bulletAxis2);
            if (this.orientation == Orientation.horizontal && bulletAxis2.getPlacement() == BulletAxisPlacement.TRAILING) {
                d += d3;
            }
            d2 += d3;
        }
        double d4 = this.bulletPixelBreadth + d2;
        this.midY = this.orientation == Orientation.horizontal ? ((double)(this.yStart - this.yEnd) - d4) / 2.0 + d + this.bulletPixelBreadth / 2.0 : (double)(this.yStart + this.yEnd) / 2.0;
        this.midX = (double)(this.xStart + this.xEnd) / 2.0;
        this.bulletTop = this.orientation == Orientation.horizontal ? this.midY - this.bulletPixelBreadth / 2.0 : (double)this.yEnd;
        this.bulletBottom = this.orientation == Orientation.horizontal ? this.midY + this.bulletPixelBreadth / 2.0 : (double)this.yStart;
        this.bulletLeft = this.orientation == Orientation.horizontal ? (double)this.xStart : this.midX - this.bulletPixelBreadth / 2.0;
        this.bulletRight = this.orientation == Orientation.horizontal ? (double)this.xEnd : this.midX + this.bulletPixelBreadth / 2.0;
    }

    public double getBulletBreadth() {
        int n = this.orientation == Orientation.horizontal ? this.xEnd - this.xStart : this.yStart - this.yEnd;
        return this.breadthProportion * (double)n;
    }

    public double getBreadthProportion() {
        return this.breadthProportion;
    }

    public void setBreadthProportion(double d) {
        this.breadthProportion = d;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object;
        Object object2;
        Object object3;
        Rectangle rectangle;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize();
        if (dimension == null) {
            return;
        }
        this.updateCoordinates(graphics2D);
        Shape shape = graphics2D.getClip();
        Rectangle rectangle2 = rectangle = shape == null ? new Rectangle(0, 0, dimension.width, dimension.height) : shape.getBounds();
        if (this.isOpaque()) {
            graphics2D.setPaint(this.getBackgroundPaint());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.paintBulletBackground(graphics2D);
        this.paintBulletBorder(graphics2D);
        for (BulletAxis object62 : this.axes) {
            if (!object62.isVisible()) continue;
            this.paintAxis(graphics2D, object62);
        }
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>(this.drawables);
        Collections.sort(arrayList, new ZOrderComparator());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object3 = (Drawable)iterator.next();
            if (object3 instanceof ZOrder) {
                ZOrder zOrder = (ZOrder)object3;
                if (zOrder.getZOrder() >= 0 && zOrder.getZOrder() < 100) {
                    object3.draw(graphics2D);
                    continue;
                }
                if (zOrder.getZOrder() < 100) continue;
                break;
            }
            object3.draw(graphics2D);
        }
        this.shapes.clear();
        ArrayList<Pair<Integer, String>> arrayList2 = new ArrayList<Pair<Integer, String>>();
        for (String string : this.valueNames) {
            IndicatorRenderer indicatorRenderer = this.renderers.get(string);
            if (indicatorRenderer == null) continue;
            object2 = 100;
            if (indicatorRenderer instanceof ZOrder) {
                object = (ZOrder)((Object)indicatorRenderer);
                object2 = object.getZOrder();
            }
            arrayList2.add(new Pair<Integer, String>((Integer)object2, string));
        }
        object3 = new Comparator<Pair<Integer, String>>(){

            @Override
            public int compare(Pair<Integer, String> pair, Pair<Integer, String> pair2) {
                int n;
                int n2 = pair.getFirst();
                if (n2 == (n = pair2.getFirst().intValue())) {
                    return 0;
                }
                return n2 < n ? -1 : 1;
            }
        };
        Collections.sort(arrayList2, object3);
        for (Pair pair : arrayList2) {
            object2 = (String)pair.getSecond();
            object = this.renderers.get(object2);
            IndicatorStyle indicatorStyle = this.styles.get(object2);
            if (indicatorStyle == null) {
                indicatorStyle = new IndicatorStyle();
            }
            Double d = this.getValue((String)object2);
            Shape shape2 = object.paintIndicator(graphics2D, this, d, indicatorStyle);
            this.shapes.put((String)object2, shape2);
        }
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            Drawable drawable = (Drawable)iterator2.next();
            if (!(drawable instanceof ZOrder) || (object2 = (ZOrder)((Object)drawable)).getZOrder() < 100) continue;
            drawable.draw(graphics2D);
        }
        for (String string : this.valueNames) {
            object2 = this.renderers.get(string);
            if (object2 == null) {
                object2 = this.renderer;
            }
            if (!(object2 instanceof AbstractIndicatorRenderer)) continue;
            object = (AbstractIndicatorRenderer)object2;
            ((AbstractIndicatorRenderer)object).paintLabel(graphics2D, this, this.getValue(string), null);
        }
    }

    protected Rectangle2D paintBulletBackground(Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle2D.Double double_ = null;
        if (this.bulletBackground != null) {
            graphics2D.setPaint(this.bulletBackground);
            double d = (int)(this.bulletRight - this.bulletLeft);
            double d2 = (int)(this.bulletBottom - this.bulletTop);
            double_ = new Rectangle2D.Double(this.bulletLeft, this.bulletTop, d, d2);
            graphics2D.fill(double_);
            graphics2D.draw(double_);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        return double_;
    }

    protected void paintBulletBorder(Graphics2D graphics2D) {
        if (this.bulletBorder != null) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            int n = (int)(this.bulletRight - this.bulletLeft + 1.0);
            int n2 = (int)(this.bulletBottom - this.bulletTop + 1.0);
            this.bulletBorder.paintBorder(this, graphics2D, (int)this.bulletLeft, (int)this.bulletTop, n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    private double axisBreadth(Graphics graphics, BulletAxis bulletAxis) {
        if (bulletAxis == null) {
            return 0.0;
        }
        BulletTickStyle bulletTickStyle = (BulletTickStyle)bulletAxis.getMajorTickStyle();
        BulletTickStyle bulletTickStyle2 = (BulletTickStyle)bulletAxis.getMinorTickStyle();
        if (!bulletAxis.isVisible()) {
            return 0.0;
        }
        if (!(bulletTickStyle != null && bulletTickStyle.isVisible() || bulletTickStyle2 != null && bulletTickStyle2.isVisible())) {
            return 0.0;
        }
        if (bulletTickStyle != null && !bulletTickStyle.isVisible() && bulletTickStyle2 != null && bulletTickStyle2.isVisible()) {
            double d = bulletTickStyle2 == null ? this.bulletPixelBreadth * 0.1 : this.bulletPixelBreadth * bulletTickStyle2.getTickLength();
            return d;
        }
        if (graphics == null) {
            return 0.0;
        }
        Font font = this.tickLabelFontForAxis(bulletAxis);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        double d = bulletTickStyle == null ? this.bulletPixelBreadth * 0.2 : this.bulletPixelBreadth * bulletTickStyle.getTickLength();
        return d + (double)n;
    }

    protected void paintAxis(Graphics2D graphics2D, BulletAxis bulletAxis) {
        float f;
        double d;
        Dimension dimension = this.getSize();
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setColor(Color.black);
        Color color = bulletAxis.getTickLabelColor();
        if (color == null) {
            color = Color.BLACK;
        }
        BulletTickStyle bulletTickStyle = (BulletTickStyle)bulletAxis.getMajorTickStyle();
        BulletTickStyle bulletTickStyle2 = (BulletTickStyle)bulletAxis.getMinorTickStyle();
        boolean bl = bulletTickStyle == null || bulletTickStyle.isVisible();
        boolean bl2 = bulletTickStyle2 == null || bulletTickStyle2.isVisible();
        Color color2 = bulletTickStyle == null ? Color.BLACK : bulletTickStyle.getTickColor();
        Color color3 = bulletTickStyle2 == null ? Color.BLACK : bulletTickStyle2.getTickColor();
        double d2 = bulletTickStyle == null ? this.bulletPixelBreadth * 0.2 : this.bulletPixelBreadth * bulletTickStyle.getTickLength();
        double d3 = bulletTickStyle2 == null ? this.bulletPixelBreadth * 0.1 : this.bulletPixelBreadth * bulletTickStyle2.getTickLength();
        double d4 = bulletTickStyle == null ? d2 * 0.05 : d2 * bulletTickStyle.getTickWidth();
        double d5 = d = bulletTickStyle2 == null ? d3 * 0.05 : d3 * bulletTickStyle2.getTickWidth();
        if (d4 < 1.0) {
            d4 = 1.0;
        }
        if (d < 1.0) {
            d = 1.0;
        }
        List<Tick> list = bulletAxis.ticks();
        double d6 = bulletAxis.minimum();
        double d7 = bulletAxis.maximum();
        double d8 = d7 - d6;
        Dimension dimension2 = this.getFontComparisonSize();
        if (this.isResizeFonts() && dimension != null && dimension.height > 0 && dimension2 != null) {
            float f2 = this.bulletPixelLength;
            float f3 = (float)(this.bulletPixelBreadth + d2);
            float f4 = f3 / (float)dimension2.height;
            f = f2 / (float)dimension2.width;
            this.setFontSizeRatio(Math.min(f4, f));
        }
        Font font = this.tickLabelFontForAxis(bulletAxis);
        graphics2D2.setFont(font);
        BulletAxisPlacement bulletAxisPlacement = bulletAxis.getPlacement();
        for (Tick tick : list) {
            float f5;
            float f6;
            Line2D.Double double_;
            double d9;
            double d10;
            double d11;
            boolean bl3 = tick.isMajor() ? bl : bl2;
            if (!bl3) continue;
            double d12 = d11 = tick.isMajor() ? d2 : d3;
            if (this.orientation == Orientation.horizontal) {
                d10 = (double)this.xStart + (tick.getPosition() - d6) / d8 * (double)this.bulletPixelLength;
                d9 = bulletAxisPlacement == BulletAxisPlacement.LEADING ? (double)((int)this.bulletBottom) : this.bulletTop - d11;
                double_ = new Line2D.Double(d10, d9, d10, d9 + d11);
            } else {
                d10 = bulletAxisPlacement == BulletAxisPlacement.LEADING ? this.bulletLeft - d11 : this.bulletRight;
                d9 = (double)this.yStart - (tick.getPosition() - d6) / d8 * (double)this.bulletPixelLength;
                double_ = new Line2D.Double(d10, d9, d10 + d11, d9);
            }
            graphics2D2.setColor(tick.isMajor() ? color2 : color3);
            double d13 = tick.isMajor() ? d4 : d;
            graphics2D2.setStroke(new BasicStroke((float)d13, 0, 2));
            graphics2D2.draw(double_);
            if (!tick.isMajor()) continue;
            graphics2D2.setColor(color);
            String string = tick.getLabel();
            if (this.orientation == Orientation.horizontal) {
                f6 = (float)d10;
                f5 = (float)(bulletAxisPlacement == BulletAxisPlacement.LEADING ? d9 + d11 : d9);
            } else {
                f6 = (float)(bulletAxisPlacement == BulletAxisPlacement.LEADING ? d10 - 1.0 : d10 + d11 + 1.0);
                f5 = (float)d9;
            }
            this.drawAxisTickLabel(graphics2D2, bulletAxis, string, f6, f5);
        }
        if (this.getFontComparisonSize() == null && dimension != null && dimension.width > 0 && dimension.height > 0) {
            float f7;
            if (this.orientation == Orientation.horizontal) {
                f7 = this.bulletPixelLength;
                f = (float)(this.bulletPixelBreadth + d2);
            } else {
                f7 = (float)(this.bulletPixelBreadth + d2);
                f = this.bulletPixelLength;
            }
            this.setFontComparisonSize(new Dimension((int)f7, (int)f));
        }
        graphics2D2.dispose();
    }

    private void drawAxisTickLabel(Graphics2D graphics2D, BulletAxis bulletAxis, String string, float f, float f2) {
        if (string == null) {
            return;
        }
        double d = bulletAxis.getTickLabelRotation();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.getDescent();
        int n2 = fontMetrics.getAscent();
        BulletAxisPlacement bulletAxisPlacement = bulletAxis.getPlacement();
        if (d == 0.0) {
            float f3;
            float f4;
            int n3 = fontMetrics.stringWidth(string);
            if (this.orientation == Orientation.horizontal) {
                f4 = f - (float)n3 / 2.0f;
                f3 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f2 - (float)n : f2 + (float)n2;
            } else {
                f4 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f + 1.0f : f - (float)n3 - 1.0f;
                f3 = f2 + (float)n;
            }
            this.drawStringIfWithinBounds(graphics2D, string, f4, f3);
        } else {
            boolean bl;
            String string2 = string;
            boolean bl2 = false;
            Font font = this.tickLabelFontForAxis(bulletAxis);
            do {
                float f5;
                float f6;
                float f7;
                String string3;
                String string4 = string3 = bl2 ? string2 + "\u2026" : string2;
                String string5 = string3.length() <= 1 ? "" : (d < 1.5707963267948966 && d > 0.0 ? string3.substring(string3.length() - 1, string3.length()) : string3.substring(0, 1));
                int n4 = fontMetrics.stringWidth(string5);
                int n5 = string2.length() <= 1 ? fontMetrics.stringWidth(string3) / 2 : fontMetrics.stringWidth(string3.substring(0, string3.length() - 1));
                float f8 = (float)n5 / 2.0f;
                float f9 = f7 = d < 1.5707963267948966 && d > 0.0 ? -((float)((double)f8 * Math.cos(d))) : (float)((double)f8 * Math.cos(d));
                if (this.orientation == Orientation.horizontal) {
                    f6 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f - f8 - f7 - (float)n4 / 2.0f : f - f8 + f7 - (float)n4 / 2.0f;
                    float f10 = (float)Math.abs((double)f8 * Math.sin(d));
                    f5 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f2 + (float)fontMetrics.getHeight() / 2.0f - (float)n2 - f10 : f2 + (float)fontMetrics.getHeight() / 2.0f + f10;
                } else {
                    f6 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? (float)((double)(f + (float)fontMetrics.charWidth(':')) + (double)f8 * Math.cos(d) - (double)((float)n4 / 2.0f)) : (float)((double)(f - (float)fontMetrics.charWidth('o') - f8) - (double)f8 * Math.cos(d) - (double)((float)n4 / 2.0f));
                    f5 = bulletAxisPlacement == BulletAxisPlacement.TRAILING ? f2 - (float)((double)f8 * Math.sin(d)) : f2 + (float)((double)f8 * Math.sin(d));
                }
                bl = this.drawRotatedStringIfWithinBounds(graphics2D, font, string3, f6, f5, d);
                string2 = string2.substring(0, string2.length() - 1);
                bl2 = true;
            } while (!bl && string2.length() > 0);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(Bullet.class.getName(), 4096);
        }
    }
}

