/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttChartPopupMenuCustomizer;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttEntryRelation;
import com.jidesoft.gantt.GanttEntryRelationModel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class RelationGanttChartPopupMenuCustomizer
implements GanttChartPopupMenuCustomizer {
    @Override
    public <T, S extends GanttEntry<T>> void customizePopupMenu(GanttChart<T, S> ganttChart, JPopupMenu jPopupMenu, int n, Point point) {
        S s = ganttChart.getEntryAt(n);
        if (s != null) {
            final GanttEntryRelationModel<S> ganttEntryRelationModel = ganttChart.getModel().getGanttEntryRelationModel();
            Set<GanttEntryRelation<S>> set = ganttEntryRelationModel.getEntryRelations(s);
            if (set.size() > 1) {
                JMenu jMenu = new JMenu(ganttChart.getResourceString("GanttChart.MenuItem.remove"));
                for (final GanttEntryRelation<S> ganttEntryRelation : set) {
                    S s2 = s == ganttEntryRelation.getSuccessorEntry() ? ganttEntryRelation.getPredecessorEntry() : ganttEntryRelation.getSuccessorEntry();
                    jMenu.add(new AbstractAction(s2.getName() + " " + this.getRelationString(ganttChart, ganttEntryRelation.getRelationType())){
                        private static final long serialVersionUID = -4720862224308490395L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ganttEntryRelationModel.removeEntryRelation(ganttEntryRelation);
                        }
                    });
                }
                jPopupMenu.add(jMenu);
            } else if (set.size() == 1) {
                for (final GanttEntryRelation<S> ganttEntryRelation : set) {
                    S s3 = s == ganttEntryRelation.getSuccessorEntry() ? ganttEntryRelation.getPredecessorEntry() : ganttEntryRelation.getSuccessorEntry();
                    String string = ganttChart.getResourceString("GanttChart.MenuItem.removeRelation");
                    jPopupMenu.add(new AbstractAction(MessageFormat.format(string, this.getRelationString(ganttChart, ganttEntryRelation.getRelationType()), s3.getName())){
                        private static final long serialVersionUID = -7567143271524345338L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ganttEntryRelationModel.removeEntryRelation(ganttEntryRelation);
                        }
                    });
                }
            }
        }
    }

    protected String getRelationString(GanttChart<?, ?> ganttChart, int n) {
        switch (n) {
            case 1: {
                return ganttChart.getResourceString("GanttChart.Relation.fs");
            }
            case 2: {
                return ganttChart.getResourceString("GanttChart.Relation.ss");
            }
            case 3: {
                return ganttChart.getResourceString("GanttChart.Relation.ff");
            }
            case 4: {
                return ganttChart.getResourceString("GanttChart.Relation.sf");
            }
        }
        return "";
    }
}

