/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.AbstractPeriodBackgroundPainter;
import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.scale.ScaleArea;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;

public class IntervalMarker<T>
extends AbstractPeriodBackgroundPainter<T> {
    private T _startInstant;
    private T _endInstant;
    private Paint _backgroundPaint;
    private Paint _outlinePaint;
    private Stroke _outlineStroke;
    private int _outlineSides;

    public IntervalMarker(Paint paint, Stroke stroke, T t) {
        this(null, paint, stroke, 1, t, t);
    }

    public IntervalMarker(Paint paint, Paint paint2, Stroke stroke, int n, T t, T t2) {
        super(null);
        this._startInstant = t;
        this._endInstant = t2;
        this._backgroundPaint = paint;
        this._outlinePaint = paint2;
        this._outlineStroke = stroke;
        this._outlineSides = n;
    }

    public IntervalMarker() {
        this(new Color(128, 128, 128, 64), Color.LIGHT_GRAY, null, 3, null, null);
    }

    @Override
    protected Paint getBackgroundPaint(T t, T t2) {
        return this._backgroundPaint;
    }

    @Override
    protected Paint getOutlinePaint(T t, T t2) {
        return this._outlinePaint;
    }

    @Override
    protected int getOutlineSides(T t, T t2) {
        return this._outlineSides;
    }

    @Override
    protected Stroke getOutlineStroke(T t, T t2) {
        return this._outlineStroke;
    }

    @Override
    public void paintPeriodBackground(GanttChart<T, GanttEntry<T>> ganttChart, Graphics2D graphics2D, T t, T t2, int n, int n2, int n3, int n4) {
        Rectangle rectangle = graphics2D.getClipBounds();
        ScaleArea<T> scaleArea = ganttChart.getScaleArea();
        int n5 = scaleArea.getX(this.getStartInstant());
        int n6 = rectangle.y;
        int n7 = scaleArea.getX(this.getEndInstant());
        int n8 = rectangle.y + rectangle.height;
        super.paintPeriodBackground(ganttChart, graphics2D, this.getStartInstant(), this.getStartInstant(), n5, n6, n7, n8);
    }

    public T getStartInstant() {
        return this._startInstant;
    }

    public void setStartInstant(T t) {
        this._startInstant = t;
    }

    public T getEndInstant() {
        return this._endInstant;
    }

    public void setEndInstant(T t) {
        this._endInstant = t;
    }

    public Paint getBackgroundPaint() {
        return this._backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this._backgroundPaint = paint;
    }

    public Paint getOutlinePaint() {
        return this._outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this._outlinePaint = paint;
    }

    public Stroke getOutlineStroke() {
        return this._outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this._outlineStroke = stroke;
    }

    public int getOutlineSides() {
        return this._outlineSides;
    }

    public void setOutlineSides(int n) {
        this._outlineSides = n;
    }
}

