/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttChartPopupMenuCustomizer;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class GanttChartPopupMenuInstaller
extends MouseAdapter {
    private final GanttChart<?, ?> _ganttChart;
    public static final String CLIENT_PROPERTY_POPUP_MENU_INSTALLER = "GanttChartPopupMenuInstaller";
    List<GanttChartPopupMenuCustomizer> _customizers;

    public GanttChartPopupMenuInstaller(GanttChart<?, ?> ganttChart) {
        this._ganttChart = ganttChart;
        this.installListeners();
    }

    public void addGanttChartPopupMenuCustomizer(GanttChartPopupMenuCustomizer ganttChartPopupMenuCustomizer) {
        if (this._customizers == null) {
            this._customizers = new ArrayList<GanttChartPopupMenuCustomizer>();
        }
        this._customizers.add(ganttChartPopupMenuCustomizer);
    }

    public void removeTablePopupMenuCustomizer(GanttChartPopupMenuCustomizer ganttChartPopupMenuCustomizer) {
        if (this._customizers != null) {
            this._customizers.remove(ganttChartPopupMenuCustomizer);
        }
    }

    public GanttChartPopupMenuCustomizer[] getGanttChartPopupMenuCustomizers() {
        return this._customizers != null ? this._customizers.toArray(new GanttChartPopupMenuCustomizer[this._customizers.size()]) : new GanttChartPopupMenuCustomizer[]{};
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        GanttChart ganttChart = (GanttChart)mouseEvent.getComponent();
        JPopupMenu jPopupMenu = this.createPopupMenu();
        int n = GanttChartPopupMenuInstaller.getClickingRow(ganttChart, mouseEvent.getPoint());
        this.customizeMenuItems(ganttChart, jPopupMenu, n, mouseEvent.getPoint());
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show(ganttChart, mouseEvent.getX(), mouseEvent.getY());
        }
        if (jPopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, ganttChart, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    protected void customizeMenuItems(GanttChart<?, ?> ganttChart, JPopupMenu jPopupMenu, int n, Point point) {
        GanttChartPopupMenuCustomizer[] ganttChartPopupMenuCustomizerArray;
        for (GanttChartPopupMenuCustomizer ganttChartPopupMenuCustomizer : ganttChartPopupMenuCustomizerArray = this.getGanttChartPopupMenuCustomizers()) {
            GanttChartPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            ganttChartPopupMenuCustomizer.customizePopupMenu(ganttChart, jPopupMenu, n, point);
        }
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n = jPopupMenu.getComponentCount();
        if (n > 0 && !(jPopupMenu.getComponent(n - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }

    public void installListeners() {
        this._ganttChart.addMouseListener(this);
        this.updateClientProperty(this._ganttChart, this);
    }

    public void uninstallListeners() {
        this._ganttChart.removeMouseListener(this);
        this.updateClientProperty(this._ganttChart, null);
    }

    public static GanttChartPopupMenuInstaller getGanttChartPopupMenuInstaller(GanttChart<?, ?> ganttChart) {
        Object object = ganttChart.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
        if (object instanceof GanttChartPopupMenuInstaller) {
            return (GanttChartPopupMenuInstaller)object;
        }
        return null;
    }

    private void updateClientProperty(GanttChart<?, ?> ganttChart, GanttChartPopupMenuInstaller ganttChartPopupMenuInstaller) {
        if (ganttChart != null) {
            Object object = ganttChart.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
            if (object instanceof GanttChartPopupMenuInstaller && object != this) {
                ((GanttChartPopupMenuInstaller)object).uninstallListeners();
            }
            ganttChart.putClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER, ganttChartPopupMenuInstaller);
        }
    }

    private static int getClickingRow(GanttChart<?, ?> ganttChart, Point point) {
        return ganttChart.rowAtPoint(point);
    }
}

