/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttModel;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.swing.CornerScroller;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialLineBorder;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableModel;

public class GanttChartPane<T, S extends GanttEntry<T>>
extends JideSplitPane {
    private static final long serialVersionUID = -7579522806491772926L;
    private GanttModel<T, S> _ganttModel;
    private TreeTable _treeTable;
    private GanttChart<T, S> _ganttChart;

    public GanttChartPane(GanttModel<T, S> ganttModel) {
        this._ganttModel = ganttModel;
        this.initComponent();
    }

    public GanttModel<T, S> getGanttModel() {
        return this._ganttModel;
    }

    public void setGanttModel(GanttModel<T, S> ganttModel) {
        this._ganttModel = ganttModel;
        this._ganttChart.setModel(ganttModel);
        if (this._ganttModel != null) {
            this.setModelToTable(this._treeTable, (TableModel)((Object)this._ganttModel.getTreeTableModel()));
        } else {
            this._treeTable.setModel(null);
        }
    }

    public void setRowHeight(int n) {
        if (this._treeTable != null && this._ganttChart != null) {
            this._treeTable.setRowHeight(n);
            this._ganttChart.setRowHeight(n);
        }
    }

    public GanttChart<T, S> getGanttChart() {
        return this._ganttChart;
    }

    public TreeTable getTreeTable() {
        return this._treeTable;
    }

    protected void initComponent() {
        this.setContinuousLayout(true);
        this.setDividerSize(2);
        JComponent jComponent = this.createTableHeaderComponent();
        this._treeTable = this.createTreeTable((TableModel)((Object)(this._ganttModel != null ? this._ganttModel.getTreeTableModel() : null)), jComponent);
        this._ganttChart = this.createGanttChart(this._ganttModel);
        this._ganttChart.getScaleArea().setTreeTable(this._treeTable);
        final JScrollPane jScrollPane = this.createScrollPane(this._treeTable);
        final JScrollPane jScrollPane2 = this.createScrollPane(this._ganttChart);
        JideSwingUtilities.synchronizeView(jScrollPane.getViewport(), jScrollPane2.getViewport(), 1);
        JideSwingUtilities.synchronizeView(jScrollPane2.getViewport(), jScrollPane.getViewport(), 1);
        this._ganttChart.setSelectionModel(this._treeTable.getSelectionModel());
        jScrollPane.addPropertyChangeListener("border", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jScrollPane2.setBorder(jScrollPane.getBorder());
            }
        });
        this.add(this.customizeScrollPane(jScrollPane));
        this.add(this.customizeScrollPane(jScrollPane2));
        this.setRowHeight(21);
    }

    protected JScrollPane createScrollPane(Component component) {
        JideScrollPane jideScrollPane = new JideScrollPane(component);
        jideScrollPane.setHorizontalScrollBarPolicy(32);
        return jideScrollPane;
    }

    protected Component customizeScrollPane(JScrollPane jScrollPane) {
        if (jScrollPane.getViewport().getView() == this._ganttChart) {
            jScrollPane.setCorner("LOWER_RIGHT_CORNER", new CornerScroller(jScrollPane));
        }
        return jScrollPane;
    }

    protected JComponent createTableHeaderComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new PartialLineBorder(Color.LIGHT_GRAY, 1, 2));
        return jPanel;
    }

    protected TreeTable createTreeTable(TableModel tableModel, final JComponent jComponent) {
        TreeTable treeTable = new TreeTable(){
            private static final long serialVersionUID = 965739719543922408L;

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.clearSavedSelections(false);
                super.valueChanged(listSelectionEvent);
            }

            @Override
            protected void configureEnclosingScrollPane() {
                Container container;
                Container container2 = this.getParent();
                if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
                    Border border;
                    JScrollPane jScrollPane = (JScrollPane)container;
                    JViewport jViewport = jScrollPane.getViewport();
                    if (jViewport == null || jViewport.getView() != this) {
                        return;
                    }
                    JPanel jPanel = new JPanel(new BorderLayout()){
                        private static final long serialVersionUID = -7010154738720761547L;

                        @Override
                        public Dimension getPreferredSize() {
                            Dimension dimension = super.getPreferredSize();
                            ScaleArea scaleArea = GanttChartPane.this.getGanttChart().getScaleArea();
                            scaleArea.setPreferredSize(null);
                            Dimension dimension2 = scaleArea.getPreferredSize();
                            if (dimension.height <= dimension2.height) {
                                dimension.height = dimension2.height;
                                scaleArea.setPreferredSize(null);
                            } else {
                                dimension2.height = dimension.height;
                                scaleArea.setPreferredSize(dimension2);
                            }
                            scaleArea.revalidate();
                            scaleArea.repaint();
                            return dimension;
                        }
                    };
                    jPanel.add((Component)jComponent, "Center");
                    jPanel.add((Component)this.getTableHeader(), "Last");
                    jScrollPane.setColumnHeaderView(jPanel);
                    Border border2 = jScrollPane.getBorder();
                    if ((border2 == null || border2 instanceof UIResource) && (border = UIManager.getBorder("Table.scrollPaneBorder")) != null) {
                        jScrollPane.setBorder(border);
                    }
                }
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
            }
        };
        treeTable.setShowTreeLines(false);
        treeTable.setShowLeafNodeTreeLines(false);
        treeTable.putClientProperty("TreeTable.paintTreeLineOnTreeTable", false);
        this.setModelToTable(treeTable, tableModel);
        treeTable.setAutoResizeMode(256);
        return treeTable;
    }

    private void setModelToTable(TreeTable treeTable, TableModel tableModel) {
        treeTable.setModel(tableModel);
        boolean bl = TableModelWrapperUtils.getActualTableModel(tableModel, SortableTreeTableModel.class) != null;
        treeTable.setSortable(bl);
    }

    protected GanttChart<T, S> createGanttChart(GanttModel<T, S> ganttModel) {
        return new GanttChart<T, S>(ganttModel);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(8192)) {
            Lm.showInvalidProductMessage(GanttChartPane.class.getName(), 8192);
        }
    }
}

