/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.AbstractGanttModel;
import com.jidesoft.gantt.DefaultGanttEntryRelationModel;
import com.jidesoft.gantt.DefaultGanttTreeTableModel;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttEntryRelationModel;
import com.jidesoft.gantt.GanttModelEvent;
import com.jidesoft.gantt.GanttTableModelEvent;
import com.jidesoft.gantt.SubEntryGanttEntry;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.range.Range;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DefaultGanttModel<T, S extends GanttEntry<T>>
extends AbstractGanttModel<T, S>
implements PropertyChangeListener {
    private static final long serialVersionUID = 5386888127084217005L;
    private ITreeTableModel<S> _treeTableModel;
    private Range<T> _range;
    private ScaleModel<T> _scaleModel;
    private GanttEntryRelationModel<S> _ganttEntryRelationModel;
    private TableModelListener _treeTableModelListener;
    private boolean _autoUpdateRange = true;

    public DefaultGanttModel() {
        this(new SortableTreeTableModel(new FilterableTreeTableModel(new DefaultGanttTreeTableModel())));
    }

    public DefaultGanttModel(ITreeTableModel<S> iTreeTableModel) {
        this.setTreeTableModel(iTreeTableModel);
        this.setGanttEntryRelationModel(this.createGanttEntryRelationModel());
    }

    protected DefaultGanttEntryRelationModel<S> createGanttEntryRelationModel() {
        return new DefaultGanttEntryRelationModel();
    }

    @Override
    public ITreeTableModel<S> getTreeTableModel() {
        return this._treeTableModel;
    }

    public void setTreeTableModel(ITreeTableModel<S> iTreeTableModel) {
        if (this._treeTableModelListener == null) {
            this._treeTableModelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    int n = -1;
                    if (tableModelEvent instanceof GanttTableModelEvent) {
                        n = ((GanttTableModelEvent)tableModelEvent).getSubEntryIndex();
                    }
                    DefaultGanttModel.this.fireGanttChanged(new GanttModelEvent(DefaultGanttModel.this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n, tableModelEvent.getType()));
                    DefaultGanttModel.this.updateRange(tableModelEvent);
                }
            };
        }
        if (this._treeTableModel != null) {
            ((TableModel)((Object)this._treeTableModel)).removeTableModelListener(this._treeTableModelListener);
        }
        this._treeTableModel = iTreeTableModel;
        if (this._treeTableModel != null) {
            ((TableModel)((Object)this._treeTableModel)).addTableModelListener(this._treeTableModelListener);
        }
        this.fireGanttDataChanged();
    }

    protected boolean isRangeColumn(int n) {
        return n == -1 || n == 1 || n == 2;
    }

    protected void updateRange(TableModelEvent tableModelEvent) {
        if (this._range == null || !this.isAutoUpdateRange() || this.getEntryCount() == 0) {
            return;
        }
        if (tableModelEvent != null && tableModelEvent.getType() == 0 && !this.isRangeColumn(tableModelEvent.getColumn())) {
            return;
        }
        List<S> list = tableModelEvent != null && (tableModelEvent.getType() == 0 || tableModelEvent.getType() == 1) ? this.getRootEntries(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow()) : this.getRootEntries(0, this.getEntryCount() - 1);
        if (list.size() == 1) {
            DefaultGanttModel.union(this._range, (Expandable)this.getTreeTableModel().getRoot(), (GanttEntry)list.get(0));
        } else if (!list.isEmpty()) {
            DefaultGanttModel.union(this._range, (Expandable)this.getTreeTableModel().getRoot());
        }
    }

    private List<S> getRootEntries(int n, int n2) {
        if (n < 0 || n >= this.getEntryCount() || n2 < 0 || n2 >= this.getEntryCount()) {
            n = 0;
            n2 = this.getEntryCount() - 1;
        }
        Object object = this.getTreeTableModel().getRoot();
        ArrayList arrayList = new ArrayList();
        for (int i = n; i <= n2; ++i) {
            Object s = this.getEntryAt(i);
            if (s.getParent() != object) continue;
            arrayList.add(s);
        }
        return arrayList;
    }

    public void setAutoUpdateRange(boolean bl) {
        this._autoUpdateRange = bl;
    }

    public boolean isAutoUpdateRange() {
        return this._autoUpdateRange;
    }

    @Override
    public Range<T> getRange() {
        return this._range;
    }

    public void setRange(Range<T> range) {
        if (!JideSwingUtilities.equals(range, this._range)) {
            this._range = range;
            this.fireGanttChanged(new GanttModelEvent(this, -2, -2, 0));
            if (this._range != null) {
                PropertyChangeListener[] propertyChangeListenerArray;
                for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = this._range.getPropertyChangeListeners()) {
                    if (propertyChangeListener != this) continue;
                    return;
                }
                this._range.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        DefaultGanttModel.this.fireGanttChanged(new GanttModelEvent(DefaultGanttModel.this, -2, -2, 0));
                    }
                });
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireGanttChanged(new GanttModelEvent(this, -2, -2, 0));
    }

    @Override
    public ScaleModel<T> getScaleModel() {
        return this._scaleModel;
    }

    public void setScaleModel(ScaleModel<T> scaleModel) {
        this._scaleModel = scaleModel;
    }

    @Override
    public GanttEntryRelationModel<S> getGanttEntryRelationModel() {
        return this._ganttEntryRelationModel;
    }

    public void setGanttEntryRelationModel(GanttEntryRelationModel<S> ganttEntryRelationModel) {
        this._ganttEntryRelationModel = ganttEntryRelationModel;
    }

    public void addGanttEntry(S s) {
        ((Expandable)this.getTreeTableModel().getRoot()).addChild(s);
    }

    public void removeGanttEntry(S s) {
        if (s != null && s.getParent() != null) {
            s.getParent().removeChild(s);
        }
    }

    public static <T> void union(Range<T> range, Expandable expandable, GanttEntry<T> ganttEntry) {
        if (range == null) {
            return;
        }
        if (ganttEntry == null) {
            DefaultGanttModel.union(range, expandable);
            return;
        }
        Range<T> range2 = ganttEntry.getRange();
        if (range2 != null) {
            double d;
            T t = range.lower();
            T t2 = range.upper();
            T t3 = range2.lower();
            T t4 = range2.upper();
            if (t == null && t2 == null) {
                DefaultGanttModel.union(range, expandable);
                return;
            }
            if (t == null) {
                t = t3;
            } else if (t3 != null) {
                d = range2.minimum();
                if (d < range.minimum()) {
                    t = t3;
                } else {
                    DefaultGanttModel.union(range, expandable);
                    return;
                }
            }
            if (t2 == null) {
                t2 = t4;
            } else if (t4 != null) {
                d = range2.maximum();
                if (d > range.maximum()) {
                    t2 = t4;
                } else {
                    DefaultGanttModel.union(range, expandable);
                    return;
                }
            }
            if (t != null && t2 != null) {
                range.adjust(t, t2);
            }
        }
    }

    public static <T> void union(Range<T> range, Expandable expandable) {
        if (range != null) {
            Range<Object> range2;
            Object object2;
            Object object3 = null;
            Object object4 = null;
            double d = 0.0;
            double d2 = 0.0;
            ArrayList<GanttEntry> arrayList = new ArrayList<GanttEntry>();
            List<?> list = expandable.getChildren();
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    Object object5 = object2.next();
                    arrayList.add((GanttEntry)object5);
                }
            }
            if (expandable instanceof SubEntryGanttEntry && (object2 = ((SubEntryGanttEntry)expandable).getSubEntries()) != null) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    range2 = iterator.next();
                    arrayList.add((GanttEntry)((Object)range2));
                }
            }
            for (GanttEntry ganttEntry : arrayList) {
                Object object;
                range2 = ganttEntry.getRange();
                if (range2 == null) continue;
                Object object5 = range2.lower();
                if (object5 != null && (object3 == null || range2.minimum() < d)) {
                    object3 = range2.lower();
                    d = range2.minimum();
                }
                if ((object = range2.upper()) == null || object4 != null && !(range2.maximum() > d2)) continue;
                object4 = range2.upper();
                d2 = range2.maximum();
            }
            if (object3 != null && object4 != null) {
                range.adjust(object3, object4);
            }
        }
    }
}

