/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.PercentConverter;
import com.jidesoft.gantt.DefaultGanttModel;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.SubEntryGanttEntry;
import com.jidesoft.grid.AbstractExpandableRow;
import com.jidesoft.grid.Cacheable;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.Row;
import com.jidesoft.range.Range;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.ArrayList;
import java.util.List;

public class DefaultGanttEntry<T>
extends AbstractExpandableRow
implements SubEntryGanttEntry<T> {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_RANGE_START = 1;
    public static final int COLUMN_RANGE_END = 2;
    public static final int COLUMN_COMPLETION = 3;
    private final Class<?> _rangeType;
    private String _name;
    private Range<T> _range;
    private List<GanttEntry<T>> _subEntries;
    private double _completion;
    private List<?> _children;
    private boolean _adjusting = false;

    public DefaultGanttEntry(String string) {
        this(string, null, null, 0.0);
    }

    public DefaultGanttEntry(String string, Range<T> range) {
        this(string, null, range, 0.0);
    }

    public DefaultGanttEntry(String string, Class<T> clazz, Range<T> range, double d) {
        this._name = string;
        this._rangeType = clazz;
        this._range = range;
        this._completion = d;
    }

    protected int getActualColumnIndex(int n) {
        return n;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        if (!JideSwingUtilities.equals(string, this._name)) {
            this._name = string;
            this.cellUpdated(this.getActualColumnIndex(0));
            this.nameUpdated();
        }
    }

    @Override
    public Range<T> getRange() {
        return this._range;
    }

    public void setRange(Range<T> range) {
        if (!JideSwingUtilities.equals(range, this._range)) {
            this._range = range;
            this.internalNotifyCellUpdated(this, this.getActualColumnIndex(1));
            this.internalNotifyCellUpdated(this, this.getActualColumnIndex(2));
            this.rangeUpdated();
        }
    }

    @Override
    public Range<T> setRange(T t, T t2) {
        if (this._range != null) {
            boolean bl;
            boolean bl2 = !JideSwingUtilities.equals(t, this._range.lower());
            boolean bl3 = bl = !JideSwingUtilities.equals(t2, this._range.upper());
            if (bl2 || bl) {
                this._range.adjust(t, t2);
                if (bl2) {
                    this.internalNotifyCellUpdated(this, this.getActualColumnIndex(1));
                }
                if (bl) {
                    this.internalNotifyCellUpdated(this, this.getActualColumnIndex(2));
                }
                this.rangeUpdated();
            }
        }
        return this._range;
    }

    @Override
    public void notifyChildDeleted(Object object) {
        super.notifyChildDeleted(object);
        this.childRangeUpdated(null);
    }

    @Override
    public void notifyChildrenDeleted(List<? extends Row> list) {
        super.notifyChildrenDeleted(list);
        this.childRangeUpdated(null);
    }

    @Override
    public void notifyCellUpdated(Object object, int n) {
        this.internalNotifyCellUpdated(object, n);
        if (n == this.getActualColumnIndex(1) || n == this.getActualColumnIndex(2)) {
            this.rangeUpdated();
        }
    }

    private void internalNotifyCellUpdated(Object object, int n) {
        Expandable expandable;
        if (this instanceof Cacheable) {
            ((Cacheable)((Object)this)).invalidateCache();
        }
        if ((expandable = this.getParent()) == null) {
            return;
        }
        if (!this.isExpanded()) {
            if (expandable instanceof ExpandableRow) {
                ((ExpandableRow)expandable).notifyCellUpdated(object, n);
            } else {
                expandable.notifyChildUpdated(this);
            }
        } else {
            if (expandable instanceof ExpandableRow) {
                ((ExpandableRow)expandable).notifyCellUpdated(object, n);
            } else {
                expandable.notifyChildUpdated(object);
            }
            expandable.notifyChildUpdated(this);
        }
    }

    @Override
    public void notifyChildInserted(Object object, int n) {
        super.notifyChildInserted(object, n);
        this.childRangeUpdated((DefaultGanttEntry)object);
    }

    public void rangeUpdated() {
        Expandable expandable = this.getParent();
        if (expandable instanceof DefaultGanttEntry) {
            ((DefaultGanttEntry)expandable).childRangeUpdated(this);
        }
    }

    public void childRangeUpdated(DefaultGanttEntry<T> defaultGanttEntry) {
        if (this._range != null) {
            T t = this._range.lower();
            T t2 = this._range.upper();
            DefaultGanttModel.union(this._range, this, defaultGanttEntry);
            if (!JideSwingUtilities.equals(t, this._range.lower()) || !JideSwingUtilities.equals(t2, this._range.upper())) {
                this.setRange(this._range);
                this.internalNotifyCellUpdated(this, this.getActualColumnIndex(1));
                this.internalNotifyCellUpdated(this, this.getActualColumnIndex(2));
                this.rangeUpdated();
            }
        }
    }

    public List<GanttEntry<T>> getChildEntries() {
        ArrayList<GanttEntry<T>> arrayList = new ArrayList<GanttEntry<T>>();
        if (this._children != null) {
            for (Object obj : this._children) {
                arrayList.add((GanttEntry)obj);
            }
        }
        return arrayList;
    }

    public void nameUpdated() {
        Expandable expandable = this.getParent();
        if (expandable instanceof DefaultGanttEntry) {
            ((DefaultGanttEntry)expandable).childNameUpdated(this);
        }
    }

    public void childNameUpdated(DefaultGanttEntry<T> defaultGanttEntry) {
        this.internalNotifyCellUpdated(this, this.getActualColumnIndex(0));
    }

    public void completionUpdated() {
        Expandable expandable = this.getParent();
        if (expandable instanceof DefaultGanttEntry) {
            ((DefaultGanttEntry)expandable).childCompletionUpdated(this);
        }
    }

    public void childCompletionUpdated(DefaultGanttEntry<T> defaultGanttEntry) {
        this.internalNotifyCellUpdated(this, this.getActualColumnIndex(3));
    }

    @Override
    public double getCompletion() {
        return this._completion;
    }

    @Override
    public void setCompletion(double d) {
        if (d > 1.0) {
            d = 1.0;
        } else if (d < 0.0) {
            d = 0.0;
        }
        this._completion = d;
        this.cellUpdated(this.getActualColumnIndex(3));
        this.completionUpdated();
    }

    @Override
    public ConverterContext getConverterContextAt(int n) {
        if (n == this.getActualColumnIndex(3)) {
            return PercentConverter.CONTEXT;
        }
        return super.getConverterContextAt(n);
    }

    @Override
    public Object getValueAt(int n) {
        if (n == this.getActualColumnIndex(0)) {
            return this.getName();
        }
        Range<T> range = this.getRange();
        if (n == this.getActualColumnIndex(1)) {
            if (range != null) {
                return range.lower();
            }
            return null;
        }
        if (n == this.getActualColumnIndex(2)) {
            if (range != null) {
                return range.upper();
            }
            return null;
        }
        if (n == this.getActualColumnIndex(3)) {
            return this.getCompletion();
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n) {
        if (n == this.getActualColumnIndex(0)) {
            return String.class;
        }
        if (n == this.getActualColumnIndex(1) || n == this.getActualColumnIndex(2)) {
            if (this._rangeType != null) {
                return this._rangeType;
            }
            return Object.class;
        }
        if (n == this.getActualColumnIndex(3)) {
            return Double.TYPE;
        }
        return Object.class;
    }

    @Override
    public void setValueAt(Object object, int n) {
        if (n == this.getActualColumnIndex(0)) {
            if (object instanceof String) {
                this.setName((String)object);
            }
        } else if (n == this.getActualColumnIndex(1)) {
            if (this._range != null) {
                this.setRange(object, this._range.upper());
            }
        } else if (n == this.getActualColumnIndex(2)) {
            if (this._range != null) {
                this.setRange(this._range.lower(), object);
            }
        } else if (n == this.getActualColumnIndex(3) && object instanceof Number) {
            this.setCompletion(((Number)object).doubleValue());
        }
    }

    @Override
    public boolean isCellEditable(int n) {
        if (n == this.getActualColumnIndex(0)) {
            return true;
        }
        if (n == this.getActualColumnIndex(3)) {
            return this.isCompletionEditable();
        }
        return this.isRangeEditable();
    }

    @Override
    public boolean isRangeEditable() {
        return !this.hasChildren();
    }

    @Override
    public boolean isCompletionEditable() {
        return !this.hasChildren();
    }

    @Override
    public List<?> getChildren() {
        return this._children;
    }

    @Override
    public void setChildren(List<?> list) {
        if (this._children != list) {
            List<?> list2 = this._children;
            this._children = list;
            if (this._children != null) {
                for (Object obj : this._children) {
                    if (!(obj instanceof Node)) continue;
                    ((Node)obj).setParent(this);
                }
            }
            this.firePropertyChange("expanded", list2, list);
        }
    }

    @Override
    public List<GanttEntry<T>> getSubEntries() {
        return this._subEntries;
    }

    @Override
    public void setSubEntries(List<GanttEntry<T>> list) {
        if (this._subEntries != list) {
            if (this._subEntries != null) {
                for (GanttEntry<T> ganttEntry : list) {
                    ganttEntry.setParent(null);
                }
            }
            this._subEntries = list;
            if (this._subEntries != null) {
                for (GanttEntry<T> ganttEntry : list) {
                    ganttEntry.setParent(this);
                }
            }
        }
    }

    @Override
    public void addSubEntry(GanttEntry<T> ganttEntry) {
        if (this._subEntries == null) {
            this._subEntries = new ArrayList<GanttEntry<T>>();
        }
        ganttEntry.setParent(this);
        this._subEntries.add(ganttEntry);
        this.rowUpdated();
    }

    @Override
    public void removeSubEntry(GanttEntry<T> ganttEntry) {
        if (this._subEntries != null) {
            this._subEntries.remove(ganttEntry);
            ganttEntry.setParent(null);
            this.rowUpdated();
        }
    }

    @Override
    public boolean isAdjusting() {
        return this._adjusting;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (bl != this._adjusting) {
            boolean bl2 = this._adjusting;
            this._adjusting = bl;
            this.firePropertyChange("adjusting", bl2, this._adjusting);
        }
    }

    public String toString() {
        return "DefaultGanttEntry [name=" + this._name + ", range=" + this._range + "]";
    }
}

