/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.filter;

import com.jidesoft.filter.RegexFilter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.DefaultWildcardSupport;

public class WildcardFilter<T>
extends RegexFilter<T> {
    private boolean _hasWildcards;
    private DefaultWildcardSupport _defaultWildcardSupport;
    private static final long serialVersionUID = 553941522244712019L;

    public WildcardFilter() {
    }

    public WildcardFilter(String string) {
        super(string);
    }

    @Override
    public void setPattern(String string) {
        super.setPattern(string);
        if (string == null) {
            this._hasWildcards = false;
            return;
        }
        if (this._defaultWildcardSupport == null) {
            this._defaultWildcardSupport = new DefaultWildcardSupport();
        }
        if (string.indexOf(this._defaultWildcardSupport.getOneOrMoreQuantifier()) != -1) {
            this._hasWildcards = true;
        } else if (string.indexOf(this._defaultWildcardSupport.getZeroOrMoreQuantifier()) != -1) {
            this._hasWildcards = true;
        } else if (string.indexOf(this._defaultWildcardSupport.getZeroOrOneQuantifier()) != -1) {
            this._hasWildcards = true;
        }
    }

    @Override
    protected String convertFromPatternToRegex(String string) {
        if (string == null) {
            return null;
        }
        if (!this.isCaseSensitive()) {
            string = string.toLowerCase();
        }
        return this._defaultWildcardSupport.convert(string);
    }

    @Override
    public boolean isValueFiltered(T t) {
        if (!this._hasWildcards) {
            String string = this.convertElementToString(t);
            String string2 = this.getPattern();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                return t != null;
            }
            if (!this.isCaseSensitive()) {
                string = string.toLowerCase();
                string2 = string2.toLowerCase();
            }
            if (this.isBeginWith() && this.isEndWith()) {
                return !string.equals(string2);
            }
            if (this.isBeginWith()) {
                return !string.startsWith(string2);
            }
            if (this.isEndWith()) {
                return !string.endsWith(string2);
            }
            return string.indexOf(string2) == -1;
        }
        return super.isValueFiltered(t);
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.isBeginWith() == ((WildcardFilter)object).isBeginWith() && this.isCaseSensitive() == ((WildcardFilter)object).isCaseSensitive() && this.isEndWith() == ((WildcardFilter)object).isEndWith() && JideSwingUtilities.equals(this.getPattern(), ((WildcardFilter)object).getPattern(), true);
    }
}

