/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.filter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.AbstractFilter;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.SqlFilterSupport;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.TypeUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class InFilter<T>
extends AbstractFilter<T>
implements SqlFilterSupport {
    private Set<T> _lookup;
    private static final long serialVersionUID = 2421275038070853349L;

    public InFilter() {
    }

    public InFilter(T[] TArray) {
        this(null, TArray);
    }

    public InFilter(String string, T[] TArray) {
        super(string);
        this.setValues(TArray);
    }

    @Override
    public boolean isValueFiltered(T t) {
        if (this._lookup == null) {
            return true;
        }
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        boolean bl = objectGrouper != null ? this._lookup.contains(objectGrouper.getValue(t)) : this._lookup.contains(t);
        if (bl) {
            return false;
        }
        if (t instanceof Number) {
            for (T t2 : this._lookup) {
                double d;
                if (!(t2 instanceof Number)) continue;
                double d2 = d = objectGrouper == null ? ((Number)t).doubleValue() : ((Number)objectGrouper.getValue(t)).doubleValue();
                if (((Number)t2).doubleValue() != d) continue;
                return false;
            }
        }
        return true;
    }

    public void setValues(T[] TArray) {
        if (TArray != null) {
            this._lookup = new HashSet<T>();
            this._lookup.addAll(Arrays.asList(TArray));
        }
    }

    public T[] getValues() {
        return this._lookup == null ? null : this._lookup.toArray();
    }

    @Override
    public String getOperator() {
        return " IN ";
    }

    @Override
    public String getName() {
        String string = super.getName();
        return string != null ? string : (this._lookup == null ? "" : "(" + this._lookup.size() + ")");
    }

    @Override
    public boolean stricterThan(Filter filter) {
        T[] TArray;
        if (this.getClass() != filter.getClass()) {
            return false;
        }
        T[] TArray2 = this.getValues();
        if (TArray2.length > (TArray = ((InFilter)filter).getValues()).length) {
            return false;
        }
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.addAll(Arrays.asList(TArray));
        for (T t : TArray2) {
            if (hashSet.contains(t)) continue;
            if (t instanceof Number) {
                boolean bl = false;
                for (Object e : hashSet) {
                    if (!(e instanceof Number) || ((Number)e).doubleValue() != ((Number)t).doubleValue()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && JideSwingUtilities.equals(this.getValues(), ((InFilter)object).getValues(), true);
    }

    @Override
    public String getPreference(Class<?> clazz, ConverterContext converterContext) {
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        if (objectGrouper != null) {
            clazz = objectGrouper.getType();
            converterContext = objectGrouper.getConverterContext();
        }
        T[] TArray = this.getValues();
        StringBuffer stringBuffer = new StringBuffer();
        for (T t : TArray) {
            stringBuffer.append(t == null ? "(Empty)" : ObjectConverterManager.toString(t, clazz, converterContext)).append("\t");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        if (objectGrouper != null) {
            stringBuffer.append('\r').append('\n').append(objectGrouper.getName());
        }
        return stringBuffer.toString();
    }

    @Override
    public Object[] setPreference(String string, Class<?> clazz, ConverterContext converterContext) {
        String[] stringArray = string.split("\r\n");
        this.setObjectGrouperName(stringArray.length >= 2 ? stringArray[1] : null);
        string = stringArray[0];
        String[] stringArray2 = string.split("\t");
        Object object = Array.newInstance(clazz, stringArray2.length);
        for (int i = 0; i < stringArray2.length; ++i) {
            if ("(Empty)".equals(stringArray2[i])) {
                Array.set(object, i, null);
                continue;
            }
            Array.set(object, i, ObjectConverterManager.fromString(stringArray2[i], clazz, converterContext));
        }
        try {
            this.setValues((Object[])object);
        }
        catch (Exception exception) {
            if (TypeUtils.isPrimitive(clazz)) {
                clazz = TypeUtils.convertPrimitiveToWrapperType(clazz);
                object = Array.newInstance(clazz, stringArray2.length);
            } else if (TypeUtils.isPrimitiveWrapper(clazz)) {
                clazz = TypeUtils.convertWrapperToPrimitiveType(clazz);
                object = Array.newInstance(clazz, stringArray2.length);
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                Array.set(object, i, ObjectConverterManager.fromString(stringArray2[i], clazz, converterContext));
            }
            this.setValues((Object[])object);
        }
        return new Object[]{this.getValues()};
    }

    @Override
    public boolean isFilterValid() {
        return this._lookup != null;
    }
}

