/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.filter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.FilterFactory;
import com.jidesoft.filter.FilterResource;
import com.jidesoft.filter.ObjectGrouperSupport;
import com.jidesoft.grid.FilterEvent;
import com.jidesoft.grid.FilterListener;
import com.jidesoft.grouper.ObjectGrouper;
import java.util.Locale;
import javax.swing.event.EventListenerList;

public abstract class AbstractFilter<T>
implements com.jidesoft.grid.Filter<T>,
ObjectGrouperSupport {
    private transient EventListenerList listenerList = new EventListenerList();
    private transient FilterFactory _filterFactory;
    private String _filterFactoryName;
    private String _name;
    private boolean _enabled = true;
    private transient ObjectGrouper _objectGrouper;
    private String _objectGrouperName;
    private static final long serialVersionUID = -6968545139267301843L;

    public AbstractFilter() {
    }

    public AbstractFilter(String string) {
        this._name = string;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String string) {
        this._name = string;
        this.fireFilterNameChanged();
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this._enabled = bl;
        if (this._enabled) {
            this.fireFilterEnabled();
        } else {
            this.fireFilterDisabled();
        }
    }

    @Override
    public FilterFactory getFilterFactory() {
        return this._filterFactory;
    }

    @Override
    public void setFilterFactory(FilterFactory filterFactory) {
        this._filterFactory = filterFactory;
    }

    @Override
    public String getFilterFactoryName() {
        return this._filterFactoryName;
    }

    @Override
    public void setFilterFactoryName(String string) {
        this._filterFactoryName = string;
    }

    @Override
    public void addFilterListener(FilterListener filterListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(FilterListener.class, filterListener);
    }

    @Override
    public void removeFilterListener(FilterListener filterListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.remove(FilterListener.class, filterListener);
    }

    public FilterListener[] getFilterListeners() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return (FilterListener[])this.listenerList.getListeners(FilterListener.class);
    }

    public void fireFilterChanged(FilterEvent filterEvent) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FilterListener.class) continue;
            ((FilterListener)objectArray[i + 1]).filterChanged(filterEvent);
        }
    }

    public void fireFilterEnabled() {
        this.fireFilterChanged(new FilterEvent(this, 6999));
    }

    public void fireFilterDisabled() {
        this.fireFilterChanged(new FilterEvent(this, 7000));
    }

    public void fireFilterNameChanged() {
        this.fireFilterChanged(new FilterEvent(this, 7001));
    }

    public void fireFilterContentChanged() {
        this.fireFilterChanged(new FilterEvent(this, 7002));
    }

    public static String getConditionString(Locale locale, String string, String string2) {
        try {
            return FilterResource.getResourceBundle(locale).getString("FilterCondition." + string2 + "." + string);
        }
        catch (Exception exception) {
            return FilterResource.getResourceBundle(locale).getString("FilterCondition." + string2);
        }
    }

    @Override
    public boolean stricterThan(Filter filter) {
        return false;
    }

    @Override
    public ObjectGrouper getObjectGrouper() {
        return this._objectGrouper;
    }

    @Override
    public void setObjectGrouper(ObjectGrouper objectGrouper) {
        this._objectGrouper = objectGrouper;
    }

    @Override
    public void setObjectGrouperName(String string) {
        this._objectGrouperName = string;
    }

    @Override
    public String getObjectGrouperName() {
        return this._objectGrouperName != null ? this._objectGrouperName : (this.getObjectGrouper() == null ? null : this.getObjectGrouper().getName());
    }

    @Override
    public String getPreference(Class<?> clazz, ConverterContext converterContext) {
        return "";
    }

    @Override
    public Object[] setPreference(String string, Class<?> clazz, ConverterContext converterContext) {
        return new Object[0];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isFilterValid() {
        return true;
    }
}

