/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.field.creditcard;

import com.jidesoft.field.creditcard.CardIssuer;
import com.jidesoft.field.creditcard.CardIssuers;
import com.jidesoft.field.creditcard.CreditCardUtils;
import java.util.HashSet;
import java.util.Set;

public class CreditCardValidator {
    private Set<String> _allowedCardIssuers;

    public CreditCardValidator() {
    }

    public CreditCardValidator(String[] stringArray) {
        if (stringArray != null) {
            this._allowedCardIssuers = new HashSet<String>();
            for (String string : stringArray) {
                this._allowedCardIssuers.add(string);
            }
        }
    }

    public CardIssuer getCardIssuer(String string) {
        if (string.matches("^\\d{13,19}$") && CreditCardUtils.isValidNumber(string)) {
            CardIssuer cardIssuer = CardIssuers.getCardIssuer(string);
            if (this._allowedCardIssuers == null || cardIssuer == null || this._allowedCardIssuers.contains(cardIssuer.getName())) {
                return cardIssuer;
            }
        }
        return null;
    }
}

