/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.field.creditcard;

import com.jidesoft.field.creditcard.CardIssuer;
import com.jidesoft.field.creditcard.CreditCardMask;
import com.jidesoft.field.creditcard.CreditCardValidator;
import com.jidesoft.field.creditcard.CreditCardsIconsFactory;
import com.jidesoft.field.creditcard.DefaultCreditCardMask;
import com.jidesoft.swing.LabeledTextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CreditCardTextField
extends LabeledTextField {
    private String[] _allowedCardIssuerNames = null;
    private CardIssuer _cardIssuer = null;
    private String _cardNumber = null;
    private boolean _maskEnabled = true;
    private CreditCardMask _creditCardMask;
    private boolean _validateOnFly = true;
    private boolean _masked = false;
    private Icon _creditCardIcon;
    private Icon _invalidCreditCardIcon;
    public static final String PROPERTY_VALIDATE_ON_FLY = "validateOnFly";
    public static final String PROPERTY_MASK_ENABLED = "maskEnabled";

    public CreditCardTextField() {
        this((Icon)null);
    }

    public CreditCardTextField(Icon icon) {
        this(icon, null);
    }

    public CreditCardTextField(Icon icon, String string) {
        super(icon, string);
        this.getTextField().addFocusListener(new CreditCardTextFieldFocusListener());
        final CreditCardTextFieldDocumentListener creditCardTextFieldDocumentListener = new CreditCardTextFieldDocumentListener();
        this.getTextField().getDocument().addDocumentListener(creditCardTextFieldDocumentListener);
        this.getTextField().addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Document document = CreditCardTextField.this.getTextField().getDocument();
                document.addDocumentListener(creditCardTextFieldDocumentListener);
            }
        });
        this.setIcon(this.getCreditCardIcon());
    }

    @Override
    protected JTextField createTextField() {
        JTextField jTextField = super.createTextField();
        jTextField.setColumns(16);
        return jTextField;
    }

    public void setAllowedCardIssuerNames(String[] stringArray) {
        this._allowedCardIssuerNames = stringArray;
        this.validateCardNumber();
    }

    public String[] getAllowedCardIssuerNames() {
        return this._allowedCardIssuerNames;
    }

    public String getCreditCardNumber() {
        return this._cardNumber;
    }

    public CardIssuer getCardIssuer() {
        this.validateCardNumber();
        return this._cardIssuer;
    }

    public CreditCardMask getCreditCardMask() {
        if (this._creditCardMask == null) {
            this._creditCardMask = new DefaultCreditCardMask();
        }
        return this._creditCardMask;
    }

    public void setCreditCardMask(CreditCardMask creditCardMask) {
        this._creditCardMask = creditCardMask;
    }

    public void setMaskEnabled(boolean bl) {
        boolean bl2 = this._maskEnabled;
        if (bl2 != bl) {
            this._maskEnabled = bl;
            this.firePropertyChange(PROPERTY_MASK_ENABLED, bl2, this._maskEnabled);
            if (this.isMaskEnabled()) {
                if (this.getTextField().hasFocus()) {
                    this.unmaskCardNumber();
                } else {
                    this.maskCardNumber();
                }
            } else {
                this.unmaskCardNumber();
            }
        }
    }

    public boolean isMaskEnabled() {
        return this._maskEnabled;
    }

    public boolean isValidateOnFly() {
        return this._validateOnFly;
    }

    public void setValidateOnFly(boolean bl) {
        boolean bl2 = this._validateOnFly;
        if (bl2 != bl) {
            this._validateOnFly = bl;
            this.firePropertyChange(PROPERTY_VALIDATE_ON_FLY, bl2, this._validateOnFly);
            if (this.isValidateOnFly()) {
                this.validateCardNumber();
            }
        }
    }

    public Icon getCreditCardIcon() {
        if (this._creditCardIcon == null) {
            this._creditCardIcon = CreditCardsIconsFactory.getImageIcon("icons/CreditCard.png");
        }
        return this._creditCardIcon;
    }

    public void setCreditCardIcon(Icon icon) {
        this._creditCardIcon = icon;
    }

    public Icon getInvalidCreditCardIcon() {
        if (this._invalidCreditCardIcon == null) {
            this._invalidCreditCardIcon = CreditCardsIconsFactory.getImageIcon("icons/Invalid.png");
        }
        return this._invalidCreditCardIcon;
    }

    public void setInvalidCreditCardIcon(Icon icon) {
        this._invalidCreditCardIcon = icon;
    }

    private static String getDigitsOnly(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public boolean validateCardNumber() {
        if (!this._masked) {
            this._cardNumber = CreditCardTextField.getDigitsOnly(this.getTextField().getText());
        }
        if (this._cardNumber != null) {
            if (this._cardNumber.length() == 0) {
                this.setIcon(this.getCreditCardIcon());
            } else {
                CreditCardValidator creditCardValidator = new CreditCardValidator(this._allowedCardIssuerNames);
                this._cardIssuer = creditCardValidator.getCardIssuer(this._cardNumber);
                if (this._cardIssuer != null) {
                    this.setIcon(this._cardIssuer.getIcon());
                    return true;
                }
                this.setIcon(this.getInvalidCreditCardIcon());
            }
        }
        return false;
    }

    public void unmaskCardNumber() {
        if (this._masked && this._cardNumber != null) {
            this._masked = false;
            this.getTextField().setText(this._cardNumber);
        }
    }

    public void maskCardNumber() {
        if (!this._masked) {
            this._cardNumber = CreditCardTextField.getDigitsOnly(this.getTextField().getText());
            String string = this.getCreditCardMask().mask(this._cardNumber);
            this._masked = true;
            this.getTextField().setText(string);
        }
    }

    private class CreditCardTextFieldDocumentListener
    implements DocumentListener {
        private CreditCardTextFieldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!CreditCardTextField.this.isValidateOnFly()) {
                return;
            }
            if (!CreditCardTextField.this._masked) {
                CreditCardTextField.this._cardNumber = this.getTextFromDocumentEvent(documentEvent);
            }
            CreditCardTextField.this.validateCardNumber();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!CreditCardTextField.this.isValidateOnFly()) {
                return;
            }
            if (!CreditCardTextField.this._masked) {
                CreditCardTextField.this._cardNumber = this.getTextFromDocumentEvent(documentEvent);
            }
            CreditCardTextField.this.validateCardNumber();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (!CreditCardTextField.this.isValidateOnFly()) {
                return;
            }
            if (!CreditCardTextField.this._masked) {
                CreditCardTextField.this._cardNumber = this.getTextFromDocumentEvent(documentEvent);
            }
            CreditCardTextField.this.validateCardNumber();
        }

        private String getTextFromDocumentEvent(DocumentEvent documentEvent) {
            try {
                Document document = documentEvent.getDocument();
                return document.getText(0, document.getLength());
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    private class CreditCardTextFieldFocusListener
    implements FocusListener {
        private CreditCardTextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            CreditCardTextField.this.unmaskCardNumber();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CreditCardTextField.this._cardNumber = CreditCardTextField.getDigitsOnly(CreditCardTextField.this.getTextField().getText());
            if (CreditCardTextField.this._cardNumber == null || CreditCardTextField.this._cardNumber.length() == 0) {
                CreditCardTextField.this.setIcon(CreditCardTextField.this.getCreditCardIcon());
            } else if (CreditCardTextField.this.isMaskEnabled()) {
                CreditCardTextField.this.maskCardNumber();
            }
        }
    }
}

