/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.field.creditcard;

import com.jidesoft.field.creditcard.AmericanExpress;
import com.jidesoft.field.creditcard.CardIssuer;
import com.jidesoft.field.creditcard.DinersClub;
import com.jidesoft.field.creditcard.Discover;
import com.jidesoft.field.creditcard.JCB;
import com.jidesoft.field.creditcard.MasterCard;
import com.jidesoft.field.creditcard.VISA;
import java.util.HashSet;
import java.util.Set;

public class CardIssuers {
    private static Set<CardIssuer> _issuers = new HashSet<CardIssuer>();

    public static void registerDefaultIssuers() {
        _issuers.add(new VISA());
        _issuers.add(new MasterCard());
        _issuers.add(new AmericanExpress());
        _issuers.add(new Discover());
        _issuers.add(new DinersClub());
        _issuers.add(new JCB());
    }

    public static void registerIssuer(CardIssuer cardIssuer) {
        _issuers.add(cardIssuer);
    }

    public static void unregisterIssuer(String string) {
        for (CardIssuer cardIssuer : _issuers) {
            if (!cardIssuer.getName().equals(string)) continue;
            _issuers.remove(cardIssuer);
        }
    }

    public static CardIssuer getCardIssuer(String string) {
        for (CardIssuer cardIssuer : _issuers) {
            if (cardIssuer.isCardNumberValid(string) != 0) continue;
            return cardIssuer;
        }
        return null;
    }

    static {
        CardIssuers.registerDefaultIssuers();
    }
}

