/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.tokenmarker;

import com.jidesoft.editor.KeywordMap;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import javax.swing.text.Segment;

public class VerilogTokenMarker
extends TokenMarker {
    static final int NORMAL = 0;
    static final int SIMPLE_QUOTE = 1;
    static final int BACK_ACCENT = 2;
    static final int DOLLAR = 3;
    int env;
    private static KeywordMap vKeywords;
    private boolean cpp;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public VerilogTokenMarker() {
        this(VerilogTokenMarker.getKeywords());
    }

    public VerilogTokenMarker(KeywordMap keywordMap) {
        this.keywords = keywordMap;
    }

    @Override
    public byte markTokensImpl(byte by, Segment segment, int n) {
        int n2;
        char[] cArray = segment.array;
        this.lastOffset = n2 = segment.offset;
        this.lastKeyword = n2;
        int n3 = segment.count + n2;
        boolean bl = false;
        boolean bl2 = false;
        this.env = 0;
        block24: for (int i = n2; i < n3; ++i) {
            int n4 = i + 1;
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            switch (by) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.doKeyword(segment, i, c);
                            this.addToken(i - this.lastOffset, by);
                            this.addToken(1, (byte)6);
                            this.lastOffset = this.lastKeyword = i + 1;
                            break;
                        }
                        case '@': {
                            if (bl) {
                                bl = false;
                                break;
                            }
                            bl2 = true;
                            this.doKeyword(segment, i, c);
                            this.addToken(i - this.lastOffset, by);
                            by = 0;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '$': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.env = 3;
                            this.addToken(i - this.lastOffset, by);
                            by = 0;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '`': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.env = 2;
                            this.addToken(i - this.lastOffset, by);
                            by = 0;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            if (n4 >= n3 || cArray[n4] != 'b' && cArray[n4] != 'B' && cArray[n4] != 'o' && cArray[n4] != 'O' && cArray[n4] != 'd' && cArray[n4] != 'D' && cArray[n4] != 'h' && cArray[n4] != 'H') continue block24;
                            this.env = 1;
                            this.addToken(i - this.lastOffset, by);
                            by = 0;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\"': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == n2) {
                                if (this.doKeyword(segment, i, c)) break;
                                bl = false;
                                this.addToken(n4 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            if (!this.doKeyword(segment, i, c)) continue block24;
                            break;
                        }
                        case '/': {
                            bl = false;
                            this.doKeyword(segment, i, c);
                            if (n3 - i <= 1) continue block24;
                            switch (cArray[n4]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (n3 - i > 2 && cArray[i + 2] == '*') {
                                        by = (byte)2;
                                        break;
                                    }
                                    by = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.addToken(n3 - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = n3;
                                    break block24;
                                }
                            }
                            continue block24;
                        }
                        default: {
                            bl = false;
                            if (bl2) {
                                bl2 = false;
                                this.doKeyword(segment, i, c);
                                this.addToken(n4 - this.lastOffset, by);
                                by = 0;
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            if (Character.isLetterOrDigit(c) || c == '_') continue block24;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                    }
                    continue block24;
                }
                case 1: 
                case 2: {
                    bl = false;
                    if (c != '*' || n3 - i <= 1 || cArray[n4] != '/') continue block24;
                    this.addToken(++i + 1 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block24;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block24;
                    }
                    if (c != '\"') continue block24;
                    this.addToken(n4 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    this.env = 0;
                    continue block24;
                }
                case 4: {
                    if (Character.isLetterOrDigit(c) || c == '_') continue block24;
                    this.addToken(n4 - this.lastOffset, (byte)4);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    this.env = 0;
                    continue block24;
                }
                case 7: {
                    if (Character.isLetterOrDigit(c) || c == '_') continue block24;
                    this.addToken(n4 - this.lastOffset, (byte)7);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    this.env = 0;
                    continue block24;
                }
                default: {
                    throw new InternalError("Invalid state: " + by);
                }
            }
        }
        if (by == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (by) {
            case 4: 
            case 7: {
                this.addToken(n3 - this.lastOffset, by);
                if (bl) break;
                by = 0;
                break;
            }
            default: {
                this.addToken(n3 - this.lastOffset, by);
            }
        }
        return by;
    }

    public static KeywordMap getKeywords() {
        if (vKeywords == null) {
            vKeywords = new KeywordMap(false);
            vKeywords.add("reg", (byte)8);
            vKeywords.add("wire", (byte)8);
            vKeywords.add("wand", (byte)8);
            vKeywords.add("wor", (byte)8);
            vKeywords.add("integer", (byte)8);
            vKeywords.add("parameter", (byte)8);
            vKeywords.add("integer", (byte)8);
            vKeywords.add("real", (byte)8);
            vKeywords.add("time", (byte)8);
            vKeywords.add("realtime", (byte)8);
            vKeywords.add("event", (byte)8);
            vKeywords.add("input", (byte)6);
            vKeywords.add("output", (byte)6);
            vKeywords.add("inout", (byte)6);
            vKeywords.add("module", (byte)6);
            vKeywords.add("endmodule", (byte)6);
            vKeywords.add("assign", (byte)6);
            vKeywords.add("always", (byte)6);
            vKeywords.add("posedge", (byte)6);
            vKeywords.add("negedge", (byte)6);
            vKeywords.add("initial", (byte)6);
            vKeywords.add("forever", (byte)6);
            vKeywords.add("while", (byte)6);
            vKeywords.add("for", (byte)6);
            vKeywords.add("if", (byte)6);
            vKeywords.add("else", (byte)6);
            vKeywords.add("case", (byte)6);
            vKeywords.add("casex", (byte)6);
            vKeywords.add("casez", (byte)6);
            vKeywords.add("default", (byte)6);
            vKeywords.add("endcase", (byte)6);
            vKeywords.add("or", (byte)6);
            vKeywords.add("#", (byte)6);
            vKeywords.add("@", (byte)6);
            vKeywords.add("begin", (byte)6);
            vKeywords.add("end", (byte)6);
            vKeywords.add("fork", (byte)6);
            vKeywords.add("join", (byte)6);
            vKeywords.add("wait", (byte)6);
            vKeywords.add("function", (byte)6);
            vKeywords.add("endfunction", (byte)6);
            vKeywords.add("task", (byte)6);
            vKeywords.add("endtask", (byte)6);
            vKeywords.add("$display", (byte)7);
            vKeywords.add("$write", (byte)7);
            vKeywords.add("$time", (byte)7);
            vKeywords.add("$monitor", (byte)7);
            vKeywords.add("$finish", (byte)7);
            vKeywords.add("$readmemb", (byte)7);
            vKeywords.add("$readmemh", (byte)7);
            vKeywords.add("$stop", (byte)7);
            vKeywords.add("$define_group_waves", (byte)7);
            vKeywords.add("$gr_waves_memsize", (byte)7);
            vKeywords.add("$gr_waves", (byte)7);
            vKeywords.add("`include", (byte)7);
            vKeywords.add("`define", (byte)7);
            vKeywords.add("`ifdef", (byte)7);
            vKeywords.add("`define", (byte)7);
            vKeywords.add("ifnone", (byte)6);
            vKeywords.add("rpmos", (byte)6);
            vKeywords.add("tranif1", (byte)6);
            vKeywords.add("and", (byte)6);
            vKeywords.add("rtran", (byte)6);
            vKeywords.add("tri", (byte)6);
            vKeywords.add("rtranif0", (byte)6);
            vKeywords.add("tri0", (byte)6);
            vKeywords.add("pmos", (byte)6);
            vKeywords.add("rtranif1", (byte)6);
            vKeywords.add("tri1", (byte)6);
            vKeywords.add("buf", (byte)6);
            vKeywords.add("endprimitive", (byte)6);
            vKeywords.add("scalared", (byte)6);
            vKeywords.add("triand", (byte)6);
            vKeywords.add("bufif0", (byte)6);
            vKeywords.add("endspecify", (byte)6);
            vKeywords.add("primitive", (byte)6);
            vKeywords.add("small", (byte)6);
            vKeywords.add("trior", (byte)6);
            vKeywords.add("bufif1", (byte)6);
            vKeywords.add("endtable", (byte)6);
            vKeywords.add("large", (byte)6);
            vKeywords.add("pull0", (byte)6);
            vKeywords.add("specify", (byte)6);
            vKeywords.add("trireg", (byte)6);
            vKeywords.add("macromodule", (byte)6);
            vKeywords.add("pull1", (byte)6);
            vKeywords.add("specparam", (byte)6);
            vKeywords.add("vectored", (byte)6);
            vKeywords.add("medium", (byte)6);
            vKeywords.add("pullup", (byte)6);
            vKeywords.add("strong0", (byte)6);
            vKeywords.add("pulldown", (byte)6);
            vKeywords.add("strong1", (byte)6);
            vKeywords.add("cmos", (byte)6);
            vKeywords.add("force", (byte)6);
            vKeywords.add("nand", (byte)6);
            vKeywords.add("rcmos", (byte)6);
            vKeywords.add("supply0", (byte)6);
            vKeywords.add("weak0", (byte)6);
            vKeywords.add("deassign", (byte)6);
            vKeywords.add("supply1", (byte)6);
            vKeywords.add("weak1", (byte)6);
            vKeywords.add("nmos", (byte)6);
            vKeywords.add("table", (byte)6);
            vKeywords.add("defparam", (byte)6);
            vKeywords.add("nor", (byte)6);
            vKeywords.add("disable", (byte)6);
            vKeywords.add("highz0", (byte)6);
            vKeywords.add("not", (byte)6);
            vKeywords.add("release", (byte)6);
            vKeywords.add("edge", (byte)6);
            vKeywords.add("highz1", (byte)6);
            vKeywords.add("notif0", (byte)6);
            vKeywords.add("repeat", (byte)6);
            vKeywords.add("tran", (byte)6);
            vKeywords.add("xnor", (byte)6);
            vKeywords.add("notif1", (byte)6);
            vKeywords.add("rnmos", (byte)6);
            vKeywords.add("tranif0", (byte)6);
            vKeywords.add("xor", (byte)6);
            vKeywords.add("generate", (byte)6);
            vKeywords.add("endgenerate", (byte)6);
            vKeywords.add("`resetall", (byte)7);
            vKeywords.add("`define", (byte)7);
            vKeywords.add("`timescale", (byte)7);
            vKeywords.add("`undef", (byte)7);
            vKeywords.add("`ifdef", (byte)7);
            vKeywords.add("`ifndef", (byte)7);
            vKeywords.add("`else", (byte)7);
            vKeywords.add("`endif", (byte)7);
            vKeywords.add("`elsif", (byte)7);
            vKeywords.add("`include", (byte)7);
            vKeywords.add("`signed", (byte)7);
            vKeywords.add("`unsigned", (byte)7);
            vKeywords.add("`celldefine", (byte)7);
            vKeywords.add("`endcelldefine", (byte)7);
            vKeywords.add("`default_nettype_wire", (byte)7);
            vKeywords.add("`unconnected_drive", (byte)7);
            vKeywords.add("`nounconnected_drive", (byte)7);
            vKeywords.add("`protect", (byte)7);
            vKeywords.add("`endprotect", (byte)7);
            vKeywords.add("`protected", (byte)7);
            vKeywords.add("`endprotected", (byte)7);
            vKeywords.add("`expand_vectornets", (byte)7);
            vKeywords.add("`noexpand_ectornets", (byte)7);
            vKeywords.add("`autoexpand_vectornets", (byte)7);
            vKeywords.add("`remove_gatename", (byte)7);
            vKeywords.add("`noremove_gatenames", (byte)7);
            vKeywords.add("`remove_netname", (byte)7);
            vKeywords.add("`noremove_netnames", (byte)7);
            vKeywords.add("$display", (byte)8);
            vKeywords.add("$write", (byte)8);
            vKeywords.add("$fdisplay", (byte)8);
            vKeywords.add("$fwrite", (byte)8);
            vKeywords.add("$strobe", (byte)8);
            vKeywords.add("$fstrobe", (byte)8);
            vKeywords.add("$monitor", (byte)8);
            vKeywords.add("$fmonitor", (byte)8);
            vKeywords.add("$time", (byte)8);
            vKeywords.add("$realtime", (byte)8);
            vKeywords.add("$finish", (byte)8);
            vKeywords.add("$stop", (byte)8);
            vKeywords.add("$setup", (byte)8);
            vKeywords.add("$hold", (byte)8);
            vKeywords.add("$width", (byte)8);
            vKeywords.add("$setuphold", (byte)8);
            vKeywords.add("$readmemb", (byte)8);
            vKeywords.add("$readmemh", (byte)8);
            vKeywords.add("$sreadmemb", (byte)8);
            vKeywords.add("$sreadmemh", (byte)8);
            vKeywords.add("$getpattern", (byte)8);
            vKeywords.add("$history", (byte)8);
            vKeywords.add("$save", (byte)8);
            vKeywords.add("$restart", (byte)8);
            vKeywords.add("$incsave", (byte)8);
            vKeywords.add("$scale", (byte)8);
            vKeywords.add("$showscopes", (byte)8);
            vKeywords.add("$showvars", (byte)8);
        }
        return vKeywords;
    }

    private boolean doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        int n3 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        switch (this.env) {
            case 2: {
                if (by != 0) break;
                by = 4;
                break;
            }
            case 1: {
                by = 4;
                this.lastKeyword += 2;
                n3 -= 2;
            }
        }
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n2;
        this.env = 0;
        return false;
    }
}

