/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.settings;

import com.jidesoft.combobox.ColorExComboBox;
import com.jidesoft.editor.CodeEditorResource;
import com.jidesoft.editor.SyntaxStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StylePanel
extends JPanel {
    private SyntaxStyle _style = new SyntaxStyle();
    private JCheckBox _italicCheckBox;
    private JCheckBox _boldCheckBox;
    private ColorExComboBox _backgroundColorComboBox;
    private ColorExComboBox _foregroundColorComboBox;
    private JComboBox _effectComboBox;
    private ColorExComboBox _effectColorComboBox;
    private ColorExComboBox _stripeColorComboBox;

    public StylePanel() {
        this.installComponents();
    }

    protected void installComponents() {
        this._boldCheckBox = new JCheckBox();
        this._italicCheckBox = new JCheckBox();
        this._foregroundColorComboBox = new ColorExComboBox();
        this._backgroundColorComboBox = new ColorExComboBox();
        this._effectComboBox = new JComboBox();
        this._effectColorComboBox = new ColorExComboBox();
        this._stripeColorComboBox = new ColorExComboBox();
        this._boldCheckBox.setText(this.getResourceString("Settings.style.bold"));
        this._boldCheckBox.setMnemonic(this.getResourceString("Settings.style.bold.mnemonic").charAt(0));
        this._boldCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._boldCheckBox.setDisplayedMnemonicIndex(0);
        this._boldCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this._italicCheckBox.setText(this.getResourceString("Settings.style.italic"));
        this._italicCheckBox.setMnemonic(this.getResourceString("Settings.style.italic.mnemonic").charAt(0));
        this._italicCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._italicCheckBox.setDisplayedMnemonicIndex(0);
        this._italicCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this._effectComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{this.getResourceString("Settings.style.effects.none"), this.getResourceString("Settings.style.effects.underlined"), this.getResourceString("Settings.style.effects.waved"), this.getResourceString("Settings.style.effects.strikethrough"), this.getResourceString("Settings.style.effects.bordered")}));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 3, 6);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(this.getResourceString("Settings.style.font")), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JLabel jLabel = new JLabel(this.getResourceString("Settings.style.background"));
        jLabel.setDisplayedMnemonic(this.getResourceString("Settings.style.background.mnemonic").charAt(0));
        jLabel.setLabelFor(this._backgroundColorComboBox);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        JLabel jLabel2 = new JLabel(this.getResourceString("Settings.style.foreground"));
        jLabel2.setDisplayedMnemonic(this.getResourceString("Settings.style.foreground.mnemonic").charAt(0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel2.setLabelFor(this._foregroundColorComboBox);
        gridBagConstraints.gridy = 3;
        JLabel jLabel3 = new JLabel(this.getResourceString("Settings.style.effects"));
        jLabel3.setDisplayedMnemonic(this.getResourceString("Settings.style.effects.mnemonic").charAt(0));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        jLabel3.setLabelFor(this._effectComboBox);
        gridBagConstraints.gridy = 4;
        JLabel jLabel4 = new JLabel(this.getResourceString("Settings.style.effectColor"));
        jLabel4.setDisplayedMnemonic(this.getResourceString("Settings.style.effectColor.mnemonic").charAt(0));
        jPanel.add((Component)jLabel4, gridBagConstraints);
        jLabel4.setLabelFor(this._effectColorComboBox);
        gridBagConstraints.gridy = 5;
        JLabel jLabel5 = new JLabel(this.getResourceString("Settings.style.stripeColor"));
        jLabel5.setDisplayedMnemonic(this.getResourceString("Settings.style.stripeColor.mnemonic").charAt(0));
        jPanel.add((Component)jLabel5, gridBagConstraints);
        jLabel5.setLabelFor(this._stripeColorComboBox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridy = 0;
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 0, 0));
        jPanel2.add(this._boldCheckBox);
        jPanel2.add(this._italicCheckBox);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._backgroundColorComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this._foregroundColorComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._effectComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this._effectColorComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this._stripeColorComboBox, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "First");
    }

    public void loadData() {
        if (this._style == null) {
            return;
        }
        this._boldCheckBox.setSelected(this._style.isBold());
        this._italicCheckBox.setSelected(this._style.isItalic());
        this._backgroundColorComboBox.setSelectedColor(this._style.getBackground());
        this._foregroundColorComboBox.setSelectedColor(this._style.getForeground());
        this._effectColorComboBox.setSelectedColor(this._style.getEffectColor());
        this._effectComboBox.setSelectedIndex(this._style.getEffect());
        this._stripeColorComboBox.setSelectedColor(this._style.getStripeColor());
    }

    public void saveData() {
        if (this._style == null) {
            return;
        }
        this._style.setFontStyle((this._boldCheckBox.isSelected() ? 1 : 0) | (this._italicCheckBox.isSelected() ? 2 : 0));
        this._style.setBackground(this._backgroundColorComboBox.getSelectedColor());
        this._style.setForeground(this._foregroundColorComboBox.getSelectedColor());
        this._style.setEffectColor(this._effectColorComboBox.getSelectedColor());
        this._style.setEffect(this._effectComboBox.getSelectedIndex());
        this._style.setStripeColor(this._stripeColorComboBox.getSelectedColor());
    }

    public SyntaxStyle getStyle() {
        this.saveData();
        return this._style;
    }

    public void setStyle(SyntaxStyle syntaxStyle) {
        this.saveData();
        this._style = syntaxStyle == null ? new SyntaxStyle() : syntaxStyle;
        this.loadData();
    }

    protected String getResourceString(String string) {
        return CodeEditorResource.getResourceBundle(Locale.getDefault()).getString(string);
    }
}

