/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.settings;

import com.jidesoft.editor.PredefinedSyntaxStyleSchema;
import com.jidesoft.editor.SyntaxStyleSchema;
import com.jidesoft.editor.settings.StylePanel;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StyleListPanel
extends JPanel {
    private JList _elementsList;
    private StylePanel _stylePanel;
    private SyntaxStyleSchema _styles;
    private String[] _names;
    private int _previousSelectedIndex = -1;

    public StyleListPanel() {
        this.installComponents();
        this.installListeners();
    }

    protected void installComponents() {
        this._elementsList = new JList(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                dimension.width = 150;
                return dimension;
            }
        };
        this._elementsList.setVisibleRowCount(10);
        this._elementsList.getSelectionModel().setSelectionMode(0);
        this._stylePanel = new StylePanel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)new JScrollPane(this._elementsList), "Before");
        this.add((Component)this._stylePanel, "Center");
    }

    protected void installListeners() {
        this._elementsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StyleListPanel.this.saveData();
                int n = StyleListPanel.this._elementsList.getSelectedIndex();
                StyleListPanel.this._previousSelectedIndex = n;
                if (n >= 0 && n < StyleListPanel.this.getStyles().getStyleCount()) {
                    StyleListPanel.this._stylePanel.setStyle(StyleListPanel.this.getStyles().getStyleByIndex(n));
                } else {
                    StyleListPanel.this._stylePanel.setStyle(null);
                }
                StyleListPanel.this._stylePanel.loadData();
            }
        });
    }

    public String[] getNames() {
        return this._names;
    }

    public void setNames(String[] stringArray) {
        this._names = stringArray;
    }

    public SyntaxStyleSchema getStyles() {
        return this._styles;
    }

    public void setStyles(SyntaxStyleSchema syntaxStyleSchema) {
        this._styles = syntaxStyleSchema;
    }

    public void saveData() {
        this._stylePanel.saveData();
        if (this._previousSelectedIndex != -1 && this.getStyles().getStyleByIndex(this._previousSelectedIndex) == null) {
            this.getStyles().setStyleByIndex(this._previousSelectedIndex, this._stylePanel.getStyle());
        }
    }

    public void loadData() {
        this._elementsList.setModel(new AbstractListModel(){

            @Override
            public Object getElementAt(int n) {
                return StyleListPanel.this.getNames()[n];
            }

            @Override
            public int getSize() {
                return StyleListPanel.this.getNames().length;
            }
        });
        this._elementsList.setSelectedIndex(0);
    }

    public static void main(String[] stringArray) {
        LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
        JDialog jDialog = new JDialog();
        jDialog.setDefaultCloseOperation(2);
        StyleListPanel styleListPanel = new StyleListPanel();
        styleListPanel.setNames(new String[]{"Comment1", "Comment2", "Keywords1", "Keywords2", "Keywords3", "Literal1", "Literal2", "Label", "Operator", "Invalid", "Error", "Warning"});
        styleListPanel.setStyles(PredefinedSyntaxStyleSchema.getIntellijSyntaxStyles());
        styleListPanel.loadData();
        jDialog.add(styleListPanel);
        jDialog.setLocationRelativeTo(null);
        jDialog.pack();
        jDialog.setVisible(true);
    }
}

