/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.selection;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.selection.SelectionEvent;
import com.jidesoft.editor.selection.SelectionListener;
import com.jidesoft.editor.selection.SelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.text.Element;

public class DefaultSelectionModel
implements SelectionModel {
    private EventListenerList _listenerList = null;
    private int _selectionStart;
    private int _selectionEnd;
    private int _selectionStartLine = -1;
    private int _selectionEndLine = -1;
    private CaretPosition _selectionStartViewPosition;
    private CaretPosition _selectionEndViewPosition;
    private boolean _columnSelectionMode = false;
    private CodeEditor _editor;

    public DefaultSelectionModel(CodeEditor codeEditor) {
        this._editor = codeEditor;
    }

    @Override
    public synchronized int getSelectionStart() {
        if (this.hasSelection()) {
            return this._selectionStart;
        }
        return this._editor.getCaretModel().getOffset();
    }

    @Override
    public synchronized int getSelectionEnd() {
        if (this.hasSelection()) {
            return this._selectionEnd;
        }
        return this._editor.getCaretModel().getOffset();
    }

    public synchronized void setSelectionStart(int n) {
        int n2 = this._selectionStart;
        if (n2 != n) {
            this._selectionStart = n;
            this._selectionStartLine = -1;
            this.fireSelectionChangeEvent(n2, this._selectionEnd, this._selectionStart, this._selectionEnd);
        }
    }

    public synchronized void setSelectionEnd(int n) {
        int n2 = this._selectionEnd;
        if (n2 != n) {
            this._selectionEnd = n;
            this._selectionEndLine = -1;
            this.fireSelectionChangeEvent(this._selectionStart, n2, this._selectionStart, this._selectionEnd);
        }
    }

    @Override
    public synchronized int getSelectionStartLine() {
        if (this.hasSelection()) {
            if (this._selectionStartLine < 0) {
                this._selectionStartLine = this._editor.getLineNumber(this._selectionStart);
            }
            return this._selectionStartLine;
        }
        return this._editor.getCaretModel().getModelPosition().line;
    }

    @Override
    public synchronized int getSelectionEndLine() {
        if (this.hasSelection()) {
            if (this._selectionEndLine < 0) {
                this._selectionEndLine = this._editor.getLineNumber(this._selectionEnd);
            }
            return this._selectionEndLine;
        }
        return this._editor.getCaretModel().getModelPosition().line;
    }

    @Override
    public CaretPosition getSelectionStartViewPosition() {
        return this._selectionStartViewPosition;
    }

    @Override
    public CaretPosition getSelectionEndViewPosition() {
        return this._selectionEndViewPosition;
    }

    @Override
    public int offsetInSelectionToOffsetInDocument(int n) {
        int n2;
        int n3;
        int n4;
        if (this._selectionStart == this._selectionEnd) {
            return -1;
        }
        if (!this.isColumnSelectionMode()) {
            return Math.min(this._selectionStart, this._selectionEnd) + n;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this._selectionStartLine < 0) {
            this._selectionStartLine = this._editor.getLineNumber(this._selectionStart);
        }
        if (this._selectionEndLine < 0) {
            this._selectionEndLine = this._editor.getLineNumber(this._selectionEnd);
        }
        if (this._selectionStart < this._selectionEnd) {
            n5 = this._selectionStart;
            n6 = this._selectionEnd;
            n7 = this._selectionStartLine;
            n8 = this._selectionEndLine;
        } else if (this._selectionStart > this._selectionEnd) {
            n5 = this._selectionEnd;
            n6 = this._selectionStart;
            n7 = this._selectionEndLine;
            n8 = this._selectionStartLine;
        }
        Element element = this._editor.getDocument().getDefaultRootElement();
        if (this._selectionStartViewPosition == null || this._selectionEndViewPosition == null) {
            n4 = n5 - this._editor.getLineStartOffset(n7);
            n3 = n6 - this._editor.getLineStartOffset(n8);
            if (n3 < n4) {
                n2 = n3;
                n3 = n4;
                n4 = n2;
            }
            n3 = Math.max(this._editor.getCaretModel().getViewPosition().column, n3);
        } else {
            n3 = this._selectionEndViewPosition.column;
            n4 = this._selectionStartViewPosition.column;
            if (n3 < n4) {
                n2 = n3;
                n3 = n4;
                n4 = n2;
            }
        }
        n2 = 0;
        for (int i = n7; i <= n8; ++i) {
            Element element2 = element.getElement(i);
            int n9 = element2.getStartOffset();
            int n10 = element2.getEndOffset() - 1;
            int n11 = Math.min(n3 - n4, n10 - (n9 = Math.min(n9 + n4, n10)));
            if (n11 == 0) {
                if (n2 <= n && n2 + n3 - n4 >= n) {
                    return -1;
                }
                n2 += n3 - n4 + 1;
                continue;
            }
            if (n2 <= n && n2 + n11 >= n) {
                return n9 + n - n2;
            }
            if ((n2 += n11) <= n && n2 + n3 - n4 - n11 >= n) {
                return -1;
            }
            n2 += n3 - n4 - n11;
            ++n2;
        }
        return -1;
    }

    @Override
    public int offsetInDocumentToOffsetInSelection(int n) {
        int n2;
        int n3;
        int n4;
        if (this._selectionStart == this._selectionEnd) {
            return -1;
        }
        if (!this.isColumnSelectionMode()) {
            return n - Math.min(this._selectionStart, this._selectionEnd);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this._selectionStartLine < 0) {
            this._selectionStartLine = this._editor.getLineNumber(this._selectionStart);
        }
        if (this._selectionEndLine < 0) {
            this._selectionEndLine = this._editor.getLineNumber(this._selectionEnd);
        }
        if (this._selectionStart < this._selectionEnd) {
            n5 = this._selectionStart;
            n6 = this._selectionEnd;
            n7 = this._selectionStartLine;
            n8 = this._selectionEndLine;
        } else if (this._selectionStart > this._selectionEnd) {
            n5 = this._selectionEnd;
            n6 = this._selectionStart;
            n7 = this._selectionEndLine;
            n8 = this._selectionStartLine;
        }
        Element element = this._editor.getDocument().getDefaultRootElement();
        if (this._selectionStartViewPosition == null || this._selectionEndViewPosition == null) {
            n4 = n5 - this._editor.getLineStartOffset(n7);
            n3 = n6 - this._editor.getLineStartOffset(n8);
            if (n3 < n4) {
                n2 = n3;
                n3 = n4;
                n4 = n2;
            }
            n3 = Math.max(this._editor.getCaretModel().getViewPosition().column, n3);
        } else {
            n3 = this._selectionEndViewPosition.column;
            n4 = this._selectionStartViewPosition.column;
            if (n3 < n4) {
                n2 = n3;
                n3 = n4;
                n4 = n2;
            }
        }
        n2 = 0;
        for (int i = n7; i <= n8; ++i) {
            Element element2 = element.getElement(i);
            int n9 = element2.getStartOffset();
            int n10 = element2.getEndOffset() - 1;
            n9 = Math.min(n9 + n4, n10);
            int n11 = Math.min(n3 - n4, n10 - n9);
            if (n9 <= n && n9 + n11 >= n) {
                return n2 + n - n9;
            }
            n2 += n3 - n4 + 1;
        }
        return -1;
    }

    @Override
    public synchronized String getSelectedText() {
        if (this._selectionStart == this._selectionEnd) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this._selectionStartLine < 0) {
            this._selectionStartLine = this._editor.getLineNumber(this._selectionStart);
        }
        if (this._selectionEndLine < 0) {
            this._selectionEndLine = this._editor.getLineNumber(this._selectionEnd);
        }
        if (this._selectionStart < this._selectionEnd) {
            n = this._selectionStart;
            n2 = this._selectionEnd;
            n3 = this._selectionStartLine;
            n4 = this._selectionEndLine;
        } else if (this._selectionStart > this._selectionEnd) {
            n = this._selectionEnd;
            n2 = this._selectionStart;
            n3 = this._selectionEndLine;
            n4 = this._selectionStartLine;
        }
        if (this.isColumnSelectionMode()) {
            int n5;
            int n6;
            int n7;
            Element element = this._editor.getDocument().getDefaultRootElement();
            if (this._selectionStartViewPosition == null || this._selectionEndViewPosition == null) {
                n7 = n - this._editor.getLineStartOffset(n3);
                n6 = n2 - this._editor.getLineStartOffset(n4);
                if (n6 < n7) {
                    n5 = n6;
                    n6 = n7;
                    n7 = n5;
                }
                n6 = Math.max(this._editor.getCaretModel().getViewPosition().column, n6);
            } else {
                n6 = this._selectionEndViewPosition.column;
                n7 = this._selectionStartViewPosition.column;
                if (n6 < n7) {
                    n5 = n6;
                    n6 = n7;
                    n7 = n5;
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n3; i <= n4; ++i) {
                int n8;
                Element element2 = element.getElement(i);
                int n9 = element2.getStartOffset();
                int n10 = element2.getEndOffset() - 1;
                int n11 = Math.min(n6 - n7, n10 - (n9 = Math.min(n9 + n7, n10)));
                if (n11 == 0) {
                    for (n8 = 0; n8 < n6 - n7; ++n8) {
                        stringBuffer.append(' ');
                    }
                } else {
                    this._editor.getText(n9, n11, this._editor.lineSegment);
                    stringBuffer.append(this._editor.lineSegment.array, this._editor.lineSegment.offset, this._editor.lineSegment.count);
                    n8 = stringBuffer.charAt(stringBuffer.length() - 1);
                    if (n8 == 10 || n8 == 13) {
                        stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                    }
                    for (int j = --n11; j < n6 - n7; ++j) {
                        stringBuffer.append(' ');
                    }
                }
                if (i == n4) continue;
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return this._editor.getText(n, Math.min(this._editor.getDocumentLength(), n2) - n);
    }

    @Override
    public synchronized void setSelection(int n, int n2) {
        int n3 = this._selectionStart;
        int n4 = this._selectionEnd;
        this._selectionStart = n;
        this._selectionStartLine = -1;
        this._selectionEnd = n2;
        this._selectionEndLine = -1;
        if (n == n2 || !this.isColumnSelectionMode()) {
            this._selectionStartViewPosition = null;
            this._selectionEndViewPosition = null;
        } else {
            this._selectionStartViewPosition = this._editor.offsetToViewPosition(this._selectionStart);
            this._selectionEndViewPosition = this._editor.offsetToViewPosition(this._selectionEnd);
        }
        this.fireSelectionChangeEvent(n3, n4, this._selectionStart, this._selectionEnd);
    }

    @Override
    public synchronized void setSelection(CaretPosition caretPosition, CaretPosition caretPosition2) {
        int n = this._selectionStart;
        int n2 = this._selectionEnd;
        this._selectionStartViewPosition = caretPosition;
        this._selectionEndViewPosition = caretPosition2;
        this._selectionStart = this._editor.modelPositionToOffset(this._editor.viewToModelPosition(caretPosition));
        this._selectionStartLine = -1;
        this._selectionEnd = this._editor.modelPositionToOffset(this._editor.viewToModelPosition(caretPosition2));
        this._selectionEndLine = -1;
        this.fireSelectionChangeEvent(n, n2, this._selectionStart, this._selectionEnd);
    }

    @Override
    public synchronized void clearSelection() {
        this.setSelection(0, 0);
    }

    @Override
    public synchronized boolean hasSelection() {
        return this._selectionStart != this._selectionEnd;
    }

    @Override
    public synchronized boolean isColumnSelectionMode() {
        return this._columnSelectionMode;
    }

    @Override
    public synchronized void setColumnSelectionMode(boolean bl) {
        if (this._columnSelectionMode != bl) {
            boolean bl2 = this._columnSelectionMode;
            this._columnSelectionMode = bl;
            this._editor.firePropertyChange("columnSelectionEnabled", bl2, this._columnSelectionMode);
        }
    }

    @Override
    public synchronized void addSelectionListener(SelectionListener selectionListener) {
        if (this._listenerList == null) {
            this._listenerList = new EventListenerList();
        }
        this._listenerList.add(SelectionListener.class, selectionListener);
    }

    @Override
    public synchronized void removeSelectionListener(SelectionListener selectionListener) {
        this._listenerList.remove(SelectionListener.class, selectionListener);
    }

    @Override
    public synchronized SelectionListener[] getSelectionListeners() {
        return (SelectionListener[])this._listenerList.getListeners(SelectionListener.class);
    }

    protected void fireSelectionChangeEvent(int n, int n2, int n3, int n4) {
        if (this._listenerList == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        SelectionEvent selectionEvent = new SelectionEvent(this._editor, n, n2, n3, n4);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SelectionListener.class) continue;
            ((SelectionListener)objectArray[i + 1]).selectionChanged(selectionEvent);
        }
    }
}

