/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.Span;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.icons.IconsFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.Icon;

public class DefaultCodeFoldingPainter
implements CodeFoldingPainter {
    private static final Icon FOLDING_BOTTOM = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_bottom.png");
    private static final Icon FOLDING_TOP = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_top.png");
    private static final Icon FOLDING_CLOSED = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_closed.png");
    private static final Icon FOLDING_OPENED = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_opened.png");
    private static final Icon FOLDING_BOTTOM_R = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_bottom_r.png");
    private static final Icon FOLDING_TOP_R = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_top_r.png");
    private static final Icon FOLDING_CLOSED_R = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_closed_r.png");
    private static final Icon FOLDING_OPENED_R = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_opened_r.png");
    private static final BasicStroke DOTTED_STROKE = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);

    @Override
    public int paintFoldingStart(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        Icon icon = n == 2 ? FOLDING_TOP_R : FOLDING_TOP;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2);
        return rectangle.y + rectangle.height / 2 + icon.getIconHeight() / 2;
    }

    @Override
    public int paintFoldingEnd(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        Icon icon = n == 2 ? FOLDING_BOTTOM_R : FOLDING_BOTTOM;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2);
        return rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2;
    }

    @Override
    public void paintCollapsedFolding(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        Icon icon = n == 2 ? FOLDING_CLOSED_R : FOLDING_CLOSED;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2 - 1);
    }

    @Override
    public void paintExpandedFolding(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        Icon icon = n == 2 ? FOLDING_OPENED_R : FOLDING_OPENED;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2 - 1);
    }

    @Override
    public void paintFoldingLine(Component component, Graphics graphics, Span span, Rectangle rectangle, int n) {
        if (n == 2) {
            graphics.setColor(Color.BLACK);
            int n2 = rectangle.x + rectangle.width / 2;
            graphics.drawLine(n2, rectangle.y, n2, rectangle.y + rectangle.height);
        }
    }

    @Override
    public void paintBackground(Component component, Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x + rectangle.width / 2;
        int n2 = rectangle.height;
        Color color = graphics.getColor();
        Stroke stroke = ((Graphics2D)graphics).getStroke();
        graphics.setColor(component.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, n, n2);
        if (component instanceof AbstractMargin && ((AbstractMargin)component).getCodeEditor() != null) {
            CodeEditor codeEditor = ((AbstractMargin)component).getCodeEditor();
            graphics.setColor(codeEditor.getPainter().getBackground());
        } else {
            graphics.setColor(Color.WHITE);
        }
        graphics.fillRect(rectangle.x + n + 1, rectangle.y, n, n2);
        graphics.setColor(Color.GRAY);
        ((Graphics2D)graphics).setStroke(DOTTED_STROKE);
        graphics.drawLine(n, 0, n, n2);
        graphics.setColor(color);
        ((Graphics2D)graphics).setStroke(stroke);
    }

    @Override
    public int getPreferredWidth() {
        return FOLDING_BOTTOM.getIconWidth() + 4;
    }
}

