/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorMarginSupport;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.editor.margin.DefaultCodeFoldingPainter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.event.MouseInputListener;

public class CodeFoldingMargin
extends AbstractMargin
implements FoldingSpanListener,
MouseInputListener {
    private transient FoldingSpan _rolloverSpan;
    private transient ArrayList<FoldingSpan> _rolloverSpans;
    protected CodeFoldingPainter _codeFoldingPainter;

    public CodeFoldingMargin() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public CodeFoldingMargin(CodeEditor codeEditor) {
        super(codeEditor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    protected void installListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().addFoldingSpanListener(this);
    }

    @Override
    protected void uninstallListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().removeFoldingSpanListener(this);
    }

    @Override
    public void paintMargin(Graphics graphics) {
        if (this.getCodeEditor() == null) {
            return;
        }
        CodeEditor codeEditor = this.getCodeEditor();
        if (codeEditor.getDocument() instanceof LazyLoadDocument) {
            FoldingSpan[] foldingSpanArray;
            int n = codeEditor.getPainter().getLineHeight();
            Rectangle rectangle = codeEditor.getVisibleRect();
            int n2 = codeEditor.xyToOffset(rectangle.x, rectangle.y);
            int n3 = codeEditor.xyToOffset(rectangle.width, rectangle.height);
            for (FoldingSpan foldingSpan : foldingSpanArray = codeEditor.getFoldingModel().getFoldingSpans()) {
                int n4 = foldingSpan.getStartOffset();
                int n5 = foldingSpan.getEndOffset();
                if (!(n4 >= n2 && n4 <= n3 || n5 >= n2 && n5 < n3) && (n4 >= n2 || n5 <= n3)) continue;
                this.paintFolding(graphics, foldingSpan, n);
            }
        } else {
            FoldingSpan[] foldingSpanArray;
            int n = this.getCodeEditor().getPainter().getLineHeight();
            for (FoldingSpan foldingSpan : foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans()) {
                this.paintFolding(graphics, foldingSpan, n);
            }
        }
    }

    @Override
    public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
        if (!foldingSpanEvent.isAdjusting()) {
            this.repaint();
        }
    }

    public CodeFoldingPainter getCodeFoldingPainter() {
        if (this._codeFoldingPainter == null) {
            this._codeFoldingPainter = new DefaultCodeFoldingPainter();
        }
        return this._codeFoldingPainter;
    }

    public void setCodeFoldingPainter(CodeFoldingPainter codeFoldingPainter) {
        this._codeFoldingPainter = codeFoldingPainter;
        this.repaint();
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
        this.getCodeFoldingPainter().paintBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    @Override
    public int getPreferredWidth() {
        return this.getCodeFoldingPainter().getPreferredWidth();
    }

    protected ArrayList<FoldingSpan> getFoldingSpansAt(Point point) {
        ArrayList<FoldingSpan> arrayList = new ArrayList<FoldingSpan>();
        if (this.getCodeEditor() == null) {
            return arrayList;
        }
        int n = this.getCodeEditor().getFirstLine();
        int n2 = this.getCodeEditor().getPainter().getLineHeight();
        int n3 = point.y / n2;
        this.getFoldingSpans(arrayList, n + n3);
        return arrayList;
    }

    protected void getFoldingSpans(ArrayList<FoldingSpan> arrayList, int n) {
        FoldingSpan[] foldingSpanArray;
        for (FoldingSpan foldingSpan : foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans()) {
            int n2 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
            int n3 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
            if (n3 < 0) continue;
            int n4 = this.getCodeEditor().modelToViewLine(n2);
            int n5 = this.getCodeEditor().modelToViewLine(n3);
            if (n4 < 0) {
                n4 = n5;
            } else if (n5 < 0 || n5 < n4) {
                n5 = n4;
            }
            if (n != n4 && n != n5) continue;
            arrayList.add(foldingSpan);
        }
    }

    protected boolean isMixedSpansAt(Point point) {
        return this.isMixedSpans(this.getFoldingSpansAt(point));
    }

    protected boolean isMixedSpans(ArrayList<FoldingSpan> arrayList) {
        if (arrayList.size() > 1) {
            boolean bl = false;
            boolean bl2 = false;
            for (FoldingSpan foldingSpan : arrayList) {
                if (foldingSpan.isExpanded()) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
            return bl2 && bl;
        }
        return false;
    }

    protected void paintFolding(Graphics graphics, FoldingSpan foldingSpan, int n) {
        int n2;
        if (this.getCodeEditor() == null) {
            return;
        }
        boolean bl = false;
        if (this._rolloverSpans != null && this._rolloverSpans.size() > 1) {
            bl = this.isMixedSpans(this._rolloverSpans);
            for (FoldingSpan foldingSpan2 : this._rolloverSpans) {
                if (foldingSpan2.isExpanded() || foldingSpan != foldingSpan2) continue;
                this._rolloverSpan = foldingSpan2;
                break;
            }
        }
        int n3 = this.getCodeEditor().getFirstLine();
        int n4 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
        int n5 = n2 = this._rolloverSpan == foldingSpan ? 2 : 0;
        if (!foldingSpan.isExpanded()) {
            n4 = this.getCodeEditor().modelToViewLine(n4) + 1;
            this.getCodeFoldingPainter().paintCollapsedFolding(this, graphics, foldingSpan, new Rectangle(0, (n4 - n3 - 1) * n + 1, this.getWidth(), n), n2);
        } else {
            int n6 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
            if (n6 < 0) {
                return;
            }
            if (n4 != n6) {
                if (bl && this._rolloverSpans.contains(foldingSpan)) {
                    return;
                }
                n4 = this.getCodeEditor().modelToViewLine(n4) + 1;
                if (n4 == (n6 = this.getCodeEditor().modelToViewLine(n6) + 1)) {
                    return;
                }
                int n7 = this.getCodeFoldingPainter().paintFoldingStart(this, graphics, foldingSpan, new Rectangle(0, (n4 - n3 - 1) * n + 1, this.getWidth(), n), n2);
                int n8 = this.getCodeFoldingPainter().paintFoldingEnd(this, graphics, foldingSpan, new Rectangle(0, (n6 - n3 - 1) * n + 1, this.getWidth(), n), n2);
                this.getCodeFoldingPainter().paintFoldingLine(this, graphics, foldingSpan, new Rectangle(0, n7, this.getWidth(), n8 - n7), n2);
            } else {
                n4 = this.getCodeEditor().modelToViewLine(n4) + 1;
                this.getCodeFoldingPainter().paintExpandedFolding(this, graphics, foldingSpan, new Rectangle(0, (n4 - n3 - 1) * n + 1, this.getWidth(), n), n2);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getCodeEditor() == null) {
            return;
        }
        if (this.isMixedSpansAt(mouseEvent.getPoint())) {
            ArrayList<FoldingSpan> arrayList = this.getFoldingSpansAt(mouseEvent.getPoint());
            for (FoldingSpan foldingSpan : arrayList) {
                if (foldingSpan.isExpanded()) continue;
                this.getCodeEditor().getFoldingModel().expandFoldingSpan(foldingSpan);
                break;
            }
        } else {
            HitInfo hitInfo = this.getSpanInfo(mouseEvent.getPoint());
            if (hitInfo != null) {
                if (hitInfo.span.isExpanded() && (hitInfo.position == 0 || hitInfo.position == 1)) {
                    this.getCodeEditor().getFoldingModel().collapseFoldingSpan(hitInfo.span);
                } else if (!(hitInfo.span.isExpanded() || hitInfo.position != 0 && hitInfo.position != 1)) {
                    this.getCodeEditor().getFoldingModel().expandFoldingSpan(hitInfo.span);
                }
            }
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._rolloverSpan != null) {
            this._rolloverSpan = null;
            this._rolloverSpans = null;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        ArrayList<FoldingSpan> arrayList = this.getFoldingSpansAt(mouseEvent.getPoint());
        this._rolloverSpans = arrayList;
        if (!arrayList.isEmpty() && this._rolloverSpan != arrayList.get(0)) {
            this._rolloverSpan = arrayList.get(0);
            this.repaint();
        } else if (arrayList.isEmpty() && this._rolloverSpan != null) {
            this._rolloverSpan = null;
            this._rolloverSpans = null;
            this.repaint();
        }
    }

    protected HitInfo getSpanInfo(Point point) {
        if (this.getCodeEditor() == null) {
            return null;
        }
        int n = this.getCodeEditor().getFirstLine();
        int n2 = this.getCodeEditor().getPainter().getLineHeight();
        int n3 = point.y;
        int n4 = n3 / n2;
        FoldingSpan[] foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans();
        int n5 = n + n4;
        for (FoldingSpan foldingSpan : foldingSpanArray) {
            int n6 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
            int n7 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
            if (n7 < 0) {
                return null;
            }
            int n8 = this.getCodeEditor().modelToViewLine(n6);
            int n9 = this.getCodeEditor().modelToViewLine(n7);
            if (n8 < 0) {
                n8 = n9;
            } else if (n9 < 0 || n9 < n8) {
                n9 = n8;
            }
            if (n5 < n8 || n5 > n9) continue;
            HitInfo hitInfo = new HitInfo();
            hitInfo.span = foldingSpan;
            if (n5 == n8) {
                hitInfo.position = 0;
                return hitInfo;
            }
            if (n5 != n9) continue;
            hitInfo.position = 0;
            return hitInfo;
        }
        return null;
    }

    @Override
    public void setCodeEditor(CodeEditor codeEditor) {
        this.setMarginSupport(new CodeEditorMarginSupport(codeEditor));
        super.setCodeEditor(codeEditor);
    }

    protected static class HitInfo {
        static final int TOP = 0;
        static final int BOTTOM = 1;
        static final int MIDDLE = 2;
        FoldingSpan span;
        int position;

        protected HitInfo() {
        }
    }
}

