/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.highlight;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.highlight.LayeredHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class DefaultHighlighter
extends LayeredHighlighter {
    private static final Highlighter.Highlight[] noHighlights = new Highlighter.Highlight[0];
    private Vector<HighlightInfo> highlights = new Vector();
    private CodeEditor component;
    private boolean drawsLayeredHighlights = true;
    private SafeDamager safeDamager = new SafeDamager();
    public static final LayeredHighlighter.LayerPainter DefaultPainter = new DefaultHighlightPainter(null);

    @Override
    public void paint(Graphics graphics) {
        int n = this.highlights.size();
        for (int i = 0; i < n; ++i) {
            HighlightInfo highlightInfo = this.highlights.elementAt(i);
            if (highlightInfo instanceof LayeredHighlightInfo) continue;
            Rectangle rectangle = this.component.getBounds();
            Insets insets = this.component.getInsets();
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            while (i < n) {
                highlightInfo = this.highlights.elementAt(i);
                if (!(highlightInfo instanceof LayeredHighlightInfo)) {
                    Highlighter.HighlightPainter highlightPainter = highlightInfo.getPainter();
                    highlightPainter.paint(graphics, highlightInfo.getStartOffset(), highlightInfo.getEndOffset(), rectangle, this.component);
                }
                ++i;
            }
        }
    }

    public Object getHighlightInfo(int n) {
        return this.highlights != null && this.highlights.size() > n ? this.highlights.elementAt(n) : null;
    }

    @Override
    public void install(CodeEditor codeEditor) {
        this.component = codeEditor;
        this.removeAllHighlights();
    }

    @Override
    public void deinstall(CodeEditor codeEditor) {
        this.component = null;
    }

    @Override
    public Object addHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        SyntaxDocument syntaxDocument = this.component.getDocument();
        HighlightInfo highlightInfo = this.getDrawsLayeredHighlights() && highlightPainter instanceof LayeredHighlighter.LayerPainter ? new LayeredHighlightInfo() : new HighlightInfo();
        highlightInfo.painter = highlightPainter;
        highlightInfo.p0 = syntaxDocument.createPosition(n);
        highlightInfo.p1 = syntaxDocument.createPosition(n2);
        this.highlights.addElement(highlightInfo);
        this.safeDamageRange(n, n2);
        return highlightInfo;
    }

    @Override
    public void removeHighlight(Object object) {
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.component.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
        } else {
            HighlightInfo highlightInfo = (HighlightInfo)object;
            this.safeDamageRange(highlightInfo.p0, highlightInfo.p1);
        }
        this.highlights.removeElement(object);
    }

    @Override
    public void removeAllHighlights() {
        if (this.getDrawsLayeredHighlights()) {
            int n = this.highlights.size();
            if (n != 0) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = -1;
                int n7 = -1;
                for (int i = 0; i < n; ++i) {
                    HighlightInfo highlightInfo = this.highlights.elementAt(i);
                    if (highlightInfo instanceof LayeredHighlightInfo) {
                        LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)highlightInfo;
                        n2 = Math.min(n2, layeredHighlightInfo.x);
                        n3 = Math.min(n3, layeredHighlightInfo.y);
                        n4 = Math.max(n4, layeredHighlightInfo.x + layeredHighlightInfo.width);
                        n5 = Math.max(n5, layeredHighlightInfo.y + layeredHighlightInfo.height);
                        continue;
                    }
                    if (n6 == -1) {
                        n6 = highlightInfo.p0.getOffset();
                        n7 = highlightInfo.p1.getOffset();
                        continue;
                    }
                    n6 = Math.min(n6, highlightInfo.p0.getOffset());
                    n7 = Math.max(n7, highlightInfo.p1.getOffset());
                }
                if (n2 != n4 && n3 != n5) {
                    this.component.repaint(n2, n3, n4 - n2, n5 - n3);
                }
                if (n6 != -1) {
                    try {
                        this.safeDamageRange(n6, n7);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                this.highlights.removeAllElements();
            }
        } else {
            int n = this.highlights.size();
            if (n != 0) {
                int n8 = Integer.MAX_VALUE;
                int n9 = 0;
                for (int i = 0; i < n; ++i) {
                    HighlightInfo highlightInfo = this.highlights.elementAt(i);
                    n8 = Math.min(n8, highlightInfo.p0.getOffset());
                    n9 = Math.max(n9, highlightInfo.p1.getOffset());
                }
                try {
                    this.safeDamageRange(n8, n9);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.highlights.removeAllElements();
            }
        }
    }

    @Override
    public void changeHighlight(Object object, int n, int n2) throws BadLocationException {
        SyntaxDocument syntaxDocument = this.component.getDocument();
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.component.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
            layeredHighlightInfo.height = 0;
            layeredHighlightInfo.width = 0;
            layeredHighlightInfo.p0 = syntaxDocument.createPosition(n);
            layeredHighlightInfo.p1 = syntaxDocument.createPosition(n2);
            this.safeDamageRange(Math.min(n, n2), Math.max(n, n2));
        } else {
            HighlightInfo highlightInfo = (HighlightInfo)object;
            int n3 = highlightInfo.p0.getOffset();
            int n4 = highlightInfo.p1.getOffset();
            if (n == n3) {
                this.safeDamageRange(Math.min(n4, n2), Math.max(n4, n2));
            } else if (n2 == n4) {
                this.safeDamageRange(Math.min(n, n3), Math.max(n, n3));
            } else {
                this.safeDamageRange(n3, n4);
                this.safeDamageRange(n, n2);
            }
            highlightInfo.p0 = syntaxDocument.createPosition(n);
            highlightInfo.p1 = syntaxDocument.createPosition(n2);
        }
    }

    @Override
    public Highlighter.Highlight[] getHighlights() {
        int n = this.highlights.size();
        if (n == 0) {
            return noHighlights;
        }
        Object[] objectArray = new Highlighter.Highlight[n];
        this.highlights.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, CodeEditor codeEditor) {
        for (int i = this.highlights.size() - 1; i >= 0; --i) {
            HighlightInfo highlightInfo = this.highlights.elementAt(i);
            if (!(highlightInfo instanceof LayeredHighlightInfo)) continue;
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)highlightInfo;
            int n3 = layeredHighlightInfo.getStartOffset();
            int n4 = layeredHighlightInfo.getEndOffset();
            if (!(n < n3 && n2 > n3 || n >= n3 && n < n4) && (!(layeredHighlightInfo.getPainter() instanceof LayeredHighlighter.LayerPainter) || !((LayeredHighlighter.LayerPainter)layeredHighlightInfo.getPainter()).isOccupyNextLine() || n < n3 || n > n4)) continue;
            layeredHighlightInfo.paintLayeredHighlights(graphics, n, n2, shape, codeEditor);
        }
    }

    private void safeDamageRange(Position position, Position position2) {
        this.safeDamager.damageRange(position, position2);
    }

    private void safeDamageRange(int n, int n2) throws BadLocationException {
        SyntaxDocument syntaxDocument = this.component.getDocument();
        this.safeDamageRange(syntaxDocument.createPosition(n), syntaxDocument.createPosition(n2));
    }

    public void setDrawsLayeredHighlights(boolean bl) {
        this.drawsLayeredHighlights = bl;
    }

    public boolean getDrawsLayeredHighlights() {
        return this.drawsLayeredHighlights;
    }

    class SafeDamager
    implements Runnable {
        private Vector<Position> p0 = new Vector(10);
        private Vector<Position> p1 = new Vector(10);
        private Document lastDoc = null;

        SafeDamager() {
        }

        @Override
        public synchronized void run() {
            if (DefaultHighlighter.this.component != null && this.lastDoc == DefaultHighlighter.this.component.getDocument()) {
                int n = this.p0.size();
                for (int i = 0; i < n; ++i) {
                    DefaultHighlighter.this.component.getPainter().invalidateRange(this.p0.get(i).getOffset(), this.p1.get(i).getOffset());
                }
            }
            this.p0.clear();
            this.p1.clear();
            this.lastDoc = null;
        }

        public synchronized void damageRange(Position position, Position position2) {
            if (DefaultHighlighter.this.component == null) {
                this.p0.clear();
                this.lastDoc = null;
                return;
            }
            boolean bl = this.p0.isEmpty();
            SyntaxDocument syntaxDocument = DefaultHighlighter.this.component.getDocument();
            if (syntaxDocument != this.lastDoc) {
                if (!this.p0.isEmpty()) {
                    this.p0.clear();
                    this.p1.clear();
                }
                this.lastDoc = syntaxDocument;
            }
            this.p0.add(position);
            this.p1.add(position2);
            if (bl) {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    class LayeredHighlightInfo
    extends HighlightInfo {
        int x;
        int y;
        int width;
        int height;

        LayeredHighlightInfo() {
        }

        void union(Shape shape) {
            if (shape == null) {
                return;
            }
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = rectangle.width;
                this.height = rectangle.height;
            } else {
                this.width = Math.max(this.x + this.width, rectangle.x + rectangle.width);
                this.height = Math.max(this.y + this.height, rectangle.y + rectangle.height);
                this.x = Math.min(this.x, rectangle.x);
                this.width -= this.x;
                this.y = Math.min(this.y, rectangle.y);
                this.height -= this.y;
            }
        }

        void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, CodeEditor codeEditor) {
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            if (n3 <= n && n4 > n2) {
                ++n2;
            }
            n = Math.max(n3, n);
            n2 = Math.min(n4, n2);
            this.union(((LayeredHighlighter.LayerPainter)this.painter).paintLayer(graphics, n, n2, shape, codeEditor));
        }
    }

    class HighlightInfo
    implements Highlighter.Highlight {
        Position p0;
        Position p1;
        Highlighter.HighlightPainter painter;

        HighlightInfo() {
        }

        @Override
        public int getStartOffset() {
            return this.p0.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.p1.getOffset();
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private Color color;

        public DefaultHighlightPainter(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public boolean isOccupyNextLine() {
            return false;
        }

        @Override
        public void paint(Graphics graphics, int n, int n2, Shape shape, CodeEditor codeEditor) {
            Rectangle rectangle = shape.getBounds();
            try {
                Rectangle rectangle2 = codeEditor.modelToView(n);
                Rectangle rectangle3 = codeEditor.modelToView(n2);
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(codeEditor.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                if (rectangle2.y == rectangle3.y) {
                    Rectangle rectangle4 = rectangle2.union(rectangle3);
                    graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                } else {
                    int n3 = rectangle.x + rectangle.width - rectangle2.x;
                    graphics.fillRect(rectangle2.x, rectangle2.y, n3, rectangle2.height);
                    if (rectangle2.y + rectangle2.height != rectangle3.y) {
                        graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                    }
                    graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, CodeEditor codeEditor) {
            Color color = this.getColor();
            if (color == null) {
                graphics.setColor(codeEditor.getSelectionColor());
            } else {
                graphics.setColor(color);
            }
            try {
                Rectangle rectangle = codeEditor.modelToView(n, n2);
                Rectangle rectangle2 = rectangle instanceof Rectangle ? rectangle : rectangle.getBounds();
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                return rectangle2;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }
}

