/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.folding;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.DefaultFoldingSpan;
import com.jidesoft.editor.folding.FoldingModel;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public class DefaultFoldingModel
implements FoldingModel,
DocumentListener {
    private FoldingCache _cache;
    private CodeEditor _editor;
    private boolean _foldingEnabled;
    private boolean _adjusting;
    private int _column;
    private int _line;
    private boolean _dirty;
    private boolean _restoreCaretPosition;
    protected EventListenerList _listenerList = new EventListenerList();

    public DefaultFoldingModel(CodeEditor codeEditor) {
        this._cache = new FoldingCache();
        this._editor = codeEditor;
        this._dirty = false;
    }

    @Override
    public synchronized FoldingSpan addFoldingSpan(int n, int n2, String string) {
        if (this.isEnabled()) {
            FoldingSpan foldingSpan = this.createFoldingSpan(n, n2, string);
            this._dirty = true;
            this._cache.addFoldingSpan(foldingSpan);
            if (!this.isAdjusting()) {
                this.rebuild();
            }
            this.fireFoldingSpanChanged(foldingSpan, 0, this.isAdjusting());
            return foldingSpan;
        }
        return null;
    }

    protected FoldingSpan createFoldingSpan(int n, int n2, String string) {
        return new DefaultFoldingSpan(this._editor, n, n2, string);
    }

    @Override
    public synchronized boolean removeFoldingSpan(FoldingSpan foldingSpan) {
        this.expandFoldingSpan(foldingSpan);
        boolean bl = this._cache.removeFoldingSpan(foldingSpan);
        if (bl) {
            if (!this.isAdjusting()) {
                this.rebuild();
            }
            this.fireFoldingSpanChanged(foldingSpan, 1, this.isAdjusting());
            this._dirty = true;
        }
        return bl;
    }

    @Override
    public synchronized void removeAllFoldingSpans() {
        this._cache.removeAllFoldingSpans();
        if (!this.isAdjusting()) {
            this.rebuild();
        }
        this._dirty = true;
    }

    @Override
    public boolean isAdjusting() {
        return this._adjusting;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (this._adjusting != bl) {
            this._adjusting = bl;
            if (!this._adjusting) {
                if (this._dirty) {
                    this.rebuild();
                }
                this.fireFoldingSpanChanged(null, 6, this.isAdjusting());
            } else {
                this.fireFoldingSpanChanged(null, 5, this.isAdjusting());
            }
        }
    }

    @Override
    public synchronized void expandFoldingSpan(FoldingSpan foldingSpan) {
        int n;
        FoldingSpan[] foldingSpanArray;
        if (foldingSpan.isExpanded()) {
            return;
        }
        if (this._restoreCaretPosition && (foldingSpanArray = this._cache.getFoldedSpansAtOffset(n = this._editor.modelPositionToOffset(new CaretPosition(this._line, this._column)))).length == 1 && foldingSpanArray[0] == foldingSpan) {
            CaretPosition caretPosition = new CaretPosition(this._line, this._column);
            this._editor.getCaretModel().setModelPosition(caretPosition);
        }
        this._dirty = true;
        if (foldingSpan instanceof DefaultFoldingSpan) {
            ((DefaultFoldingSpan)foldingSpan).setExpandedInternal(true);
        } else {
            foldingSpan.setExpanded(true);
        }
        if (!this.isAdjusting()) {
            this.rebuild();
        }
        this.fireFoldingSpanChanged(foldingSpan, 3, this.isAdjusting());
    }

    @Override
    public synchronized void collapseFoldingSpan(FoldingSpan foldingSpan) {
        if (!foldingSpan.isExpanded()) {
            return;
        }
        CaretPosition caretPosition = this._editor.getCaretModel().getModelPosition();
        int n = this._editor.modelPositionToOffset(caretPosition);
        if (this._cache.contains(foldingSpan, n) && !this._restoreCaretPosition) {
            this._column = caretPosition.column;
            this._line = caretPosition.line;
            this._restoreCaretPosition = true;
        }
        int n2 = this._editor.getSelectionModel().getSelectionStart();
        int n3 = this._editor.getSelectionModel().getSelectionEnd();
        if (this._cache.contains(foldingSpan, n2 - 1) || this._cache.contains(foldingSpan, n3)) {
            this._editor.getSelectionModel().clearSelection();
        }
        this._dirty = true;
        ((DefaultFoldingSpan)foldingSpan).setExpandedInternal(false);
        if (!this.isAdjusting()) {
            this.rebuild();
        }
        this.fireFoldingSpanChanged(foldingSpan, 4, this.isAdjusting());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void expandAll(boolean bl) {
        FoldingSpan[] foldingSpanArray = this.getFoldingSpans();
        try {
            this.setAdjusting(true);
            for (FoldingSpan foldingSpan : foldingSpanArray) {
                foldingSpan.setExpanded(bl);
            }
        }
        finally {
            this.setAdjusting(false);
        }
    }

    @Override
    public synchronized void expandAll() {
        this.expandAll(true);
    }

    @Override
    public synchronized void collapseAll() {
        this.expandAll(false);
    }

    @Override
    public synchronized void foldingSpanUpdated(FoldingSpan foldingSpan) {
        if (!this.isAdjusting()) {
            this.rebuild();
        }
        this.fireFoldingSpanChanged(foldingSpan, 2, this.isAdjusting());
    }

    @Override
    public synchronized FoldingSpan[] getFoldingSpans() {
        return this._cache.getAllFoldingSpans();
    }

    @Override
    public synchronized void setEnabled(boolean bl) {
        this._foldingEnabled = bl;
    }

    @Override
    public synchronized boolean isEnabled() {
        return this._foldingEnabled;
    }

    protected void fireFoldingSpanChanged(FoldingSpan foldingSpan, int n, boolean bl) {
        Object[] objectArray = this._listenerList.getListenerList();
        FoldingSpanEvent foldingSpanEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FoldingSpanListener.class) continue;
            if (foldingSpanEvent == null) {
                foldingSpanEvent = new FoldingSpanEvent(this, foldingSpan, n, bl);
            }
            ((FoldingSpanListener)objectArray[i + 1]).foldingSpanChanged(foldingSpanEvent);
        }
    }

    @Override
    public void addFoldingSpanListener(FoldingSpanListener foldingSpanListener) {
        this._listenerList.add(FoldingSpanListener.class, foldingSpanListener);
    }

    @Override
    public void removeFoldingSpanListener(FoldingSpanListener foldingSpanListener) {
        this._listenerList.remove(FoldingSpanListener.class, foldingSpanListener);
    }

    @Override
    public FoldingSpanListener[] getFoldingSpanListeners() {
        return (FoldingSpanListener[])this._listenerList.getListeners(FoldingSpanListener.class);
    }

    private int getLineEndOffsetExcludeLineBreak(int n) {
        char c;
        int n2;
        String string = this._editor.getLineText(n);
        for (n2 = string.length(); n2 > 0 && ((c = string.charAt(n2 - 1)) == '\r' || c == '\n'); --n2) {
        }
        return n2;
    }

    public String toString() {
        return this._cache == null ? "(empty)" : this._cache.toString();
    }

    public void rebuild() {
        this._cache.rebuild();
    }

    public int getLastTopLevelIndexBefore(int n) {
        return this._cache.getLastTopLevelIndexBefore(n);
    }

    public int getFoldedLinesCountBefore(int n) {
        return this._cache.getFoldedLinesCountBefore(n);
    }

    public FoldingSpan[] getTopLevelSpans() {
        return this._cache.getTopLevelSpans();
    }

    public FoldingSpan getOutermostSpanAtViewPosition(CaretPosition caretPosition) {
        return this._cache.getOutermostSpanAtViewPosition(caretPosition);
    }

    public FoldingSpan getOutermostSpanAtOffset(int n) {
        return this._cache.getOutermostSpanAtOffset(n);
    }

    public FoldingSpan[] getFoldedSpansAtOffset(int n) {
        return this._cache.getFoldedSpansAtOffset(n);
    }

    public boolean hasAnySpan(int n, int n2) {
        return this._cache.hasAnySpan(n, n2);
    }

    public FoldingSpan[] getVisibleSpans() {
        return this._cache.getVisibleSpans();
    }

    private void updateCachedOffsets() {
        this._cache.updateCachedOffsets();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this._cache.insertUpdate(documentEvent.getOffset(), documentEvent.getLength());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this._cache.removeUpdate(documentEvent.getOffset(), documentEvent.getLength());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateCachedOffsets();
    }

    public void resetCaretPosition() {
        this._restoreCaretPosition = false;
    }

    public static FoldingSpan findFoldingSpanStartingAtLine(CodeEditor codeEditor, int n) {
        FoldingSpan[] foldingSpanArray = codeEditor.getFoldingModel().getFoldingSpans();
        FoldingSpan foldingSpan = null;
        for (FoldingSpan foldingSpan2 : foldingSpanArray) {
            if (codeEditor.getLineNumber(foldingSpan2.getStartOffset()) != n) continue;
            if (foldingSpan != null) {
                return null;
            }
            foldingSpan = foldingSpan2;
        }
        return foldingSpan;
    }

    public static FoldingSpan[] getFoldingSpanAtOffset(CodeEditor codeEditor, int n) {
        FoldingSpan[] foldingSpanArray;
        ArrayList<FoldingSpan> arrayList = new ArrayList<FoldingSpan>();
        for (FoldingSpan foldingSpan : foldingSpanArray = codeEditor.getFoldingModel().getFoldingSpans()) {
            if (foldingSpan.getStartOffset() > n || n >= foldingSpan.getEndOffset()) continue;
            arrayList.add(foldingSpan);
        }
        foldingSpanArray = arrayList.toArray(new FoldingSpan[arrayList.size()]);
        Arrays.sort(foldingSpanArray, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                FoldingSpan foldingSpan = (FoldingSpan)object;
                FoldingSpan foldingSpan2 = (FoldingSpan)object2;
                return foldingSpan2.getStartOffset() - foldingSpan.getStartOffset();
            }
        });
        return foldingSpanArray;
    }

    private class FoldingCache {
        private FoldingSpan[] _visibleSpans = null;
        private FoldingSpan[] _topLevelSpans;
        private int[] _endOffsets;
        private int[] _startOffsets;
        private int[] _numberOfLines;
        private CaretPosition[] _viewPositions;
        private final LinkedList<FoldingSpan> _foldingSpanList = new LinkedList();

        public boolean isEnabled() {
            return DefaultFoldingModel.this.isEnabled() && this._visibleSpans != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rebuild() {
            FoldingSpan[] foldingSpanArray;
            FoldingSpan[] foldingSpanArray2;
            ArrayList<FoldingSpan[]> arrayList;
            ArrayList<FoldingSpan[]> arrayList2;
            Object object = this._foldingSpanList;
            synchronized (object) {
                arrayList2 = new ArrayList<FoldingSpan[]>(this._foldingSpanList.size() / 2);
                arrayList = new ArrayList<FoldingSpan[]>(this._foldingSpanList.size());
                foldingSpanArray2 = this._foldingSpanList.toArray(new FoldingSpan[this._foldingSpanList.size()]);
            }
            object = null;
            FoldingSpan[] foldingSpanArray3 = foldingSpanArray2;
            int n = foldingSpanArray3.length;
            for (int i = 0; i < n; ++i) {
                FoldingSpan[] foldingSpanArray4 = foldingSpanArray3[i];
                if (!foldingSpanArray4.isValid()) continue;
                arrayList.add(foldingSpanArray4);
                if (foldingSpanArray4.isExpanded() || object != null && object.getEndOffset() >= foldingSpanArray4.getStartOffset()) continue;
                object = foldingSpanArray4;
                arrayList2.add(foldingSpanArray4);
            }
            this._topLevelSpans = arrayList2.toArray(new FoldingSpan[arrayList2.size()]);
            Arrays.sort(this._topLevelSpans, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    int n;
                    FoldingSpan foldingSpan = (FoldingSpan)object;
                    FoldingSpan foldingSpan2 = (FoldingSpan)object2;
                    int n2 = foldingSpan.getEndOffset();
                    if (n2 < (n = foldingSpan2.getEndOffset())) {
                        return -1;
                    }
                    return n2 <= n ? 0 : 1;
                }
            });
            block4: for (FoldingSpan foldingSpan : foldingSpanArray = (foldingSpanArray3 = arrayList.toArray(new FoldingSpan[arrayList.size()]))) {
                FoldingSpan[] foldingSpanArray5 = this._topLevelSpans;
                for (int i = 0; i < foldingSpanArray5.length; ++i) {
                    FoldingSpan foldingSpan2 = foldingSpanArray5[i];
                    if (!this.contains(foldingSpan2, foldingSpan)) continue;
                    arrayList.remove(foldingSpan);
                    continue block4;
                }
            }
            this._visibleSpans = arrayList.toArray(new FoldingSpan[arrayList.size()]);
            Arrays.sort(this._visibleSpans, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    int n;
                    FoldingSpan foldingSpan = (FoldingSpan)object;
                    FoldingSpan foldingSpan2 = (FoldingSpan)object2;
                    int n2 = foldingSpan.getEndOffset();
                    if (n2 < (n = foldingSpan2.getEndOffset())) {
                        return 1;
                    }
                    return n2 <= n ? 0 : -1;
                }
            });
            this.updateCachedOffsets();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertUpdate(int n, int n2) {
            LinkedList<FoldingSpan> linkedList = this._foldingSpanList;
            synchronized (linkedList) {
                for (FoldingSpan foldingSpan : this._foldingSpanList) {
                    if (!(foldingSpan instanceof DefaultFoldingSpan)) continue;
                    if (foldingSpan.getStartOffset() >= n) {
                        DefaultFoldingModel.this.setAdjusting(true);
                        ((DefaultFoldingSpan)foldingSpan).setStartOffset(foldingSpan.getStartOffset() + n2);
                        ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() + n2);
                        continue;
                    }
                    if (foldingSpan.getEndOffset() <= n) continue;
                    DefaultFoldingModel.this.setAdjusting(true);
                    ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() + n2);
                }
                if (DefaultFoldingModel.this.isAdjusting()) {
                    this.updateCachedOffsets();
                }
                DefaultFoldingModel.this.setAdjusting(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(int n, int n2) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            LinkedList<FoldingSpan> linkedList = this._foldingSpanList;
            synchronized (linkedList) {
                for (int i = 0; i < this._foldingSpanList.size(); ++i) {
                    FoldingSpan foldingSpan = this._foldingSpanList.get(i);
                    if (!(foldingSpan instanceof DefaultFoldingSpan)) continue;
                    if (foldingSpan.getStartOffset() > n + n2 - 1) {
                        DefaultFoldingModel.this.setAdjusting(true);
                        ((DefaultFoldingSpan)foldingSpan).setStartOffset(foldingSpan.getStartOffset() - n2);
                        ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() - n2);
                        continue;
                    }
                    if (foldingSpan.getEndOffset() <= n) continue;
                    DefaultFoldingModel.this.setAdjusting(true);
                    if (foldingSpan.getStartOffset() >= n) {
                        if (foldingSpan.getEndOffset() > n + n2 - 1) {
                            ((DefaultFoldingSpan)foldingSpan).setStartOffset(n);
                            ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() - n2);
                            continue;
                        }
                        arrayList.add(i);
                        continue;
                    }
                    if (foldingSpan.getEndOffset() > n + n2 - 1) {
                        ((DefaultFoldingSpan)foldingSpan).setEndOffset(foldingSpan.getEndOffset() - n2);
                        continue;
                    }
                    ((DefaultFoldingSpan)foldingSpan).setEndOffset(n - 1);
                }
                LinkedList<FoldingSpan> linkedList2 = this._foldingSpanList;
                synchronized (linkedList2) {
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        int n3 = (Integer)arrayList.get(i);
                        this._foldingSpanList.remove(n3);
                    }
                }
                if (DefaultFoldingModel.this.isAdjusting()) {
                    this.updateCachedOffsets();
                }
                DefaultFoldingModel.this.setAdjusting(false);
            }
        }

        public void updateCachedOffsets() {
            if (this.isEnabled()) {
                FoldingSpan[] foldingSpanArray;
                FoldingSpan[] foldingSpanArray2 = foldingSpanArray = this._visibleSpans;
                int n = foldingSpanArray2.length;
                for (int i = 0; i < n; ++i) {
                    FoldingSpan foldingSpan = foldingSpanArray2[i];
                    if (foldingSpan.isValid()) continue;
                    this.rebuild();
                    return;
                }
                int n2 = 0;
                if (this._endOffsets == null || this._endOffsets.length != this._topLevelSpans.length) {
                    this._endOffsets = new int[this._topLevelSpans.length];
                    this._startOffsets = new int[this._topLevelSpans.length];
                    this._numberOfLines = new int[this._topLevelSpans.length];
                    this._viewPositions = new CaretPosition[this._topLevelSpans.length];
                }
                for (n = 0; n < this._topLevelSpans.length; ++n) {
                    FoldingSpan foldingSpan = this._topLevelSpans[n];
                    this._startOffsets[n] = foldingSpan.getStartOffset();
                    this._endOffsets[n] = foldingSpan.getEndOffset() - 1;
                    int n3 = DefaultFoldingModel.this._editor.getLineNumber(this._endOffsets[n]);
                    int n4 = DefaultFoldingModel.this.getLineEndOffsetExcludeLineBreak(n3) + DefaultFoldingModel.this._editor.getLineStartOffset(n3);
                    if (this._endOffsets[n] >= n4) {
                        this._endOffsets[n] = n4 - 1;
                    }
                    this._numberOfLines[n] = n2 += DefaultFoldingModel.this._editor.getLineNumber(foldingSpan.getEndOffset()) - DefaultFoldingModel.this._editor.getLineNumber(foldingSpan.getStartOffset());
                }
                for (n = 0; n < this._topLevelSpans.length; ++n) {
                    CaretPosition caretPosition = DefaultFoldingModel.this._editor.offsetToViewPosition(this._startOffsets[n]);
                    this._viewPositions[n] = new CaretPosition(caretPosition.line, caretPosition.column + (this._topLevelSpans[n].getDescription() == null ? 0 : this._topLevelSpans[n].getDescription().length()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addFoldingSpan(FoldingSpan foldingSpan) {
            LinkedList<FoldingSpan> linkedList = this._foldingSpanList;
            synchronized (linkedList) {
                for (int i = 0; i < this._foldingSpanList.size(); ++i) {
                    FoldingSpan foldingSpan2 = this._foldingSpanList.get(i);
                    if (foldingSpan2.isValid() && this.intersects(foldingSpan2, foldingSpan)) {
                        return false;
                    }
                    if (foldingSpan.getStartOffset() >= foldingSpan2.getStartOffset() && (foldingSpan.getStartOffset() != foldingSpan2.getStartOffset() || foldingSpan.getEndOffset() <= foldingSpan2.getEndOffset())) continue;
                    for (int j = i + 1; j < this._foldingSpanList.size(); ++j) {
                        FoldingSpan foldingSpan3 = this._foldingSpanList.get(j);
                        if (foldingSpan3.getEndOffset() < foldingSpan.getEndOffset() || !foldingSpan3.isValid()) continue;
                        if (foldingSpan3.getStartOffset() >= foldingSpan.getStartOffset()) break;
                        return false;
                    }
                    this._foldingSpanList.add(i, foldingSpan);
                    return true;
                }
                this._foldingSpanList.addLast(foldingSpan);
            }
            return true;
        }

        public FoldingSpan getOutermostSpanAtOffset(int n) {
            if (!this.isEnabled()) {
                return null;
            }
            int n2 = 0;
            int n3 = this._endOffsets.length - 1;
            while (n2 <= n3) {
                int n4 = (n2 + n3) / 2;
                if (n < this._startOffsets[n4]) {
                    n3 = n4 - 1;
                    continue;
                }
                if (n > this._endOffsets[n4]) {
                    n2 = n4 + 1;
                    continue;
                }
                return this._topLevelSpans[n4];
            }
            return null;
        }

        public FoldingSpan getOutermostSpanAtViewPosition(CaretPosition caretPosition) {
            if (this._viewPositions == null) {
                return null;
            }
            int n = 0;
            int n2 = this._viewPositions.length - 1;
            int n3 = 0;
            while (n <= n2) {
                n3 = (n + n2) / 2;
                CaretPosition caretPosition2 = this._viewPositions[n3];
                if (caretPosition2.line < caretPosition.line) {
                    n = n3 + 1;
                    continue;
                }
                if (caretPosition2.line > caretPosition.line) {
                    n2 = n3 - 1;
                    continue;
                }
                if (caretPosition2.column < caretPosition.column) {
                    n = n3 + 1;
                    continue;
                }
                if (caretPosition2.column >= caretPosition.column) break;
                n2 = n3 - 1;
            }
            if (n3 >= 0 && n3 < this._viewPositions.length) {
                if (this._viewPositions[n3].line > caretPosition.line || this._viewPositions[n3].line == caretPosition.line && this._viewPositions[n3].column - (this._topLevelSpans[n3].getDescription() == null ? 0 : this._topLevelSpans[n3].getDescription().length()) >= caretPosition.column) {
                    if (--n3 >= 0) {
                        return this._topLevelSpans[n3];
                    }
                    return null;
                }
                return this._topLevelSpans[n3];
            }
            return null;
        }

        public FoldingSpan[] getVisibleSpans() {
            if (!this.isEnabled()) {
                return new FoldingSpan[0];
            }
            return this._visibleSpans;
        }

        public FoldingSpan[] getTopLevelSpans() {
            if (!this.isEnabled()) {
                return null;
            }
            return this._topLevelSpans;
        }

        private boolean contains(FoldingSpan foldingSpan, FoldingSpan foldingSpan2) {
            return foldingSpan.getStartOffset() < foldingSpan2.getStartOffset() && foldingSpan.getEndOffset() > foldingSpan2.getStartOffset();
        }

        private boolean intersects(FoldingSpan foldingSpan, FoldingSpan foldingSpan2) {
            int n = foldingSpan.getStartOffset();
            int n2 = foldingSpan2.getStartOffset();
            int n3 = foldingSpan.getEndOffset();
            int n4 = foldingSpan2.getEndOffset();
            return n == n2 && n3 == n4 || n < n2 && n2 < n3 && n3 < n4 || n2 < n && n < n4 && n4 < n3;
        }

        private boolean contains(FoldingSpan foldingSpan, int n) {
            return foldingSpan.getStartOffset() <= n && foldingSpan.getEndOffset() > n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FoldingSpan[] getFoldedSpansAtOffset(int n) {
            if (!this.isEnabled()) {
                return new FoldingSpan[0];
            }
            ArrayList<FoldingSpan> arrayList = new ArrayList<FoldingSpan>();
            LinkedList<FoldingSpan> linkedList = this._foldingSpanList;
            synchronized (linkedList) {
                for (FoldingSpan foldingSpan : this._foldingSpanList) {
                    if (foldingSpan.isExpanded() || !this.contains(foldingSpan, n)) continue;
                    arrayList.add(foldingSpan);
                }
            }
            return arrayList.toArray(new FoldingSpan[arrayList.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasAnySpan(int n, int n2) {
            if (!DefaultFoldingModel.this.isEnabled()) {
                return true;
            }
            LinkedList<FoldingSpan> linkedList = this._foldingSpanList;
            synchronized (linkedList) {
                for (FoldingSpan foldingSpan : this._foldingSpanList) {
                    boolean bl = this.contains(foldingSpan, n);
                    boolean bl2 = this.contains(foldingSpan, n2);
                    if ((!bl || bl2) && (bl || !bl2)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FoldingSpan[] getAllFoldingSpans() {
            LinkedList<FoldingSpan> linkedList = this._foldingSpanList;
            synchronized (linkedList) {
                if (!this.isEnabled()) {
                    return new FoldingSpan[0];
                }
                return this._foldingSpanList.toArray(new FoldingSpan[this._foldingSpanList.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeFoldingSpan(FoldingSpan foldingSpan) {
            LinkedList<FoldingSpan> linkedList = this._foldingSpanList;
            synchronized (linkedList) {
                return this._foldingSpanList.remove(foldingSpan);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllFoldingSpans() {
            LinkedList<FoldingSpan> linkedList = this._foldingSpanList;
            synchronized (linkedList) {
                this._foldingSpanList.clear();
            }
        }

        public int getFoldedLinesCountBefore(int n) {
            int n2 = this.getLastTopLevelIndexBefore(n);
            if (n2 == -1) {
                return 0;
            }
            return this._numberOfLines[n2];
        }

        public int getLastTopLevelIndexBefore(int n) {
            if (!this.isEnabled()) {
                return -1;
            }
            int n2 = 0;
            int n3 = this._endOffsets.length - 1;
            while (n2 <= n3) {
                int n4 = (n2 + n3) / 2;
                if (n < this._endOffsets[n4]) {
                    n3 = n4 - 1;
                    continue;
                }
                if (n > this._endOffsets[n4]) {
                    n2 = n4 + 1;
                    continue;
                }
                return n4;
            }
            return n3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._topLevelSpans != null) {
                for (int i = 0; i < this._topLevelSpans.length; ++i) {
                    stringBuffer.append("Folded Span (").append(this._topLevelSpans[i].getStartOffset()).append(",").append(this._topLevelSpans[i].getEndOffset()).append(").");
                    if (i < this._startOffsets.length) {
                        stringBuffer.append("Start at: ").append(this._startOffsets[i]).append(".");
                    }
                    if (i < this._endOffsets.length) {
                        stringBuffer.append("End at: ").append(this._endOffsets[i]).append(".");
                    }
                    if (i < this._numberOfLines.length) {
                        stringBuffer.append("Occupies ").append(this._numberOfLines[i]).append(" lines.");
                    }
                    if (i < this._viewPositions.length) {
                        stringBuffer.append("View Position is:(").append(this._viewPositions[i].line).append(",").append(this._viewPositions[i].column).append(").");
                    }
                    stringBuffer.append("\r\n");
                }
            }
            return stringBuffer.toString();
        }
    }
}

