/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxStyle;
import com.jidesoft.editor.SyntaxStyleSchema;
import com.jidesoft.editor.tokenmarker.Token;
import com.jidesoft.marker.Marker;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class SyntaxUtils {
    public static final String SPECIAL_CHAR_SPACE = "\u00b7";
    public static final String SPECIAL_CHAR_TAB = "\u00bb";
    public static final String SPECIAL_CHAR_END_OF_LINE = "\u00b6";

    private SyntaxUtils() {
    }

    public static boolean regionMatches(boolean bl, Segment segment, int n, String string) {
        int n2 = n + string.length();
        char[] cArray = segment.array;
        if (n2 > segment.offset + segment.count) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            char c2 = string.charAt(n4);
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public static boolean regionMatches(boolean bl, Segment segment, int n, char[] cArray) {
        int n2 = n + cArray.length;
        char[] cArray2 = segment.array;
        if (n2 > segment.offset + segment.count) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            char c = cArray2[n3];
            char c2 = cArray[n4];
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    @Deprecated
    public static int paintSyntaxLine(CodeEditor codeEditor, Segment segment, int n, int n2, Token token, SyntaxStyleSchema syntaxStyleSchema, TabExpander tabExpander, Graphics graphics, int n3, int n4) {
        return SyntaxUtils.paintSyntaxLine(codeEditor, segment, n, n2, token, syntaxStyleSchema, tabExpander, graphics, n3, n4, 0);
    }

    public static int paintSyntaxLine(CodeEditor codeEditor, Segment segment, int n, int n2, Token token, SyntaxStyleSchema syntaxStyleSchema, TabExpander tabExpander, Graphics graphics, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        byte by;
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        int n9 = 0;
        ArrayList<PaintStyle> arrayList = new ArrayList<PaintStyle>();
        while ((by = token.id) != 127) {
            int n10 = n2 != -1 ? Math.min(n2 - n9, token.length) : token.length;
            SyntaxStyle object = syntaxStyleSchema.getStyle(by);
            arrayList.add(new PaintStyle(n9 + segment.offset, n10, object, by));
            if (n2 != -1 && n2 <= (n9 += n10)) break;
            token = token.next;
        }
        List<Marker> list = codeEditor.getMarkerModel().getMarkersAt(segment.offset + n5, segment.getEndIndex() + n5);
        for (Marker marker : list) {
            PaintStyle paintStyle;
            if (!marker.isEnabled() || marker.getType() < 128) continue;
            n8 = marker.getStartOffset() - n5;
            int n10 = marker.getEndOffset() - n5;
            n7 = -1;
            n6 = -1;
            int n11 = 0;
            while (n11 < arrayList.size()) {
                paintStyle = (PaintStyle)arrayList.get(n11);
                if (n7 < 0 && n8 < paintStyle.getOffset() + paintStyle.getLength()) {
                    n7 = n11;
                }
                if (n10 < paintStyle.getOffset()) break;
                n6 = n11++;
            }
            if (n7 < 0 || n6 < 0 || codeEditor.getStyles().getStyle(marker.getType()) == null) continue;
            PaintStyle paintStyle2 = (PaintStyle)arrayList.get(n7);
            paintStyle = (PaintStyle)arrayList.get(n6);
            for (int i = n7; i <= n6; ++i) {
                arrayList.remove(n7);
            }
            if (n10 < paintStyle.getOffset() + paintStyle.getLength() - 1) {
                arrayList.add(n7, new PaintStyle(n10 + 1, paintStyle.getOffset() + paintStyle.getLength() - n10 - 1, paintStyle.getStyle(), paintStyle.getId()));
            }
            arrayList.add(n7, new PaintStyle(Math.max(n8, paintStyle2.getOffset()), Math.min(n10 + 1, paintStyle.getOffset() + paintStyle.getLength()) - Math.max(n8, paintStyle2.getOffset()), codeEditor.getStyles().getStyle(marker.getType()), marker.getType()));
            if (n8 <= paintStyle2.getOffset()) continue;
            arrayList.add(n7, new PaintStyle(paintStyle2.getOffset(), n8 - paintStyle2.getOffset(), paintStyle2.getStyle(), paintStyle2.getId()));
        }
        n += segment.offset;
        for (PaintStyle paintStyle : arrayList) {
            n8 = paintStyle.getId();
            SyntaxStyle syntaxStyle = paintStyle.getStyle();
            n7 = paintStyle.getLength();
            n6 = paintStyle.getOffset();
            if (syntaxStyle == null || n8 == 0 && syntaxStyle.getForeground() == null) {
                if (!color.equals(graphics.getColor())) {
                    graphics.setColor(color);
                }
                if (!font.equals(graphics.getFont())) {
                    graphics.setFont(font);
                }
            } else {
                syntaxStyle.setGraphicsFlags(graphics, font);
            }
            segment.count = n7;
            segment.offset = n6;
            if (n > n6 + n7) continue;
            if (n > n6 && n <= n6 + segment.count) {
                segment.offset += n - n6;
                segment.count -= n - n6;
            }
            n3 = SyntaxUtils.drawTabbedText(codeEditor, segment, n3, n4, graphics, tabExpander, 0);
        }
        return n3;
    }

    static int getXWithoutDrawingFoldedText(CodeEditor codeEditor, String string, int n) {
        if (string == null) {
            return n;
        }
        return n + codeEditor.getPainter().getFontMetrics().stringWidth(string);
    }

    static int getXWithoutDrawingSyntaxLine(CodeEditor codeEditor, Segment segment, int n, int n2, Token token, int n3) {
        int n4;
        int n5;
        byte by;
        Font font = codeEditor.getPainter().getFont();
        SyntaxStyleSchema syntaxStyleSchema = codeEditor.getStyles();
        Graphics graphics = codeEditor.getPainter().getGraphics();
        if (graphics == null) {
            return 0;
        }
        int n6 = segment.offset;
        int n7 = segment.count;
        int n8 = 0;
        ArrayList<PaintStyle> arrayList = new ArrayList<PaintStyle>();
        while ((by = token.id) != 127) {
            int n9 = n2 != -1 ? Math.min(n2 - n8, token.length) : token.length;
            SyntaxStyle object = syntaxStyleSchema.getStyle(by);
            arrayList.add(new PaintStyle(n8 + segment.offset, n9, object, by));
            if (n2 != -1 && n2 <= (n8 += n9)) break;
            token = token.next;
        }
        List<Marker> list = codeEditor.getMarkerModel().getMarkersAt(segment.offset, segment.getEndIndex());
        for (Marker marker : list) {
            PaintStyle paintStyle;
            n5 = -1;
            int n9 = -1;
            n4 = 0;
            while (n4 < arrayList.size()) {
                paintStyle = (PaintStyle)arrayList.get(n4);
                if (n5 < 0 && marker.getStartOffset() < paintStyle.getOffset() + paintStyle.getLength()) {
                    n5 = n4;
                }
                if (marker.getEndOffset() < paintStyle.getOffset()) break;
                n9 = n4++;
            }
            if (n5 < 0 || n9 < 0 || codeEditor.getStyles().getStyle(marker.getType()) == null) continue;
            PaintStyle paintStyle2 = (PaintStyle)arrayList.get(n5);
            paintStyle = (PaintStyle)arrayList.get(n9);
            for (int i = n5; i <= n9; ++i) {
                arrayList.remove(n5);
            }
            if (marker.getEndOffset() < paintStyle.getOffset() + paintStyle.getLength() - 1) {
                arrayList.add(n5, new PaintStyle(marker.getEndOffset() + 1, paintStyle.getOffset() + paintStyle.getLength() - marker.getEndOffset() - 1, paintStyle.getStyle(), paintStyle.getId()));
            }
            arrayList.add(n5, new PaintStyle(Math.max(marker.getStartOffset(), paintStyle2.getOffset()), Math.min(marker.getEndOffset() + 1, paintStyle.getOffset() + paintStyle.getLength()) - Math.max(marker.getStartOffset(), paintStyle2.getOffset()), codeEditor.getStyles().getStyle(marker.getType()), marker.getType()));
            if (marker.getStartOffset() <= paintStyle2.getOffset()) continue;
            arrayList.add(n5, new PaintStyle(paintStyle2.getOffset(), marker.getStartOffset() - paintStyle2.getOffset(), paintStyle2.getStyle(), paintStyle2.getId()));
        }
        n += segment.offset;
        for (PaintStyle paintStyle : arrayList) {
            n5 = paintStyle.getId();
            SyntaxStyle syntaxStyle = paintStyle.getStyle();
            n4 = paintStyle.getLength();
            int n10 = paintStyle.getOffset();
            if (n5 == 0) {
                if (!font.equals(graphics.getFont())) {
                    graphics.setFont(font);
                }
            } else {
                syntaxStyle.setGraphicsFlags(graphics, font);
            }
            segment.count = n4;
            segment.offset = n10;
            if (n > n10 + n4) continue;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (n > n10 && n <= n10 + segment.count) {
                segment.offset += n - n10;
                segment.count -= n - n10;
            }
            n3 += Utilities.getTabbedTextWidth(segment, fontMetrics, n3, (TabExpander)codeEditor.getPainter(), 0);
        }
        segment.offset = n6;
        segment.count = n7;
        return n3;
    }

    static int drawTabbedText(CodeEditor codeEditor, Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        return SyntaxUtils.drawTabbedText(codeEditor, segment, n, n2, graphics, tabExpander, n3, null);
    }

    static JComponent getJComponent(View view) {
        Container container;
        if (view != null && (container = view.getContainer()) instanceof JComponent) {
            return (JComponent)container;
        }
        return null;
    }

    public static int drawTabbedText(CodeEditor codeEditor, Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3, int[] nArray) {
        boolean bl = codeEditor.isSpecialCharactersVisible();
        Color color = codeEditor.getSpecialCharactersColor();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = n;
        char[] cArray = segment.array;
        int n5 = segment.offset;
        int n6 = 0;
        int n7 = segment.offset;
        int n8 = 0;
        int n9 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        int n10 = Math.min(segment.offset + segment.count, cArray.length);
        for (int i = n5; i < n10; ++i) {
            Color color2;
            if (cArray[i] == '\t' || cArray[i] == ' ') {
                if (n6 > 0) {
                    graphics.drawChars(cArray, n7, n6, n, n2);
                    n4 = n + graphics.getFontMetrics().charsWidth(cArray, n7, n6);
                    n6 = 0;
                }
                n7 = i + 1;
                if (cArray[i] == '\t') {
                    if (bl) {
                        color2 = graphics.getColor();
                        graphics.setColor(color);
                        graphics.drawString(SPECIAL_CHAR_TAB, n4, n2);
                        graphics.setColor(color2);
                    }
                    n4 = tabExpander != null ? (int)tabExpander.nextTabStop(n4, n3 + i - n5) : (n4 += fontMetrics.charWidth(' '));
                } else if (cArray[i] == ' ') {
                    if (bl) {
                        color2 = graphics.getColor();
                        graphics.setColor(color);
                        graphics.drawString(SPECIAL_CHAR_SPACE, n4, n2);
                        graphics.setColor(color2);
                    }
                    n4 += fontMetrics.charWidth(' ') + n8;
                    if (i <= n9) {
                        // empty if block
                    }
                }
                n = ++n4;
                continue;
            }
            if (cArray[i] == '\n' || cArray[i] == '\r') {
                if (bl) {
                    color2 = graphics.getColor();
                    graphics.setColor(color);
                    graphics.drawString(SPECIAL_CHAR_END_OF_LINE, n + graphics.getFontMetrics().charsWidth(cArray, n7, n6), n2);
                    graphics.setColor(color2);
                }
                if (n6 > 0) {
                    graphics.drawChars(cArray, n7, n6, n, n2);
                    n4 = n + graphics.getFontMetrics().charsWidth(cArray, n7, n6);
                    n6 = 0;
                }
                n7 = i + 1;
                n = n4;
                continue;
            }
            ++n6;
        }
        if (n6 > 0) {
            graphics.drawChars(cArray, n7, n6, n, n2);
            n4 = n + graphics.getFontMetrics().charsWidth(cArray, n7, n6);
        }
        return n4;
    }

    private static class PaintStyle {
        private int _offset;
        private int _length;
        private SyntaxStyle _style;
        private int _id;

        public PaintStyle(int n, int n2, SyntaxStyle syntaxStyle, int n3) {
            this._offset = n;
            this._length = n2;
            this._style = syntaxStyle;
            this._id = n3;
        }

        public int getOffset() {
            return this._offset;
        }

        public int getLength() {
            return this._length;
        }

        public SyntaxStyle getStyle() {
            return this._style;
        }

        public int getId() {
            return this._id;
        }
    }
}

