/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.DocumentListenerEx;
import com.jidesoft.editor.LineBreak;
import com.jidesoft.editor.TextUtils;
import com.jidesoft.editor.tokenmarker.Token;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import com.jidesoft.swing.DelayUndoManager;
import com.jidesoft.utils.PortingUtils;
import java.util.Locale;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SyntaxDocument
extends PlainDocument
implements LineBreak {
    protected UndoManager _undoManager;
    protected CompoundEdit _compoundEdit;
    protected int _compoundEditCount = 0;
    private int _lookupBufferSize = 256;
    private static final long serialVersionUID = -6307295612809666540L;
    Segment lineSegment = new Segment();
    Segment _checkCommentSegment = new Segment();
    Token _checkCommentToken = null;
    protected TokenMarker tokenMarker;

    public SyntaxDocument() {
        this._undoManager = new DelayUndoManager();
        this.addUndoableEditListener(new MyUndoableEditListener());
    }

    public String getLineText(int n) throws BadLocationException {
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        int n3 = element.getElement(n2).getStartOffset();
        int n4 = element.getElement(n2).getEndOffset();
        return this.getText(n3, n4 - n3);
    }

    public int getLineNumber(int n) {
        return this.getDefaultRootElement().getElementIndex(n);
    }

    public void undo() {
        UndoManager undoManager = this.getUndoManager();
        if (undoManager.canUndo()) {
            undoManager.undo();
        } else {
            PortingUtils.notifyUser();
        }
    }

    public void redo() {
        UndoManager undoManager = this.getUndoManager();
        if (undoManager.canRedo()) {
            undoManager.redo();
        } else {
            PortingUtils.notifyUser();
        }
    }

    public UndoManager getUndoManager() {
        return this._undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this._undoManager = undoManager;
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        if (this.tokenMarker != null) {
            this.tokenMarker.setDocument(null);
        }
        this.tokenMarker = tokenMarker;
        if (tokenMarker == null) {
            return;
        }
        this.tokenMarker.setDocument(this);
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int n, int n2) {
        this.tokenizeLines(n, n2, false, false);
    }

    void tokenizeLines(int n, int n2, boolean bl, boolean bl2) {
        if (this.tokenMarker == null || !this.tokenMarker.supportsMultilineTokens()) {
            return;
        }
        n2 += n;
        Segment segment = new Segment();
        try {
            for (int i = n; i < n2 && i < this.getLineCount(); ++i) {
                int n3 = this.getLineStartOffset(i);
                int n4 = this.getLineEndOffset(i) - n3;
                this.getText(n3, n4, segment);
                this.tokenMarker.markTokens(segment, i);
                if (!bl) continue;
                byte by = this.tokenMarker.getLastToken(i);
                if (!(bl2 ? by != 3 && by != 1 : by == 3 || by == 1)) {
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean isInCommentOrLiteral(int n) throws BadLocationException {
        TokenMarker tokenMarker = this.getTokenMarker();
        if (tokenMarker == null || n < 0 || n >= this.getLength()) {
            return false;
        }
        int n2 = this.getLineNumber(n);
        int n3 = this.getLineStartOffset(n2);
        int n4 = this.getLineEndOffset(n2) - n3;
        if (n >= n3 && n < n3 + n4) {
            if (this._checkCommentSegment.getBeginIndex() != n3 || this._checkCommentSegment.getEndIndex() != n3 + n4 || this._checkCommentToken == null) {
                this.getText(n3, n4, this._checkCommentSegment);
                this._checkCommentToken = tokenMarker.markTokens(this._checkCommentSegment, n2);
            }
            Token token = this._checkCommentToken;
            int n5 = 0;
            while (token != null && token.id != 127) {
                if ((token.id == 1 || token.id == 2 || token.id == 3 || token.id == 4) && n3 + n5 < n && n3 + n5 + token.length > n + 1) {
                    return true;
                }
                n5 += token.length;
                token = token.next;
            }
        }
        return false;
    }

    public void beginCompoundEdit() {
        if (this._compoundEdit == null) {
            this._compoundEdit = new CompoundEdit();
        }
        ++this._compoundEditCount;
    }

    public void endCompoundEdit() {
        --this._compoundEditCount;
        if (this._compoundEditCount == 0) {
            this._compoundEdit.end();
            this.getUndoManager().undoableEditHappened(new UndoableEditEvent(this, this._compoundEdit));
            this._compoundEdit = null;
        }
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        this.syncLineInfoOnInsert(documentEvent);
        super.fireInsertUpdate(documentEvent);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        this.syncLineInfoOnRemove(documentEvent);
        super.fireRemoveUpdate(documentEvent);
    }

    void syncLineInfoOnInsert(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.insertLines(elementChange.getIndex() + 1, elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length);
        }
    }

    void syncLineInfoOnRemove(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.deleteLines(elementChange.getIndex() + 1, elementChange.getChildrenRemoved().length - elementChange.getChildrenAdded().length);
        }
    }

    public static int convertLineBreaks(String string, StringBuffer stringBuffer) {
        int n = CodeEditor.getCodeEditorDefaultLineBreakStyle();
        int n2 = SyntaxDocument.convertLineBreaks(string, stringBuffer, TextUtils.getLineBreak(n != 2 ? n : 1), null);
        if (n2 != n && n2 != 2 && n2 != -1 && n2 != -2) {
            stringBuffer.replace(0, stringBuffer.length(), "");
            n2 = SyntaxDocument.convertLineBreaks(string, stringBuffer, TextUtils.getLineBreak(n2), null);
        }
        return n2;
    }

    public static int convertLineBreaks(String string, StringBuffer stringBuffer, String string2) {
        return SyntaxDocument.convertLineBreaks(string, stringBuffer, string2, null);
    }

    private static int convertLineBreaks(String string, StringBuffer stringBuffer, String string2, int[] nArray) {
        int n = -2;
        boolean bl = false;
        if (string == null) {
            return n;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                stringBuffer.append(string2);
                SyntaxDocument.shiftOffsets(nArray, stringBuffer.length(), 1, string2.length());
                if (bl) continue;
                if (n == -2) {
                    n = 1;
                    continue;
                }
                if (n == 1) continue;
                n = -1;
                bl = true;
                continue;
            }
            if (c == '\r') {
                stringBuffer.append(string2);
                if (i < string.length() - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                    SyntaxDocument.shiftOffsets(nArray, stringBuffer.length(), 2, string2.length());
                    if (bl) continue;
                    if (n == -2) {
                        n = 0;
                        continue;
                    }
                    if (n == 0) continue;
                    n = -1;
                    bl = true;
                    continue;
                }
                if (i < string.length() - 2 && string.charAt(i + 1) == '\r' && string.charAt(i + 2) == '\n') {
                    i += 2;
                    SyntaxDocument.shiftOffsets(nArray, stringBuffer.length(), 3, string2.length());
                    if (bl) continue;
                    if (n == -2) {
                        n = 0;
                        continue;
                    }
                    if (n == 0) continue;
                    n = -1;
                    bl = true;
                    continue;
                }
                SyntaxDocument.shiftOffsets(nArray, stringBuffer.length(), 1, string2.length());
                if (bl) continue;
                if (n == -2) {
                    n = 2;
                    continue;
                }
                if (n == 2) continue;
                n = -1;
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return n;
    }

    private static void shiftOffsets(int[] nArray, int n, int n2, int n3) {
        if (nArray == null) {
            return;
        }
        int n4 = n3 - n2;
        if (n4 == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = nArray[i];
            if (n5 < n + n2) continue;
            int n6 = i;
            nArray[n6] = nArray[n6] + n4;
        }
    }

    public char charAt(int n) throws BadLocationException {
        this.getContent().getChars(n, 1, this.lineSegment);
        return this.lineSegment.first();
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        this.fireRemovingUpdate(defaultDocumentEvent);
        super.removeUpdate(defaultDocumentEvent);
    }

    protected void fireRemovingUpdate(DocumentEvent documentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DocumentListener.class || !(objectArray[i + 1] instanceof DocumentListenerEx)) continue;
            ((DocumentListenerEx)objectArray[i + 1]).removingUpdate(documentEvent);
        }
    }

    public int getLookupBufferSize() {
        return this._lookupBufferSize;
    }

    public void setLookupBufferSize(int n) {
        this._lookupBufferSize = n;
    }

    public int findNext(String[] stringArray, int n, int n2, boolean bl) {
        return this.findNext(stringArray, n, n2, bl, false);
    }

    public int findNext(String[] stringArray, int n, int n2, boolean bl, boolean bl2) {
        return this.findNext(stringArray, n, n2, bl, true, bl2);
    }

    protected boolean isWordChar(char c) {
        return c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    int findNext(String[] stringArray, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        if (n < 0 || n2 < 0 || n >= this.getLength() || n2 > this.getLength()) {
            return -1;
        }
        String[] stringArray2 = stringArray;
        int n4 = 0;
        if (!bl) {
            stringArray2 = new String[stringArray.length];
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                stringArray2[n3] = stringArray[n3].toLowerCase(Locale.getDefault());
                n4 = Math.max(n4, stringArray2[n3].length());
            }
        } else {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                n4 = Math.max(n4, stringArray2[n3].length());
            }
        }
        if (n + n4 > n2) {
            return -1;
        }
        n3 = n;
        int n5 = Math.min(this.getLookupBufferSize(), n2 - n3);
        while (n3 < n2) {
            String string;
            if (!bl2 && !this.isOffsetLoaded(n3 + n5 - 1)) {
                return -1;
            }
            try {
                string = this.getText(n3, n5);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            if (!bl) {
                string = string.toLowerCase(Locale.getDefault());
            }
            int n6 = -1;
            for (String string2 : stringArray2) {
                int n7 = string.indexOf(string2);
                if (n7 >= 0 && bl3) {
                    int n8;
                    do {
                        n8 = n7;
                        if (n7 > 0 && this.isWordChar(string.charAt(n7 - 1))) {
                            n8 = -1;
                        }
                        if (n7 >= 0 && n7 + string2.length() < string.length() && this.isWordChar(string.charAt(n7 + string2.length()))) {
                            n8 = -1;
                        }
                        n7 = string.indexOf(string2, n7 + 1);
                    } while (n8 < 0 && n7 >= 0);
                    n7 = n8;
                }
                if (n7 < 0) continue;
                n6 = n6 < 0 ? n7 : Math.min(n6, n7);
            }
            if (n6 >= 0) {
                return n3 + n6;
            }
            if (n3 + n5 >= n2) break;
            n5 = Math.min(this.getLookupBufferSize(), n2 - (n3 += n5 - n4 + 1));
        }
        return -1;
    }

    public int findPrevious(String[] stringArray, int n, int n2, boolean bl) {
        return this.findPrevious(stringArray, n, n2, bl, false);
    }

    public int findPrevious(String[] stringArray, int n, int n2, boolean bl, boolean bl2) {
        return this.findPrevious(stringArray, n, n2, bl, true, bl2);
    }

    public boolean isOffsetLoaded(int n) {
        return true;
    }

    public boolean isLineLoaded(int n) {
        return true;
    }

    int findPrevious(String[] stringArray, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        if (n < 0 || n2 < 0 || n > this.getLength() || n2 >= this.getLength()) {
            return -1;
        }
        String[] stringArray2 = stringArray;
        int n4 = 0;
        if (!bl) {
            stringArray2 = new String[stringArray.length];
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                stringArray2[n3] = stringArray[n3].toLowerCase(Locale.getDefault());
                n4 = Math.max(n4, stringArray2[n3].length());
            }
        } else {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                n4 = Math.max(n4, stringArray2[n3].length());
            }
        }
        if (n2 + n4 > n) {
            return -1;
        }
        n3 = Math.max(n - this.getLookupBufferSize(), n2);
        int n5 = Math.min(this.getLookupBufferSize(), n - n2);
        while (n3 >= n2) {
            String string;
            if (!bl2 && !this.isOffsetLoaded(n3)) {
                return -1;
            }
            try {
                string = this.getText(n3, n5);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            if (!bl) {
                string = string.toLowerCase(Locale.getDefault());
            }
            int n6 = -1;
            for (String string2 : stringArray2) {
                int n7 = string.lastIndexOf(string2);
                if (n7 >= 0 && bl3) {
                    int n8;
                    do {
                        n8 = n7;
                        if (n7 > 0 && this.isWordChar(string.charAt(n7 - 1))) {
                            n8 = -1;
                        }
                        if (n7 >= 0 && n7 + string2.length() < string.length() && this.isWordChar(string.charAt(n7 + string2.length()))) {
                            n8 = -1;
                        }
                        string = string.substring(0, n7);
                        n7 = string.lastIndexOf(string2);
                    } while (n8 < 0 && n7 >= 0);
                    n7 = n8;
                }
                if (n7 < 0) continue;
                n6 = n6 < 0 ? n7 : Math.max(n6, n7);
            }
            if (n6 >= 0) {
                return n3 + n6;
            }
            if (n3 == n2) break;
            n5 = Math.min(this.getLookupBufferSize(), n3 + n4 - 1);
            n3 = Math.max(n3 + n4 - 1 - this.getLookupBufferSize(), n2);
        }
        return -1;
    }

    public int getLineCount() {
        return this.getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int n) {
        Element element = this.getDefaultRootElement();
        if (n >= element.getElementCount()) {
            return this.getLength() + 1;
        }
        Element element2 = element.getElement(n);
        if (element2 == null) {
            return -1;
        }
        return element2.getStartOffset();
    }

    public int getLineEndOffset(int n) {
        Element element;
        Element element2 = this.getDefaultRootElement();
        if (n >= element2.getElementCount()) {
            n = element2.getElementCount() - 1;
        }
        if ((element = element2.getElement(n)) == null) {
            return -1;
        }
        return element.getEndOffset() - 1;
    }

    public int getLineLength(int n) {
        return this.getLineEndOffset(n) - this.getLineStartOffset(n) + 1;
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (SyntaxDocument.this._compoundEdit != null) {
                SyntaxDocument.this._compoundEdit.addEdit(undoableEditEvent.getEdit());
            } else {
                SyntaxDocument.this.getUndoManager().undoableEditHappened(undoableEditEvent);
            }
        }
    }
}

