/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.LazyLoadDocument;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

class SubPageEdit
extends AbstractUndoableEdit {
    private LazyLoadDocument _document;
    private int _offset;
    private DocumentEvent.EventType _type;
    private String _string;
    private static final long serialVersionUID = -8532668113076740979L;

    public SubPageEdit(LazyLoadDocument lazyLoadDocument, int n, DocumentEvent.EventType eventType, String string) {
        this._document = lazyLoadDocument;
        this._offset = n;
        this._type = eventType;
        this._string = string;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            return;
        }
        if (this._type == DocumentEvent.EventType.REMOVE) {
            try {
                this._document.insertString(this._offset, this._string, null, true);
            }
            catch (BadLocationException badLocationException) {}
        } else if (this._type == DocumentEvent.EventType.INSERT) {
            try {
                this._document.remove(this._offset, this._string.length(), true);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        super.undo();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            return;
        }
        if (this._type == DocumentEvent.EventType.REMOVE) {
            try {
                this._document.remove(this._offset, this._string.length(), true);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else if (this._type == DocumentEvent.EventType.INSERT) {
            try {
                this._document.insertString(this._offset, this._string, null, true);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        super.redo();
    }
}

