/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.AbstractListCodeEditorIntelliHints;
import com.jidesoft.editor.CodeEditor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class ListDataCodeEditorIntelliHints<T>
extends AbstractListCodeEditorIntelliHints {
    private boolean _caseSensitive = false;
    private List<T> _completionList;

    public ListDataCodeEditorIntelliHints(CodeEditor codeEditor, List<T> list) {
        super(codeEditor);
        this.setCompletionList(list);
    }

    public ListDataCodeEditorIntelliHints(CodeEditor codeEditor, T[] TArray) {
        super(codeEditor);
        this.setCompletionList(TArray);
    }

    public List<T> getCompletionList() {
        return this._completionList;
    }

    public void setCompletionList(List<T> list) {
        this._completionList = list;
    }

    public void setCompletionList(T[] TArray) {
        final Object[] objectArray = TArray;
        this._completionList = new AbstractList<T>(){

            @Override
            public T get(int n) {
                return objectArray[n];
            }

            @Override
            public int size() {
                return objectArray.length;
            }
        };
    }

    @Override
    public boolean updateHints(Object object) {
        if (object == null) {
            return false;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : this.getCompletionList()) {
            if (!this.compare(object, t)) continue;
            arrayList.add(t);
        }
        Object[] objectArray = arrayList.toArray();
        this.setListData(objectArray);
        if (objectArray.length > 0) {
            this.getList().setSelectedIndex(0);
        }
        return objectArray.length > 0;
    }

    protected boolean compare(Object object, T t) {
        boolean bl = false;
        String string = t == null ? "" : t.toString();
        String string2 = object.toString();
        int n = string2.length();
        if (n <= string.length()) {
            if (!this.isCaseSensitive()) {
                if (string2.equalsIgnoreCase(string.substring(0, n))) {
                    bl = true;
                }
            } else if (string.startsWith(string2)) {
                bl = true;
            }
        }
        if (bl) {
            if (!this.isCaseSensitive()) {
                if (string2.equalsIgnoreCase(string)) {
                    bl = false;
                }
            } else if (string2.equals(string)) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }
}

