/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.SyntaxUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.Segment;

public class KeywordMap {
    protected int mapLength;
    private Keyword[] map;
    private boolean ignoreCase;

    public KeywordMap(boolean bl) {
        this(bl, 52);
        this.setIgnoreCase(bl);
    }

    public KeywordMap(boolean bl, int n) {
        this.mapLength = n;
        this.setIgnoreCase(bl);
        this.map = new Keyword[n];
    }

    public synchronized byte lookup(Segment segment, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        Keyword keyword = this.map[this.getSegmentMapKey(segment, n, n2)];
        while (keyword != null) {
            if (n2 != keyword.keyword.length) {
                keyword = keyword.next;
                continue;
            }
            if (SyntaxUtils.regionMatches(this.ignoreCase, segment, n, keyword.keyword)) {
                return keyword.id;
            }
            keyword = keyword.next;
        }
        return 0;
    }

    public synchronized void add(String string, byte by) {
        int n = this.getStringMapKey(string);
        this.map[n] = new Keyword(string.toCharArray(), by, this.map[n]);
    }

    public synchronized byte get(String string) {
        if (string.length() == 0) {
            return 0;
        }
        Keyword keyword = this.map[this.getStringMapKey(string)];
        while (keyword != null) {
            if (string.length() != keyword.keyword.length) {
                keyword = keyword.next;
                continue;
            }
            if (KeywordMap.regionMatches(this.ignoreCase, string, keyword.keyword)) {
                return keyword.id;
            }
            keyword = keyword.next;
        }
        return 0;
    }

    private static boolean regionMatches(boolean bl, String string, char[] cArray) {
        int n = cArray.length;
        char[] cArray2 = string.toCharArray();
        if (n > string.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = cArray2[i];
            char c2 = cArray[i];
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c == c2) continue;
            return false;
        }
        return true;
    }

    public Set<String> keyWordSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Keyword keyword : this.map) {
            if (keyword == null || keyword.keyword == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            for (char c : keyword.keyword) {
                stringBuffer.append(c);
            }
            hashSet.add(stringBuffer.toString());
            while (keyword != null && keyword.next != null) {
                keyword = keyword.next;
                if (keyword == null || keyword.keyword == null) continue;
                stringBuffer = new StringBuffer();
                for (char c : keyword.keyword) {
                    stringBuffer.append(c);
                }
                hashSet.add(stringBuffer.toString());
            }
        }
        return hashSet;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    protected int getStringMapKey(String string) {
        return (Character.toUpperCase(string.charAt(0)) + Character.toUpperCase(string.charAt(string.length() - 1))) % this.mapLength;
    }

    protected int getSegmentMapKey(Segment segment, int n, int n2) {
        return (Character.toUpperCase(segment.array[n]) + Character.toUpperCase(segment.array[n + n2 - 1])) % this.mapLength;
    }

    class Keyword {
        public char[] keyword;
        public byte id;
        public Keyword next;

        public Keyword(char[] cArray, byte by, Keyword keyword) {
            this.keyword = cArray;
            this.id = by;
            this.next = keyword;
        }
    }
}

