/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorPainter;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

class InputMethodSupport
implements InputMethodRequests,
InputMethodListener {
    private CodeEditor _owner;
    private TextLayout _composedTextLayout = null;
    private int _composedCaretX = 0;
    private int _lastCommittedAt = 0;
    private String _lastCommittedText = null;

    public InputMethodSupport(CodeEditor codeEditor) {
        this._owner = codeEditor;
        codeEditor.addInputMethodListener(this);
    }

    private Rectangle getCaretRectangle(int n, int n2) {
        CodeEditorPainter codeEditorPainter = this._owner.getPainter();
        Point point = codeEditorPainter.getLocationOnScreen();
        int n3 = codeEditorPainter.getLineHeight();
        return new Rectangle(point.x + n, point.y + n2, 0, n3);
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        Point point = this._owner.getCaretLocation();
        return this.getCaretRectangle(point.x + this._composedCaretX, point.y);
    }

    @Override
    public TextHitInfo getLocationOffset(int n, int n2) {
        if (this._composedTextLayout != null) {
            Point point = this._owner.getPainter().getLocationOnScreen();
            Point point2 = this._owner.getCaretLocation();
            float f = n - point.x - point2.x;
            float f2 = (float)(n2 - point.y - point2.y) - (this._composedTextLayout.getLeading() + 1.0f) - this._composedTextLayout.getAscent();
            return this._composedTextLayout.hitTestChar(f, f2);
        }
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        return this._owner.getCaretPosition() * -1;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        String string = this._owner.getText(n, n2 - n);
        return new AttributedString(string != null ? string : "").getIterator();
    }

    @Override
    public int getCommittedTextLength() {
        return this._lastCommittedText == null ? 0 : this._lastCommittedText.length();
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        if (this._lastCommittedText != null) {
            int n = this._lastCommittedAt;
            int n2 = this._lastCommittedText.length();
            String string = this._owner.getText(n, n2);
            if (string != null && string.equals(this._lastCommittedText)) {
                AttributedCharacterIterator attributedCharacterIterator = new AttributedString(string).getIterator();
                this._owner.select(n, n);
                this._owner.setCaretPosition(n);
                this._lastCommittedText = null;
                return attributedCharacterIterator;
            }
            this._lastCommittedText = null;
        }
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        if (this._owner.getSelectedText() != null) {
            return new AttributedString(this._owner.getSelectedText()).getIterator();
        }
        return null;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        this._composedTextLayout = null;
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        if (attributedCharacterIterator != null) {
            int n;
            int n2 = inputMethodEvent.getCommittedCharacterCount();
            if (n2 > 0) {
                this._lastCommittedText = null;
                this._lastCommittedAt = this._owner.getCaretPosition();
                StringBuffer stringBuffer = new StringBuffer(n2);
                char c = attributedCharacterIterator.first();
                for (int i = n2; c != '\uffff' && i > 0; --i) {
                    stringBuffer.append(c);
                    c = attributedCharacterIterator.next();
                }
                this._lastCommittedText = stringBuffer.toString();
                this._owner.insertChar(this._lastCommittedText);
            }
            if (n2 < (n = attributedCharacterIterator.getEndIndex())) {
                AttributedString attributedString = new AttributedString(attributedCharacterIterator, n2, n);
                CodeEditorPainter codeEditorPainter = this._owner.getPainter();
                attributedString.addAttribute(TextAttribute.FONT, codeEditorPainter.getFont());
                this._composedTextLayout = new TextLayout(attributedString.getIterator(), codeEditorPainter.getFontRenderContext());
            }
        }
        this.caretPositionChanged(inputMethodEvent);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        this._composedCaretX = 0;
        if (this._composedTextLayout != null) {
            TextHitInfo textHitInfo = inputMethodEvent.getCaret();
            if (textHitInfo != null) {
                this._composedCaretX = Math.round(this._composedTextLayout.getCaretInfo(textHitInfo)[0]);
            }
            int n = this._owner.getCaretLocation().x;
            TextHitInfo textHitInfo2 = inputMethodEvent.getVisiblePosition();
            int n2 = 0;
            n2 = textHitInfo2 != null ? Math.round(this._composedTextLayout.getCaretInfo(textHitInfo2)[0]) : this._composedCaretX;
            int n3 = n + n2;
            int n4 = this._owner.getPainter().getWidth();
            int n5 = 0;
            if (n3 < 0) {
                n5 = n3;
            }
            if (n3 >= n4) {
                n5 = n3 - (n4 - 1);
            }
            if (n5 != 0) {
                this._owner.setHorizontalOffset(this._owner.getHorizontalOffset() - n5);
            }
        } else {
            this._owner.scrollToCaret();
        }
        this._owner.getPainter().setImeElement(this._composedTextLayout, this._composedCaretX);
        inputMethodEvent.consume();
    }
}

