/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.folding.DefaultFoldingModel;
import com.jidesoft.editor.folding.FoldingSpan;

class FoldingState {
    private int _previousSpanEndOffset;
    private int _spanEndOffset;
    private int _documentLength;
    private DefaultFoldingModel _foldingModel = null;
    private FoldingSpan _span = null;
    private CodeEditor _editor;

    public FoldingState(CodeEditor codeEditor, int n) {
        this._editor = codeEditor;
        this._previousSpanEndOffset = n;
        this._documentLength = codeEditor.getDocument().getLength();
        this._foldingModel = (DefaultFoldingModel)codeEditor.getFoldingModel();
        this._spanEndOffset = this._documentLength;
        this._spanEndOffset = Math.min(this._spanEndOffset, this.findNextSpanStart(this._previousSpanEndOffset));
        this._span = this._foldingModel.getOutermostSpanAtOffset(this._previousSpanEndOffset);
        if (this._span != null) {
            this._spanEndOffset = this._span.getEndOffset();
        }
    }

    public void advance() {
        this._span = null;
        this._previousSpanEndOffset = this._spanEndOffset;
        FoldingSpan foldingSpan = this._foldingModel.getOutermostSpanAtOffset(this._previousSpanEndOffset);
        if (foldingSpan != null) {
            this._spanEndOffset = foldingSpan.getEndOffset();
            this._span = foldingSpan;
        } else {
            this._spanEndOffset = this._documentLength;
            this._spanEndOffset = Math.min(this._spanEndOffset, this.findNextSpanStart(this._previousSpanEndOffset));
        }
        if (this._spanEndOffset <= this._previousSpanEndOffset && this._spanEndOffset < this._documentLength) {
            this._editor.logFoldingSpanErrorInfo("Advance error at: ", this._span);
            this._foldingModel.rebuild();
            this._spanEndOffset = this._previousSpanEndOffset + 1;
            this._span = null;
        }
    }

    private int findNextSpanStart(int n) {
        int n2 = this._documentLength;
        FoldingSpan[] foldingSpanArray = this._foldingModel.getTopLevelSpans();
        if (foldingSpanArray != null) {
            for (int i = this._foldingModel.getLastTopLevelIndexBefore(n) + 1; i >= 0 && i < foldingSpanArray.length; ++i) {
                int n3;
                FoldingSpan foldingSpan = foldingSpanArray[i];
                if (!foldingSpan.isValid() || (n3 = foldingSpan.getStartOffset()) <= n) continue;
                if (n3 >= n2) break;
                n2 = n3;
            }
        }
        return n2;
    }

    public int getStartOffset() {
        return this._previousSpanEndOffset;
    }

    public int getEndOffset() {
        return this._spanEndOffset;
    }

    public FoldingSpan getCurrentFold() {
        return this._span;
    }

    public String toString() {
        return "startOffset:" + this.getStartOffset() + "; endOffset:" + this.getEndOffset() + "; span:" + (this.getCurrentFold() == null ? null : this.getCurrentFold().getDescription());
    }
}

