/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class ColumnGuide {
    public static final int UNIT_IN_COLUMNS = 0;
    public static final int UNIT_IN_PIXELS = 1;
    public static final Color DEFAULT_COLOR = Color.LIGHT_GRAY;
    private int _location;
    private int _unit;
    private Color _color;
    private Stroke _stroke;

    public ColumnGuide(int n) {
        this(n, 0, DEFAULT_COLOR);
    }

    public ColumnGuide(int n, int n2) {
        this(n, n2, DEFAULT_COLOR);
    }

    public ColumnGuide(int n, Color color) {
        this(n, 0, color);
    }

    public ColumnGuide(int n, int n2, Color color) {
        this._location = n;
        this._unit = n2;
        this._color = color;
    }

    public int getLocation() {
        return this._location;
    }

    public void setLocation(int n) {
        this._location = n;
    }

    public int getUnit() {
        return this._unit;
    }

    public void setUnit(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid value. The unit must be either ColumnGuide.UNIT_IN_COLUMNS or ColumnGuide.UNIT_IN_PIXELS.");
        }
        this._unit = n;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public void setStroke(Stroke stroke) {
        this._stroke = stroke;
    }

    public void paint(CodeEditor codeEditor, Graphics graphics, Rectangle rectangle) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.getColor());
        if (this.getStroke() != null) {
            graphics2D.setStroke(this.getStroke());
        }
        int n2 = n = this.getUnit() == 1 ? this.getLocation() : this.getLocation() * codeEditor.getPainter().getFontMetrics().charWidth('w');
        if (n > rectangle.x && n < rectangle.x + rectangle.width) {
            graphics2D.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
        }
        graphics2D.setColor(color);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
        }
    }
}

