/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.selection.SelectionModel;
import javax.swing.text.BadLocationException;

class CodeEditorUtils {
    CodeEditorUtils() {
    }

    public static void insertStringAtCaret(CodeEditor codeEditor, String string) {
        CodeEditorUtils.insertStringAtCaret(codeEditor, string, false, true);
    }

    public static int insertStringAtCaret(CodeEditor codeEditor, String string, boolean bl, boolean bl2) {
        int n;
        SelectionModel selectionModel = codeEditor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            codeEditor.getCaretModel().setOffset(codeEditor.getSelectionStart());
        }
        int n2 = codeEditor.getCaretModel().getOffset();
        int n3 = CodeEditorUtils.calcAfterLineEnd(codeEditor);
        String string2 = CodeEditorUtils.calcStringToFillVirtualSpace(codeEditor);
        if (string2.length() > 0) {
            string = string2 + string;
        }
        int n4 = 0;
        if (!codeEditor.isOverwriteEnabled() || !bl) {
            if (selectionModel.hasSelection()) {
                CodeEditorUtils.deleteSelectedText(codeEditor);
            }
            try {
                n = codeEditor.getDocumentLength();
                codeEditor.getDocument().insertString(n2, string, null);
                int n5 = codeEditor.getDocumentLength();
                n4 = n5 - n;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            boolean bl3 = selectionModel.hasSelection();
            if (bl3) {
                CodeEditorUtils.deleteSelectedText(codeEditor);
            }
            SyntaxDocument syntaxDocument = codeEditor.getDocument();
            int n6 = codeEditor.getCaretModel().getModelPosition().line;
            if (n6 >= codeEditor.getLineCount()) {
                return CodeEditorUtils.insertStringAtCaret(codeEditor, string, false, bl2);
            }
            try {
                if (n3 != 0 && !bl3) {
                    syntaxDocument.remove(n2, 1);
                }
                int n7 = codeEditor.getDocumentLength();
                syntaxDocument.insertString(n2, string, null);
                int n8 = codeEditor.getDocumentLength();
                n4 = n8 - n7;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        n = n2 + n4;
        if (bl2) {
            codeEditor.getCaretModel().setOffset(n);
            codeEditor.scrollToCaret();
            selectionModel.clearSelection();
        }
        return n;
    }

    public static void deleteSelectedText(CodeEditor codeEditor) {
        SelectionModel selectionModel = codeEditor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            int n = codeEditor.getSelectionStart();
            int n2 = codeEditor.getSelectionEnd();
            int n3 = codeEditor.getCaretModel().getOffset();
            if (n > n3 || n2 < n3) {
                codeEditor.getSelectionModel().clearSelection();
                return;
            }
            codeEditor.getCaretModel().setOffset(n);
            selectionModel.clearSelection();
            try {
                if (n2 == codeEditor.getDocument().getEndPosition().getOffset()) {
                    --n2;
                }
                codeEditor.getDocument().remove(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            codeEditor.scrollToCaret();
        }
    }

    private static int calcAfterLineEnd(CodeEditor codeEditor) {
        int n = codeEditor.getCaretModel().getModelPosition().column;
        int n2 = codeEditor.getCaretModel().getModelPosition().line;
        if (n2 >= codeEditor.getLineCount()) {
            return n;
        }
        int n3 = codeEditor.getLineEndOffsetExcludeLineBreak(n2);
        return n - n3;
    }

    private static String calcStringToFillVirtualSpace(CodeEditor codeEditor) {
        int n = CodeEditorUtils.calcAfterLineEnd(codeEditor);
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(' ');
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static int getLastColumnAtVisualLine(CodeEditor codeEditor, int n) {
        CaretPosition caretPosition = new CaretPosition(n, 0);
        CaretPosition caretPosition2 = codeEditor.viewToModelPosition(caretPosition);
        int n2 = caretPosition2.line;
        while (n2 < codeEditor.getLineCount() - 1) {
            caretPosition2 = new CaretPosition(caretPosition2.line + 1, caretPosition2.column);
            CaretPosition caretPosition3 = codeEditor.modelToViewPosition(caretPosition2);
            if (caretPosition3.line != caretPosition.line) break;
            n2 = caretPosition2.line;
        }
        int n3 = codeEditor.getLineCount() - 1;
        if (n3 < 0) {
            return 0;
        }
        return codeEditor.offsetToViewPosition((int)codeEditor.getLineEndOffset((int)Math.min((int)n2, (int)n3))).column;
    }

    public static int getSpanDescriptionLength(FoldingSpan foldingSpan) {
        return foldingSpan == null || foldingSpan.getDescription() == null ? 0 : foldingSpan.getDescription().length();
    }
}

