/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorUtils;
import com.jidesoft.editor.ColumnGuide;
import com.jidesoft.editor.FoldingState;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.SyntaxStyle;
import com.jidesoft.editor.SyntaxUtils;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.highlight.LayeredHighlighter;
import com.jidesoft.editor.tokenmarker.Token;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import com.jidesoft.marker.Marker;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.HtmlUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;

public class CodeEditorPainter
extends JComponent
implements TabExpander {
    protected int currentLineIndex;
    protected Token currentLineTokens;
    protected Segment currentLine;
    protected CodeEditor _editor;
    protected FontMetrics _fm;
    private int _tabWidth;
    public TextLayout _composedTextLayout = null;
    public int _composedCaretX = 0;
    private transient FontRenderContext fontRenderContext;

    public CodeEditorPainter(CodeEditor codeEditor) {
        this._editor = codeEditor;
        this.setAutoscrolls(true);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.currentLine = new Segment();
        this.currentLineIndex = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.fontRenderContext = new FontRenderContext(null, false, false);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (CodeEditorPainter.this._editor.getDocument() == null) {
                    return;
                }
                int n = CodeEditorPainter.this._editor.getVisualLineCount();
                int n2 = CodeEditorPainter.this._editor.yToLine(CodeEditorPainter.this.getHeight());
                if (n2 > n) {
                    int n3 = CodeEditorPainter.this._editor.getFirstLine() - (n2 - n);
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    CodeEditorPainter.this._editor.setFirstLine(n3);
                }
            }
        });
    }

    @Override
    public final boolean isManagingFocus() {
        return false;
    }

    public FontMetrics getFontMetrics() {
        return this._fm;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._fm = this.getFontMetrics(this.getFont());
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this._editor.isShowToolTipOverMarkedText()) {
            return super.getToolTipText(mouseEvent);
        }
        int n = this._editor.xyToOffset(mouseEvent.getX(), mouseEvent.getY());
        List<Marker> list = this._editor.getMarkerModel().getMarkersAt(n, n);
        if (list != null && list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("<html>");
            for (int i = 0; i < list.size(); ++i) {
                Marker marker = list.get(i);
                String string = marker.getToolTipText();
                stringBuffer.append(HtmlUtils.formatHtmlSubString(string));
                if (i == list.size() - 1) continue;
                stringBuffer.append("<br>");
            }
            stringBuffer.append("</html>");
            if (stringBuffer.length() <= "<html>".length() + "</html>".length()) {
                return null;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public void paint(final Graphics graphics) {
        JideSwingUtilities.withFractionalAntiAliasing(graphics, new Runnable(){

            @Override
            public void run() {
                CodeEditorPainter.this._paint(graphics);
            }
        });
    }

    protected void _paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Highlighter highlighter;
        Highlighter highlighter2;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        JideSwingUtilities.setupAntialiasing(this, graphics2D);
        this.fontRenderContext = graphics2D.getFontRenderContext();
        this.updateTabWidth();
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(this._editor.isEnabled() ? this.getBackground() : UIDefaultsLookup.getColor("TextField.inactiveBackground"));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!this._editor.isContentVisible() || this._editor.getDocument() == null) {
            return;
        }
        if (!this._editor.isEnabled()) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        if ((highlighter2 = this._editor.getHighlighter()) != null) {
            highlighter2.paint(graphics2D);
        }
        if ((highlighter = this._editor.getFixedHighlighter()) != null) {
            highlighter.paint(graphics2D);
        }
        int n6 = this.getLineHeight();
        int n7 = this._editor.getFirstLine();
        int n8 = n7 + rectangle.y / n6;
        int n9 = n7 + (rectangle.y + rectangle.height - 1) / n6;
        int n10 = this._editor.viewToModelLine(n7 - 1);
        int n11 = this._editor.viewToModelLine(Math.min(n9 + 1, this._editor.getLineCount()));
        if (!this._editor.getDocument().isLineLoaded(Math.max(0, n10)) || !this._editor.getDocument().isLineLoaded(Math.max(0, Math.min(n11, this._editor.getLineCount() - 1)))) {
            ((LazyLoadDocument)this._editor.getDocument()).startLoadPage(Math.max(0, n10), Math.max(0, Math.min(n11, this._editor.getLineCount() - 1)));
            return;
        }
        int n12 = this._editor.getSelectionModel().hasSelection() ? Math.max(this._editor.getSelectionStart(), this._editor.getLineStartOffset(n10 + 1) - 1) : (n5 = this._editor.getCaretModel().getModelPosition().line >= n10 && this._editor.getCaretModel().getModelPosition().line <= n11 ? this._editor.getSelectionStart() : -1);
        int n13 = this._editor.getSelectionModel().hasSelection() ? Math.min(this._editor.getSelectionEnd(), this._editor.getLineEndOffset(n11 - 1) + 1) : (this._editor.getCaretModel().getModelPosition().line >= n10 && this._editor.getCaretModel().getModelPosition().line <= n11 ? this._editor.getSelectionEnd() : -1);
        CaretPosition caretPosition = !this._editor.isEnabled() || n5 < 0 ? new CaretPosition(0, 0) : this._editor.offsetToViewPosition(n5);
        CaretPosition caretPosition2 = !this._editor.isEnabled() || n13 < 0 ? new CaretPosition(0, 0) : this._editor.offsetToViewPosition(n13);
        try {
            int n14;
            TokenMarker tokenMarker = this._editor.getDocument().getTokenMarker();
            n4 = this._editor.getHorizontalOffset();
            n3 = this._editor.getLineStartOffset(this._editor.viewToModelLine(n8));
            FoldingState foldingState = new FoldingState(this._editor, n3);
            n2 = 0;
            if (n11 - 1 < this._editor.getLineCount()) {
                n2 = tokenMarker != null ? tokenMarker.getLastToken(n11 - 1) : 0;
            }
            for (n = n8; n <= n9; ++n) {
                n14 = this._editor.viewToModelLine(n);
                int n15 = this._editor.lineToY(n);
                this.paintLine(graphics2D, tokenMarker, n14, n, caretPosition, caretPosition2, n4, n15, foldingState);
            }
            n = 0;
            if (n11 - 1 < this._editor.getLineCount()) {
                int n16 = n = tokenMarker != null ? (int)tokenMarker.getLastToken(n11 - 1) : 0;
            }
            if (n2 != n && this._editor.getTokenMarker().supportsMultilineTokens() && (n2 == 1 || n2 == 3 || n == 1 || n == 3)) {
                this._editor.getDocument().tokenizeLines(n11, this._editor.getLineCount() - n11, true, n == 1 || n == 3);
            }
            if (this._editor.isEnabled()) {
                this.paintCaret(graphics2D, this._editor.getCaretModel().getViewPosition().line);
            }
            if (tokenMarker != null && tokenMarker.isNextLineRequested()) {
                n14 = rectangle.y + rectangle.height;
                this.repaint(0, n14, this.getWidth(), this.getHeight() - n14);
            }
        }
        catch (Exception exception) {
            System.err.println("Error repainting line range {" + n8 + "," + n9 + "}:");
            exception.printStackTrace();
        }
        if (this._composedTextLayout != null) {
            int n17 = this._editor.getLineNumber(this._editor.getSelectionEnd()) - this._editor.getLineNumber(this._editor.getSelectionStart());
            n4 = 1;
            n3 = this._editor.getCaretModel().getModelPosition().line;
            int n18 = this._editor.getLineStartOffset(n3);
            n2 = this._editor.getLineEndOffset(n3);
            n = this._editor.lineToY(n3);
            this.paintImeInput(graphics2D, n17, n4, n18, n2, n);
        }
        this.paintColumnGuides(graphics2D, rectangle);
        graphics2D.dispose();
    }

    public void updateTabWidth() {
        this._tabWidth = this._fm.charWidth(' ') * this._editor.getTabSize();
    }

    FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    void setImeElement(TextLayout textLayout, int n) {
        this._composedTextLayout = textLayout;
        this._composedCaretX = n;
    }

    protected void paintImeInput(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (this._composedTextLayout != null && n3 <= (n6 = this._editor.getCaretPosition()) && n6 <= n4) {
            FontMetrics fontMetrics = this.getFontMetrics();
            int n7 = this._editor.getCaretLocation().x;
            int n8 = Math.round(this._composedTextLayout.getAdvance());
            int n9 = this.getLineHeight();
            int n10 = n7 + this._composedCaretX;
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(n7, n5, n8, n9 + 1);
            graphics2D.setColor(this.getForeground());
            this._composedTextLayout.draw(graphics2D, n7, n5 + n9 - 1);
            graphics2D.setColor(this._editor.getCaretColor());
            graphics2D.drawLine(n10, n5, n10, n5 + n9 + 1);
        }
    }

    public final void invalidateLine(int n) {
        this.repaint(0, this._editor.lineToY(n) + this._fm.getMaxDescent() + this._fm.getLeading(), this.getWidth(), this.getLineHeight());
    }

    public final void invalidateRange(int n, int n2) {
        int n3 = this._editor.offsetToViewPosition((int)n).line;
        int n4 = this._editor.offsetToViewPosition((int)n2).line;
        this.invalidateLineRange(n3, n4);
    }

    public final void invalidateLineRange(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        this.repaint(0, this._editor.lineToY(n) + this._fm.getMaxDescent() + this._fm.getLeading(), this.getWidth(), (n2 - n + 1) * this.getLineHeight());
    }

    public final void invalidateSelectedLines() {
        this.invalidateRange(this._editor.getSelectionStart(), this._editor.getSelectionEnd());
    }

    @Override
    public float nextTabStop(float f, int n) {
        if (this._tabWidth <= 0) {
            this._tabWidth = 1;
        }
        int n2 = this._editor.getHorizontalOffset();
        int n3 = ((int)f - n2) / this._tabWidth;
        return (n3 + 1) * this._tabWidth + n2;
    }

    public int nextTabStop(int n) {
        if (this._tabWidth <= 0) {
            this._tabWidth = 1;
        }
        this._tabWidth *= this._fm.charWidth(' ');
        int n2 = n / this._tabWidth;
        return (n2 + 1) * this._tabWidth;
    }

    @Override
    public Font getFont() {
        return this._editor.getFont();
    }

    protected void paintLine(Graphics graphics, TokenMarker tokenMarker, int n, int n2, CaretPosition caretPosition, CaretPosition caretPosition2, int n3, int n4, FoldingState foldingState) {
        int n5 = n3;
        Font font = this.getFont();
        Color color = this.getForeground();
        this.currentLineIndex = n;
        int n6 = this._editor.getLineStartOffset(n);
        int n7 = this._editor.getLineEndOffset(n);
        if (n < 0 || n >= this._editor.getLineCount()) {
            if (this._editor.isPaintInvalid()) {
                this.paintHighlight(graphics, n, n2, caretPosition, caretPosition2, n4);
                this.paintMarker(graphics, n, n4);
                this._editor.getStyles().getStyle(10).setGraphicsFlags(graphics, font);
                graphics.drawString("~", 0, n4 + this.getLineHeight());
            }
        } else if (tokenMarker == null) {
            this.paintPlainLine(graphics, n, n2, caretPosition, caretPosition2, font, color, n5, n4);
        } else {
            if (n7 >= foldingState.getEndOffset() && n6 > foldingState.getStartOffset()) {
                while (n7 >= foldingState.getEndOffset() && (foldingState.getCurrentFold() == null || n6 >= foldingState.getEndOffset()) && foldingState.getEndOffset() < this._editor.getDocumentLength()) {
                    foldingState.advance();
                }
            } else if (n7 >= foldingState.getEndOffset() && n6 == foldingState.getStartOffset() && foldingState.getCurrentFold() == null) {
                foldingState.advance();
            }
            if (foldingState.getCurrentFold() == null) {
                this.paintSyntaxLine(graphics, tokenMarker, n, n2, 0, -1, caretPosition, caretPosition2, font, color, n5, n4, true);
            } else if (foldingState.getStartOffset() >= n6 && foldingState.getEndOffset() >= n7) {
                n5 = this.paintSyntaxLine(graphics, tokenMarker, n, n2, 0, foldingState.getStartOffset() - n6, caretPosition, caretPosition2, font, color, n5, n4, true);
                n5 = !this.isSpanSelected(foldingState.getCurrentFold(), n2, foldingState.getStartOffset() - n6, caretPosition, caretPosition2) ? this.paintFoldedText(graphics, font, foldingState.getCurrentFold().getDescription(), n5, n4, this._fm) : this.paintSelectedFoldedText(graphics, font, foldingState.getCurrentFold().getDescription(), n5, n4, this._fm);
                int n8 = this._editor.getLineNumber(foldingState.getEndOffset() + 1);
                int n9 = this._editor.modelToViewLine(n8);
                if (n9 == n2) {
                    this.currentLineIndex = n8;
                    this.paintSyntaxLine(graphics, tokenMarker, n8, n9, foldingState.getEndOffset() - this._editor.getLineStartOffset(n8), -1, caretPosition, caretPosition2, font, color, n5, n4, false);
                }
            } else if (foldingState.getStartOffset() >= n6 && foldingState.getEndOffset() < n7) {
                n5 = this.paintSyntaxLine(graphics, tokenMarker, n, n2, 0, foldingState.getStartOffset() - n6, caretPosition, caretPosition2, font, color, n5, n4, true);
                n5 = !this.isSpanSelected(foldingState.getCurrentFold(), n2, foldingState.getStartOffset() - n6, caretPosition, caretPosition2) ? this.paintFoldedText(graphics, font, foldingState.getCurrentFold().getDescription(), n5, n4, this._fm) : this.paintSelectedFoldedText(graphics, font, foldingState.getCurrentFold().getDescription(), n5, n4, this._fm);
                this.paintSyntaxLine(graphics, tokenMarker, n, n2, foldingState.getEndOffset() - n6, -1, caretPosition, caretPosition2, font, color, n5, n4, false);
            } else if (foldingState.getStartOffset() < n6 && foldingState.getEndOffset() >= n7) {
                System.out.println("not reached 1");
            } else if (foldingState.getStartOffset() < n6 && foldingState.getEndOffset() < n7) {
                this.paintSyntaxLine(graphics, tokenMarker, n, n2, foldingState.getEndOffset() - n6, -1, caretPosition, caretPosition2, font, color, n5, n4, true);
            } else {
                System.out.println("not reached 2");
            }
        }
        if (this._editor.isBracketHighlightVisible() && n == this._editor.getBracketLine()) {
            this.paintBracketHighlight(graphics, n, n4);
        }
    }

    protected boolean isSpanSelected(FoldingSpan foldingSpan, int n, int n2, CaretPosition caretPosition, CaretPosition caretPosition2) {
        boolean bl = true;
        if (caretPosition.line > n || caretPosition2.line < n) {
            bl = false;
        } else if (caretPosition.line == n && caretPosition.column >= n2) {
            bl = false;
        } else if (caretPosition2.line == n && caretPosition2.column < n2 + CodeEditorUtils.getSpanDescriptionLength(foldingSpan)) {
            bl = false;
        }
        return bl;
    }

    private void paintMarker(Graphics graphics, int n, int n2) {
        int n3 = this._editor.getLineStartOffset(n);
        List<Marker> list = this._editor.getMarkerModel().getMarkersAt(n3, this._editor.getLineEndOffset(n));
        if (list != null && list.size() > 0) {
            for (Marker marker : list) {
                SyntaxStyle syntaxStyle;
                if (!marker.isEnabled()) continue;
                int n4 = this._editor.offsetToX(marker.getStartOffset());
                if (this._editor.getLineNumber(marker.getStartOffset()) < n) {
                    n4 = this._editor.offsetToX(this._editor.getLineStartOffset(n));
                }
                int n5 = this._editor.offsetToX(Math.min(this._editor.getDocumentLength(), marker.getEndOffset() + 1));
                if (this._editor.getLineNumber(Math.min(this._editor.getDocumentLength(), marker.getEndOffset() + 1)) > n) {
                    n5 = this._editor.offsetToX(this._editor.getLineStartOffset(n) + this._editor.getLineEndOffsetExcludeLineBreak(n));
                }
                if (marker.getType() == 0) {
                    this._editor.getStyles().getStyle(11).paintMarker(graphics, n4, n5, n2, this._fm);
                    continue;
                }
                if (marker.getType() == 1) {
                    this._editor.getStyles().getStyle(12).paintMarker(graphics, n4, n5, n2, this._fm);
                    continue;
                }
                if (marker.getType() < 128 || (syntaxStyle = this._editor.getStyles().getStyle(marker.getType())) == null) continue;
                syntaxStyle.paintMarker(graphics, n4, n5, n2, this._fm);
            }
        }
    }

    protected void paintPlainLine(Graphics graphics, int n, int n2, CaretPosition caretPosition, CaretPosition caretPosition2, Font font, Color color, int n3, int n4) {
        this.paintHighlight(graphics, n, n2, caretPosition, caretPosition2, n4);
        this.paintMarker(graphics, n, n4);
        if (!this._editor.getLineText(n, this.currentLine)) {
            return;
        }
        graphics.setFont(font);
        graphics.setColor(color);
        n4 += this.getLineHeight();
        if (this.currentLine.count != 0) {
            this.paintPlainLine(graphics, n3, n4);
        }
    }

    protected int paintPlainLine(Graphics graphics, int n, int n2) {
        return SyntaxUtils.drawTabbedText(this._editor, this.currentLine, n, n2, graphics, this, 0);
    }

    protected int paintSyntaxLine(Graphics graphics, TokenMarker tokenMarker, int n, int n2, int n3, int n4, CaretPosition caretPosition, CaretPosition caretPosition2, Font font, Color color, int n5, int n6, boolean bl) {
        if (!this._editor.getLineText(this.currentLineIndex, this.currentLine)) {
            return n5;
        }
        if (bl) {
            this.paintHighlight(graphics, n, n2, caretPosition, caretPosition2, n6);
            this.paintMarker(graphics, n, n6);
        }
        this.currentLineTokens = tokenMarker.markTokens(this.currentLine, this.currentLineIndex);
        graphics.setFont(font);
        graphics.setColor(color);
        n6 += this.getLineHeight();
        if (this.currentLine.count != 0) {
            n5 = this.paintSyntaxLine(graphics, n, n3, n4, n5, n6);
        }
        return n5;
    }

    protected int paintSyntaxLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        return SyntaxUtils.paintSyntaxLine(this._editor, this.currentLine, n2, n3, this.currentLineTokens, this._editor.getStyles(), this, graphics, n4, n5, this._editor.getLineStartOffset(n) - this.currentLine.offset);
    }

    protected void paintHighlight(final Graphics graphics, final int n, final int n2, final CaretPosition caretPosition, final CaretPosition caretPosition2, final int n3) {
        JideSwingUtilities.withoutFractionalAntiAliasing(graphics, new Runnable(){

            @Override
            public void run() {
                CodeEditorPainter.this._paintHighlight(graphics, n, n2, caretPosition, caretPosition2, n3);
            }
        });
    }

    private void _paintHighlight(Graphics graphics, int n, int n2, CaretPosition caretPosition, CaretPosition caretPosition2, int n3) {
        Highlighter highlighter;
        LayeredHighlighter layeredHighlighter;
        Highlighter highlighter2;
        int n4 = caretPosition.line;
        int n5 = caretPosition2.line;
        if (n2 >= Math.min(n4, n5) && n2 <= Math.max(n4, n5)) {
            this.paintLineHighlight(graphics, n, n2, caretPosition, caretPosition2, n3);
        }
        LayeredHighlighter layeredHighlighter2 = (highlighter2 = this._editor.getHighlighter()) instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter2 : null;
        int n6 = this._editor.getLineStartOffset(n);
        int n7 = this._editor.getLineEndOffset(n);
        if (layeredHighlighter2 != null) {
            layeredHighlighter2.paintLayeredHighlights(graphics, n6, n7, new Rectangle(0, n3, this._fm.charWidth('w') * (n7 - n6), this._editor.getLineHeight()), this._editor);
        }
        LayeredHighlighter layeredHighlighter3 = layeredHighlighter = (highlighter = this._editor.getFixedHighlighter()) instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
        if (layeredHighlighter != null) {
            layeredHighlighter.paintLayeredHighlights(graphics, n6, n7, new Rectangle(0, n3, this._fm.charWidth('w') * (n7 - n6), this._editor.getLineHeight()), this._editor);
        }
    }

    protected void paintLineHighlight(Graphics graphics, int n, int n2, CaretPosition caretPosition, CaretPosition caretPosition2, int n3) {
        Color color = graphics.getColor();
        int n4 = this.getLineHeight();
        n3 += this._fm.getLeading() + this._fm.getMaxDescent();
        if (caretPosition.equals(caretPosition2)) {
            if (this._editor.isLineHighlightVisible()) {
                graphics.setColor(this._editor.getLineHighlightColor());
                graphics.fillRect(0, n3, this.getWidth(), n4);
            }
        } else {
            this.paintLineSelection(graphics, n2, caretPosition, caretPosition2, n3 - this._fm.getLeading() - this._fm.getMaxDescent());
        }
        graphics.setColor(color);
    }

    protected void paintLineSelection(Graphics graphics, int n, CaretPosition caretPosition, CaretPosition caretPosition2, int n2) {
        int n3;
        int n4;
        int n5 = caretPosition.line;
        int n6 = caretPosition2.line;
        if (n < Math.min(n5, n6) || n > Math.max(n5, n6)) {
            return;
        }
        if (caretPosition.equals(caretPosition2)) {
            return;
        }
        Color color = graphics.getColor();
        int n7 = this.getLineHeight();
        n2 += this._fm.getLeading() + this._fm.getMaxDescent();
        graphics.setColor(this._editor.getSelectionColor());
        if (this._editor.isSelectionRectangular()) {
            if (this._editor.getSelectionModel().getSelectionStartViewPosition() == null || this._editor.getSelectionModel().getSelectionEndViewPosition() == null) {
                int n8 = this._editor.getSelectionModel().getSelectionStart();
                int n9 = this._editor.getSelectionModel().getSelectionEnd();
                caretPosition = !this._editor.isEnabled() || n8 < 0 ? new CaretPosition(0, 0) : this._editor.offsetToViewPosition(n8);
                caretPosition2 = !this._editor.isEnabled() || n9 < 0 ? new CaretPosition(0, 0) : this._editor.offsetToViewPosition(n9);
                n4 = this._editor.columnToX(caretPosition.line, caretPosition.column);
                n3 = this._editor.columnToX(caretPosition2.line, this._editor.getCaretModel().getViewPosition().column);
            } else {
                caretPosition = this._editor.getSelectionModel().getSelectionStartViewPosition();
                caretPosition2 = this._editor.getSelectionModel().getSelectionEndViewPosition();
                n4 = this._editor.columnToX(caretPosition.line, caretPosition.column);
                n3 = this._editor.columnToX(caretPosition2.line, caretPosition2.column);
            }
            if (n4 == n3) {
                ++n3;
            }
        } else if (caretPosition.line == caretPosition2.line) {
            n4 = this._editor.columnToX(caretPosition.line, caretPosition.column);
            n3 = this._editor.columnToX(caretPosition2.line, caretPosition2.column);
        } else if (n == (caretPosition.line < caretPosition2.line ? caretPosition.line : caretPosition2.line)) {
            CaretPosition caretPosition3 = caretPosition.line < caretPosition2.line ? caretPosition : caretPosition2;
            n4 = this._editor.columnToX(caretPosition3.line, caretPosition3.column);
            n3 = this.getWidth();
        } else if (n == (caretPosition.line < caretPosition2.line ? caretPosition2.line : caretPosition.line)) {
            n4 = 0;
            CaretPosition caretPosition4 = caretPosition.line < caretPosition2.line ? caretPosition2 : caretPosition;
            n3 = this._editor.columnToX(caretPosition4.line, caretPosition4.column);
        } else {
            n4 = 0;
            n3 = this.getWidth();
        }
        graphics.fillRect(n4 > n3 ? n3 : n4, n2, n4 > n3 ? n4 - n3 : n3 - n4, n7);
        graphics.setColor(color);
    }

    protected void paintBracketHighlight(Graphics graphics, int n, int n2) {
        int n3 = this._editor.getBracketPosition();
        if (n3 == -1) {
            return;
        }
        n2 += this._fm.getLeading() + this._fm.getMaxDescent();
        int n4 = this._editor._offsetToX(n, n3);
        graphics.setColor(this._editor.getBracketHighlightColor());
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        graphics.fillRect(n4, n2, this._fm.charWidth('('), this.getLineHeight() - 1);
        graphics2D.setComposite(composite);
    }

    protected void paintCaret(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (JideSwingUtilities.isIntegerScaleFactor(graphics2D)) {
            this.paintIntegerCaret(graphics, n);
        } else {
            this.paintFractionalCaret(graphics, n);
        }
    }

    private void paintFractionalCaret(Graphics graphics, int n) {
        if (this._editor.isCaretVisible() && n >= this._editor.getFirstLine() && n <= this._editor.getFirstLine() + this._editor.getVisibleLines()) {
            CaretPosition caretPosition = this._editor.getCaretModel().getViewPosition();
            int n2 = caretPosition.column;
            int n3 = this.columnToX(n, n2);
            int n4 = this._editor.isBlockCaret() || this._editor.isOverwriteEnabled() ? this._fm.charWidth('w') : 1;
            int n5 = this.getCaretStartY(n);
            int n6 = this.getCaretHeight();
            graphics.setColor(this._editor.getCaretColor());
            if (this._editor.isOverwriteEnabled()) {
                graphics.setXORMode(this._editor.getLineHighlightColor());
                graphics.fillRect(n3, n5, n4, n6 - 1);
                graphics.setPaintMode();
            } else {
                graphics.drawLine(n3, n5, n3, n5 + n6 - 1);
            }
        }
    }

    private void paintIntegerCaret(Graphics graphics, int n) {
        if (this._editor.isCaretVisible() && n >= this._editor.getFirstLine() && n <= this._editor.getFirstLine() + this._editor.getVisibleLines()) {
            CaretPosition caretPosition = this._editor.getCaretModel().getViewPosition();
            int n2 = caretPosition.column;
            int n3 = this._editor.columnToX(n, n2);
            int n4 = this._editor.isBlockCaret() || this._editor.isOverwriteEnabled() ? this._fm.charWidth('w') : 1;
            int n5 = this.getCaretStartY(n);
            int n6 = this.getCaretHeight();
            graphics.setColor(this._editor.getCaretColor());
            if (this._editor.isOverwriteEnabled()) {
                graphics.setXORMode(this._editor.getLineHighlightColor());
                graphics.fillRect(n3, n5, n4, n6 - 1);
                graphics.setPaintMode();
            } else {
                graphics.drawRect(n3, n5, n4, n6 - 1);
            }
        }
    }

    public Token getCurrentLineTokens() {
        return this.currentLineTokens;
    }

    public int getCurrentLineIndex() {
        return this.currentLineIndex;
    }

    public int columnToX(int n, int n2) {
        int n3;
        CaretPosition caretPosition = new CaretPosition(n, n2);
        CaretPosition caretPosition2 = this._editor.viewToModelPosition(caretPosition);
        int n4 = caretPosition2.line;
        int n5 = this.getLineEndOffsetExcludeLineBreak(n4);
        int n6 = this._editor.offsetToX(this._editor.modelPositionToOffset(caretPosition2));
        FontMetrics fontMetrics = this.getFontMetrics();
        if (caretPosition2.column > n5) {
            n6 += (caretPosition2.column - n5) * fontMetrics.charWidth(' ');
        }
        if ((n3 = n2 - this._editor.modelToViewPosition((CaretPosition)caretPosition2).column) > 0) {
            n6 += n3 * fontMetrics.charWidth(' ');
        }
        return n6;
    }

    private int getLineEndOffsetExcludeLineBreak(int n) {
        char c;
        int n2;
        String string = this._editor.getLineText(n);
        for (n2 = string.length(); n2 > 0 && ((c = string.charAt(n2 - 1)) == '\r' || c == '\n'); --n2) {
        }
        return n2;
    }

    public void setCurrentLineIndex(int n) {
        this.currentLineIndex = n;
    }

    public void setCurrentLineTokens(Token token) {
        this.currentLineTokens = token;
    }

    protected int getCaretStartY(int n) {
        int n2 = this._editor.lineToY(n);
        return n2 += this._fm.getLeading() + this._fm.getMaxDescent();
    }

    protected int getCaretHeight() {
        return this.getLineHeight();
    }

    public int getLineHeight() {
        return this._fm.getHeight();
    }

    public CodeEditor getCodeEditor() {
        return this._editor;
    }

    private int paintSelectedFoldedText(Graphics graphics, Font font, String string, int n, int n2, FontMetrics fontMetrics) {
        if (string == null) {
            return n;
        }
        SyntaxStyle syntaxStyle = this._editor.getStyles().getStyle(13);
        int n3 = fontMetrics.stringWidth(string);
        Color color = graphics.getColor();
        Font font2 = graphics.getFont();
        graphics.setFont(font);
        graphics.setColor(syntaxStyle.getForeground());
        graphics.drawString(string, n, n2 + this.getLineHeight());
        graphics.setColor(color);
        graphics.setFont(font2);
        return n + n3;
    }

    public int paintFoldedText(Graphics graphics, Font font, String string, int n, int n2, FontMetrics fontMetrics) {
        if (string == null) {
            return n;
        }
        SyntaxStyle syntaxStyle = this._editor.getStyles().getStyle(13);
        syntaxStyle.paintMarker(graphics, n, n + fontMetrics.stringWidth(string), n2, fontMetrics);
        int n3 = fontMetrics.stringWidth(string);
        Color color = graphics.getColor();
        Font font2 = graphics.getFont();
        graphics.setFont(font);
        graphics.setColor(syntaxStyle.getForeground());
        graphics.drawString(string, n, n2 + this.getLineHeight());
        graphics.setColor(color);
        graphics.setFont(font2);
        return n + n3;
    }

    public void paintColumnGuides(Graphics graphics, Rectangle rectangle) {
        List<ColumnGuide> list = this.getCodeEditor().internalGetColumnGuides();
        for (ColumnGuide columnGuide : list) {
            columnGuide.paint(this.getCodeEditor(), graphics, rectangle);
        }
    }
}

