/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorTransferHandler;
import java.awt.Point;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import javax.swing.SwingUtilities;

class CodeEditorDropTargetListener
extends DropTargetAdapter {
    private final CodeEditor _codeEditor;

    public CodeEditorDropTargetListener(CodeEditor codeEditor) {
        this._codeEditor = codeEditor;
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!(this._codeEditor.getTransferHandler() instanceof CodeEditorTransferHandler) || !((CodeEditorTransferHandler)this._codeEditor.getTransferHandler()).canImport()) {
            return;
        }
        if (!this._codeEditor.hasFocus()) {
            this._codeEditor.requestFocus(true);
        }
        Point point = SwingUtilities.convertPoint(this._codeEditor, dropTargetDragEvent.getLocation(), this._codeEditor.getPainter());
        int n = this._codeEditor.xyToOffset(point.x, point.y);
        this._codeEditor.getCaretModel().setOffset(n);
    }
}

