/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.document.DocumentComponent;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorDocumentComponent;
import com.jidesoft.editor.CodeEditorDocumentPane;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResultIntepreter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class CodeEditorDocumentPaneFindAndReplaceTarget
implements FindAndReplaceTarget,
DocumentListener {
    private CodeEditor _current;
    private String _currentName;
    private CodeEditorDocumentPane _documentPane;
    private boolean _replaceAllInProgress = false;
    private boolean _targetChanged = false;
    private DocumentListener[] _listeners;

    public CodeEditorDocumentPaneFindAndReplaceTarget(CodeEditorDocumentPane codeEditorDocumentPane) {
        this._documentPane = codeEditorDocumentPane;
        this.next();
    }

    @Override
    public FindResultIntepreter getIntepreter() {
        return this._current;
    }

    public CodeEditor getCodeEditor() {
        return this._current;
    }

    @Override
    public JComponent getConfigurationPanel() {
        return new JLabel(this.getResourceString("FindAndReplace.allOpenFiles"));
    }

    @Override
    public boolean hasNext() {
        String string = this._documentPane.getNextDocument(this._currentName);
        return string != null && this._documentPane.getDocument(string) instanceof CodeEditorDocumentComponent;
    }

    @Override
    public void next() {
        DocumentComponent documentComponent;
        String string;
        if (this._current != null && this._replaceAllInProgress) {
            this._current.getDocument().endCompoundEdit();
        }
        if ((string = this._documentPane.getNextDocument(this._currentName)) != null && (documentComponent = this._documentPane.getDocument(string)) instanceof CodeEditorDocumentComponent) {
            this.changeCurrentEditor(((CodeEditorDocumentComponent)documentComponent).getCodeEditor(), string);
            return;
        }
        this.changeCurrentEditor(null, null);
    }

    @Override
    public boolean hasPrevious() {
        String string = this._documentPane.getPreviousDocument(this._currentName);
        return string != null && this._documentPane.getDocument(string) instanceof CodeEditorDocumentComponent;
    }

    @Override
    public void previous() {
        DocumentComponent documentComponent;
        String string = this._documentPane.getPreviousDocument(this._currentName);
        if (string != null && (documentComponent = this._documentPane.getDocument(string)) instanceof CodeEditorDocumentComponent) {
            this.changeCurrentEditor(((CodeEditorDocumentComponent)documentComponent).getCodeEditor(), string);
            return;
        }
        this.changeCurrentEditor(null, null);
    }

    @Override
    public int getCurrentPosition(boolean bl) {
        if (this.getCodeEditor().getSelectionModel().hasSelection()) {
            return bl ? this.getCodeEditor().getSelectionEnd() : this.getCodeEditor().getSelectionStart();
        }
        return this.getCodeEditor().getCaretModel().getOffset();
    }

    @Override
    public void adjustCurrentPosition(String string, boolean bl) {
        if (this.getCodeEditor().getSelectionModel().hasSelection()) {
            int n = bl ? this.getCodeEditor().getSelectionStart() : this.getCodeEditor().getSelectionEnd();
            this.getCodeEditor().select(n, n, true);
        }
    }

    @Override
    public void highlight(int n, int n2) {
        if (this._currentName != null && !this._currentName.equals(this._documentPane.getActiveDocumentName())) {
            this._documentPane.setActiveDocument(this._currentName, true);
        }
        this.getCodeEditor().select(n, n2, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(int n, int n2, String string) throws BadLocationException {
        this.getCodeEditor().getDocument().beginCompoundEdit();
        try {
            this.getCodeEditor().getDocument().remove(n, n2);
            this.getCodeEditor().getDocument().insertString(n, string, null);
            this.getCodeEditor().getCaretModel().setOffset(n + string.length());
        }
        finally {
            this.getCodeEditor().getDocument().endCompoundEdit();
        }
    }

    @Override
    public Window getPromptDialogParent() {
        return JideSwingUtilities.getWindowForComponent(this.getCodeEditor());
    }

    @Override
    public Point getPromptDialogLocation(Rectangle rectangle) {
        if (!this.getCodeEditor().isChangePromptDialogPosition()) {
            return null;
        }
        Point point = this.getCodeEditor().getCaretLocation();
        Point point2 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), Math.min(point.y + 50, this.getCodeEditor().getPainter().getHeight() - rectangle.height - 50));
        if (point2.y <= point.y && point2.y + rectangle.height >= point.y) {
            point2.y = Math.max(0, point.y - 50 - rectangle.height);
        }
        SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
        return point2;
    }

    @Override
    public Point getPromptDialogLocation() {
        Point point = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + this.getCodeEditor().getVisibleLines() - 10));
        SwingUtilities.convertPointToScreen(point, this.getCodeEditor().getPainter());
        return point;
    }

    @Override
    public void scrollToShowCaret(Rectangle rectangle) {
        Point point = this.getCodeEditor().getCaretLocation();
        SwingUtilities.convertPointToScreen(point, this.getCodeEditor().getPainter());
        if (rectangle.y <= point.y && point.y <= rectangle.y + rectangle.height) {
            Point point2 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + 5));
            SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
            int n = this.getCodeEditor().getCaretModel().getViewPosition().line;
            if (rectangle.y <= point2.y && point2.y <= rectangle.y + rectangle.height) {
                Point point3 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + this.getCodeEditor().getVisibleLines() - 5));
                SwingUtilities.convertPointToScreen(point3, this.getCodeEditor().getPainter());
                if ((rectangle.y > point3.y || point3.y > rectangle.y + rectangle.height) && n >= this.getCodeEditor().getVisibleLines() - 5) {
                    this.getCodeEditor().setFirstLine(n - this.getCodeEditor().getVisibleLines() + 5);
                }
            } else if (n >= 5) {
                this.getCodeEditor().setFirstLine(n - 5);
            }
        }
    }

    @Override
    public String getCurrentName() {
        return this._documentPane.getDocument(this._currentName).getTitle();
    }

    @Override
    public CharSequence getCurrentText() {
        CharSequence charSequence = this.getCodeEditor().getDocument() instanceof LazyLoadDocument ? ((LazyLoadDocument)this.getCodeEditor().getDocument()).getLazyLoadText() : this.getCodeEditor().getRawText();
        this.setTargetChanged(false);
        return charSequence;
    }

    @Override
    public void showMessage(String string) {
        this.getCodeEditor().showMessage(string);
    }

    @Override
    public void replaceAllStarts() {
        this._replaceAllInProgress = true;
        this.getCodeEditor().getDocument().beginCompoundEdit();
        for (DocumentListener documentListener : this._listeners = this.getCodeEditor().getDocument().getDocumentListeners()) {
            this.getCodeEditor().getDocument().removeDocumentListener(documentListener);
        }
    }

    @Override
    public void replaceAllEnds() {
        this.getCodeEditor().getDocument().endCompoundEdit();
        if (this._listeners != null) {
            DocumentEvent documentEvent = this.getCodeEditor().createReplaceAllDocumentEvent();
            for (DocumentListener documentListener : this._listeners) {
                this.getCodeEditor().getDocument().addDocumentListener(documentListener);
                documentListener.changedUpdate(documentEvent);
            }
        }
        this._replaceAllInProgress = false;
    }

    protected void changeCurrentEditor(CodeEditor codeEditor, String string) {
        if (this._current != null) {
            if (this._replaceAllInProgress) {
                this._current.getDocument().endCompoundEdit();
            }
            this._current.getDocument().removeDocumentListener(this);
        }
        this._current = codeEditor;
        this._currentName = string;
        this.setTargetChanged(true);
        if (this._current != null) {
            if (this._replaceAllInProgress) {
                this._current.getDocument().beginCompoundEdit();
            }
            this._current.getDocument().addDocumentListener(this);
        }
    }

    protected void setTargetChanged(boolean bl) {
        this._targetChanged = bl;
    }

    @Override
    public boolean isTargetChanged() {
        return this._targetChanged;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public String getResourceString(String string) {
        return this.getCodeEditor().getResourceString(string);
    }

    @Override
    public Locale getLocale() {
        return this.getCodeEditor().getLocale();
    }
}

