/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.alert.InputPopup;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.editor.AbstractCodeEditorIntelliHints;
import com.jidesoft.editor.ClipboardsDialog;
import com.jidesoft.editor.CodeEditorDefaultTransferHandler;
import com.jidesoft.editor.CodeEditorDropTargetListener;
import com.jidesoft.editor.CodeEditorFindAndReplaceTarget;
import com.jidesoft.editor.CodeEditorPainter;
import com.jidesoft.editor.CodeEditorResource;
import com.jidesoft.editor.CodeEditorRowMarginSupport;
import com.jidesoft.editor.CodeEditorSearchable;
import com.jidesoft.editor.CodeEditorSelectionFindAndReplaceTarget;
import com.jidesoft.editor.CodeEditorSettings;
import com.jidesoft.editor.CodeEditorTransferHandler;
import com.jidesoft.editor.CodeEditorUtils;
import com.jidesoft.editor.CodeInspector;
import com.jidesoft.editor.ColumnGuide;
import com.jidesoft.editor.DefaultCodeEditorSettings;
import com.jidesoft.editor.DefaultSettings;
import com.jidesoft.editor.FoldingState;
import com.jidesoft.editor.InputMethodSupport;
import com.jidesoft.editor.IntArrayList;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.LineBreak;
import com.jidesoft.editor.PageLoadEvent;
import com.jidesoft.editor.PageLoadListener;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.SyntaxStyle;
import com.jidesoft.editor.SyntaxStyleSchema;
import com.jidesoft.editor.SyntaxUtils;
import com.jidesoft.editor.TextUtils;
import com.jidesoft.editor.action.InputHandler;
import com.jidesoft.editor.caret.CaretEvent;
import com.jidesoft.editor.caret.CaretListener;
import com.jidesoft.editor.caret.CaretModel;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.caret.DefaultCaretModel;
import com.jidesoft.editor.folding.DefaultFoldingModel;
import com.jidesoft.editor.folding.FoldingModel;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.highlight.DefaultHighlighter;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.margin.MarginArea;
import com.jidesoft.editor.marker.DefaultMarkerModel;
import com.jidesoft.editor.marker.MarkerArea;
import com.jidesoft.editor.selection.DefaultSelectionModel;
import com.jidesoft.editor.selection.SelectionEvent;
import com.jidesoft.editor.selection.SelectionListener;
import com.jidesoft.editor.selection.SelectionModel;
import com.jidesoft.editor.tokenmarker.Token;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import com.jidesoft.margin.RowNumberMargin;
import com.jidesoft.marker.Marker;
import com.jidesoft.marker.MarkerEvent;
import com.jidesoft.marker.MarkerListener;
import com.jidesoft.marker.MarkerModel;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.search.FindAndReplace;
import com.jidesoft.search.FindAndReplaceDialog;
import com.jidesoft.search.FindAndReplaceEvent;
import com.jidesoft.search.FindAndReplaceListener;
import com.jidesoft.search.FindAndReplaceResource;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResult;
import com.jidesoft.search.FindResultIntepreter;
import com.jidesoft.search.FindResults;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.DelayUndoManager;
import com.jidesoft.swing.InfiniteProgressPanel;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Overlayable;
import com.jidesoft.swing.OverlayableUtils;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.StringUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CodeEditor
extends JComponent
implements SelectionListener,
CaretListener,
PropertyChangeListener,
FindResultIntepreter,
LineBreak {
    private static final Logger LOGGER;
    private boolean lastLinePartial;
    private static TransferHandler _defaultTransferHandler;
    private InputMethodRequests _inputMethodSupport = null;
    public static String LEFT_OF_SCROLLBAR;
    public static final String PROPERTY_OVERWRITE_ENABLED = "overwriteEnabled";
    public static final String PROPERTY_FIRST_LINE = "firstLine";
    public static final String PROPERTY_VISIBLE_LINES = "visibleLines";
    public static final String PROPERTY_COLUMN_SELECTION_ENABLED = "columnSelectionEnabled";
    public MarginArea _marginArea;
    public RowNumberMargin _lineNumberMargin;
    protected static List<Transferable> _clipboards;
    private final String PROPERTY_NO_WORD_DELIMITERS = "nonwordDelimiters";
    public Searchable _searchable;
    private JidePopup _messagePopup;
    public Timer _inspectionTimer;
    private FoldingModel _foldingModel;
    private FoldingSpanListener _foldingSpanListener;
    private MarkerModel _markerModel;
    private FindAndReplace _findAndReplace = null;
    private EditorSize _editorSize;
    protected CodeEditorSettings _defaultSettings;
    protected DefaultCodeEditorSettings _localSettings;
    private transient Highlighter _highlighter;
    private transient Highlighter _fixedHighlighter;
    private List<ColumnGuide> _columnGuides;
    private transient boolean _alwaysScrollCaret = false;
    private boolean _tabAlignment = true;
    private int _horizontalScrollBarPolicy = 1;
    private int _verticalScrollBarPolicy = 1;
    private boolean _showToolTipOverMarkedText = false;
    private boolean _ownSystemSelection = false;
    private ClipboardOwner _clipboardOwner;
    private String _fileName;
    private boolean _contentVisible = true;
    private boolean _delayContentsOnLoading = true;
    private Rectangle _findDialogBounds;
    private Rectangle _replaceDialogBounds;
    private Rectangle _pasteDialogBounds;
    private boolean _changePromptDialogPosition;
    private List<FoldingSpan> _internalAddedSpans;
    private boolean _adjustColumnSelectionOnMouseEvent = true;
    private boolean _skipsEmptyLinesOnLineComments = false;
    private int _lineSelection;
    private boolean _indentOnPasting = true;
    private boolean _copyVisibleTextOnly = false;
    private static final int CARET_DIRECTION_FORWARD = 0;
    private static final int CARET_DIRECTION_BACKWARD = 1;
    private static final int CARET_DIRECTION_HOLD = 2;
    private com.jidesoft.marker.MarkerArea _markerArea;
    private MarkerListener _markerListener;
    private List<CodeInspector> _codeInspectors = new LinkedList<CodeInspector>();
    private boolean _autoInspecting = false;
    public static final String PROPERTY_EDITABLE = "editable";
    protected static String CENTER;
    protected static String RIGHT;
    protected static String LEFT;
    protected static String BOTTOM;
    @Deprecated
    protected static CodeEditor focusedComponent;
    @Deprecated
    protected static Timer caretTimer;
    private Timer _caretTimer;
    protected CodeEditorPainter _painter;
    protected boolean _caretVisible = true;
    private boolean _blink;
    protected boolean _editable;
    protected CodeEditorSettings _settings;
    protected int _firstLine;
    protected int _visibleLines;
    protected int _horizontalOffset;
    protected JScrollBar _verticalScrollBar;
    protected JScrollBar _horizontalScrollBar;
    protected boolean _scrollBarsInitialized;
    protected SyntaxDocument _document;
    protected DocumentHandler _documentHandler;
    protected UndoableEditListener _undoableEditListener;
    public Segment lineSegment;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int _magicCaret;
    protected boolean _overwrite;
    private boolean _autoIndent = true;
    private Timer _repaintTimer;
    protected CaretModel _caretModel;
    protected SelectionModel _selectionModel;
    public static final String PROPERTY_TAB_SIZE = "tabSize";
    private int _tabSize = 4;
    public static final String PROPERTY_REPLACE_TAB_WITH_SPACE = "replaceTabWithSpace";
    private boolean _replaceTabWithSpace = true;
    public static final String PROPERTY_LINE_BREAK_STYLE = "lineBreakStyle";
    private int _lineBreakStyle = -2;
    public static final String PROPERTY_MAX_NUMBER_OF_CLIPBOARDS = "maxNumberOfClipboards";
    private int _maxNumberOfClipboards = 10;
    private boolean dragEnabled;
    private static Insets insets;
    public static final String SMART_HOME_END_PROPERTY = "InputHandler.homeEnd";

    public CodeEditor() {
        this(DefaultSettings.getDefaults());
    }

    private void initComponents() {
        Highlighter highlighter;
        this._lineBreakStyle = this.getDefaultLineBreakStyle();
        this.setBorder(UIDefaultsLookup.getBorder("TextField.border"));
        this.setAutoscrolls(true);
        this.addMouseWheelListener(new MouseWheelHandler());
        this._searchable = this.createSearchable(this);
        Highlighter highlighter2 = this.getHighlighter();
        if (highlighter2 == null || highlighter2 instanceof UIResource) {
            this.setHighlighter(this.createHighlighter());
        }
        if ((highlighter = this.getFixedHighlighter()) == null || highlighter instanceof UIResource) {
            this.setFixedHighlighter(this.createHighlighter());
        }
        this.loadActionMap();
    }

    protected Searchable createSearchable(CodeEditor codeEditor) {
        return new CodeEditorSearchable(codeEditor);
    }

    public CodeEditor(DefaultSettings defaultSettings) {
        this.enableEvents(8L);
        this._painter = this.createCodeEditorPainter(this);
        this._defaultSettings = defaultSettings;
        this._localSettings = new DefaultCodeEditorSettings();
        this._documentHandler = new DocumentHandler();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.setBlink(true);
        this._undoableEditListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                CodeEditor.this.updateUndoRedoActions();
            }
        };
        this._marginArea = new MarginArea(this);
        this._lineNumberMargin = new RowNumberMargin(new CodeEditorRowMarginSupport(this));
        this._marginArea.add(this._lineNumberMargin);
        this.setLayout(new ScrollLayout());
        this.add(CENTER, this._painter);
        this.add(LEFT, this._marginArea);
        this._verticalScrollBar = this.createScrollBar(1);
        this.add(RIGHT, this._verticalScrollBar);
        this._horizontalScrollBar = this.createScrollBar(0);
        this.add(BOTTOM, this._horizontalScrollBar);
        this._verticalScrollBar.addAdjustmentListener(new AdjustHandler());
        this._horizontalScrollBar.addAdjustmentListener(new AdjustHandler());
        this._painter.addComponentListener(new ComponentHandler());
        MouseHandler mouseHandler = new MouseHandler();
        this._painter.addMouseListener(mouseHandler);
        this._painter.addMouseMotionListener(mouseHandler);
        this.addFocusListener(new FocusHandler());
        this.initializeDefaultSettings(defaultSettings);
        this._editorSize = new EditorSize();
        this._editorSize.reset();
        this.initComponents();
        this.setTransferHandler(this.createDefaultTransferHandler());
        DropTarget dropTarget = this.getDropTarget();
        try {
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(new CodeEditorDropTargetListener(this));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void swap() {
        this.add(RIGHT, this._marginArea);
        this.add(LEFT, this._verticalScrollBar);
    }

    protected CodeEditorPainter createCodeEditorPainter(CodeEditor codeEditor) {
        return new CodeEditorPainter(codeEditor);
    }

    protected TransferHandler createDefaultTransferHandler() {
        return new CodeEditorTransferHandler(this);
    }

    private void updateUndoRedoActions() {
        UndoManager undoManager = this.getDocument().getUndoManager();
        if (undoManager instanceof DelayUndoManager && !((DelayUndoManager)undoManager).isCacheEmpty()) {
            return;
        }
        Action action = this.getAction("undo");
        if (action != null) {
            action.setEnabled(undoManager.canUndo());
        }
        if ((action = this.getAction("redo")) != null) {
            action.setEnabled(undoManager.canRedo());
        }
    }

    protected JScrollBar createScrollBar(int n) {
        return new JScrollBar(n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("blockCaret".equals(propertyChangeEvent.getPropertyName()) || "selectionColor".equals(propertyChangeEvent.getPropertyName()) || "lineHighlight".equals(propertyChangeEvent.getPropertyName()) || "lineHighlightColor".equals(propertyChangeEvent.getPropertyName())) {
            this._painter.invalidateSelectedLines();
        } else if ("bracketHighlightColor".equals(propertyChangeEvent.getPropertyName()) || "bracketHighlight".equals(propertyChangeEvent.getPropertyName())) {
            this._painter.invalidateLine(this.modelToViewPosition((CaretPosition)new CaretPosition((int)this.bracketLine, (int)this.bracketPosition)).line);
        } else if ("specialCharactersColor".equals(propertyChangeEvent.getPropertyName()) || "specialCharacters".equals(propertyChangeEvent.getPropertyName())) {
            this._painter.repaint();
        } else if ("styles".equals(propertyChangeEvent.getPropertyName())) {
            SyntaxStyleSchema syntaxStyleSchema = this.getStyles();
            if (syntaxStyleSchema != null && this.getMarkerArea() != null) {
                Color color;
                Color color2;
                SyntaxStyle syntaxStyle = syntaxStyleSchema.getStyle(11);
                Color color3 = color2 = syntaxStyle == null ? null : syntaxStyle.getStripeColor();
                if (color2 != null) {
                    this.getMarkerArea().registerMarkerColor(0, color2);
                } else {
                    this.getMarkerArea().registerMarkerColor(0, MarkerArea.DEFAULT_WARNING_COLOR);
                }
                SyntaxStyle syntaxStyle2 = syntaxStyleSchema.getStyle(12);
                Color color4 = color = syntaxStyle2 == null ? null : syntaxStyle2.getStripeColor();
                if (color != null) {
                    this.getMarkerArea().registerMarkerColor(1, color);
                } else {
                    this.getMarkerArea().registerMarkerColor(1, MarkerArea.DEFAULT_WARNING_COLOR);
                }
                this._painter.repaint();
            }
        } else if ("font".equals(propertyChangeEvent.getPropertyName())) {
            this.setFont((Font)propertyChangeEvent.getNewValue());
        } else if ("caretBlinks".equals(propertyChangeEvent.getPropertyName())) {
            if (Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                this.setBlink(false);
            }
            this._painter.invalidateSelectedLines();
        }
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    @Override
    public TransferHandler getTransferHandler() {
        TransferHandler transferHandler = super.getTransferHandler();
        if (transferHandler == null) {
            if (_defaultTransferHandler == null) {
                _defaultTransferHandler = new CodeEditorDefaultTransferHandler();
            }
            return _defaultTransferHandler;
        }
        return transferHandler;
    }

    public final SyntaxStyleSchema getStyles() {
        if (this._localSettings.getStyles() != null) {
            return this._localSettings.getStyles();
        }
        return this._defaultSettings.getStyles();
    }

    public final void setStyles(SyntaxStyleSchema syntaxStyleSchema) {
        this._localSettings.setStyles(syntaxStyleSchema);
        this.repaint();
    }

    public final Color getCaretColor() {
        if (this._localSettings.getCaretColor() != null) {
            return this._localSettings.getCaretColor();
        }
        return this._defaultSettings.getCaretColor();
    }

    public final void setCaretColor(Color color) {
        this._localSettings.setCaretColor(color);
    }

    public final Color getSelectionColor() {
        if (this._localSettings.getSelectionColor() != null) {
            return this._localSettings.getSelectionColor();
        }
        return this._defaultSettings.getSelectionColor();
    }

    public final void setSelectionColor(Color color) {
        this._localSettings.setSelectionColor(color);
    }

    public final Color getLineHighlightColor() {
        if (this._localSettings.getLineHighlightColor() != null) {
            return this._localSettings.getLineHighlightColor();
        }
        return this._defaultSettings.getLineHighlightColor();
    }

    public final void setLineHighlightColor(Color color) {
        this._localSettings.setLineHighlightColor(color);
    }

    public final boolean isLineHighlightVisible() {
        if (this._localSettings.isLineHighlightVisibleSet()) {
            return this._localSettings.isLineHighlightVisible();
        }
        return this._defaultSettings.isLineHighlightVisible();
    }

    public final void setLineHighlight(boolean bl) {
        this._localSettings.setLineHighlightVisible(bl);
    }

    public final Color getBracketHighlightColor() {
        if (this._localSettings.getBracketHighlightColor() != null) {
            return this._localSettings.getBracketHighlightColor();
        }
        return this._defaultSettings.getBracketHighlightColor();
    }

    public final void setBracketHighlightColor(Color color) {
        this._localSettings.setBracketHighlightColor(color);
    }

    public final boolean isBracketHighlightVisible() {
        if (this._localSettings.isBracketHighlightVisibleSet()) {
            return this._localSettings.isBracketHighlightVisible();
        }
        return this._defaultSettings.isBracketHighlightVisible();
    }

    public final void setBracketHighlightVisible(boolean bl) {
        this._localSettings.setBracketHighlightVisible(bl);
    }

    public final boolean isBlockCaret() {
        if (this._localSettings.isBlockCaretSet()) {
            return this._localSettings.isBlockCaret();
        }
        return this._defaultSettings.isBlockCaret();
    }

    public final void setBlockCaret(boolean bl) {
        this._localSettings.setBlockCaret(bl);
    }

    public final boolean isCaretBlinks() {
        if (this._localSettings.isCaretBlinksSet()) {
            return this._localSettings.isCaretBlinks();
        }
        return this._defaultSettings.isCaretBlinks();
    }

    public void setCaretBlinks(boolean bl) {
        this._localSettings.setCaretBlinks(bl);
    }

    public final Color getSpecialCharactersColor() {
        if (this._localSettings.getSpecialCharactersColor() != null) {
            return this._localSettings.getSpecialCharactersColor();
        }
        return this._defaultSettings.getSpecialCharactersColor();
    }

    public final void setSpecialCharactersColor(Color color) {
        this._localSettings.setSpecialCharactersColor(color);
    }

    public final boolean isSpecialCharactersVisible() {
        if (this._localSettings.isSpecialCharactersSet()) {
            return this._localSettings.isSpecialCharactersVisible();
        }
        return this._defaultSettings.isSpecialCharactersVisible();
    }

    public final void setSpecialCharactersVisible(boolean bl) {
        this._localSettings.setSpecialCharactersVisible(bl);
    }

    public boolean isPaintInvalid() {
        if (this._localSettings.isPaintInvalidSet()) {
            return this._localSettings.isPaintInvalid();
        }
        return this._defaultSettings.isPaintInvalid();
    }

    public void setPaintInvalid(boolean bl) {
        this._localSettings.setPaintInvalid(bl);
    }

    public boolean isVirtualSpaceAllowed() {
        if (this._localSettings.isVirtualSpaceAllowedSet()) {
            return this._localSettings.isVirtualSpaceAllowed();
        }
        return this._defaultSettings.isVirtualSpaceAllowed();
    }

    public void setVirtualSpaceAllowed(boolean bl) {
        this._localSettings.setVirtualSpaceAllowed(bl);
    }

    public com.jidesoft.marker.MarkerArea getMarkerArea() {
        return this._markerArea;
    }

    public void setMarkerArea(com.jidesoft.marker.MarkerArea markerArea) {
        this._markerArea = markerArea;
    }

    public void initializeDefaultSettings(DefaultSettings defaultSettings) {
        this.setFont(defaultSettings.getFont());
        this.setDocument(new SyntaxDocument());
        this.getDocument().putProperty("nonwordDelimiters", "_");
        this._settings = defaultSettings;
        this._editable = true;
    }

    public void addCodeInspector(CodeInspector codeInspector) {
        this._codeInspectors.add(codeInspector);
    }

    public void removeCodeInspector(CodeInspector codeInspector) {
        this._codeInspectors.remove(codeInspector);
    }

    public CodeInspector[] getCodeInspectors() {
        return this._codeInspectors.toArray(new CodeInspector[this._codeInspectors.size()]);
    }

    public int getCodeInspectorCount() {
        return this._codeInspectors.size();
    }

    public CodeInspector getCodeInspector(int n) {
        return this._codeInspectors.get(n);
    }

    public boolean isAutoInspecting() {
        return this._autoInspecting;
    }

    public void setAutoInspecting(boolean bl) {
        if (this._autoInspecting != bl) {
            this._autoInspecting = bl;
            if (this.isAutoInspecting()) {
                this.inspectCode();
            } else {
                this.stopInspectCode();
            }
        }
    }

    public void stopInspectCode() {
        if (this._inspectionTimer != null && this._inspectionTimer.isRunning()) {
            this._inspectionTimer.stop();
        }
    }

    public void inspectCode() {
        this.inspectCode(null);
    }

    public void inspectCode(final DocumentEvent documentEvent) {
        if (this._inspectionTimer == null) {
            this._inspectionTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            if (CodeEditor.this._markerArea != null) {
                                CodeEditor.this._markerArea.setInspecting(true);
                            }
                            for (CodeInspector codeInspector : CodeEditor.this._codeInspectors) {
                                codeInspector.inspect(CodeEditor.this, documentEvent, CodeEditor.this.getMarkerModel());
                            }
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    if (CodeEditor.this._markerArea != null) {
                                        CodeEditor.this._markerArea.requireMinimumMode(0);
                                        CodeEditor.this._markerArea.setInspecting(false);
                                    }
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                    };
                    thread.start();
                }
            });
            this._inspectionTimer.setRepeats(false);
        }
        if (this._inspectionTimer.isRunning()) {
            this._inspectionTimer.restart();
        } else {
            this._inspectionTimer.start();
        }
    }

    public int getLineHeight() {
        return this._painter.getLineHeight();
    }

    @Override
    public final boolean isManagingFocus() {
        return true;
    }

    public final CodeEditorPainter getPainter() {
        return this._painter;
    }

    public final InputHandler getInputHandler() {
        if (this._localSettings.getInputHandler() != null) {
            return this._localSettings.getInputHandler();
        }
        return this._defaultSettings.getInputHandler();
    }

    public void setInputHandler(InputHandler inputHandler) {
        this._localSettings.setInputHandler(inputHandler);
    }

    public final boolean isCaretVisible() {
        return (!this.isCaretBlinks() || this.isBlink()) && this._caretVisible;
    }

    public void setCaretVisible(boolean bl) {
        this._caretVisible = bl;
        this.setBlink(true);
        this._painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        if (this._caretTimer == null) {
            this._caretTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CodeEditor.this.hasFocus()) {
                        CodeEditor.this.blinkCaret();
                    }
                }
            });
            this._caretTimer.setInitialDelay(500);
            this._caretTimer.start();
        }
        if (!this._caretTimer.isRunning()) {
            this._caretTimer.restart();
        }
        if (this.isCaretBlinks()) {
            if (this.getPainter()._composedTextLayout == null) {
                this.setBlink(!this._blink);
            } else {
                this.setBlink(false);
            }
            this._painter.invalidateSelectedLines();
            this._painter.invalidateLine(this.getCaretModel().getViewPosition().line);
        } else {
            this.setBlink(true);
        }
    }

    public final int getElectricScroll() {
        if (this._localSettings.getElectricScroll() != -1) {
            return this._localSettings.getElectricScroll();
        }
        return this._defaultSettings.getElectricScroll();
    }

    public final void setElectricScroll(int n) {
        this._localSettings.setElectricScroll(n);
    }

    public void updateScrollBars() {
        int n;
        if (this._verticalScrollBar != null && this._visibleLines != 0) {
            this._verticalScrollBar.setValues(this._firstLine, this._visibleLines, 0, this.getVisualLineCount() + 1);
            this._verticalScrollBar.setUnitIncrement(2);
            this._verticalScrollBar.setBlockIncrement(this._visibleLines);
            n = this.getVerticalScrollBarPolicy();
            if (n == 1) {
                this._verticalScrollBar.setVisible(true);
            } else if (n == 2) {
                this._verticalScrollBar.setVisible(false);
            } else if (n == 0) {
                this._verticalScrollBar.setVisible(this._visibleLines <= this.getVisualLineCount() + 1);
            }
            if (this.getMarkerArea() != null) {
                this.getMarkerArea().updateMarkerAreaHeight(0);
            }
        }
        n = this._painter.getWidth();
        if (this._horizontalScrollBar != null && n != 0) {
            this._horizontalScrollBar.setValues(-this._horizontalOffset, n, 0, this.getContentSize().width);
            this._horizontalScrollBar.setUnitIncrement(this._painter.getFontMetrics().charWidth('w'));
            this._horizontalScrollBar.setBlockIncrement(n / 2);
            int n2 = this.getHorizontalScrollBarPolicy();
            if (n2 == 1) {
                this._horizontalScrollBar.setVisible(true);
            } else if (n2 == 2) {
                this._horizontalScrollBar.setVisible(false);
            } else if (n2 == 0) {
                this._horizontalScrollBar.setVisible(n <= this.getContentSize().width || this.getHorizontalOffset() < 0);
            }
            if (this.getMarkerArea() != null) {
                this.getMarkerArea().updateMarkerAreaHeight(0);
            }
        }
    }

    public final int getFirstLine() {
        if (this._firstLine < 0) {
            this.setFirstLine(0);
        } else if (this._firstLine >= this.getLineCount()) {
            this.setFirstLine(this.getLineCount() - this.getVisibleLines() + 1);
            if (this.getCaretModel().getModelPosition().line >= this.getLineCount()) {
                this.setCaretPosition(this.getDocumentLength());
            }
        }
        return this._firstLine;
    }

    public void setFirstLine(int n) {
        if (n == this._firstLine) {
            return;
        }
        int n2 = this._firstLine;
        if (n < 0) {
            n = 0;
        }
        if (n + this.getVisibleLines() > this.getVisualLineCount()) {
            n = this.getVisualLineCount() - this.getVisibleLines() + (this.lastLinePartial ? 1 : 0);
        }
        if (n < 0) {
            n = 0;
        }
        this._firstLine = n;
        if (n != this._verticalScrollBar.getValue()) {
            this.updateScrollBars();
        }
        this._painter.repaint();
        this._marginArea.repaint();
        this.firePropertyChange(PROPERTY_FIRST_LINE, n2, this._firstLine);
    }

    public final int getVisibleLines() {
        return this._visibleLines;
    }

    public final void recalculateVisibleLines() {
        if (this._painter == null) {
            return;
        }
        int n = this._visibleLines;
        int n2 = this._painter.getHeight();
        int n3 = this.getLineHeight();
        if (n3 == 0) {
            this._visibleLines = 0;
        } else if (n2 <= 0) {
            this._visibleLines = 0;
            this.lastLinePartial = false;
        } else {
            this._visibleLines = n2 / n3;
            boolean bl = this.lastLinePartial = n2 % n3 != 0;
            if (this.lastLinePartial) {
                ++this._visibleLines;
            }
        }
        this.updateScrollBars();
        if (n != this._visibleLines) {
            this.firePropertyChange(PROPERTY_VISIBLE_LINES, n, this._visibleLines);
        }
    }

    public final int getHorizontalOffset() {
        return this._horizontalOffset;
    }

    public void setHorizontalOffset(int n) {
        if (n == this._horizontalOffset) {
            return;
        }
        this._horizontalOffset = n;
        if (n != this._horizontalScrollBar.getValue()) {
            this.updateScrollBars();
        }
        this._painter.repaint();
    }

    public boolean setOrigin(int n, int n2) {
        boolean bl = false;
        if (n2 != this._horizontalOffset) {
            this.setHorizontalOffset(n2);
            bl = true;
        }
        if (n != this._firstLine) {
            this.setFirstLine(n);
            bl = true;
        }
        if (bl) {
            this.updateScrollBars();
            this._painter.repaint();
            this._marginArea.repaint();
        }
        return bl;
    }

    public boolean scrollToCaret() {
        return this.scrollToCaret(false);
    }

    boolean scrollToCaret(boolean bl) {
        CaretPosition caretPosition;
        boolean bl2 = false;
        if (this._editorSize._caretMaxWidth) {
            bl2 = true;
        } else {
            caretPosition = this.getCaretModel().getViewPosition();
            int n = this.columnToX(caretPosition.line, caretPosition.column);
            int n2 = n - this.getHorizontalOffset();
            if (n2 > this.getContentSize().width) {
                bl2 = true;
            }
        }
        if (bl2) {
            this._editorSize._recalculateNeeded = true;
            this.updateScrollBars();
        }
        caretPosition = null;
        if (bl) {
            caretPosition = this.getSelectionModel().hasSelection() ? this.offsetToViewPosition(this.getSelectionStart() == this.getCaretModel().getOffset() ? this.getSelectionEnd() : this.getSelectionStart()) : null;
        }
        return this.scrollToViewPosition(this.getCaretModel().getViewPosition(), caretPosition);
    }

    public boolean scrollTo(CaretPosition caretPosition) {
        return this.scrollToViewPosition(this.modelToViewPosition(caretPosition));
    }

    public boolean scrollToViewPosition(CaretPosition caretPosition) {
        return this.scrollToViewPosition(caretPosition, null);
    }

    protected boolean scrollToViewPosition(CaretPosition caretPosition, CaretPosition caretPosition2) {
        int n;
        int n2;
        int n3;
        if (this._visibleLines == 0) {
            this.setFirstLine(Math.max(0, caretPosition.line - this.getElectricScroll()));
            return true;
        }
        int n4 = this._firstLine;
        int n5 = this._horizontalOffset;
        if (caretPosition.line < this._firstLine + this.getElectricScroll()) {
            n4 = Math.max(0, caretPosition.line - this.getElectricScroll());
            if (caretPosition2 != null) {
                n3 = caretPosition2.line;
                n2 = caretPosition.line;
                n = Math.abs(n3 - n2) + 1;
                n4 = n >= this._visibleLines ? Math.max(0, Math.min(n2, n3) - this.getElectricScroll()) : Math.max(0, Math.min(n2, n3) - this.getElectricScroll() - (this._visibleLines - n) / 2);
            }
        } else if (caretPosition.line + this.getElectricScroll() >= this._firstLine + this._visibleLines) {
            n4 = caretPosition.line - this._visibleLines + this.getElectricScroll() + 1;
            if (caretPosition2 != null) {
                n3 = caretPosition2.line;
                n2 = caretPosition.line;
                n = Math.abs(n3 - n2) + 1;
                n4 = n >= this._visibleLines ? Math.max(n2, n3) - this._visibleLines + this.getElectricScroll() + 1 : Math.max(n2, n3) - this._visibleLines + this.getElectricScroll() + 1 + (this._visibleLines - n) / 2;
            }
            if (n4 + this._visibleLines >= this.getLineCount()) {
                n4 = this.getLineCount() - this._visibleLines + 1;
            }
            if (n4 < 0) {
                n4 = 0;
            }
        }
        n3 = n2 = this.columnToX(caretPosition.line, caretPosition.column);
        if (caretPosition2 != null) {
            n3 = this.columnToX(caretPosition2.line, caretPosition2.column);
        }
        n = this._painter.getFontMetrics().charWidth('w');
        if (Math.max(n2, n3) + n >= this._painter.getWidth()) {
            n5 = this._horizontalOffset + (this._painter.getWidth() - Math.max(n2, n3)) - n - 5;
        } else if (Math.min(n2, n3) < 0) {
            n5 = Math.max(n2, n3) + n - this._horizontalOffset < this._painter.getWidth() ? 0 : (n2 < 0 ? Math.min(0, this._horizontalOffset - Math.min(n2, n3) + n + 5) : this._horizontalOffset + n);
        } else {
            CaretPosition caretPosition3 = this.getCaretModel().getViewPosition();
            int n6 = this.columnToX(caretPosition3.line, caretPosition3.column);
            int n7 = n6 - this.getHorizontalOffset();
            if (n7 == this.getContentSize().width && (n5 = this._horizontalOffset + (this._painter.getWidth() - n2) - n - 5) >= 0) {
                n5 = 0;
            }
        }
        return this.setOrigin(n4, n5);
    }

    protected DocumentEvent createReplaceAllDocumentEvent() {
        return new DocumentEvent(){

            @Override
            public int getOffset() {
                return 0;
            }

            @Override
            public int getLength() {
                return CodeEditor.this.getDocumentLength();
            }

            @Override
            public Document getDocument() {
                return CodeEditor.this.getDocument();
            }

            @Override
            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.CHANGE;
            }

            @Override
            public DocumentEvent.ElementChange getChange(Element element) {
                return null;
            }
        };
    }

    public int lineToY(int n) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        return (n - this._firstLine) * fontMetrics.getHeight() - (fontMetrics.getLeading() + fontMetrics.getMaxDescent());
    }

    public int yToLine(int n) {
        return this.yToVisualLine(n);
    }

    private int yToVisualLine(int n) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        return Math.max(0, n / n2 + this._firstLine);
    }

    public final int offsetToX(int n) {
        this._painter.currentLineTokens = null;
        return this._offsetToX(n);
    }

    @Deprecated
    public final int offsetToX(int n, int n2) {
        this._painter.currentLineTokens = null;
        return this._offsetToX(n2 + this.getLineStartOffset(n));
    }

    @Deprecated
    public int _offsetToX(int n, int n2) {
        return this._offsetToX(n2 + this.getLineStartOffset(n));
    }

    public int _offsetToX(int n) {
        if (this.isIntegerScaleFactor()) {
            return this.getIntegerOffsetToX(n);
        }
        return this.getFractionalOffsetToX(n);
    }

    protected int getIntegerOffsetToX(int n) {
        Object object;
        int n2;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        int n3 = this.getLineNumber(n);
        if (n3 < 0 || n3 >= this.getLineCount()) {
            return this._horizontalOffset;
        }
        if (n == 0 && n3 == 0 || !this.getLineText(n3, this.lineSegment)) {
            return this._horizontalOffset;
        }
        int n4 = n - this.getLineStartOffset(n3);
        int n5 = this.lineSegment.offset;
        int n6 = this._horizontalOffset;
        Token token = null;
        if (tokenMarker != null) {
            if (this._painter.currentLineIndex == n3 && this._painter.currentLineTokens != null) {
                token = this._painter.currentLineTokens;
            } else {
                this._painter.currentLineIndex = n3;
                token = this._painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, n3);
            }
        }
        if (this.getFoldingModel().isEnabled() && tokenMarker != null) {
            int n7 = this.getLineStartOffset(n3);
            int n8 = this.getLineEndOffset(n3);
            n2 = this.getLineEndOffsetExcludeLineBreak(n3);
            int n9 = this.modelToViewLine(n3);
            object = new FoldingState(this, n7);
            if (n8 >= ((FoldingState)object).getEndOffset() && n7 > ((FoldingState)object).getStartOffset()) {
                while (n8 >= ((FoldingState)object).getEndOffset() && (((FoldingState)object).getCurrentFold() == null || n7 >= ((FoldingState)object).getEndOffset()) && ((FoldingState)object).getEndOffset() < this.getDocumentLength()) {
                    ((FoldingState)object).advance();
                }
            } else if (n8 >= ((FoldingState)object).getEndOffset() && n7 == ((FoldingState)object).getStartOffset() && ((FoldingState)object).getCurrentFold() == null) {
                ((FoldingState)object).advance();
            }
            if (((FoldingState)object).getCurrentFold() != null) {
                if (((FoldingState)object).getStartOffset() >= n7 && ((FoldingState)object).getEndOffset() >= n8) {
                    int n10 = ((FoldingState)object).getCurrentFold().getStartOffset();
                    int n11 = this.getLineNumber(n10);
                    if (n11 != n3 && n10 != this.getLineStartOffset(n11)) {
                        this.getLineText(n11, this.lineSegment);
                        token = tokenMarker.markTokens(this.lineSegment, n11);
                        n6 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, 0, n10 - this.getLineStartOffset(n11), token, n6);
                        this.getLineText(n3, this.lineSegment);
                        token = tokenMarker.markTokens(this.lineSegment, n3);
                    }
                    if (n4 <= ((FoldingState)object).getStartOffset() - n7) {
                        return SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, 0, n4, token, n6);
                    }
                    n6 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, 0, ((FoldingState)object).getStartOffset() - n7, token, n6);
                    if (n4 < ((FoldingState)object).getEndOffset() - n7 && n4 != n2) {
                        return n6;
                    }
                    n6 = SyntaxUtils.getXWithoutDrawingFoldedText(this, ((FoldingState)object).getCurrentFold().getDescription(), n6);
                    int n12 = this.getLineNumber(((FoldingState)object).getEndOffset() + 1);
                    int n13 = this.modelToViewLine(n12);
                    if (n13 == n9) {
                        if (n4 <= n2) {
                            return SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, ((FoldingState)object).getEndOffset() - n7, n4, token, n6);
                        }
                        n6 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, ((FoldingState)object).getEndOffset() - n7, -1, token, n6);
                        n6 += this.getPainter().getFontMetrics().charWidth(' ') * (n4 - n2);
                    }
                    return n6;
                }
                if (((FoldingState)object).getStartOffset() >= n7 && ((FoldingState)object).getEndOffset() < n8) {
                    int n14 = ((FoldingState)object).getCurrentFold().getStartOffset();
                    int n15 = this.getLineNumber(n14);
                    if (n15 != n3 && n14 != this.getLineStartOffset(n15)) {
                        this.getLineText(n15, this.lineSegment);
                        token = tokenMarker.markTokens(this.lineSegment, n15);
                        n6 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, 0, n14 - this.getLineStartOffset(n15), token, n6);
                        this.getLineText(n3, this.lineSegment);
                        token = tokenMarker.markTokens(this.lineSegment, n3);
                    }
                    if (n4 <= ((FoldingState)object).getStartOffset() - n7) {
                        return SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, 0, n4, token, n6);
                    }
                    n6 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, 0, ((FoldingState)object).getStartOffset() - n7, token, n6);
                    if (n4 < ((FoldingState)object).getEndOffset() - n7 && n4 != n2) {
                        return n6;
                    }
                    n6 = SyntaxUtils.getXWithoutDrawingFoldedText(this, ((FoldingState)object).getCurrentFold().getDescription(), n6);
                    if (n4 <= n2) {
                        return SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, ((FoldingState)object).getEndOffset() - n7, n4, token, n6);
                    }
                    n6 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, ((FoldingState)object).getEndOffset() - n7, -1, token, n6);
                    return n6 + this.getPainter().getFontMetrics().charWidth(' ') * (n4 - n2);
                }
                if (((FoldingState)object).getStartOffset() < n7 && ((FoldingState)object).getEndOffset() >= n8) {
                    System.out.println("not reached 1");
                } else {
                    if (((FoldingState)object).getStartOffset() < n7 && ((FoldingState)object).getEndOffset() < n8) {
                        if (n4 <= n2) {
                            return SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, ((FoldingState)object).getEndOffset() - n7, n4, token, n6);
                        }
                        n6 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, ((FoldingState)object).getEndOffset() - n7, -1, token, n6);
                        return n6 + this.getPainter().getFontMetrics().charWidth(' ') * (n4 - n2);
                    }
                    System.out.println("not reached 2");
                }
                return n6;
            }
        }
        if (tokenMarker == null || n3 > this.getLineCount()) {
            this.lineSegment.count = n4;
            try {
                return n6 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n6, (TabExpander)this._painter, 0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return n6;
            }
        }
        Font font = this._painter.getFont();
        SyntaxStyleSchema syntaxStyleSchema = this.getStyles();
        while ((n2 = (int)token.id) != 127) {
            SyntaxStyle syntaxStyle = syntaxStyleSchema.getStyle(n2);
            object = this._painter.getGraphics();
            if (object == null) {
                fontMetrics = this._painter.getFontMetrics();
            } else {
                if (syntaxStyle == null || n2 == 0 && syntaxStyle.getForeground() == null) {
                    if (!font.equals(((Graphics)object).getFont())) {
                        ((Graphics)object).setFont(font);
                    }
                } else {
                    syntaxStyle.setGraphicsFlags((Graphics)object, font);
                }
                fontMetrics = ((Graphics)object).getFontMetrics();
            }
            int n16 = token.length;
            if (n4 + n5 < this.lineSegment.offset + n16) {
                this.lineSegment.count = n4 - (this.lineSegment.offset - n5);
                return n6 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n6, (TabExpander)this._painter, 0);
            }
            this.lineSegment.count = n16;
            n6 += Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n6, (TabExpander)this._painter, 0);
            this.lineSegment.offset += n16;
            token = token.next;
        }
        return n6;
    }

    public int xToColumn(int n) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        return (n - this.getHorizontalOffset()) / fontMetrics.charWidth('w');
    }

    public int xToColumn(int n, int n2) {
        FontMetrics fontMetrics;
        int n3;
        int n4 = this.xToOffset(n, n2);
        int n5 = this.offsetToViewPosition((int)n4).column;
        int n6 = this.offsetToX(n4);
        if (n6 < n2 && (n3 = (fontMetrics = this._painter.getFontMetrics()).charWidth(' ')) > 0) {
            n5 += (n2 - n6) / n3;
        }
        return n5;
    }

    @Deprecated
    public int columnToX(int n) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        return n * fontMetrics.charWidth('w') + this.getHorizontalOffset();
    }

    public int columnToX(int n, int n2) {
        int n3;
        CaretPosition caretPosition = new CaretPosition(n, n2);
        CaretPosition caretPosition2 = this.viewToModelPosition(caretPosition);
        int n4 = caretPosition2.line;
        int n5 = this.getLineEndOffsetExcludeLineBreak(n4);
        int n6 = this.offsetToX(this.modelPositionToOffset(caretPosition2));
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        if (caretPosition2.column > n5) {
            n6 += (caretPosition2.column - n5) * fontMetrics.charWidth(' ');
        }
        if ((n3 = n2 - this.modelToViewPosition((CaretPosition)caretPosition2).column) > 0) {
            n6 += n3 * fontMetrics.charWidth(' ');
        }
        return n6;
    }

    protected int getLineEndOffsetExcludeLineBreak(int n) {
        char c;
        int n2;
        String string = this.getLineText(n);
        for (n2 = string.length(); n2 > 0 && ((c = string.charAt(n2 - 1)) == '\r' || c == '\n'); --n2) {
        }
        return n2;
    }

    public int xToOffset(int n, int n2) {
        int n3;
        int n4;
        Object object;
        int n5;
        if (!this.isIntegerScaleFactor()) {
            n5 = this.getLineStartOffset(n);
            object = this.getLineText(n);
            for (n4 = 0; n4 < ((String)object).length(); ++n4) {
                n3 = this._offsetToX(n5 + n4);
                if (n3 < n2) continue;
                return n5 + n4;
            }
        }
        n5 = this.getHorizontalOffset();
        n2 -= n5;
        object = this.getTokenMarker();
        n4 = this.viewToModelLine(n);
        if (!this.getLineText(n4, this.lineSegment)) {
            return 0;
        }
        n3 = this.getLineStartOffset(n4);
        if (this.getFoldingModel().isEnabled() && object != null) {
            int n6 = this.getLineEndOffset(n4);
            int n7 = this.getLineEndOffsetExcludeLineBreak(n4);
            FoldingState foldingState = new FoldingState(this, n3);
            if (n6 >= foldingState.getEndOffset() && n3 > foldingState.getStartOffset()) {
                while (n6 >= foldingState.getEndOffset() && (foldingState.getCurrentFold() == null || n3 >= foldingState.getEndOffset()) && foldingState.getEndOffset() < this.getDocumentLength()) {
                    foldingState.advance();
                }
            } else if (n6 >= foldingState.getEndOffset() && n3 == foldingState.getStartOffset() && foldingState.getCurrentFold() == null) {
                foldingState.advance();
            }
            if (foldingState.getCurrentFold() != null) {
                Token token;
                if (this._painter.currentLineIndex == n4 && this._painter.currentLineTokens != null) {
                    token = this._painter.currentLineTokens;
                } else {
                    this._painter.currentLineIndex = n4;
                    token = this._painter.currentLineTokens = ((TokenMarker)object).markTokens(this.lineSegment, n4);
                }
                if (foldingState.getStartOffset() >= n3 && foldingState.getEndOffset() >= n6) {
                    int n8 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, 0, foldingState.getStartOffset() - n3, token, 0);
                    if (n2 <= n8) {
                        return this.calculateOffset(n2, n4, n3);
                    }
                    if ((n2 -= n8) < (n8 = SyntaxUtils.getXWithoutDrawingFoldedText(this, foldingState.getCurrentFold().getDescription(), 0))) {
                        return foldingState.getStartOffset();
                    }
                    int n9 = this.getLineNumber(foldingState.getEndOffset());
                    if ((n2 -= n8) == 0 && n9 != n4) {
                        return n3;
                    }
                    int n10 = this.modelToViewLine(n9);
                    if (n10 == n) {
                        n7 = this.getLineEndOffsetExcludeLineBreak(n9);
                        this.getLineText(n9, this.lineSegment);
                        token = this._painter.currentLineTokens = ((TokenMarker)object).markTokens(this.lineSegment, n9);
                        int n11 = this.getLineStartOffset(n9);
                        n8 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, foldingState.getEndOffset() - n11, -1, token, 0);
                        if (n2 <= n8) {
                            return this.calculateOffset(n2, n9, foldingState.getEndOffset());
                        }
                        n3 = n11;
                    }
                    return n3 + n7;
                }
                if (foldingState.getStartOffset() >= n3 && foldingState.getEndOffset() < n6) {
                    int n12 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, 0, foldingState.getStartOffset() - n3, token, 0);
                    if (n2 <= n12) {
                        return this.calculateOffset(n2, n4, n3);
                    }
                    if ((n2 -= n12) < (n12 = SyntaxUtils.getXWithoutDrawingFoldedText(this, foldingState.getCurrentFold().getDescription(), 0))) {
                        return foldingState.getStartOffset();
                    }
                    if ((n2 -= n12) == 0) {
                        return n3;
                    }
                    n12 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, foldingState.getEndOffset() - n3, -1, token, 0);
                    if (n2 <= n12) {
                        return this.calculateOffset(n2, n4, foldingState.getEndOffset());
                    }
                    return n3 + n7;
                }
                if (foldingState.getStartOffset() < n3 && foldingState.getEndOffset() >= n6) {
                    System.out.println("not reached 1");
                } else {
                    if (foldingState.getStartOffset() < n3 && foldingState.getEndOffset() < n6) {
                        int n13 = SyntaxUtils.getXWithoutDrawingSyntaxLine(this, this.lineSegment, foldingState.getEndOffset() - n3, -1, token, 0);
                        if (n2 <= n13) {
                            return this.calculateOffset(n2, n4, foldingState.getEndOffset());
                        }
                        return n3 + n7;
                    }
                    System.out.println("not reached 2");
                }
            }
        }
        return Math.min(this.calculateOffset(n2, n4, n3), this.getLineStartOffset(n4) + this.getLineEndOffsetExcludeLineBreak(n4));
    }

    protected int calculateOffset(int n, int n2, int n3) {
        Token token;
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        TokenMarker tokenMarker = this.getTokenMarker();
        this.getLineText(n2, this.lineSegment);
        int n4 = n3 - this.getLineStartOffset(n2);
        char[] cArray = this.lineSegment.array;
        this.lineSegment.count = Math.min(this.lineSegment.count, this.getLineEndOffsetExcludeLineBreak(n2) + 1);
        int n5 = this.lineSegment.offset + n4;
        int n6 = this.lineSegment.count - n4;
        int n7 = 0;
        boolean bl = this.isBlockCaret();
        if (tokenMarker == null) {
            for (int i = 0; i < n6; ++i) {
                int n8;
                char c = cArray[i + n5];
                if (c == '\t') {
                    int n9 = n7 + this.getHorizontalOffset();
                    n8 = (int)this._painter.nextTabStop(n9, i) - n9;
                } else {
                    n8 = fontMetrics.charWidth(c);
                }
                if (bl ? n - n8 <= n7 : n - n8 / 2 <= n7) {
                    return n3 + i;
                }
                n7 += n8;
            }
            return n3 + n6 - 1;
        }
        if (this._painter.currentLineIndex == n2 && this._painter.currentLineTokens != null) {
            token = this._painter.currentLineTokens;
        } else {
            this._painter.currentLineIndex = n2;
            token = this._painter.currentLineTokens = tokenMarker.markTokens(this.lineSegment, n2);
        }
        int n10 = 0;
        Font font = this._painter.getFont();
        SyntaxStyleSchema syntaxStyleSchema = this.getStyles();
        byte by;
        while ((by = token.id) != 127) {
            fontMetrics = by == 0 || this._painter.getGraphics() == null ? this._painter.getFontMetrics() : syntaxStyleSchema.getStyle(by).getFontMetrics(font, this._painter.getGraphics());
            int n11 = token.length;
            for (int i = 0; i < n11; ++i) {
                int n12;
                int n13 = n5 + n10 + i;
                if (n13 >= cArray.length) continue;
                char c = cArray[n13];
                if (c == '\t') {
                    int n14 = n7 + this.getHorizontalOffset();
                    n12 = (int)this._painter.nextTabStop(n14, n10 + i) - n14;
                } else {
                    n12 = fontMetrics.charWidth(c);
                }
                if (bl ? n - n12 <= n7 : n - n12 / 2 <= n7) {
                    return n3 + n10 + i;
                }
                n7 += n12;
            }
            n10 += n11;
            token = token.next;
        }
        return n3 + Math.max(0, n10 - 1);
    }

    public int xyToOffset(int n, int n2) {
        int n3 = this.yToLine(n2);
        int n4 = this.xToColumn(n3, n);
        return this.modelPositionToOffset(this.viewToModelPosition(new CaretPosition(n3, n4)));
    }

    public final SyntaxDocument getDocument() {
        return this._document;
    }

    public void setDocument(SyntaxDocument syntaxDocument) {
        if (this._document == syntaxDocument) {
            return;
        }
        if (this._document != null) {
            this._document.removeDocumentListener(this._documentHandler);
            this._document.removeUndoableEditListener(this._undoableEditListener);
            if (this.getFoldingModel() instanceof DocumentListener) {
                this._document.removeDocumentListener((DocumentListener)((Object)this.getFoldingModel()));
            }
            if (this.getMarkerModel() instanceof DocumentListener) {
                this._document.removeDocumentListener((DocumentListener)((Object)this.getMarkerModel()));
            }
            if (this._document instanceof LazyLoadDocument) {
                ((LazyLoadDocument)this._document).removePageLoadingListener(this._documentHandler);
            }
        }
        SyntaxDocument syntaxDocument2 = this._document;
        this._document = syntaxDocument;
        if (this._document != null) {
            this._document.addDocumentListener(this._documentHandler);
            if (this.getFoldingModel() instanceof DocumentListener) {
                this._document.addDocumentListener((DocumentListener)((Object)this.getFoldingModel()));
            }
            if (this.getMarkerModel() instanceof DocumentListener) {
                this._document.addDocumentListener((DocumentListener)((Object)this.getMarkerModel()));
            }
            this._document.addUndoableEditListener(this._undoableEditListener);
            if (this._document instanceof LazyLoadDocument) {
                ((LazyLoadDocument)this._document).addPageLoadingListener(this._documentHandler);
            }
            this.select(0, 0);
            if (this._editorSize != null) {
                this._editorSize.reset();
            }
            this.updateScrollBars();
            this._painter.repaint();
        }
        this.firePropertyChange("document", syntaxDocument2, this._document);
    }

    public final TokenMarker getTokenMarker() {
        return this._document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this._document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLength();
    }

    public final int getLineCount() {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLineCount();
    }

    public int getVisualLineCount() {
        int n = this.getLineCount();
        return n -= ((DefaultFoldingModel)this.getFoldingModel()).getFoldedLinesCountBefore(this.getDocument().getLength() + 1);
    }

    public final int getLineNumber(int n) {
        return this._document.getLineNumber(n);
    }

    public int getLineStartOffset(int n) {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLineStartOffset(n);
    }

    public int getLineStartOffsetNoSpace(int n) {
        if (this._document == null) {
            return 0;
        }
        int n2 = this.getLineStartOffset(n);
        while (n2 < this._document.getLength()) {
            try {
                char c = this._document.getText(n2, 1).charAt(0);
                if (!Character.isSpaceChar(c)) break;
                ++n2;
            }
            catch (BadLocationException badLocationException) {
                LOGGER.warning(badLocationException.getLocalizedMessage());
            }
        }
        return n2;
    }

    public int getLineEndOffset(int n) {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLineEndOffset(n);
    }

    public int getLineLength(int n) {
        if (this._document == null) {
            return 0;
        }
        return this._document.getLineLength(n);
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.exportText(this.getRawText(), stringBuffer);
        return stringBuffer.toString();
    }

    public void setText(String string) {
        if (string == null) {
            this.setRawText("");
            this.setLineBreakStyle(-2);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.importText(string.substring(0, Math.min(1000, string.length())), stringBuffer);
            if (n == 2) {
                stringBuffer = new StringBuffer();
                int n2 = CodeEditor.getCodeEditorDefaultLineBreakStyle();
                n = SyntaxDocument.convertLineBreaks(string, stringBuffer, TextUtils.getLineBreak(n2 != 2 ? n2 : 1));
                this.setLineBreakStyle(n);
                this.setRawText(stringBuffer.toString());
            } else if (string.length() < 1000) {
                this.setLineBreakStyle(n);
                this.setRawText(stringBuffer.toString());
            } else if (n != this.getLineBreakStyle()) {
                stringBuffer = new StringBuffer();
                n = this.importText(string, stringBuffer);
                this.setLineBreakStyle(n);
                this.setRawText(stringBuffer.toString());
            } else {
                this.setRawText(string);
            }
        }
    }

    public void append(String string) {
        SyntaxDocument syntaxDocument = this.getDocument();
        if (syntaxDocument != null) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                int n = this.importText(string, stringBuffer);
                if (n != -2 && n != this.getLineBreakStyle()) {
                    this.setLineBreakStyle(-1);
                }
                syntaxDocument.insertString(syntaxDocument.getLength(), stringBuffer.toString(), null);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.warning(badLocationException.getLocalizedMessage());
            }
        }
    }

    public final String getText(int n, int n2) {
        try {
            return this._document.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
            return "";
        }
    }

    public final void getText(int n, int n2, Segment segment) {
        try {
            if (n2 > 0) {
                this._document.getText(n, n2, segment);
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
            segment.count = 0;
            segment.offset = 0;
        }
    }

    protected int exportText(String string, StringBuffer stringBuffer) {
        int n = this.getLineBreakStyle();
        String string2 = TextUtils.getLineBreak(n);
        return SyntaxDocument.convertLineBreaks(string, stringBuffer, string2);
    }

    protected int importText(String string, StringBuffer stringBuffer) {
        return SyntaxDocument.convertLineBreaks(string, stringBuffer);
    }

    public String getRawText() {
        try {
            return this._document.getText(0, this._document.getLength());
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
            return null;
        }
    }

    public void setRawText(String string) {
        try {
            this.getFoldingModel().removeAllFoldingSpans();
            TokenMarker tokenMarker = this.getDocument() == null ? null : this.getDocument().getTokenMarker();
            DocumentListener[] documentListenerArray = this.getDocument() == null ? null : this.getDocument().getDocumentListeners();
            DocumentFilter documentFilter = this.getDocument() == null ? null : this.getDocument().getDocumentFilter();
            Dictionary<Object, Object> dictionary = this.getDocument() == null ? null : this.getDocument().getDocumentProperties();
            UndoableEditListener[] undoableEditListenerArray = this.getDocument() == null ? null : this.getDocument().getUndoableEditListeners();
            this.setDocument(new SyntaxDocument());
            this.getDocument().putProperty("nonwordDelimiters", "_");
            if (tokenMarker != null) {
                this.getDocument().setTokenMarker(tokenMarker);
            }
            if (documentListenerArray != null) {
                for (DocumentListener eventListener : documentListenerArray) {
                    this.getDocument().removeDocumentListener(eventListener);
                    this.getDocument().addDocumentListener(eventListener);
                }
            }
            if (documentFilter != null) {
                this.getDocument().setDocumentFilter(documentFilter);
            }
            if (dictionary != null) {
                this.getDocument().setDocumentProperties(dictionary);
            }
            this.getDocument().insertString(0, string, null);
            if (undoableEditListenerArray != null) {
                for (EventListener eventListener : undoableEditListenerArray) {
                    if (eventListener instanceof SyntaxDocument.MyUndoableEditListener) continue;
                    this.getDocument().removeUndoableEditListener((UndoableEditListener)eventListener);
                    this.getDocument().addUndoableEditListener((UndoableEditListener)eventListener);
                }
            }
            this.select(0);
            this.discardAllEdits();
            this.getCaretModel().setOffset(0);
            this.getMarginArea().invalidate();
            this.resetContentSize();
            this.doLayout();
            this.getMarginArea().doLayout();
            this.updateScrollBars();
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
        }
    }

    public final String getLineText(int n) {
        int n2;
        int n3 = this.getLineStartOffset(n);
        if (n3 != -1 && (n2 = this.getLineEndOffset(n)) >= n3) {
            return this.getText(n3, n2 - n3 + 1);
        }
        return "";
    }

    public final boolean getLineText(int n, Segment segment) {
        int n2;
        if (n >= 0 && n < this.getLineCount() && (n2 = this.getLineStartOffset(n)) != -1) {
            this.getText(n2, this.getLineEndOffset(n) - n2 + 1, segment);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLineText(int n, String string) {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        int n2 = this.getLineStartOffset(n);
        int n3 = this.getLineEndOffset(n);
        try {
            this._document.remove(n2, n3 - n2);
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = this.importText(string, stringBuffer);
            if (n4 != -2 && n4 != this.getLineBreakStyle()) {
                this.setLineBreakStyle(-1);
            }
            this._document.insertString(n2, stringBuffer.toString(), null);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    public final int getSelectionStart() {
        return this.getSelectionModel().getSelectionStart() < this.getSelectionModel().getSelectionEnd() ? this.getSelectionModel().getSelectionStart() : this.getSelectionModel().getSelectionEnd();
    }

    public int getSelectionStart(int n) {
        if (this.getSelectionModel().isColumnSelectionMode()) {
            Element element = this._document.getDefaultRootElement();
            int n2 = this.getSelectionModel().getSelectionEndViewPosition() == null || this.getSelectionModel().getSelectionStartViewPosition() == null ? (this.getSelectionModel().getSelectionStart() > this.getSelectionModel().getSelectionEnd() ? this.getCaretModel().getViewPosition().column : this.offsetToViewPosition((int)this.getSelectionStart()).column) : Math.min(this.getSelectionModel().getSelectionStartViewPosition().column, this.getSelectionModel().getSelectionEndViewPosition().column);
            Element element2 = element.getElement(n);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset() - 1;
            return Math.min(n4, n3 + this.getCorrespondingColumn(n2, this.getSelectionStartLine(), n));
        }
        if (n == this.getSelectionStartLine()) {
            return this.getSelectionStart();
        }
        return this.getLineStartOffset(n);
    }

    public final int getSelectionStartLine() {
        return this.getSelectionModel().getSelectionStartLine() <= this.getSelectionModel().getSelectionEndLine() ? this.getSelectionModel().getSelectionStartLine() : this.getSelectionModel().getSelectionEndLine();
    }

    public final void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public final void surroundSelection(String string, String string2) {
        String string3 = this.getSelectedText();
        if (string3 != null) {
            this.setSelectedText(string + string3 + string2);
        } else {
            this.setSelectedText(string + string2);
        }
    }

    public void selectWord() {
        int n = this.getCaretModel().getModelPosition().line;
        int n2 = this.getLineStartOffset(n);
        int n3 = this.getCaretModel().getOffset() - n2;
        if (this.getLineLength(n) == 0) {
            return;
        }
        String string = this.getLineText(n);
        String string2 = (String)this.getDocument().getProperty("nonwordDelimiters");
        if (n3 == this.getLineLength(n)) {
            --n3;
        }
        if (string.length() > 0) {
            int n4 = TextUtils.findWordEnd(string, n3, string2);
            int n5 = TextUtils.findWordStart(string, n3 - (n4 == n3 ? 1 : 0), string2);
            this.getSelectionModel().setSelection(n2 + n5, n2 + n4);
        }
    }

    public void selectWord(String string) {
        int[] nArray = this.getCurrentWordBounds(string);
        this.select(nArray[0], nArray[1]);
    }

    public int[] getCurrentWordBounds() {
        return this.getCurrentWordBounds((String)this.getDocument().getProperty("nonwordDelimiters"));
    }

    public String getLeftWordPart() {
        return this.getLeftWordPart((String)this.getDocument().getProperty("nonwordDelimiters"));
    }

    public String getLeftWordPart(String string) {
        int n = this.getCaretModel().getOffset();
        int n2 = this.getCaretModel().getModelPosition().line;
        int n3 = this.getLineStartOffset(n2);
        int n4 = 0;
        String string2 = this.getLineText(this.getCaretModel().getModelPosition().line);
        if ((n -= n3) > 0) {
            n4 = TextUtils.findWordStart(string2, n, string);
        }
        return string2.substring(n4, n);
    }

    public int[] getCurrentWordBounds(String string) {
        int n = this.getCaretModel().getOffset();
        int n2 = this.getCaretModel().getModelPosition().line;
        int n3 = this.getLineStartOffset(n2);
        int n4 = 0;
        String string2 = this.getLineText(this.getCaretModel().getModelPosition().line);
        if ((n -= n3) == 0) {
            n4 = n3;
        } else if (n > 0) {
            n4 = n3 + TextUtils.findWordStart(string2, n, string);
        }
        if (n < string2.length()) {
            n = TextUtils.findWordEnd(string2, n, string);
        }
        return new int[]{n4, n += n3};
    }

    public String getCurrentWord() {
        int[] nArray = this.getCurrentWordBounds();
        return this.getText(nArray[0], nArray[1] - nArray[0]);
    }

    public String getCurrentWord(String string) {
        int[] nArray = this.getCurrentWordBounds(string);
        return this.getText(nArray[0], nArray[1] - nArray[0]);
    }

    public void selectToMatchingBracket() {
        int n = this.getCaretModel().getOffset();
        int n2 = -1;
        try {
            n2 = TextUtils.findMatchingBracket(this._document, n - 1);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
        }
        if (n2 != -1 && n2 != n) {
            if (n2 > n) {
                this.select(n, n2 + 1);
            } else {
                this.select(n2, n);
            }
        } else {
            this.selectBlock();
        }
    }

    public void selectBlock() {
        int n;
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        String[] stringArray = new String[]{"<", "(", "{", "[", ">", ")", "}", "]"};
        String string = "<({[";
        String string2 = ">)}]";
        if (!(n2 != 0 || this.getDocumentLength() > 0 && string.contains(this.getText(n2, 1)))) {
            PortingUtils.notifyUser();
            return;
        }
        int n4 = 1;
        String string3 = null;
        String string4 = null;
        ++n2;
        while (n2 > 0) {
            n2 = this.getDocument().findPrevious(stringArray, n2, 0, false, false);
            try {
                if (this._document.isInCommentOrLiteral(n2)) {
                    --n2;
                    continue;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            if (n2 < 0) {
                return;
            }
            char c = this.getText(n2, 1).charAt(0);
            n = string.indexOf(c);
            if (n != -1) {
                if (--n4 == 0) {
                    string3 = "" + c;
                    string4 = "" + string2.charAt(n);
                    break;
                }
            } else if (string2.indexOf(c) != -1 && n2 < this.getSelectionStart()) {
                ++n4;
            }
            --n2;
        }
        if (string3 == null) {
            PortingUtils.notifyUser();
            return;
        }
        n4 = 1;
        String[] stringArray2 = new String[]{string3, string4};
        n = this.getDocumentLength();
        if (n3 <= n2) {
            n3 = n2 + 1;
        }
        while (n3 < n) {
            n3 = this.getDocument().findNext(stringArray2, n3, n, false);
            try {
                if (this._document.isInCommentOrLiteral(n3)) {
                    ++n3;
                    continue;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (n3 < 0) {
                return;
            }
            char c = this.getText(n3, 1).charAt(0);
            if (c == string4.charAt(0)) {
                if (--n4 == 0) {
                    ++n3;
                    break;
                }
            } else if (c == string3.charAt(0)) {
                ++n4;
            }
            ++n3;
        }
        this.select(n2, n3);
    }

    public void gotoEndOfLine() {
        int n = this.viewToModelLine(this.getCaretModel().getViewPosition().line + 1) - 1;
        CaretPosition caretPosition = new CaretPosition(n, this.getLineEndOffsetExcludeLineBreak(n));
        this.select(this.modelPositionToOffset(caretPosition));
    }

    public void commentLine(int n) {
        String string = this.getLineText(n);
        int n2 = this.getLineStartOffset(n);
        if (string.startsWith("//")) {
            this.select(n2, n2 + 2);
            this.setSelectedText("");
        } else {
            this.select(n2);
            this.setSelectedText("//");
        }
    }

    public void commentLine() {
        int n;
        int n2 = this.getLineNumber(this.getSelectionStart());
        if (n2 == (n = this.getLineNumber(this.getSelectionEnd()))) {
            this.commentLine(this.getCaretModel().getModelPosition().line);
        } else {
            for (int i = n2; i <= n; ++i) {
                this.commentLine(i);
            }
        }
    }

    public void indentSelectedLines() {
        this.indentLinesBetween(this.getSelectionStartLine(), this.getSelectionEndLine());
    }

    public void indentLinesBetween(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.indentLine(i);
        }
    }

    public void indentLine(int n) {
        String string = this.getLineText(n).trim();
        if (n != 0) {
            String string2 = this.getLineText(n - 1);
            String string3 = TextUtils.getLeadingWhitespace(string2);
            if (!string.startsWith("}") && (string2.endsWith("{") || string2.endsWith(":"))) {
                string3 = string3 + '\t';
            } else if (string.indexOf(125) != -1 && string3.length() >= 1) {
                string3 = string3.substring(0, string3.length() - 1);
            } else if ((string2.endsWith("/**") || string2.endsWith("/*")) && string.startsWith("*")) {
                string3 = string3 + " ";
            } else if (string2.endsWith("*/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string = string3 + string;
        }
        this.selectLine(n);
        this.setSelectedText(string);
    }

    public void selectLine(int n) {
        int n2 = this.getLineStartOffset(n);
        int n3 = this.getLineEndOffset(n) + 1;
        if (n3 > this.getDocumentLength()) {
            n3 = this.getDocumentLength();
        }
        this.select(n2, n3);
        this.getCaretModel().setOffset(n2);
    }

    public void selectLines(int n, int n2) {
        int n3 = this.getLineEndOffset(n2) + 1;
        this.select(this.getLineStartOffset(n), n3);
        this.getCaretModel().setOffset(n3);
    }

    public final int getSelectionEnd() {
        return this.getSelectionModel().getSelectionEnd() > this.getSelectionModel().getSelectionStart() ? this.getSelectionModel().getSelectionEnd() : this.getSelectionModel().getSelectionStart();
    }

    public int getSelectionEnd(int n) {
        if (this.getSelectionModel().isColumnSelectionMode()) {
            int n2 = this.getSelectionModel().getSelectionEndViewPosition() == null || this.getSelectionModel().getSelectionStartViewPosition() == null ? (this.getSelectionModel().getSelectionStart() < this.getSelectionEnd() ? this.getCaretModel().getViewPosition().column : this.offsetToViewPosition((int)this.getSelectionEnd()).column) : Math.max(this.getSelectionModel().getSelectionStartViewPosition().column, this.getSelectionModel().getSelectionEndViewPosition().column);
            int n3 = this.getLineStartOffset(n);
            int n4 = this.getLineEndOffset(n);
            return Math.min(n4, n3 + this.getCorrespondingColumn(n2, this.getSelectionEndLine(), n));
        }
        if (n == this.getSelectionEndLine()) {
            return this.getSelectionEnd();
        }
        return this.getLineEndOffset(n);
    }

    public final int getSelectionEndLine() {
        return this.getSelectionModel().getSelectionStartLine() <= this.getSelectionModel().getSelectionEndLine() ? this.getSelectionModel().getSelectionEndLine() : this.getSelectionModel().getSelectionStartLine();
    }

    public final void setSelectionEnd(int n) {
        this.getSelectionModel().setSelection(this.getSelectionStart(), n);
        this.select(this.getSelectionStart(), n);
    }

    public int getLeadSelectionOffset() {
        int n = this.getCaretModel().getOffset();
        if (!this.getSelectionModel().hasSelection()) {
            return n;
        }
        if (n == this.getSelectionModel().getSelectionEnd()) {
            return this.getSelectionModel().getSelectionStart();
        }
        return this.getSelectionModel().getSelectionEnd();
    }

    public int getAnchorSelectionOffset() {
        int n = this.getCaretModel().getOffset();
        if (!this.getSelectionModel().hasSelection()) {
            return n;
        }
        if (n == this.getSelectionModel().getSelectionStart()) {
            return this.getSelectionModel().getSelectionEnd();
        }
        return this.getSelectionModel().getSelectionStart();
    }

    private CaretPosition getMarkViewPosition() {
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        SelectionModel selectionModel = this.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return caretPosition;
        }
        if (JideSwingUtilities.equals(caretPosition, selectionModel.getSelectionStartViewPosition())) {
            return selectionModel.getSelectionEndViewPosition();
        }
        return selectionModel.getSelectionStartViewPosition();
    }

    public final int getMarkPosition() {
        return this.getAnchorSelectionOffset();
    }

    public final void select(int n) {
        this.select(n, n);
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength(), false);
    }

    public final void selectNone() {
        this.select(this.getCaretModel().getOffset(), this.getCaretModel().getOffset());
    }

    public void select(int n, int n2) {
        this.select(n, n2, this._alwaysScrollCaret || this.getAutoscrolls());
    }

    public void select(int n, int n2, boolean bl) {
        this.select(n, n2, bl, false);
    }

    void select(int n, int n2, boolean bl, boolean bl2) {
        this.getSelectionModel().setSelection(n, n2);
        this.getCaretModel().setOffset(n2);
        if (bl) {
            this.scrollToCaret(bl2);
        }
    }

    void select(CaretPosition caretPosition, CaretPosition caretPosition2) {
        this.select(caretPosition, caretPosition2, this._alwaysScrollCaret || this.getAutoscrolls());
    }

    void select(CaretPosition caretPosition, CaretPosition caretPosition2, boolean bl) {
        if (caretPosition == null || caretPosition2 == null) {
            return;
        }
        this.getSelectionModel().setSelection(caretPosition, caretPosition2);
        this.getCaretModel().setViewPosition(caretPosition2);
        if (bl) {
            if (this.getSelectionStart() == this.getSelectionEnd()) {
                this.setMagicCaretPosition(-1);
            }
            boolean bl2 = false;
            if (this._editorSize._caretMaxWidth) {
                bl2 = true;
            } else {
                int n = this.columnToX(caretPosition2.line, caretPosition2.column);
                int n2 = n - this.getHorizontalOffset();
                if (n2 > this.getContentSize().width) {
                    bl2 = true;
                }
            }
            if (bl2) {
                this._editorSize._recalculateNeeded = true;
                this.updateScrollBars();
            }
            this.scrollToViewPosition(caretPosition2, caretPosition);
        }
    }

    /*
     * WARNING - void declaration
     */
    String getSelectedVisibleText() {
        FoldingSpan[] foldingSpanArray;
        if (this.getSelectionModel().isColumnSelectionMode()) {
            return this.getSelectedText();
        }
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        FoldingModel foldingModel = this.getFoldingModel();
        if (foldingModel != null && (foldingSpanArray = foldingModel.getFoldingSpans()) != null) {
            Arrays.sort(foldingSpanArray, new Comparator<FoldingSpan>(){

                @Override
                public int compare(FoldingSpan foldingSpan, FoldingSpan foldingSpan2) {
                    if (foldingSpan == null && foldingSpan2 == null) {
                        return 0;
                    }
                    if (foldingSpan == null) {
                        return -1;
                    }
                    if (foldingSpan2 == null) {
                        return 1;
                    }
                    if (foldingSpan.getStartOffset() < foldingSpan2.getStartOffset()) {
                        return -1;
                    }
                    if (foldingSpan.getStartOffset() > foldingSpan2.getStartOffset()) {
                        return 1;
                    }
                    if (foldingSpan.getEndOffset() < foldingSpan2.getEndOffset()) {
                        return -1;
                    }
                    if (foldingSpan.getEndOffset() > foldingSpan2.getEndOffset()) {
                        return 1;
                    }
                    return 0;
                }
            });
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            FoldingSpan[] object = foldingSpanArray;
            int n3 = object.length;
            for (int i = 0; i < n3; ++i) {
                FoldingSpan foldingSpan = object[i];
                if (foldingSpan.isValid() && !foldingSpan.isExpanded() && foldingSpan.getStartOffset() >= n && foldingSpan.getStartOffset() < n2) {
                    if (arrayList.size() > 0 && foldingSpan.getStartOffset() < (Integer)arrayList.get(arrayList.size() - 1)) continue;
                    arrayList.add(foldingSpan.getStartOffset());
                    arrayList.add(foldingSpan.getEndOffset());
                    continue;
                }
                if (foldingSpan.getStartOffset() >= n2) break;
            }
            if (arrayList.size() > 0) {
                void var6_8;
                arrayList.add(0, n);
                arrayList.add(n2);
                String string = "";
                for (n3 = 0; n3 < arrayList.size(); n3 += 2) {
                    Integer n4 = (Integer)arrayList.get(n3);
                    Integer n5 = (Integer)arrayList.get(n3 + 1);
                    if (n4 >= n5) continue;
                    String string2 = (String)var6_8 + this.getText(n4, n5 - n4);
                }
                return var6_8;
            }
        }
        return this.getText(n, n2 - n);
    }

    public final String getSelectedText() {
        return this.getSelectionModel().getSelectedText();
    }

    public void setSelectedText(String string) {
        if (!this._editable) {
            throw new InternalError("Text component read only");
        }
        try {
            if (string != null) {
                int n;
                if (this.getSelectionModel().hasSelection()) {
                    n = this.getSelectionStart();
                    int n2 = this.getSelectionEnd();
                    if (n2 >= this.getDocumentLength()) {
                        n2 = this.getDocumentLength();
                    }
                    this.getSelectionModel().clearSelection();
                    this._document.remove(n, n2 - n);
                    this._document.insertString(n, string, null);
                } else {
                    CaretPosition caretPosition = this.getCaretModel().getModelPosition();
                    int n3 = this.getLineEndOffset(caretPosition.line);
                    CaretPosition caretPosition2 = this.offsetToModelPosition(n3);
                    if (caretPosition.column > caretPosition2.column) {
                        n = n3;
                        this._document.insertString(n, TextUtils.createWhiteSpace(caretPosition.column - caretPosition2.column, this.getTabSize(), this.isReplaceTabWithSpace(), caretPosition2.column) + string, null);
                    } else {
                        n = this.getCaretModel().getOffset();
                        this._document.insertString(n, string, null);
                    }
                }
                FoldingState foldingState = new FoldingState(this, n);
                do {
                    if (foldingState.getCurrentFold() != null) {
                        this.getFoldingModel().expandFoldingSpan(foldingState.getCurrentFold());
                    }
                    foldingState.advance();
                } while (foldingState.getStartOffset() < n + string.length() && foldingState.getEndOffset() < this.getDocumentLength());
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
            throw new InternalError("Cannot replace selection");
        }
    }

    public final boolean isEditable() {
        return this._editable;
    }

    public final void setEditable(boolean bl) {
        Action action;
        boolean bl2 = this._editable;
        if (bl2 != bl) {
            this._editable = bl;
            this.firePropertyChange(PROPERTY_EDITABLE, bl2, bl);
        }
        if ((action = this.getAction("cut")) != null) {
            action.setEnabled(this.isEditable() && this.isEnabled());
        }
        if ((action = this.getAction("paste")) != null) {
            action.setEnabled(this.isEditable() && this.isEnabled());
        }
        if ((action = this.getAction("delete")) != null) {
            action.setEnabled(this.isEditable() && this.isEnabled());
        }
    }

    public final int getMagicCaretPosition() {
        return this._magicCaret;
    }

    public final void setMagicCaretPosition(int n) {
        this._magicCaret = n;
    }

    public void overwriteSetSelectedText(String string) {
        if (!this._overwrite || this.getSelectionStart() != this.getSelectionEnd()) {
            this.setSelectedText(string);
            return;
        }
        int n = this.getCaretModel().getOffset();
        int n2 = this.getLineEndOffset(this.getCaretModel().getModelPosition().line);
        if (n2 - n < string.length()) {
            this.setSelectedText(string);
            return;
        }
        try {
            this._document.remove(n, string.length());
            this._document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
        }
    }

    public final boolean isOverwriteEnabled() {
        return this._overwrite;
    }

    public final void setOverwriteEnabled(boolean bl) {
        boolean bl2 = this._overwrite;
        if (bl2 != bl) {
            this._overwrite = bl;
            this._painter.invalidateSelectedLines();
            this.firePropertyChange(PROPERTY_OVERWRITE_ENABLED, bl2, bl);
        }
    }

    public final boolean isSelectionRectangular() {
        return this.getSelectionModel().isColumnSelectionMode();
    }

    public final void setSelectionRectangular(boolean bl) {
        this.getSelectionModel().setColumnSelectionMode(bl);
        this._painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public void undo() {
        this._document.undo();
        this.updateUndoRedoActions();
    }

    public void redo() {
        this._document.redo();
        this.updateUndoRedoActions();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._defaultSettings != null) {
            this._defaultSettings.addPropertyChangeListener(this);
        }
        if (this._localSettings != null) {
            this._localSettings.addPropertyChangeListener(this);
        }
        this.blinkCaret();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._defaultSettings != null) {
            this._defaultSettings.removePropertyChangeListener(this);
        }
        if (this._localSettings != null) {
            this._localSettings.removePropertyChangeListener(this);
        }
        if (this._caretTimer != null) {
            this._caretTimer.stop();
            this._caretTimer = null;
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this._searchable.isPopupVisible()) {
            super.processKeyEvent(keyEvent);
        } else {
            if (this.getInputHandler() != null) {
                switch (keyEvent.getID()) {
                    case 400: {
                        this.getInputHandler().keyTyped(keyEvent);
                        break;
                    }
                    case 401: {
                        this.getInputHandler().keyPressed(keyEvent);
                        break;
                    }
                    case 402: {
                        this.getInputHandler().keyReleased(keyEvent);
                    }
                }
            }
            if (!keyEvent.isConsumed()) {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    protected void updateBracketHighlight(int n) {
        try {
            int n2 = TextUtils.findMatchingBracket(this._document, n - 1);
            if (n2 != -1) {
                this.bracketLine = this.getLineNumber(n2);
                this.bracketPosition = n2 - this.getLineStartOffset(this.bracketLine);
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(this._document.getDefaultRootElement());
        this._editorSize.documentChanged(documentEvent);
        int n = elementChange == null ? 0 : (elementChange instanceof LazyLoadDocument.LazyLoadElementChange ? ((LazyLoadDocument.LazyLoadElementChange)elementChange).getInsertedLineCount() : elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length);
        int n2 = this.offsetToViewPosition((int)documentEvent.getOffset()).line;
        if (n == 0) {
            this._painter.invalidateLine(n2);
        } else if (n2 < this._firstLine) {
            this.setFirstLine(this._firstLine + n);
        } else {
            this._painter.invalidateLineRange(n2, this.getFirstLine() + this.getVisibleLines());
        }
        this.updateScrollBars();
        if (this.isAutoInspecting()) {
            this.inspectCode(documentEvent);
        }
        if (this.getMarginArea() != null) {
            this.getMarginArea().invalidate();
            this.getMarginArea().repaint();
        }
    }

    public boolean isBlink() {
        return this._blink;
    }

    public void setBlink(boolean bl) {
        this._blink = bl;
    }

    public void pauseBlink() {
        this.setBlink(true);
        if (this._caretTimer != null) {
            this._caretTimer.stop();
        }
    }

    public boolean isTabAlignment() {
        return this._tabAlignment;
    }

    public void setTabAlignment(boolean bl) {
        this._tabAlignment = bl;
    }

    public int getHorizontalScrollBarPolicy() {
        return this._horizontalScrollBarPolicy;
    }

    public void setHorizontalScrollBarPolicy(int n) {
        this._horizontalScrollBarPolicy = n;
    }

    public int getVerticalScrollBarPolicy() {
        return this._verticalScrollBarPolicy;
    }

    public void setVerticalScrollBarPolicy(int n) {
        this._verticalScrollBarPolicy = n;
    }

    public boolean isShowToolTipOverMarkedText() {
        return this._showToolTipOverMarkedText;
    }

    public void setShowToolTipOverMarkedText(boolean bl) {
        this._showToolTipOverMarkedText = bl;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String string) {
        this.setFileName(string, "UTF-8");
    }

    public void setFileName(String string, String string2) {
        this._fileName = string;
        this.getFoldingModel().removeAllFoldingSpans();
        if (this._fileName != null) {
            TokenMarker tokenMarker;
            int n = this.getLineCount();
            TokenMarker tokenMarker2 = tokenMarker = this._document == null ? null : this._document.getTokenMarker();
            if (!(this._document instanceof LazyLoadDocument)) {
                LazyLoadDocument lazyLoadDocument = this.createLazyLoadDocument();
                this.setDocument(lazyLoadDocument);
            }
            if (this._document instanceof LazyLoadDocument) {
                ((LazyLoadDocument)this._document).setFileName(this._fileName, string2);
            }
            if (tokenMarker != null) {
                if (this._document.getTokenMarker() != tokenMarker) {
                    this._document.setTokenMarker(tokenMarker);
                } else {
                    tokenMarker.deleteLines(0, n);
                    tokenMarker.insertLines(0, this.getLineCount());
                    this._document.tokenizeLines();
                }
            }
            this.setTokenMarker(tokenMarker == null ? this._document.getTokenMarker() : tokenMarker);
        } else {
            this.setRawText("");
        }
        this.select(0);
        this.discardAllEdits();
        this.getMarginArea().invalidate();
        this.getCaretModel().setOffset(0);
        this.resetContentSize();
        this.doLayout();
        this.getMarginArea().doLayout();
        this.updateScrollBars();
    }

    protected LazyLoadDocument createLazyLoadDocument() {
        return new LazyLoadDocument();
    }

    public boolean exportToOutputStream(OutputStream outputStream) throws IOException, BadLocationException {
        OutputStreamWriter outputStreamWriter = this.createOutputStreamWriter(outputStream);
        if (this.getDocument() instanceof LazyLoadDocument) {
            return ((LazyLoadDocument)this.getDocument()).writeToOutputStream(outputStreamWriter);
        }
        outputStreamWriter.write(this.getText());
        outputStreamWriter.flush();
        return true;
    }

    protected OutputStreamWriter createOutputStreamWriter(OutputStream outputStream) {
        return new OutputStreamWriter(outputStream);
    }

    public boolean isContentVisible() {
        return this._contentVisible;
    }

    public void setContentVisible(boolean bl) {
        this._contentVisible = bl;
    }

    public boolean isDelayContentsOnLoading() {
        return this._delayContentsOnLoading;
    }

    public void setDelayContentsOnLoading(boolean bl) {
        this._delayContentsOnLoading = bl;
    }

    public boolean isChangePromptDialogPosition() {
        return this._changePromptDialogPosition;
    }

    public void setChangePromptDialogPosition(boolean bl) {
        this._changePromptDialogPosition = bl;
    }

    public boolean isIndentOnPasting() {
        return this._indentOnPasting;
    }

    public void setIndentOnPasting(boolean bl) {
        this._indentOnPasting = bl;
    }

    public boolean isCopyVisibleTextOnly() {
        return this._copyVisibleTextOnly;
    }

    public void setCopyVisibleTextOnly(boolean bl) {
        this._copyVisibleTextOnly = bl;
    }

    public boolean isSkipsEmptyLinesOnLineComments() {
        return this._skipsEmptyLinesOnLineComments;
    }

    public void setSkipsEmptyLinesOnLineComments(boolean bl) {
        this._skipsEmptyLinesOnLineComments = bl;
    }

    private Timer createRepaintTimer() {
        return new Timer(200, new AbstractAction(){
            private static final long serialVersionUID = -5539461235451859382L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeEditor.this.setContentVisible(true);
                CodeEditor.this.repaint();
            }
        });
    }

    protected void pageLoadFailedHandling(PageLoadEvent pageLoadEvent) {
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean getFocusCycleRoot() {
        return true;
    }

    private void select(int n, int n2, int n3) {
        int n4 = this.getMarkPosition();
        if (this._lineSelection >= 0) {
            int n5 = this.getLineStartOffset(this.viewToModelLine(this._lineSelection));
            int n6 = this.getLineStartOffset(this.viewToModelLine(this._lineSelection + 1));
            if (n <= n5) {
                n4 = n6;
                n = this.getLineStartOffset(this.viewToModelLine(this.offsetToViewPosition((int)n).line));
            } else if (n >= n6) {
                n4 = n5;
                int n7 = this.offsetToViewPosition((int)n).line;
                n = n7 < this.getVisualLineCount() - 1 ? this.getLineStartOffset(this.viewToModelLine(n7 + 1)) : this.getDocumentLength();
            } else {
                n = n4 == n5 ? n6 : n5;
            }
        }
        if (this.getSelectionModel().isColumnSelectionMode()) {
            this.select(this.getMarkViewPosition(), new CaretPosition(n2, n3));
        } else {
            this.select(n4, n);
        }
    }

    protected boolean isColumnSelectionMode(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) != 0;
    }

    public void scrollUpPage() {
        this.setFirstLine(this.getFirstLine() - this.getVisibleLines() + (this.lastLinePartial ? 1 : 0));
    }

    public void scrollDownPage() {
        this.setFirstLine(this.getFirstLine() + this.getVisibleLines() - (this.lastLinePartial ? 1 : 0));
    }

    public MarginArea getMarginArea() {
        return this._marginArea;
    }

    public void setMarginArea(MarginArea marginArea) {
        this._marginArea = marginArea;
    }

    public void setLineNumberVisible(boolean bl) {
        this._lineNumberMargin.setVisible(bl);
    }

    public boolean isLineNumberVisible() {
        return this._lineNumberMargin.isVisible();
    }

    public RowNumberMargin getLineNumberMargin() {
        return this._lineNumberMargin;
    }

    public CaretModel getCaretModel() {
        if (this._caretModel == null) {
            this._caretModel = this.createCaretModel();
            this._caretModel.addCaretListener(this);
        }
        return this._caretModel;
    }

    private DefaultCaretModel createCaretModel() {
        return new DefaultCaretModel(this);
    }

    public SelectionModel getSelectionModel() {
        if (this._selectionModel == null) {
            this._selectionModel = this.createSelectionModel();
            this._selectionModel.addSelectionListener(this);
        }
        return this._selectionModel;
    }

    @Override
    public void selectionChanged(SelectionEvent selectionEvent) {
        if (selectionEvent.getOldSelectionStart() != selectionEvent.getNewSelectionStart() || selectionEvent.getOldSelectionEnd() != selectionEvent.getNewSelectionEnd()) {
            if (selectionEvent.getNewSelectionEnd() == selectionEvent.getNewSelectionStart() && selectionEvent.getOldSelectionEnd() == selectionEvent.getOldSelectionStart()) {
                return;
            }
            this._painter.invalidateRange(selectionEvent.getOldSelectionStart(), selectionEvent.getOldSelectionEnd());
            this._painter.invalidateRange(selectionEvent.getNewSelectionStart(), selectionEvent.getNewSelectionEnd());
            try {
                Clipboard clipboard = this.getToolkit().getSystemSelection();
                if (clipboard != null) {
                    String string = this.getSelectedText();
                    if (string == null) {
                        string = "";
                    }
                    if (!"".equals(string)) {
                        this._ownSystemSelection = true;
                        clipboard.setContents(new StringSelection(string), this.getClipboardOwner());
                    } else if (this._ownSystemSelection) {
                        clipboard.setContents(new StringSelection(string), this.getClipboardOwner());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ClipboardOwner getClipboardOwner() {
        if (this._clipboardOwner == null) {
            this._clipboardOwner = this.createClipboardOwner();
        }
        return this._clipboardOwner;
    }

    protected ClipboardOwner createClipboardOwner() {
        return new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                CodeEditor.this._ownSystemSelection = false;
            }
        };
    }

    @Override
    public void caretUpdated(CaretEvent caretEvent) {
        if (caretEvent.getType() == 1) {
            int n = caretEvent.getOldPosition().line;
            this._painter.invalidateLineRange(n, n);
            int n2 = caretEvent.getNewPosition().line;
            this._painter.invalidateLineRange(n2, n2);
        } else {
            int n = this.modelToViewPosition((CaretPosition)caretEvent.getOldPosition()).line;
            this._painter.invalidateLineRange(n, n);
            int n3 = this.modelToViewPosition((CaretPosition)caretEvent.getNewPosition()).line;
            this._painter.invalidateLineRange(n3, n3);
        }
        if (this.isBracketHighlightVisible()) {
            if (this.bracketLine != -1) {
                this._painter.invalidateLine(this.modelToViewPosition((CaretPosition)new CaretPosition((int)this.bracketLine, (int)this.bracketPosition)).line);
            }
            this.updateBracketHighlight(this.modelPositionToOffset(caretEvent.getNewPosition()));
            if (this.bracketLine != -1) {
                this._painter.invalidateLine(this.modelToViewPosition((CaretPosition)new CaretPosition((int)this.bracketLine, (int)this.bracketPosition)).line);
            }
            this._marginArea.repaint();
        }
        ((DefaultFoldingModel)this.getFoldingModel()).resetCaretPosition();
        if (!this.isVirtualSpaceAllowed() && caretEvent.getOldPosition().line == caretEvent.getNewPosition().line && caretEvent.getType() == 1) {
            this.setMagicCaretPosition(this.columnToX(caretEvent.getNewPosition().line, caretEvent.getNewPosition().column));
        }
    }

    protected SelectionModel createSelectionModel() {
        return new DefaultSelectionModel(this);
    }

    public CaretPosition viewToModelPosition(CaretPosition caretPosition) {
        FoldingSpan foldingSpan;
        if (caretPosition.line == 0 && caretPosition.column == 0) {
            return new CaretPosition(0, 0);
        }
        DefaultFoldingModel defaultFoldingModel = (DefaultFoldingModel)this.getFoldingModel();
        int n = caretPosition.line;
        int n2 = caretPosition.column;
        if (defaultFoldingModel.isEnabled() && (foldingSpan = defaultFoldingModel.getOutermostSpanAtViewPosition(caretPosition)) != null) {
            CaretPosition caretPosition2 = this.offsetToModelPosition(foldingSpan.getStartOffset());
            CaretPosition caretPosition3 = this.modelToViewPosition(caretPosition2);
            if (caretPosition.line == caretPosition3.line && caretPosition.column >= caretPosition3.column && caretPosition.column < caretPosition3.column + CodeEditorUtils.getSpanDescriptionLength(foldingSpan)) {
                return caretPosition2;
            }
            CaretPosition caretPosition4 = this.offsetToModelPosition(foldingSpan.getEndOffset());
            n = caretPosition4.line + (caretPosition.line - caretPosition3.line);
            if (caretPosition3.line == caretPosition.line) {
                if (caretPosition.column >= caretPosition3.column + CodeEditorUtils.getSpanDescriptionLength(foldingSpan)) {
                    n2 = Math.min(caretPosition4.column, this.getLineEndOffsetExcludeLineBreak(caretPosition4.line)) + (caretPosition.column - caretPosition3.column - CodeEditorUtils.getSpanDescriptionLength(foldingSpan));
                } else {
                    return this.offsetToModelPosition(foldingSpan.getStartOffset());
                }
            }
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return new CaretPosition(n, n2);
    }

    public CaretPosition modelToViewPosition(CaretPosition caretPosition) {
        DefaultFoldingModel defaultFoldingModel = (DefaultFoldingModel)this.getFoldingModel();
        if (!defaultFoldingModel.isEnabled()) {
            return new CaretPosition(caretPosition.line, caretPosition.column);
        }
        if (caretPosition.line == 0 && caretPosition.column == 0) {
            return new CaretPosition(0, 0);
        }
        int n = this.modelPositionToOffset(caretPosition);
        FoldingSpan foldingSpan = defaultFoldingModel.getOutermostSpanAtOffset(n);
        if (foldingSpan != null && n > foldingSpan.getStartOffset()) {
            if (n < this.getDocument().getLength() - 1) {
                int n2 = foldingSpan.getStartOffset();
                CaretPosition caretPosition2 = this.offsetToModelPosition(n2);
                CaretPosition caretPosition3 = this.modelToViewPosition(caretPosition2);
                if (n == foldingSpan.getEndOffset() - 1 && caretPosition.column >= this.getLineEndOffsetExcludeLineBreak(caretPosition.line)) {
                    return new CaretPosition(caretPosition3.line, caretPosition3.column + CodeEditorUtils.getSpanDescriptionLength(foldingSpan) + (caretPosition.column - this.getLineEndOffsetExcludeLineBreak(caretPosition.line)));
                }
                return caretPosition3;
            }
            n = foldingSpan.getEndOffset() + 3;
        }
        int n3 = caretPosition.line;
        int n4 = caretPosition.column;
        n3 -= defaultFoldingModel.getFoldedLinesCountBefore(n);
        FoldingSpan[] foldingSpanArray = defaultFoldingModel.getTopLevelSpans();
        for (int i = defaultFoldingModel.getLastTopLevelIndexBefore(n); i >= 0; --i) {
            FoldingSpan foldingSpan2 = foldingSpanArray[i];
            if (!foldingSpan2.isValid()) continue;
            if (this.getLineNumber(foldingSpan2.getEndOffset()) != caretPosition.line) break;
            int n5 = 0;
            if (foldingSpan2.getEndOffset() >= n) {
                if (n != this.getLineEndOffsetExcludeLineBreak(caretPosition.line) + this.getLineStartOffset(caretPosition.line) && foldingSpan2.getEndOffset() != n) break;
                n5 = foldingSpan2.getEndOffset() - n;
            }
            CaretPosition caretPosition4 = this.offsetToModelPosition(foldingSpan2.getStartOffset());
            CaretPosition caretPosition5 = this.offsetToModelPosition(foldingSpan2.getEndOffset());
            n4 += caretPosition4.column + CodeEditorUtils.getSpanDescriptionLength(foldingSpan2) - caretPosition5.column + n5;
            n = foldingSpan2.getStartOffset();
            caretPosition = caretPosition4;
        }
        return new CaretPosition(n3, n4);
    }

    public CaretPosition offsetToModelPosition(int n) {
        if (n <= 0) {
            return new CaretPosition(0, 0);
        }
        int n2 = this._document.getLength();
        if (n > n2) {
            return new CaretPosition(this._document.getLineCount(), 0);
        }
        int n3 = this.getLineNumber(n);
        int n4 = this.getLineStartOffset(n3);
        return new CaretPosition(n3, Math.max(n - n4, 0));
    }

    public CaretPosition offsetToViewPosition(int n) {
        return this.modelToViewPosition(this.offsetToModelPosition(n));
    }

    public int modelPositionToOffset(CaretPosition caretPosition) {
        if (this.getLineCount() == 0) {
            return 0;
        }
        if (caretPosition.line < 0) {
            throw new IndexOutOfBoundsException("Wrong line: " + caretPosition.line);
        }
        if (caretPosition.column < 0) {
            throw new IndexOutOfBoundsException("Wrong column:" + caretPosition.column);
        }
        if (caretPosition.line == 0 && caretPosition.column == 0) {
            return 0;
        }
        if (caretPosition.line >= this.getLineCount()) {
            return this._document.getLength();
        }
        int n = this.getLineStartOffset(caretPosition.line);
        int n2 = this.getLineEndOffsetExcludeLineBreak(caretPosition.line);
        int n3 = n;
        if (caretPosition.column > 0 && n2 > 0) {
            n3 += Math.min(caretPosition.column, n2);
        }
        return n3;
    }

    @Deprecated
    public int offsetToLine(int n) {
        return this.offsetToViewPosition((int)n).line;
    }

    public int getTabSize() {
        return this._tabSize;
    }

    public void setTabSize(int n) {
        int n2 = this._tabSize;
        if (n2 != n) {
            this._tabSize = n;
            this.firePropertyChange(PROPERTY_TAB_SIZE, n2, n);
        }
    }

    public boolean isReplaceTabWithSpace() {
        return this._replaceTabWithSpace;
    }

    public void setReplaceTabWithSpace(boolean bl) {
        boolean bl2 = this._replaceTabWithSpace;
        if (bl2 != bl) {
            this._replaceTabWithSpace = bl;
            this.firePropertyChange(PROPERTY_REPLACE_TAB_WITH_SPACE, bl2, bl);
        }
    }

    static int getCodeEditorDefaultLineBreakStyle() {
        if (SystemInfo.isWindows()) {
            return 0;
        }
        if (SystemInfo.isMacClassic()) {
            return 2;
        }
        if (SystemInfo.isUnix() || SystemInfo.isMacOSX()) {
            return 1;
        }
        return 0;
    }

    public int getDefaultLineBreakStyle() {
        return CodeEditor.getCodeEditorDefaultLineBreakStyle();
    }

    public int getLineBreakStyle() {
        return this._lineBreakStyle == -1 ? this.getDefaultLineBreakStyle() : this._lineBreakStyle;
    }

    public boolean isLineBreakStyleMixed() {
        return this._lineBreakStyle == -1;
    }

    public void setLineBreakStyle(int n) {
        int n2;
        if (n == -2) {
            n = this.getDefaultLineBreakStyle();
        }
        if ((n2 = this._lineBreakStyle) != n) {
            this._lineBreakStyle = n;
            this.firePropertyChange(PROPERTY_LINE_BREAK_STYLE, n2, n);
        }
    }

    private String getLineBreak() {
        return this.getLineBreakStyle() == 2 ? "\n" : TextUtils.getLineBreak(this.getLineBreakStyle());
    }

    public void discardAllEdits() {
        this.getDocument().getUndoManager().discardAllEdits();
    }

    public void promptGotoLine() {
        Point point;
        final InputPopup inputPopup = new InputPopup(this.getResourceString("CodeEditor.gotoLine"), MessageFormat.format(this.getResourceString("CodeEditor.gotoLine.message"), 1, this.getLineCount()), this.getCaretModel().getModelPosition().line + 1);
        inputPopup.setOwner(this);
        inputPopup.removeExcludedComponent(this);
        try {
            point = this.getLocationOnScreen();
        }
        catch (Exception exception) {
            point = this.getLocation();
        }
        Dimension dimension = inputPopup.getPreferredSize();
        point.x += (this.getWidth() - dimension.width) / 2;
        point.y += (this.getHeight() - dimension.height) / 2;
        inputPopup.getTextField().addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 7299209753351159934L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                String string = jTextField.getText();
                if (string != null && string.trim().length() > 0) {
                    try {
                        int n = Integer.parseInt("" + string);
                        CodeEditor.this.gotoLine(n - 1);
                        inputPopup.hidePopup();
                    }
                    catch (NumberFormatException numberFormatException) {
                        inputPopup.getStatusLabel().setForeground(Color.RED);
                        inputPopup.getStatusLabel().setText(CodeEditor.this.getResourceString("CodeEditor.gotoLine.invalid"));
                    }
                } else {
                    inputPopup.getStatusLabel().setForeground(Color.RED);
                    inputPopup.getStatusLabel().setText(CodeEditor.this.getResourceString("CodeEditor.gotoLine.empty"));
                }
            }
        });
        inputPopup.setTimeout(0);
        inputPopup.showPopup(point.x, point.y, this);
    }

    public void promptGotoLineAtView() {
        Object object = JOptionPane.showInputDialog(this, "Line number: ", "Go to Line at View", 3, null, null, this.getCaretModel().getViewPosition().line + 1);
        if (object != null) {
            try {
                int n = Integer.parseInt("" + object);
                this.gotoLineAtView(n - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void promptGotoOffset() {
        Object object = JOptionPane.showInputDialog(this, "Offset: ", "Go to Offset", 3, null, null, this.getCaretModel().getOffset());
        if (object != null) {
            try {
                int n = Integer.parseInt("" + object);
                this.gotoOffset(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void gotoLine(int n) {
        if (n < 0) {
            PortingUtils.notifyUser();
            n = 0;
        }
        if (n > this.getLineCount() - 1) {
            PortingUtils.notifyUser();
            n = this.getLineCount() - 1;
        }
        CaretPosition caretPosition = this.getCaretModel().getModelPosition();
        int n2 = caretPosition.column;
        if (!this.isVirtualSpaceAllowed()) {
            n2 = Math.min(n2, this.getLineEndOffset(n) - this.getLineStartOffset(n));
        }
        this.getCaretModel().setModelPosition(new CaretPosition(n, n2));
        CaretPosition caretPosition2 = this.getCaretModel().getViewPosition();
        if (caretPosition2.line < this.getFirstLine() || caretPosition2.line >= this.getFirstLine() + this.getVisibleLines() - 1) {
            if (caretPosition2.line - 10 >= 0 && caretPosition2.line - 10 + this.getVisibleLines() < this.getVisualLineCount()) {
                this.setFirstLine(caretPosition2.line - 10);
            } else if (caretPosition2.line + 10 < this.getVisualLineCount() && caretPosition2.line + 10 - this.getVisibleLines() >= 0) {
                this.setFirstLine(caretPosition2.line + 10 - this.getVisibleLines());
            } else {
                this.scrollToViewPosition(caretPosition2);
            }
        }
    }

    public void gotoLineAtView(int n) {
        if (n < 0) {
            PortingUtils.notifyUser();
            n = 0;
        }
        if (n > this.getVisualLineCount() - 1) {
            PortingUtils.notifyUser();
            n = this.getVisualLineCount() - 1;
        }
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        int n2 = caretPosition.column;
        if (!this.isVirtualSpaceAllowed()) {
            n2 = Math.min(n2, this.getLineEndOffset(n) - this.getLineStartOffset(n));
        }
        CaretPosition caretPosition2 = new CaretPosition(n, n2);
        this.getCaretModel().setViewPosition(caretPosition2);
        if (caretPosition2.line < this.getFirstLine() || caretPosition2.line >= this.getFirstLine() + this.getVisibleLines() - 1) {
            if (caretPosition2.line - 10 >= 0 && caretPosition2.line - 10 + this.getVisibleLines() < this.getVisualLineCount()) {
                this.setFirstLine(caretPosition2.line - 10);
            } else if (caretPosition2.line + 10 < this.getVisualLineCount() && caretPosition2.line + 10 - this.getVisibleLines() >= 0) {
                this.setFirstLine(caretPosition2.line + 10 - this.getVisibleLines());
            } else {
                this.scrollToViewPosition(caretPosition2);
            }
        }
    }

    public void gotoOffset(int n) {
        if (n < 0) {
            PortingUtils.notifyUser();
            n = 0;
        }
        if (n > this.getDocumentLength() - 1) {
            PortingUtils.notifyUser();
            n = this.getDocumentLength() - 1;
        }
        this.getCaretModel().setOffset(n);
        this.scrollToCaret();
    }

    public MarkerModel getMarkerModel() {
        if (this._markerModel == null) {
            this.setMarkerModel(new DefaultMarkerModel());
        }
        return this._markerModel;
    }

    public void setMarkerModel(MarkerModel markerModel) {
        if (this._markerModel != null && this._markerListener != null) {
            this._markerModel.removeMarkerListener(this._markerListener);
        }
        this._markerModel = markerModel;
        if (this._markerModel != null) {
            if (this._markerListener == null) {
                this._markerListener = new MarkerListener(){

                    @Override
                    public void markerChanged(MarkerEvent markerEvent) {
                        Marker marker = markerEvent.getMarker();
                        if (marker != null && markerEvent.getType() == 0 && CodeEditor.this.getMarkerArea() != null) {
                            if (marker.getType() == 0) {
                                CodeEditor.this.getMarkerArea().requireMinimumMode(200);
                            } else if (marker.getType() == 1) {
                                CodeEditor.this.getMarkerArea().requireMinimumMode(100);
                            }
                        }
                        if (!markerEvent.isAdjusting()) {
                            if (CodeEditor.this.getMarkerArea() != null) {
                                CodeEditor.this.getMarkerArea().repaint();
                            }
                            CodeEditor.this._painter.repaint();
                        }
                    }
                };
            }
            this._markerModel.addMarkerListener(this._markerListener);
        }
    }

    public int getMaxNumberOfClipboards() {
        return this._maxNumberOfClipboards;
    }

    public void setMaxNumberOfClipboards(int n) {
        int n2 = this._maxNumberOfClipboards;
        if (n2 != n) {
            this._maxNumberOfClipboards = n;
            this.firePropertyChange(PROPERTY_MAX_NUMBER_OF_CLIPBOARDS, n2, n);
        }
    }

    public void setDragEnabled(boolean bl) {
        if (bl && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._painter.setFont(font);
        this.recalculateVisibleLines();
        this.resetContentSize();
        this.getMarginArea().setFont(font);
    }

    public Searchable getSearchable() {
        return this._searchable;
    }

    public FindAndReplace getFindAndReplace() {
        block4: {
            Object object;
            block5: {
                boolean bl = false;
                if (this._findAndReplace == null) {
                    this._findAndReplace = new FindAndReplace();
                    object = new CodeEditorFindAndReplaceTarget(this);
                    this._findAndReplace.addTarget((FindAndReplaceTarget)object);
                    this._findAndReplace.setTarget((FindAndReplaceTarget)object);
                    bl = true;
                    final CodeEditorSelectionFindAndReplaceTarget object2 = new CodeEditorSelectionFindAndReplaceTarget(this);
                    this._findAndReplace.addTarget(object2);
                    this._findAndReplace.addFindAndReplaceListener(new FindAndReplaceListener(){
                        private boolean _searchingAll;
                        private int _findStart;
                        private int _findEnd;

                        @Override
                        public void statusChanged(FindAndReplaceEvent findAndReplaceEvent) {
                            FindResult findResult;
                            int n = 0;
                            if (findAndReplaceEvent.getSource() instanceof FindAndReplace && ((FindAndReplace)findAndReplaceEvent.getSource()).getTarget() instanceof CodeEditorSelectionFindAndReplaceTarget && CodeEditor.this.getSelectionModel().hasSelection()) {
                                n = CodeEditor.this.getSelectionStart();
                            }
                            if (findAndReplaceEvent.getStatus() == 0) {
                                if (findAndReplaceEvent.getSource() instanceof FindAndReplace && ((FindAndReplace)findAndReplaceEvent.getSource()).isTargetChanged() && ((FindAndReplace)findAndReplaceEvent.getSource()).getTarget() instanceof CodeEditorFindAndReplaceTarget && object2.hasHighlight()) {
                                    CodeEditor.this.select(CodeEditor.this.getSelectionStart() + object2.getCurrentPosition(false) + 1);
                                }
                                CodeEditor.this.clearSearchHighlighters();
                            }
                            if (findAndReplaceEvent.getStatus() == 1) {
                                this._searchingAll = true;
                                if (CodeEditor.this.getSelectionModel().hasSelection() && this._findStart != this._findEnd && this._findStart >= 0 && this._findEnd >= 0 && CodeEditor.this.getSelectionStart() == this._findStart && CodeEditor.this.getSelectionEnd() == this._findEnd) {
                                    CodeEditor.this.getSelectionModel().clearSelection();
                                }
                                this._findStart = -1;
                                this._findEnd = -1;
                            } else if (findAndReplaceEvent.getStatus() == 2) {
                                FindResult findResult2;
                                this._searchingAll = false;
                                FindResults findResults = findAndReplaceEvent.getFindResults();
                                if (findResults != null && (findResult2 = findResults.getFirstFindResult(CodeEditor.this)) != null) {
                                    CodeEditor.this.select(findResult2.getStart(), findResult2.getEnd());
                                }
                            } else if (!this._searchingAll && findAndReplaceEvent.getStatus() == 4) {
                                FindResult findResult3 = findAndReplaceEvent.getFindResult();
                                if (findResult3 != null) {
                                    this._findStart = findResult3.getStart() + n;
                                    this._findEnd = findResult3.getEnd() + n;
                                }
                            } else if (findAndReplaceEvent.getStatus() == 4 && this._searchingAll && (findResult = findAndReplaceEvent.getFindResult()) != null) {
                                try {
                                    Object object = CodeEditor.this.getClientProperty("Searchable");
                                    Color color = CodeEditorSelectionFindAndReplaceTarget.DEFAULT_HIGHLIGHT_COLOR;
                                    if (object instanceof CodeEditorSearchable) {
                                        color = ((CodeEditorSearchable)object).getHighlightColor();
                                    }
                                    CodeEditor.this.getHighlighter().addHighlight(findResult.getStart() + n, findResult.getEnd() + n, new SearchAllHighlightPainter(color));
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
                object = this._findAndReplace.getTargets();
                if (!this.getSelectionModel().hasSelection()) break block5;
                if (this.getSelectionStartLine() == this.getSelectionEndLine() || !bl) break block4;
                for (FindAndReplaceTarget findAndReplaceTarget : object) {
                    if (!(findAndReplaceTarget instanceof CodeEditorSelectionFindAndReplaceTarget)) continue;
                    this._findAndReplace.setTarget(findAndReplaceTarget);
                    break block4;
                }
                break block4;
            }
            if (this._findAndReplace.getTarget() instanceof CodeEditorSelectionFindAndReplaceTarget) {
                for (FindAndReplaceTarget findAndReplaceTarget : object) {
                    if (findAndReplaceTarget == this._findAndReplace.getTarget() || findAndReplaceTarget instanceof CodeEditorSelectionFindAndReplaceTarget || !(findAndReplaceTarget instanceof CodeEditorFindAndReplaceTarget)) continue;
                    this._findAndReplace.setTarget(findAndReplaceTarget);
                    break;
                }
            }
        }
        return this._findAndReplace;
    }

    void clearSearchHighlighters() {
        Highlighter highlighter = this.getHighlighter();
        if (highlighter instanceof DefaultHighlighter) {
            Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
            for (int i = highlightArray.length - 1; i >= 0; --i) {
                Highlighter.Highlight highlight = highlightArray[i];
                if (!(highlight.getPainter() instanceof SearchAllHighlightPainter)) continue;
                highlighter.removeHighlight(((DefaultHighlighter)highlighter).getHighlightInfo(i));
            }
        }
    }

    public Point getCaretLocation() {
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        int n = (caretPosition.line - this.getFirstLine()) * this.getLineHeight();
        int n2 = this.columnToX(caretPosition.line, caretPosition.column);
        return new Point(n2, n);
    }

    public Point getCaretLocationOnScreen() {
        Point point = this.getCaretLocation();
        SwingUtilities.convertPointToScreen(point, this.getPainter());
        return point;
    }

    public void showMessage(String string) {
        this.hideMessage();
        this._messagePopup = JidePopupFactory.getSharedInstance().createPopup();
        this.getCaretModel().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdated(CaretEvent caretEvent) {
                CodeEditor.this.hideMessage();
            }
        });
        JLabel jLabel = new JLabel(string);
        jLabel.setOpaque(true);
        jLabel.setFont(UIDefaultsLookup.getFont("Label.font").deriveFont(1, 11.0f));
        jLabel.setBackground(UIDefaultsLookup.getColor("ToolTip.background"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        jLabel.setForeground(UIDefaultsLookup.getColor("ToolTip.foreground"));
        this._messagePopup.getContentPane().setLayout(new BorderLayout());
        this._messagePopup.getContentPane().add(jLabel);
        this._messagePopup.setOwner(this);
        this._messagePopup.setPopupBorder(new MessagePopupBorder());
        Point point = this.getCaretLocation();
        SwingUtilities.convertPointToScreen(point, this.getPainter());
        Point point2 = new Point(this.getWidth(), this.getHeight());
        SwingUtilities.convertPointToScreen(point2, this);
        if (point.x + this._messagePopup.getPreferredSize().width > point2.x) {
            point.x = point2.x - this._messagePopup.getPreferredSize().width;
        }
        if (point.y + this._messagePopup.getPreferredSize().height > point2.y) {
            point.y = point2.y - this._messagePopup.getPreferredSize().height;
        }
        this._messagePopup.setDefaultMoveOperation(0);
        this._messagePopup.setTransient(true);
        this._messagePopup.showPopup(point.x, point.y + this.getLineHeight());
    }

    private void hideMessage() {
        if (this._messagePopup != null) {
            this._messagePopup.hidePopupImmediately();
            this._messagePopup = null;
        }
    }

    public void find() {
        Window window;
        this.hideMessage();
        this.getFindAndReplace().setReplace(false);
        if (this.getSelectionModel().hasSelection() && this.getSelectionModel().getSelectionStartLine() == this.getSelectionModel().getSelectionEndLine()) {
            this.getFindAndReplace().setFindText(this.getSelectedText());
        }
        FindAndReplaceDialog findAndReplaceDialog = (window = JideSwingUtilities.getWindowForComponent(this)) instanceof Frame ? new FindAndReplaceDialog((Frame)window, this.getResourceString("FindAndReplace.findTitle"), this.getFindAndReplace()) : new FindAndReplaceDialog((Dialog)window, this.getResourceString("FindAndReplace.findTitle"), this.getFindAndReplace());
        this.customizeDialogData(findAndReplaceDialog);
        findAndReplaceDialog.pack();
        findAndReplaceDialog.setLocationRelativeTo(this);
        if (this._findDialogBounds != null) {
            findAndReplaceDialog.setBounds(this._findDialogBounds);
        }
        findAndReplaceDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof FindAndReplaceDialog) {
                    CodeEditor.this._findDialogBounds = ((FindAndReplaceDialog)componentEvent.getSource()).getBounds();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof FindAndReplaceDialog) {
                    CodeEditor.this._findDialogBounds = ((FindAndReplaceDialog)componentEvent.getSource()).getBounds();
                }
            }
        });
        this.customizeDialog(findAndReplaceDialog);
        findAndReplaceDialog.setVisible(true);
    }

    public void findNext() {
        this.getFindAndReplace().setForward(!this.getFindAndReplace().isReversed());
        this.getFindAndReplace().searchAgain();
    }

    public void findPrevious() {
        this.getFindAndReplace().setForward(this.getFindAndReplace().isReversed());
        this.getFindAndReplace().searchAgain();
    }

    public void replace() {
        Window window;
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this.getFindAndReplace().setReplace(true);
        if (this.getSelectionModel().hasSelection() && this.getSelectionModel().getSelectionStartLine() == this.getSelectionModel().getSelectionEndLine()) {
            this.getFindAndReplace().setFindText(this.getSelectedText());
        }
        FindAndReplaceDialog findAndReplaceDialog = (window = JideSwingUtilities.getWindowForComponent(this)) instanceof Frame ? new FindAndReplaceDialog((Frame)window, this.getResourceString("FindAndReplace.replaceTitle"), this.getFindAndReplace()) : new FindAndReplaceDialog((Dialog)window, this.getResourceString("FindAndReplace.replaceTitle"), this.getFindAndReplace());
        this.customizeDialogData(findAndReplaceDialog);
        findAndReplaceDialog.pack();
        findAndReplaceDialog.setLocationRelativeTo(this);
        if (this._replaceDialogBounds != null) {
            findAndReplaceDialog.setBounds(this._replaceDialogBounds);
        }
        findAndReplaceDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof FindAndReplaceDialog) {
                    CodeEditor.this._replaceDialogBounds = ((FindAndReplaceDialog)componentEvent.getSource()).getBounds();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof FindAndReplaceDialog) {
                    CodeEditor.this._replaceDialogBounds = ((FindAndReplaceDialog)componentEvent.getSource()).getBounds();
                }
            }
        });
        this.customizeDialog(findAndReplaceDialog);
        findAndReplaceDialog.setVisible(true);
    }

    public void quickSearch(String string) {
        this.getSearchable().showPopup(string);
    }

    private static void updateSelection(CodeEditor codeEditor, boolean bl, int n) {
        if (bl) {
            if (codeEditor.getSelectionModel().isColumnSelectionMode()) {
                codeEditor.getSelectionModel().setSelection(n, codeEditor.getCaretModel().getOffset());
            } else {
                codeEditor.getSelectionModel().setSelection(n, codeEditor.getCaretModel().getOffset());
            }
        } else {
            codeEditor.getSelectionModel().clearSelection();
        }
    }

    public void moveToLineEnd(boolean bl) {
        int n = this.getLeadSelectionOffset();
        int n2 = this.getCaretModel().getModelPosition().line;
        if (n2 >= this.getLineCount()) {
            CaretPosition caretPosition = new CaretPosition(n2, 0);
            this.getCaretModel().setModelPosition(caretPosition);
            CodeEditor.updateSelection(this, bl, n);
            if (this._alwaysScrollCaret || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            return;
        }
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        caretPosition = new CaretPosition(caretPosition.line, CodeEditorUtils.getLastColumnAtVisualLine(this, caretPosition.line));
        CaretPosition caretPosition2 = this.viewToModelPosition(caretPosition);
        int n3 = this.modelPositionToOffset(caretPosition2);
        n2 = caretPosition2.line;
        int n4 = n3;
        int n5 = this.getLineStartOffset(n2);
        try {
            String string = this.getDocument().getLineText(n5);
            for (int i = n4 - 1 - n5; i >= 0 && (string.charAt(i) == ' ' || string.charAt(i) == '\t'); --i) {
                n4 = i + n5;
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
        }
        if (n4 == this.getCaretModel().getOffset()) {
            n4 = n3;
        }
        this.getCaretModel().setOffset(n4);
        if (this._alwaysScrollCaret || this.getAutoscrolls()) {
            this.scrollToCaret();
        }
        CodeEditor.updateSelection(this, bl, n);
        this.adjustColumnSelectionModelOnCaretMoving(bl);
        if (!this.isVirtualSpaceAllowed()) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
    }

    private static int findNonspace(CodeEditor codeEditor, int n) {
        int n2 = CodeEditor.findFirstNonspaceLine(codeEditor, n);
        if (n2 >= 0) {
            int n3 = CodeEditor.findFirstNonspace(codeEditor, n2);
            return codeEditor.offsetToModelPosition((int)n3).column;
        }
        return 0;
    }

    private static int findFirstNonspaceLine(CodeEditor codeEditor, int n) {
        if (n < 0 || n > codeEditor.getDocumentLength()) {
            return -1;
        }
        int n2 = Math.max(n - codeEditor.getDocument().getLookupBufferSize(), 0);
        int n3 = Math.min(codeEditor.getDocument().getLookupBufferSize(), n);
        while (n2 >= 0) {
            char c;
            int n4;
            String string = codeEditor.getText(n2, n3);
            for (n4 = string.length() - 1; n4 >= 0 && ((c = string.charAt(n4)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --n4) {
            }
            if (n4 >= 0) {
                return codeEditor.getLineNumber(n4 + n2);
            }
            if (n2 == 0) break;
            n3 = Math.min(codeEditor.getDocument().getLookupBufferSize(), n2);
            n2 = Math.max(n2 - codeEditor.getDocument().getLookupBufferSize(), 0);
        }
        return -1;
    }

    private static int findFirstNonspace(CodeEditor codeEditor, int n) {
        int n2 = codeEditor.getLineStartOffset(n);
        int n3 = codeEditor.getLineEndOffset(n);
        try {
            String string = codeEditor.getDocument().getLineText(n2);
            for (int i = 0; i < n3 - n2; ++i) {
                char c = string.charAt(i);
                if (c == ' ' || c == '\t') continue;
                return n2 + i;
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
        }
        return n3;
    }

    private void moveTo(boolean bl, int n, int n2) {
        this.hideHintPopup();
        if (this.getSelectionModel().isColumnSelectionMode()) {
            int n3 = this.getCaretModel().getViewPosition().line + n2;
            int n4 = this.getCaretModel().getViewPosition().column + n;
            int n5 = this.modelPositionToOffset(this.viewToModelPosition(new CaretPosition(n3, n4)));
            this.setSelectionRectangular(true);
            this.select(n5, n3, n4);
        } else {
            this.getCaretModel().moveCaret(n, n2, bl, false, this._alwaysScrollCaret || this.getAutoscrolls());
        }
        if (!this.isVirtualSpaceAllowed() && n != 0) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
    }

    private void hideHintPopup() {
        Object object = this.getClientProperty("INTELLI_HINTS");
        if (object instanceof AbstractCodeEditorIntelliHints) {
            ((AbstractCodeEditorIntelliHints)object).hideHintsPopup();
        }
    }

    public void moveToLineStart(boolean bl) {
        boolean bl2;
        int n;
        int n2 = this.getLeadSelectionOffset();
        int n3 = this.getCaretModel().getModelPosition().column;
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        for (n = this.getCaretModel().getModelPosition().line; n >= 0 && this.modelToViewPosition((CaretPosition)new CaretPosition((int)n, (int)0)).line == caretPosition.line; --n) {
        }
        ++n;
        boolean bl3 = bl2 = !Boolean.FALSE.equals(this.getClientProperty(SMART_HOME_END_PROPERTY));
        if (!bl2) {
            CaretPosition caretPosition2 = new CaretPosition(n, 0);
            this.getCaretModel().setModelPosition(caretPosition2);
            CodeEditor.updateSelection(this, bl, n2);
            if (this._alwaysScrollCaret || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            return;
        }
        int n4 = this.getCaretModel().getOffset();
        if (n >= this.getLineCount() || n4 > this.getDocumentLength()) {
            int n5 = 0;
            if (n3 == 0) {
                n5 = CodeEditor.findNonspace(this, n4);
            }
            CaretPosition caretPosition3 = new CaretPosition(n, n5);
            this.getCaretModel().setModelPosition(caretPosition3);
            CodeEditor.updateSelection(this, bl, n2);
            if (this._alwaysScrollCaret || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            return;
        }
        int n6 = CodeEditor.findFirstNonspace(this, n);
        int n7 = this.getLineEndOffset(n);
        if (n > 0 && n7 == n6 && n3 == 0) {
            int n8 = CodeEditor.findNonspace(this, n4);
            CaretPosition caretPosition4 = new CaretPosition(n, n8);
            this.getCaretModel().setModelPosition(caretPosition4);
            CodeEditor.updateSelection(this, bl, n2);
            if (this._alwaysScrollCaret || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            return;
        }
        int n9 = this.getLineStartOffset(n);
        if (n6 < n4 || n3 == 0) {
            n9 = n6;
        }
        this.getCaretModel().setOffset(n9);
        if (this._alwaysScrollCaret || this.getAutoscrolls()) {
            this.scrollToCaret();
        }
        CodeEditor.updateSelection(this, bl, n2);
        this.adjustColumnSelectionModelOnCaretMoving(bl);
        if (!this.isVirtualSpaceAllowed()) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
    }

    public void moveToDocumentStart(boolean bl) {
        if (bl) {
            this.select(this.getMarkPosition(), 0);
        } else {
            this.select(0);
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
        if (!this.isVirtualSpaceAllowed()) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
    }

    public void moveToDocumentEnd(boolean bl) {
        if (bl) {
            this.select(this.getMarkPosition(), this.getDocumentLength());
        } else {
            this.select(this.getDocumentLength());
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
        if (!this.isVirtualSpaceAllowed()) {
            this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
        }
    }

    public void moveToNextChar(boolean bl) {
        if (!bl && this.getSelectionModel().hasSelection()) {
            this.getCaretModel().setOffset(Math.min(this.getDocumentLength(), Math.max(this.getSelectionModel().getSelectionStart(), this.getSelectionModel().getSelectionEnd())));
            this.getSelectionModel().clearSelection();
            if (this._alwaysScrollCaret || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            this.setBlink(true);
            if (!this.isVirtualSpaceAllowed()) {
                this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
            }
            return;
        }
        if (this.getCaretModel().getOffset() >= this.getDocumentLength() && !this.isVirtualSpaceAllowed()) {
            PortingUtils.notifyUser();
            return;
        }
        this.moveTo(bl, 1, 0);
    }

    public void moveToNextLine(boolean bl) {
        if (this.getCaretModel().getViewPosition().line >= this.getVisualLineCount() - 1) {
            PortingUtils.notifyUser();
            return;
        }
        this.moveTo(bl, 0, 1);
    }

    public void moveToNextPage(boolean bl) {
        int n = this.getVisibleLines();
        int n2 = this.getCaretModel().getViewPosition().line;
        int n3 = this.getVisualLineCount();
        if (n2 >= n3 || this.getCaretModel().getOffset() >= this.getDocumentLength()) {
            PortingUtils.notifyUser();
            return;
        }
        if (n2 + n > n3 - 1) {
            n = n3 - n2 - 1;
        }
        this.moveTo(bl, 0, n);
    }

    public void moveToNextWord(boolean bl) {
        this.moveToNextWord(bl, true);
    }

    public void moveToNextWord(boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        this.hideHintPopup();
        int n5 = n4 = this.getCaretModel().getOffset();
        do {
            boolean bl3 = n5 == n4;
            n2 = this.offsetToModelPosition((int)n5).line;
            n5 = this.findNextWordWithinThisLine(n5, bl2, bl3);
            n3 = this.offsetToModelPosition((int)n5).line;
            n = this.getLineStartOffset(n3) + this.getLineEndOffsetExcludeLineBreak(n3);
        } while (n5 <= this.getDocumentLength() && n5 >= 0 && n3 < this.getLineCount() - 1 && n3 != n2);
        n5 = Math.min(n5, n);
        if (n5 > this.getDocumentLength() || n5 < 0) {
            PortingUtils.notifyUser();
        } else {
            if (bl) {
                this.select(this.getMarkPosition(), n5);
            } else {
                this.select(n5);
            }
            if (!this.isVirtualSpaceAllowed()) {
                this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
            }
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
    }

    private int findNextWordWithinThisLine(int n, boolean bl, boolean bl2) {
        int n2;
        int n3 = this.offsetToModelPosition((int)n).line;
        int n4 = this.getLineStartOffset(n3);
        int n5 = n - n4;
        String string = this.getLineText(n3);
        String string2 = (String)this.getDocument().getProperty("nonwordDelimiters");
        if (n5 > this.getLineEndOffsetExcludeLineBreak(n3)) {
            n2 = n3 + 1;
            n5 = n2 >= this.getLineCount() ? -1 : this.getLineStartOffset(n2);
        } else {
            n5 = TextUtils.findWordEnd(string, n5 + 1, string2, true, bl);
            n5 += n4;
        }
        if (n5 >= 0 && !bl2 && bl && (n2 = this.offsetToModelPosition((int)n5).line) == n3) {
            n5 = TextUtils.findWordStart(string, n5 - n4 - 1, string2, true, !bl, true) + n4;
        }
        return n5;
    }

    public void moveToPreviousChar(boolean bl) {
        if (!bl && this.getSelectionModel().hasSelection()) {
            this.getCaretModel().setOffset(Math.min(this.getSelectionModel().getSelectionStart(), this.getSelectionModel().getSelectionEnd()));
            this.getSelectionModel().clearSelection();
            if (this._alwaysScrollCaret || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
            this.setBlink(true);
            if (!this.isVirtualSpaceAllowed()) {
                this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
            }
            return;
        }
        if (this.getCaretModel().getOffset() <= 0) {
            PortingUtils.notifyUser();
            return;
        }
        this.moveTo(bl, -1, 0);
    }

    public void moveToPreviousLine(boolean bl) {
        if (this.getCaretModel().getViewPosition().line <= 0) {
            PortingUtils.notifyUser();
            return;
        }
        this.moveTo(bl, 0, -1);
    }

    public void moveToPreviousPage(boolean bl) {
        int n = this.getVisibleLines();
        int n2 = this.getCaretModel().getViewPosition().line;
        if (n2 <= 0) {
            PortingUtils.notifyUser();
            return;
        }
        if (n2 - n < 0) {
            n = n2;
        }
        this.moveTo(bl, 0, -n);
    }

    public void moveToPreviousWord(boolean bl) {
        this.moveToPreviousWord(bl, false);
    }

    public void moveToPreviousWord(boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        this.hideHintPopup();
        for (n4 = n3 = this.getCaretModel().getOffset(); (n4 = this.findPreviousWordWithinLine(n4, bl2, n4 == n3)) == (n2 = this.getLineStartOffset(n = this.offsetToModelPosition((int)n4).line)) && n4 < this.getDocumentLength() && n4 > 0 && n != 0 && Character.isWhitespace(this.getText(n4, 1).charAt(0)); --n4) {
        }
        if (n4 < 0) {
            PortingUtils.notifyUser();
        } else {
            if (bl) {
                this.select(this.getMarkPosition(), n4);
            } else {
                this.select(n4);
            }
            if (!this.isVirtualSpaceAllowed()) {
                this.setMagicCaretPosition(this.columnToX(this.getCaretModel().getViewPosition().line, this.getCaretModel().getViewPosition().column));
            }
        }
        this.adjustColumnSelectionModelOnCaretMoving(bl);
    }

    protected void adjustColumnSelectionModelOnCaretMoving(boolean bl) {
        if (!bl && this.getSelectionModel().isColumnSelectionMode()) {
            this.getSelectionModel().setColumnSelectionMode(false);
        }
    }

    private int findPreviousWordWithinLine(int n, boolean bl, boolean bl2) {
        int n2 = this.offsetToModelPosition((int)n).line;
        int n3 = this.getLineStartOffset(n2);
        String string = this.getLineText(n2);
        int n4 = n - n3;
        if (n4 == 0) {
            int n5;
            n4 = n3 == 0 ? -1 : ((n5 = n2 - 1) == -1 ? -1 : this.getLineStartOffset(n5) + this.getLineEndOffsetExcludeLineBreak(n5));
        } else {
            String string2 = (String)this.getDocument().getProperty("nonwordDelimiters");
            n4 = TextUtils.findWordStart(string, n4 - 1, string2, true, bl, bl2);
            n4 += n3;
        }
        return n4;
    }

    public void toggleOverwrite() {
        this.setOverwriteEnabled(!this.isOverwriteEnabled());
    }

    public void splitLine() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this.getSelectionModel().isColumnSelectionMode()) {
            this.deleteChar();
            return;
        }
        int n = this.getSelectionModel().hasSelection() ? this.getSelectionStart() : this.getCaretModel().getOffset();
        this.insertBreak();
        this.getCaretModel().setOffset(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBreak() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this.getSelectionModel().isColumnSelectionMode() && this.getSelectionModel().hasSelection()) {
            this.deleteChar();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            this.setSelectedText(this.getLineBreak());
            int n = this.getCaretModel().getModelPosition().line;
            int n2 = n - 1;
            if (n2 >= 0) {
                try {
                    int n3 = this.getCaretModel().getOffset();
                    String string = this.isAutoIndent() ? TextUtils.getLeadingWhitespace(this.getLineText(n2)) : "";
                    this.getDocument().insertString(n3, string, null);
                    this.setMagicCaretPosition(this.columnToX(n2, string.length()));
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    public void startNewLine() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this.getSelectionModel().isColumnSelectionMode()) {
            this.deleteChar();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            int n = this.getCaretModel().getModelPosition().line;
            String string = this.isAutoIndent() ? TextUtils.getLeadingWhitespace(this.getLineText(n)) : "";
            this.gotoEndOfLine();
            this.setSelectedText(this.getLineBreak() + string);
            this.setMagicCaretPosition(this.columnToX(n, string.length()));
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentSelection() {
        block9: {
            if (!this.isEditable() || !this.isEnabled()) {
                PortingUtils.notifyUser();
                return;
            }
            try {
                this._document.beginCompoundEdit();
                if (!this.getSelectionModel().hasSelection() || this.getSelectionModel().isColumnSelectionMode()) {
                    this.insertChar("\t");
                    break block9;
                }
                int n = this.getSelectionEndLine();
                int n2 = this.getSelectionStartLine();
                try {
                    String string = this._document.getText(this.getSelectionEnd() - 1, 1);
                    if (string.equals("\n") || string.equals("\r")) {
                        --n;
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.warning(badLocationException.getLocalizedMessage());
                }
                for (int i = n2; i <= n; ++i) {
                    this.indentLine(i, false);
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unindentSelection() {
        if (!this.isEditable() || !this.isEnabled() || this.getSelectionModel().isColumnSelectionMode()) {
            PortingUtils.notifyUser();
            return;
        }
        try {
            int n;
            this._document.beginCompoundEdit();
            int n2 = this.getSelectionModel().hasSelection() ? this.getSelectionStartLine() : this.getCaretModel().getModelPosition().line;
            int n3 = n = this.getSelectionModel().hasSelection() ? this.getSelectionEndLine() : n2;
            if (n < n2) {
                n = n2;
            }
            for (int i = n2; i <= n; ++i) {
                this.indentLine(i, true);
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indentLine(int n, boolean bl) {
        int[] nArray = new int[1];
        int n2 = this.getCurrentIndentForLine(n, nArray);
        if (bl) {
            if ((n2 -= this.getTabSize()) < 0) {
                n2 = 0;
            }
        } else {
            n2 += this.getTabSize();
        }
        try {
            this._document.beginCompoundEdit();
            int n3 = this.getLineStartOffset(n);
            try {
                this._document.remove(n3, nArray[0]);
                this._document.insertString(n3, TextUtils.createWhiteSpace(n2, this.getTabSize(), this.isReplaceTabWithSpace()), null);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.warning(badLocationException.getLocalizedMessage());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
        return true;
    }

    public int getCurrentIndentForLine(int n, int[] nArray) {
        if (!this.getLineText(n, this.lineSegment)) {
            return 0;
        }
        int n2 = this.getTabSize();
        int n3 = 0;
        block4: for (int i = 0; i < this.lineSegment.count; ++i) {
            char c = this.lineSegment.array[this.lineSegment.offset + i];
            switch (c) {
                case ' ': {
                    ++n3;
                    if (nArray == null) continue block4;
                    nArray[0] = nArray[0] + 1;
                    continue block4;
                }
                case '\t': {
                    n3 += n2 - n3 % n2;
                    if (nArray == null) continue block4;
                    nArray[0] = nArray[0] + 1;
                    continue block4;
                }
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInsertChar(String string) {
        SelectionModel selectionModel = this.getSelectionModel();
        if (!selectionModel.hasSelection() || !selectionModel.isColumnSelectionMode()) {
            this.insertCharNormally(string);
            return;
        }
        boolean bl = this.isVirtualSpaceAllowed();
        this.setVirtualSpaceAllowed(true);
        try {
            int n;
            int n2 = this.getSelectionStartLine();
            int n3 = this.getSelectionEndLine();
            for (n = n2; n < n3 && this.getSelectionStart(n) + 1 == this.getSelectionEnd(n + 1); ++n) {
            }
            if (n >= n3) {
                this.insertCharNormally(string);
                return;
            }
            CaretPosition caretPosition = this.getSelectionModel().getSelectionStartViewPosition();
            CaretPosition caretPosition2 = this.getSelectionModel().getSelectionEndViewPosition();
            this.internalRemoveCharInColumnSelectionModel(2);
            if (caretPosition != null && caretPosition2 != null) {
                int n4 = Math.min(caretPosition.column, caretPosition2.column);
                this.getSelectionModel().setSelection(new CaretPosition(caretPosition.line, n4), new CaretPosition(caretPosition2.line, n4));
                this.getCaretModel().setViewPosition(new CaretPosition(Math.min(caretPosition.line, caretPosition2.line), n4));
            }
            String[] stringArray = new String[n3 - n2 + 1];
            for (int i = 0; i < n3 - n2 + 1; ++i) {
                stringArray[i] = string;
            }
            CaretPosition[] caretPositionArray = this.insertStringInColumnSelectionModel(stringArray, n2);
            if (caretPositionArray.length == 2 && caretPositionArray[0] != null && caretPositionArray[1] != null) {
                this.select(caretPositionArray[0], caretPositionArray[1], false);
                this.getCaretModel().setViewPosition(new CaretPosition(Math.min(caretPositionArray[0].line, caretPositionArray[1].line), Math.max(caretPositionArray[0].column, caretPositionArray[1].column)));
            }
            if (this._alwaysScrollCaret || this.getAutoscrolls()) {
                this.scrollToCaret();
            }
        }
        finally {
            this.setVirtualSpaceAllowed(bl);
        }
    }

    private void internalRemoveCharInColumnSelectionModel() {
        this.internalRemoveCharInColumnSelectionModel(2);
    }

    private void internalRemoveCharInColumnSelectionModel(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.getSelectionStartLine();
        int n8 = this.getSelectionEndLine();
        int n9 = n8 - n7 + 1;
        int[] nArray = new int[n9 * 2];
        boolean bl = true;
        for (n6 = n7; n6 <= n8; ++n6) {
            if (this.getLineEndOffsetExcludeLineBreak(n6) == 0) continue;
            bl = false;
            break;
        }
        for (n6 = n7; n6 <= n8; ++n6) {
            n5 = this.getLineStartOffset(n6);
            if (bl) {
                nArray[(n6 - n7) * 2] = n5;
                nArray[(n6 - n7) * 2 + 1] = n5;
                continue;
            }
            n4 = this.getSelectionStart(n6);
            n3 = this.getSelectionEnd(n6);
            n2 = this.getLineEndOffsetExcludeLineBreak(n6) + this.getLineStartOffset(n6);
            if (n4 >= n2 && n == 0 || (n3 <= n5 || n3 > n2) && n == 1) {
                nArray[(n6 - n7) * 2] = -1;
                nArray[(n6 - n7) * 2 + 1] = -1;
                continue;
            }
            nArray[(n6 - n7) * 2] = Math.min(n4, n3);
            nArray[(n6 - n7) * 2 + 1] = Math.max(n4, n3);
        }
        n5 = this.getSelectionModel().getSelectionStart() > this.getSelectionModel().getSelectionEnd() ? this.getCaretModel().getViewPosition().column : this.offsetToViewPosition((int)this.getSelectionStart()).column;
        n4 = this.getSelectionModel().getSelectionStart() < this.getSelectionEnd() ? this.getCaretModel().getViewPosition().column : this.offsetToViewPosition((int)this.getSelectionEnd()).column;
        n3 = Math.min(n5, n4);
        n2 = 0;
        for (n6 = n8; n6 >= n7; --n6) {
            if (nArray[(n6 - n7) * 2] < 0 || nArray[(n6 - n7) * 2 + 1] < 0) continue;
            try {
                n2 = nArray[(n6 - n7) * 2 + 1] - nArray[(n6 - n7) * 2];
                if (n2 > 0) {
                    this.getDocument().remove(nArray[(n6 - n7) * 2], n2);
                    continue;
                }
                switch (n) {
                    case 0: {
                        this.getDocument().remove(nArray[(n6 - n7) * 2], 1);
                        break;
                    }
                    case 1: {
                        if (n3 <= 0) break;
                        this.getDocument().remove(nArray[(n6 - n7) * 2] - 1, 1);
                        break;
                    }
                }
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (n == 1) {
            if (n2 == 0) {
                --n3;
            } else if (n3 == n4) {
                n3 -= n2;
            }
        }
        CaretModel caretModel = this.getCaretModel();
        CaretPosition caretPosition = new CaretPosition(caretModel.getViewPosition().line, n3);
        caretModel.setViewPosition(caretPosition);
    }

    private void insertCharNormally(String string) {
        CodeEditorUtils.deleteSelectedText(this);
        CodeEditorUtils.insertStringAtCaret(this, string, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertChar(String string) {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this.expandFolding();
        try {
            int n;
            this._document.beginCompoundEdit();
            int n2 = this.getInputHandler().getRepeatCount();
            if ("\t".equals(string) && this.isReplaceTabWithSpace() && (n = this.getTabSize()) >= 1) {
                if (this.isTabAlignment() && n2 == 1) {
                    n = !this.getSelectionModel().hasSelection() ? (n -= this.getCaretModel().getViewPosition().column % n) : (n -= this.offsetToViewPosition((int)this.getSelectionStart()).column % n);
                }
                StringBuffer stringBuffer = new StringBuffer(n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(' ');
                }
                string = stringBuffer.toString();
            }
            if (this.isEditable() && this.isEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(string);
                }
                this.internalInsertChar(stringBuffer.toString());
            } else {
                PortingUtils.notifyUser();
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinLines() {
        block17: {
            if (!this.isEditable() || !this.isEnabled()) {
                PortingUtils.notifyUser();
                return;
            }
            try {
                this._document.beginCompoundEdit();
                if (!this.getSelectionModel().hasSelection()) {
                    int n = this.getCaretModel().getModelPosition().line;
                    int n2 = this.getLineEndOffset(n);
                    try {
                        if (n >= 0 && n < this.getLineCount() - 1) {
                            this._document.remove(n2, 1 + TextUtils.getLeadingWhitespace(this.getLineText(n + 1)).length());
                            this._document.insertString(n2, " ", null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.warning(badLocationException.getLocalizedMessage());
                    }
                    this.select(n2);
                    break block17;
                }
                if (this.getSelectionEndLine() != this.getSelectionStartLine()) {
                    int n = this.getSelectionStartLine();
                    int n3 = this.getSelectionEndLine();
                    try {
                        String string = this._document.getText(this.getSelectionEnd() - 1, 1);
                        if (string.equals("\n") || string.equals("\r")) {
                            --n3;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.warning(badLocationException.getLocalizedMessage());
                    }
                    if (n3 - n >= 1) {
                        for (int i = n3 - 1; i >= n; --i) {
                            int n4 = this.getLineEndOffset(i);
                            try {
                                this._document.remove(n4, 1 + TextUtils.getLeadingWhitespace(this.getLineText(i + 1)).length());
                                this._document.insertString(n4, " ", null);
                                continue;
                            }
                            catch (BadLocationException badLocationException) {
                                LOGGER.warning(badLocationException.getLocalizedMessage());
                            }
                        }
                    } else {
                        PortingUtils.notifyUser();
                    }
                    break block17;
                }
                PortingUtils.notifyUser();
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleCase() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (!this.getSelectionModel().hasSelection()) {
            PortingUtils.notifyUser();
            return;
        }
        try {
            this._document.beginCompoundEdit();
            String string = this.getSelectionModel().getSelectedText();
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            CaretPosition caretPosition = this.getSelectionModel().getSelectionStartViewPosition();
            CaretPosition caretPosition2 = this.getSelectionModel().getSelectionEndViewPosition();
            boolean bl = this.getSelectionModel().isColumnSelectionMode();
            string = this.isUpperCase(string) ? string.toLowerCase(this.getLocale()) : string.toUpperCase(this.getLocale());
            boolean bl2 = this.isIndentOnPasting();
            this.setIndentOnPasting(false);
            try {
                this.pasteString(string);
            }
            finally {
                this.setIndentOnPasting(bl2);
            }
            this.getSelectionModel().setColumnSelectionMode(bl);
            if (this.getSelectionModel().isColumnSelectionMode()) {
                this.getSelectionModel().setSelection(caretPosition, caretPosition2);
            } else {
                this.getSelectionModel().setSelection(n, n2);
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    private boolean isUpperCase(String string) {
        if (string.length() <= 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) continue;
            return Character.isUpperCase(c);
        }
        return false;
    }

    public void duplicateSelection() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            String string = this.getSelectedText();
            if (string == null || string.length() == 0) {
                int n = this.getCaretModel().getOffset();
                this.selectLine(this.getCaretModel().getModelPosition().line);
                string = this.getSelectedText();
                if (string == null) {
                    this.setSelectedText("\n");
                    this.getCaretModel().setOffset(n + 1);
                } else if (!string.endsWith("\n")) {
                    this.setSelectedText(string + "\n" + string);
                    this.getCaretModel().setOffset(n + string.length() + 1);
                } else {
                    this.setSelectedText(string + string);
                    this.getCaretModel().setOffset(n + string.length());
                }
            } else {
                this.setSelectedText(string + string);
                int n = this.getCaretModel().getOffset();
                this.select(n - string.length(), n);
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backspaceChar() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            if (this.getSelectionStart() != this.getSelectionEnd()) {
                if (this.getSelectionModel().isColumnSelectionMode()) {
                    this.internalRemoveCharInColumnSelectionModel(1);
                } else {
                    this.setSelectedText("");
                }
            } else {
                FoldingSpan[] foldingSpanArray;
                CaretPosition caretPosition = this.getCaretModel().getModelPosition();
                if (this.getLineEndOffset(caretPosition.line) - this.getLineStartOffset(caretPosition.line) < caretPosition.column) {
                    CaretPosition caretPosition2 = this.getCaretModel().getViewPosition();
                    this.getCaretModel().setViewPosition(new CaretPosition(caretPosition2.line, caretPosition2.column - 1));
                    return;
                }
                int n = this.getCaretModel().getOffset();
                if (n == 0) {
                    PortingUtils.notifyUser();
                    return;
                }
                if (this.getFoldingModel() instanceof DefaultFoldingModel && this.getFoldingModel().isEnabled() && (foldingSpanArray = ((DefaultFoldingModel)this.getFoldingModel()).getTopLevelSpans()) != null) {
                    for (FoldingSpan foldingSpan : foldingSpanArray) {
                        if (foldingSpan.getEndOffset() != n) continue;
                        return;
                    }
                }
                try {
                    int n2 = n - 1;
                    int n3 = 1;
                    String string = this.getLineBreak();
                    int n4 = string.indexOf(this.getDocument().getText(n2, n3));
                    if (n4 >= 0 && n2 >= n4 && string.equals(this.getDocument().getText(n2 - n4, string.length()))) {
                        n2 -= n4;
                        n3 = string.length();
                    }
                    this.getDocument().remove(n2, n3);
                    this.getCaretModel().setOffset(n2);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backspaceWord() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            int n = this.getCaretModel().getOffset();
            this.moveToPreviousWord(false);
            int n2 = this.getCaretModel().getOffset();
            if (n2 < n) {
                try {
                    this.getDocument().remove(n2, n - n2);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChar() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            if (this.getSelectionStart() != this.getSelectionEnd()) {
                if (this.getSelectionModel().isColumnSelectionMode()) {
                    this.internalRemoveCharInColumnSelectionModel();
                } else {
                    this.setSelectedText("");
                }
            } else {
                String string;
                FoldingSpan[] foldingSpanArray;
                int n = this.getCaretModel().getOffset();
                if (n == this.getDocumentLength()) {
                    PortingUtils.notifyUser();
                    return;
                }
                if (this.getFoldingModel() instanceof DefaultFoldingModel && this.getFoldingModel().isEnabled() && (foldingSpanArray = ((DefaultFoldingModel)this.getFoldingModel()).getTopLevelSpans()) != null) {
                    for (FoldingSpan foldingSpan : foldingSpanArray) {
                        if (foldingSpan.getStartOffset() != n) continue;
                        return;
                    }
                }
                foldingSpanArray = this.getCaretModel().getModelPosition();
                int n2 = foldingSpanArray.column - (this.getLineEndOffset(foldingSpanArray.line) - this.getLineStartOffset(foldingSpanArray.line));
                int n3 = 1;
                if (n2 > 0) {
                    this.internalInsertChar("t");
                    n = this.getCaretModel().getOffset() - 1;
                    ++n3;
                }
                if ((string = this.getText(n, Math.min(2, this.getDocumentLength() - n))) != null && string.length() >= 1 && string.charAt(0) == '\r' && string.length() >= 2 && string.charAt(1) == '\n') {
                    ++n3;
                }
                try {
                    this.getDocument().remove(n, n3);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWord() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            int n = this.getCaretModel().getOffset();
            this.moveToNextWord(true);
            int n2 = this.getCaretModel().getOffset();
            if (n2 > n) {
                try {
                    this.getDocument().remove(n, n2 - n);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLine() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        int n = this.getCaretModel().getModelPosition().line;
        int n2 = this.getLineStartOffset(n);
        int n3 = this.getLineEndOffset(n) + 1;
        try {
            if (n3 > this.getDocumentLength()) {
                if (n2 != 0) {
                    --n2;
                }
                n3 = this.getDocumentLength();
            }
            this._document.beginCompoundEdit();
            try {
                this._document.remove(n2, n3 - n2);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.warning(badLocationException.getLocalizedMessage());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    public void clipboardCut() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this._document.getUndoManager() instanceof DelayUndoManager) {
            ((DelayUndoManager)this._document.getUndoManager()).commitCache();
        }
        this._document.beginCompoundEdit();
        try {
            this.clipboardCopy();
            if (this.getSelectionModel().isColumnSelectionMode()) {
                this.internalRemoveCharInColumnSelectionModel();
            } else {
                this.setSelectedText("");
            }
        }
        finally {
            this._document.endCompoundEdit();
            if (this._document.getUndoManager() instanceof DelayUndoManager) {
                ((DelayUndoManager)this._document.getUndoManager()).commitCache();
            }
        }
    }

    public void clipboardMove(int n) {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this._document.getUndoManager() instanceof DelayUndoManager) {
            ((DelayUndoManager)this._document.getUndoManager()).commitCache();
        }
        this._document.beginCompoundEdit();
        try {
            if (n < this.getSelectionStart()) {
                this.clipboardCut();
                this.getCaretModel().setOffset(n);
                this.clipboardPaste();
            } else if (n > this.getSelectionEnd()) {
                int n2 = Math.abs(this.getSelectionEnd() - this.getSelectionStart());
                this.clipboardCut();
                this.getCaretModel().setOffset(n - n2);
                this.clipboardPaste();
            }
        }
        finally {
            this._document.endCompoundEdit();
            if (this._document.getUndoManager() instanceof DelayUndoManager) {
                ((DelayUndoManager)this._document.getUndoManager()).commitCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dragSelectedTextTo(int n, MouseEvent mouseEvent) {
        if (!(this.isEditable() && this.isEnabled() && this.getSelectionModel().hasSelection())) {
            PortingUtils.notifyUser();
            return;
        }
        String string = this.getSelectedText();
        if (string == null) {
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            if (!this.getSelectionModel().isColumnSelectionMode()) {
                if (n < this.getSelectionStart()) {
                    if (mouseEvent != null && mouseEvent.isControlDown()) {
                        this.getSelectionModel().clearSelection();
                    } else {
                        this.setSelectedText("");
                        this.getCaretModel().setOffset(n);
                    }
                    this.internalInsertChar(string);
                } else if (n > this.getSelectionEnd()) {
                    int n2 = Math.abs(this.getSelectionEnd() - this.getSelectionStart());
                    if (mouseEvent != null && mouseEvent.isControlDown()) {
                        this.getSelectionModel().clearSelection();
                    } else {
                        this.setSelectedText("");
                        this.getCaretModel().setOffset(n - n2);
                    }
                    this.internalInsertChar(string);
                }
            } else {
                Comparable<CaretPosition> comparable;
                if (mouseEvent != null && mouseEvent.isControlDown()) {
                    this.getSelectionModel().clearSelection();
                } else {
                    comparable = this.getCaretModel().getViewPosition();
                    CaretPosition caretPosition = this.getSelectionModel().getSelectionStartViewPosition();
                    CaretPosition caretPosition2 = this.getSelectionModel().getSelectionEndViewPosition();
                    if (caretPosition != null && caretPosition2 != null) {
                        int n3 = Math.min(caretPosition.line, caretPosition2.line);
                        int n4 = Math.max(caretPosition.line, caretPosition2.line);
                        if (((CaretPosition)comparable).line >= n3 && ((CaretPosition)comparable).line <= n4) {
                            int n5 = Math.max(caretPosition.column, caretPosition2.column);
                            int n6 = Math.min(caretPosition.column, caretPosition2.column);
                            if (((CaretPosition)comparable).column >= n5) {
                                comparable = new CaretPosition(((CaretPosition)comparable).line, ((CaretPosition)comparable).column - (n5 - n6));
                            } else if (((CaretPosition)comparable).column >= n6) {
                                comparable = new CaretPosition(((CaretPosition)comparable).line, n6);
                            }
                        }
                    }
                    this.internalRemoveCharInColumnSelectionModel();
                    this.getSelectionModel().clearSelection();
                    this.getCaretModel().setViewPosition((CaretPosition)comparable);
                }
                comparable = new StringBuffer();
                this.exportText(string, (StringBuffer)comparable);
                this.pasteString(((StringBuffer)comparable).toString());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    public void clipboardCopy() {
        String string;
        if (!this.getSelectionModel().hasSelection()) {
            this.selectLine(this.getCaretModel().getModelPosition().line);
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        String string2 = string = this.isCopyVisibleTextOnly() ? this.getSelectedVisibleText() : this.getSelectedText();
        if (string == null) {
            PortingUtils.notifyUser();
            return;
        }
        int n = this.getInputHandler().getRepeatCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        this.exportText(stringBuffer.toString(), stringBuffer2);
        StringSelection stringSelection = new StringSelection(stringBuffer2.toString());
        if (_clipboards == null) {
            _clipboards = new ArrayList<Transferable>();
        }
        _clipboards.add(0, stringSelection);
        if (_clipboards.size() > this.getMaxNumberOfClipboards()) {
            _clipboards.remove(_clipboards.size() - 1);
        }
        clipboard.setContents(stringSelection, this.getClipboardOwner());
    }

    public void clipboardPaste() {
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        if (this._document.getUndoManager() instanceof DelayUndoManager) {
            ((DelayUndoManager)this._document.getUndoManager()).commitCache();
        }
        this._document.beginCompoundEdit();
        try {
            if (this._editable) {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                this.pasteTransferable(clipboard.getContents(this));
            }
        }
        finally {
            this._document.endCompoundEdit();
            if (this._document.getUndoManager() instanceof DelayUndoManager) {
                ((DelayUndoManager)this._document.getUndoManager()).commitCache();
            }
        }
    }

    private void pasteTransferable(Transferable transferable) {
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            this.pasteString(string);
        }
        catch (Exception exception) {
            PortingUtils.notifyUser();
            LOGGER.warning(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pasteString(String string) {
        block41: {
            try {
                int n;
                int n2 = this.getInputHandler().getRepeatCount();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(string);
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                int n3 = this.importText(stringBuffer.toString(), stringBuffer2);
                if (this.getSelectionModel().isColumnSelectionMode()) {
                    boolean bl = this.isVirtualSpaceAllowed();
                    this.setVirtualSpaceAllowed(true);
                    try {
                        Object[] objectArray;
                        int n4 = this.getSelectionStartLine();
                        int n5 = this.getSelectionEndLine();
                        int n6 = n5 - n4 + 1;
                        CaretPosition caretPosition = this.getSelectionModel().getSelectionStartViewPosition();
                        CaretPosition caretPosition2 = this.getSelectionModel().getSelectionEndViewPosition();
                        if (!JideSwingUtilities.equals(caretPosition, caretPosition2)) {
                            this.internalRemoveCharInColumnSelectionModel(2);
                            if (caretPosition != null && caretPosition2 != null) {
                                this.getCaretModel().setViewPosition(new CaretPosition(Math.min(caretPosition.line, caretPosition2.line), Math.min(caretPosition.column, caretPosition2.column)));
                            }
                        }
                        this.getSelectionModel().clearSelection();
                        Object[] objectArray2 = stringBuffer2.toString().split(TextUtils.getLineBreak(n3));
                        if (n6 > objectArray2.length && objectArray2.length > 0) {
                            objectArray = new String[n6];
                            for (int i = 0; i < objectArray.length; ++i) {
                                objectArray[i] = i < objectArray2.length && objectArray2[i] != null ? objectArray2[i] : objectArray2[objectArray2.length - 1];
                            }
                            objectArray2 = objectArray;
                        }
                        if ((objectArray = this.insertStringInColumnSelectionModel((String[])objectArray2, this.getCaretModel().getModelPosition().line)).length >= 2 && objectArray[0] != null && objectArray[1] != null) {
                            this.select((CaretPosition)objectArray[0], (CaretPosition)objectArray[1], false);
                            this.getCaretModel().setViewPosition(new CaretPosition(Math.min(((CaretPosition)objectArray[0]).line, ((CaretPosition)objectArray[1]).line), Math.max(((CaretPosition)objectArray[0]).column, ((CaretPosition)objectArray[1]).column)));
                        }
                        break block41;
                    }
                    finally {
                        this.setVirtualSpaceAllowed(bl);
                    }
                }
                if (this.getSelectionModel().hasSelection()) {
                    n = this.getCaretModel().getOffset();
                    if (this.getSelectionStart() > n || this.getSelectionEnd() < n) {
                        this.getSelectionModel().clearSelection();
                    }
                }
                if (this.isIndentOnPasting()) {
                    int n7;
                    StringBuffer stringBuffer3;
                    String string2;
                    int n8;
                    n = 1;
                    int n9 = this.getSelectionStart();
                    if (n9 > (n8 = this.getLineStartOffset(this.getLineNumber(n9)))) {
                        string2 = this.getText(n8, n9 - n8);
                        for (int i = 0; i < string2.length(); ++i) {
                            char c = string2.charAt(i);
                            if (c == ' ' || c == '\t') continue;
                            n = 0;
                            break;
                        }
                    }
                    string2 = stringBuffer2.toString();
                    String[] stringArray = string2.split(TextUtils.getLineBreak(n3 == 2 ? 1 : n3));
                    String string3 = "";
                    int n10 = -1;
                    if (!this.getSelectionModel().hasSelection() && n != 0) {
                        CaretPosition caretPosition = this.getCaretModel().getModelPosition();
                        n10 = this.getLineEndOffset(caretPosition.line);
                        CaretPosition caretPosition3 = this.offsetToModelPosition(n10);
                        if (caretPosition.column > caretPosition3.column) {
                            string3 = TextUtils.createWhiteSpace(caretPosition.column - caretPosition3.column, this.getTabSize(), this.isReplaceTabWithSpace(), caretPosition3.column);
                        } else {
                            n10 = this.getCaretModel().getOffset();
                        }
                    }
                    int n11 = this.getSelectionModel().hasSelection() ? this.getSelectionStartLine() : this.getCaretModel().getModelPosition().line;
                    int n12 = n11 - 1;
                    String string4 = "";
                    if (n12 >= 0 && n12 < this.getLineCount()) {
                        int n13;
                        for (n13 = n12; n13 >= 0 && this.isEmptyString(this.getLineText(n13)); --n13) {
                        }
                        if (n13 >= 0) {
                            string4 = TextUtils.getLeadingWhitespace(this.getLineText(n13));
                        }
                    }
                    String string5 = "";
                    if (stringArray.length >= 1) {
                        string5 = TextUtils.getLeadingWhitespace(stringArray[0]);
                    }
                    String string6 = "";
                    if (this.isReplaceTabWithSpace()) {
                        stringBuffer3 = new StringBuffer();
                        for (n7 = 0; n7 < this.getTabSize(); ++n7) {
                            stringBuffer3.append(" ");
                        }
                        string6 = stringBuffer3.toString();
                        string5 = string5.replaceAll("\t", string6);
                        string4 = string4.replaceAll("\t", string6);
                    }
                    if (stringArray.length > 1) {
                        String string7;
                        if (string4.length() != 0 || string5.length() != 0) {
                            for (int i = 1; i < stringArray.length; ++i) {
                                String string8 = TextUtils.getLeadingWhitespace(stringArray[i]);
                                if (this.isReplaceTabWithSpace()) {
                                    string8 = string8.replaceAll("\t", string6);
                                    stringArray[i] = stringArray[i].replaceAll("\t", string6);
                                }
                                if (string8.startsWith(string5)) {
                                    stringArray[i] = string4 + stringArray[i].substring(string5.length());
                                    continue;
                                }
                                if (!string5.startsWith(string8)) continue;
                                string7 = string5.substring(string8.length());
                                if (string4.startsWith(string7)) {
                                    stringArray[i] = string4.substring(string7.length()) + stringArray[i].substring(string8.length());
                                    continue;
                                }
                                if (!string7.startsWith(string4)) continue;
                                stringArray[i] = stringArray[i].substring(string8.length());
                            }
                        }
                        stringBuffer3 = new StringBuffer();
                        for (n7 = 0; n7 < stringArray.length; ++n7) {
                            string7 = stringArray[n7];
                            stringBuffer3.append(string7);
                            if (n7 == stringArray.length - 1) continue;
                            stringBuffer3.append(this.getLineBreak());
                        }
                        if (string2.endsWith("\r") || string2.endsWith("\n")) {
                            stringBuffer3.append(this.getLineBreak());
                        }
                        string2 = stringBuffer3.toString();
                    } else if (stringArray.length == 1 && !string.endsWith(TextUtils.getLineBreak(1))) {
                        string2 = stringArray[0];
                    }
                    if (n != 0) {
                        if (string3.length() == 0 || string2.startsWith(string3)) {
                            string2 = string2.substring(string3.length());
                            this.setSelectedText(string2);
                        } else {
                            this.setSelectedText(string2);
                            int n14 = this.getCaretModel().getOffset();
                            this._document.remove(n8, string3.length() + (n10 - n8));
                            this.getCaretModel().setOffset(n14 - string3.length() - (n10 - n8));
                        }
                    } else {
                        this.setSelectedText(string2);
                    }
                } else {
                    this.setSelectedText(stringBuffer2.toString());
                }
            }
            catch (BadLocationException badLocationException) {
                PortingUtils.notifyUser();
                LOGGER.warning(badLocationException.getLocalizedMessage());
            }
        }
    }

    private boolean isEmptyString(String string) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            if (c == ' ' || c == '\t' || c == 'r' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    private CaretPosition[] insertStringInColumnSelectionModel(String[] stringArray, int n) {
        int n2;
        if (stringArray == null || stringArray.length < 1) {
            return new CaretPosition[]{this.getSelectionModel().getSelectionStartViewPosition(), this.getSelectionModel().getSelectionEndViewPosition()};
        }
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        CaretPosition[] caretPositionArray = new CaretPosition[2];
        boolean bl = true;
        int n3 = this.getCaretModel().getOffset();
        block0: while (bl) {
            bl = false;
            this.getCaretModel().moveCaret(stringArray[0].length(), Math.min(stringArray.length, this.getLineCount() - n + 1), false, false, false);
            n2 = this.getCaretModel().getOffset();
            FoldingState foldingState = new FoldingState(this, n3);
            do {
                if (foldingState.getCurrentFold() != null) {
                    this.getFoldingModel().expandFoldingSpan(foldingState.getCurrentFold());
                    bl = true;
                    continue block0;
                }
                foldingState.advance();
            } while (foldingState.getStartOffset() < n2);
        }
        n2 = n + stringArray.length - this.getLineCount();
        if (n2 > 0) {
            this.getCaretModel().setModelPosition(new CaretPosition(this.getLineCount() - 1, 0));
            this.getSelectionModel().setColumnSelectionMode(false);
            for (int i = 0; i <= n2; ++i) {
                this.startNewLine();
            }
            this.getSelectionModel().setColumnSelectionMode(true);
        }
        for (int i = n + stringArray.length - 1; i >= n; --i) {
            Comparable<StringBuffer> comparable;
            if (i >= this.getLineCount()) continue;
            String string = stringArray[i - n];
            this.getCaretModel().setViewPosition(caretPosition);
            this.getCaretModel().moveCaret(0, i - n, false, false, false);
            if (this.getLineEndOffsetExcludeLineBreak(i) < this.getCaretModel().getModelPosition().column) {
                if (this.isEmptyString(string)) continue;
                comparable = new StringBuffer();
                for (int j = 0; j < this.getCaretModel().getModelPosition().column - this.getLineEndOffsetExcludeLineBreak(i); ++j) {
                    ((StringBuffer)comparable).append(' ');
                }
                string = ((StringBuffer)comparable).toString() + string;
                this.getCaretModel().setModelPosition(new CaretPosition(i, this.getLineEndOffsetExcludeLineBreak(i)));
            }
            CodeEditorUtils.insertStringAtCaret(this, string, false, false);
            comparable = this.getCaretModel().getViewPosition();
            if (caretPositionArray[1] == null) {
                caretPositionArray[1] = comparable;
            }
            caretPositionArray[0] = comparable;
        }
        if (caretPositionArray[0] != null && caretPositionArray[1] != null) {
            this.getCaretModel().setViewPosition(new CaretPosition(Math.min(caretPositionArray[0].line, caretPositionArray[1].line), Math.max(caretPositionArray[0].column, caretPositionArray[1].column)));
        }
        return caretPositionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteWithDialog() {
        Transferable transferable3;
        if (!this.isEditable() || !this.isEnabled()) {
            PortingUtils.notifyUser();
            return;
        }
        Window window = JideSwingUtilities.getWindowForComponent(this);
        ArrayList<Transferable> arrayList = new ArrayList<Transferable>();
        Transferable transferable2 = this.getToolkit().getSystemClipboard().getContents(this);
        Object object = null;
        try {
            object = transferable2.getTransferData(DataFlavor.stringFlavor);
            if (_clipboards == null || _clipboards.size() < 1) {
                arrayList.add(transferable2);
            } else {
                arrayList.addAll(_clipboards);
                if (object != null) {
                    boolean bl = true;
                    for (Transferable transferable3 : _clipboards) {
                        if (transferable3 == null || !object.equals(transferable3.getTransferData(DataFlavor.stringFlavor))) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        arrayList.add(transferable2);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClipboardsDialog clipboardsDialog = window instanceof Frame ? new ClipboardsDialog((Frame)window, this.getResourceString("Clipboard.pasteDialogTitle"), arrayList, this._painter.getFont()) : new ClipboardsDialog((Dialog)window, this.getResourceString("Clipboard.pasteDialogTitle"), arrayList, this._painter.getFont());
        this.customizeDialogData(clipboardsDialog);
        clipboardsDialog.pack();
        clipboardsDialog.setLocationRelativeTo(this);
        if (this._pasteDialogBounds != null) {
            clipboardsDialog.setBounds(this._pasteDialogBounds);
        } else if (clipboardsDialog.getPreferredSize().width >= 500) {
            clipboardsDialog.setSize(500, clipboardsDialog.getPreferredSize().height);
        }
        clipboardsDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof ClipboardsDialog) {
                    CodeEditor.this._pasteDialogBounds = ((ClipboardsDialog)componentEvent.getSource()).getBounds();
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (componentEvent.getSource() instanceof ClipboardsDialog) {
                    CodeEditor.this._pasteDialogBounds = ((ClipboardsDialog)componentEvent.getSource()).getBounds();
                }
            }
        });
        this.customizeDialog(clipboardsDialog);
        clipboardsDialog.setVisible(true);
        int n = clipboardsDialog.getDialogResult();
        if (n == 0 && (transferable3 = clipboardsDialog.getSelectedClipboard()) != null) {
            if (transferable3 != transferable2) {
                _clipboards.remove(transferable3);
                _clipboards.add(0, transferable3);
            }
            this._document.beginCompoundEdit();
            try {
                this._alwaysScrollCaret = true;
                this.pasteTransferable(transferable3);
            }
            finally {
                this._alwaysScrollCaret = false;
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineComments() {
        block20: {
            if (!this.isEditable() || !this.isEnabled()) {
                PortingUtils.notifyUser();
                return;
            }
            try {
                int n;
                int n2;
                this._document.beginCompoundEdit();
                String string = (String)this._document.getProperty("lineComment");
                if (string == null) {
                    return;
                }
                if (!this.getSelectionModel().hasSelection()) {
                    int n3 = this.getCaretModel().getModelPosition().line;
                    int n4 = this.getLineStartOffset(n3);
                    if (!this.isSkipsEmptyLinesOnLineComments() || !this.isLineEmpty(n3)) {
                        int n5 = this.hasLineComment(n3, string);
                        try {
                            if (n5 != -1) {
                                this._document.remove(n4 + n5, string.length());
                            } else {
                                this._document.insertString(n4, string, null);
                                this.getCaretModel().setOffset(n4);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.warning(badLocationException.getLocalizedMessage());
                        }
                    }
                    this.getCaretModel().moveCaret(0, 1, false, true, this._alwaysScrollCaret || this.getAutoscrolls());
                    break block20;
                }
                int n6 = this.getSelectionStartLine();
                int n7 = this.getSelectionEndLine();
                try {
                    String string2 = this._document.getText(this.getSelectionEnd() - 1, 1);
                    if ((string2.equals("\n") || string2.equals("\r")) && n6 != n7) {
                        --n7;
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.warning(badLocationException.getLocalizedMessage());
                }
                boolean bl = true;
                for (n2 = n7; n2 >= n6; --n2) {
                    n = this.hasLineComment(n2, string);
                    if (n != -1 || this.isSkipsEmptyLinesOnLineComments() && this.isLineEmpty(n2)) continue;
                    bl = false;
                    break;
                }
                for (n2 = n7; n2 >= n6; --n2) {
                    n = this.getLineStartOffset(n2);
                    if (this.isSkipsEmptyLinesOnLineComments() && this.isLineEmpty(n2)) continue;
                    int n8 = bl ? this.hasLineComment(n2, string) : -1;
                    try {
                        if (n8 != -1) {
                            this._document.remove(n + n8, string.length());
                            continue;
                        }
                        this._document.insertString(n, string, null);
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.warning(badLocationException.getLocalizedMessage());
                    }
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    private boolean isLineEmpty(int n) {
        String string = this.getLineText(n);
        return string == null || string.trim().length() == 0;
    }

    private int hasLineComment(int n, String string) {
        String string2 = this.getLineText(n);
        return this.getLineCommentPosition(string2, string);
    }

    private int getLineCommentPosition(String string, String string2) {
        String string3 = TextUtils.getLeadingWhitespace(string);
        boolean bl = string.length() >= string3.length() + string2.length() && string2.equals(string.substring(string3.length(), string3.length() + string2.length()));
        return bl ? string3.length() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockComments() {
        block19: {
            if (!this.isEditable() || !this.isEnabled()) {
                PortingUtils.notifyUser();
                return;
            }
            try {
                int n;
                this._document.beginCompoundEdit();
                String string = (String)this._document.getProperty("blockCommentStart");
                String string2 = (String)this._document.getProperty("blockCommentEnd");
                if (string == null || string2 == null) {
                    return;
                }
                if (!this.getSelectionModel().hasSelection()) {
                    int n2 = this.getCaretModel().getOffset();
                    try {
                        this._document.insertString(n2, string + string2, null);
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.warning(badLocationException.getLocalizedMessage());
                    }
                    break block19;
                }
                int n3 = this.getSelectionStart();
                int n4 = this.getSelectionEnd();
                if (n4 > (n = this._document.getLength())) {
                    n4 = n;
                }
                int n5 = Math.max(string.length(), string2.length());
                try {
                    String[] stringArray = new String[]{string, string2};
                    if (string.equals(this._document.getText(n3, string.length())) && string2.equals(this._document.getText(n4 - string2.length(), string2.length()))) {
                        int n6 = this._document.findPrevious(stringArray, n4, n3, true, false);
                        while (n6 >= 0) {
                            if (this._document.getText(n6, n5).startsWith(string)) {
                                this._document.remove(n6, string.length());
                            } else {
                                this._document.remove(n6, string2.length());
                            }
                            n6 = this._document.findPrevious(stringArray, n6, n3, true, false);
                        }
                        break block19;
                    }
                    this._document.insertString(n4, string2, null);
                    int n7 = this._document.findPrevious(stringArray, n4, n3, true, false);
                    while (n7 >= 0) {
                        if (this._document.getText(n7, n5).startsWith(string)) {
                            this._document.insertString(n7, string2, null);
                        } else {
                            this._document.insertString(n7 + string2.length(), string, null);
                        }
                        n7 = this._document.findPrevious(stringArray, n7, n3, true, false);
                    }
                    this._document.insertString(n3, string, null);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.warning(badLocationException.getLocalizedMessage());
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    private FoldingSpanListener getFoldingSpanListener() {
        if (this._foldingSpanListener == null) {
            this._foldingSpanListener = new FoldingSpanListener(){

                @Override
                public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
                    if (!foldingSpanEvent.isAdjusting()) {
                        CodeEditor.this.getCaretModel().updateViewPosition();
                        CodeEditor.this._painter.invalidateLineRange(CodeEditor.this.getFirstLine(), CodeEditor.this.getFirstLine() + CodeEditor.this.getVisibleLines());
                        CodeEditor.this._editorSize.reset();
                        CodeEditor.this.updateScrollBars();
                    }
                    if (foldingSpanEvent.getType() == 3 && CodeEditor.this._internalAddedSpans != null && CodeEditor.this._internalAddedSpans.contains(foldingSpanEvent.getFoldingSpan())) {
                        CodeEditor.this._internalAddedSpans.remove(foldingSpanEvent.getFoldingSpan());
                        CodeEditor.this.getFoldingModel().removeFoldingSpan(foldingSpanEvent.getFoldingSpan());
                    }
                }
            };
        }
        return this._foldingSpanListener;
    }

    public FoldingModel getFoldingModel() {
        if (this._foldingModel == null) {
            this._foldingModel = new DefaultFoldingModel(this);
            this._foldingModel.setEnabled(true);
            this._foldingModel.addFoldingSpanListener(this.getFoldingSpanListener());
        }
        return this._foldingModel;
    }

    public void setFoldingModel(FoldingModel foldingModel) {
        if (this._foldingModel != foldingModel) {
            if (this._foldingModel != null) {
                this._foldingModel.removeFoldingSpanListener(this.getFoldingSpanListener());
            }
            this._foldingModel = foldingModel;
            if (this._foldingModel != null) {
                this._foldingModel.addFoldingSpanListener(this.getFoldingSpanListener());
            }
        }
    }

    public void expandFolding() {
        FoldingModel foldingModel = this.getFoldingModel();
        if (foldingModel.isEnabled()) {
            CaretPosition caretPosition = this.getCaretModel().getViewPosition();
            FoldingSpan foldingSpan = ((DefaultFoldingModel)foldingModel).getOutermostSpanAtViewPosition(caretPosition);
            if (foldingSpan != null) {
                CaretPosition caretPosition2 = this.offsetToViewPosition(foldingSpan.getStartOffset());
                if (caretPosition2.line != caretPosition.line || caretPosition.column < caretPosition2.column || caretPosition.column >= caretPosition2.column + CodeEditorUtils.getSpanDescriptionLength(foldingSpan)) {
                    foldingSpan = null;
                }
            }
            if (foldingSpan != null && !foldingSpan.isExpanded()) {
                foldingSpan.setExpanded(true);
            } else {
                int n = this.getCaretModel().getOffset();
                FoldingSpan[] foldingSpanArray = DefaultFoldingModel.getFoldingSpanAtOffset(this, n);
                for (int i = foldingSpanArray.length - 1; i >= 0; --i) {
                    FoldingSpan foldingSpan2 = foldingSpanArray[i];
                    if (foldingSpan2.isExpanded() || foldingSpan2.getStartOffset() >= n) continue;
                    foldingSpan2.setExpanded(true);
                    break;
                }
            }
        }
    }

    public void collapseFolding() {
        FoldingModel foldingModel = this.getFoldingModel();
        if (foldingModel.isEnabled()) {
            int n = this.getCaretModel().getModelPosition().line;
            FoldingSpan foldingSpan = DefaultFoldingModel.findFoldingSpanStartingAtLine(this, n);
            if (foldingSpan != null && foldingSpan.isExpanded()) {
                foldingSpan.setExpanded(false);
            } else {
                int n2 = this.getCaretModel().getOffset();
                FoldingSpan[] foldingSpanArray = DefaultFoldingModel.getFoldingSpanAtOffset(this, n2);
                for (int i = 0; i < foldingSpanArray.length; ++i) {
                    FoldingSpan foldingSpan2 = foldingSpanArray[i];
                    if (!foldingSpan2.isExpanded()) continue;
                    foldingSpan2.setExpanded(false);
                    break;
                }
            }
        }
    }

    public void expandAll() {
        FoldingModel foldingModel = this.getFoldingModel();
        foldingModel.expandAll();
        if (this._alwaysScrollCaret || this.getAutoscrolls()) {
            this.scrollToCaret();
        }
    }

    public void collapseAll() {
        FoldingModel foldingModel = this.getFoldingModel();
        foldingModel.collapseAll();
        if (this._alwaysScrollCaret || this.getAutoscrolls()) {
            this.scrollToCaret();
        }
    }

    public void toggleFoldingSelection() {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        try {
            if (n < n2 && "\n".equals(this.getDocument().getText(n2 - 1, 1))) {
                --n2;
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.warning(badLocationException.getLocalizedMessage());
        }
        if (n != n2 && !((DefaultFoldingModel)this.getFoldingModel()).hasAnySpan(n, n2)) {
            FoldingSpan foldingSpan = this.getFoldingModel().addFoldingSpan(n, n2, "...");
            if (this._internalAddedSpans == null) {
                this._internalAddedSpans = new ArrayList<FoldingSpan>();
            }
            this._internalAddedSpans.add(foldingSpan);
            foldingSpan.setExpanded(false);
            int n3 = Math.min(n + "...".length(), this.getDocumentLength());
            this.getCaretModel().setOffset(n3);
        } else {
            FoldingSpan foldingSpan = ((DefaultFoldingModel)this.getFoldingModel()).getOutermostSpanAtOffset(n);
            if (foldingSpan != null) {
                this.getFoldingModel().removeFoldingSpan(foldingSpan);
            }
            if (n != n2 && (foldingSpan = ((DefaultFoldingModel)this.getFoldingModel()).getOutermostSpanAtOffset(n2)) != null) {
                this.getFoldingModel().removeFoldingSpan(foldingSpan);
            }
        }
    }

    public int modelToViewLine(int n) {
        return this.modelToViewPosition((CaretPosition)new CaretPosition((int)n, (int)0)).line;
    }

    public int viewToModelLine(int n) {
        return this.viewToModelPosition((CaretPosition)new CaretPosition((int)n, (int)0)).line;
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.getMarkerArea() != null) {
            this.getMarkerArea().repaint();
        }
    }

    @Override
    public void repaint(long l) {
        super.repaint(l);
        if (this.getMarkerArea() != null) {
            this.getMarkerArea().repaint(l);
        }
    }

    public Dimension getContentSize() {
        return this.recalculateContentSize();
    }

    protected Dimension recalculateContentSize() {
        Dimension dimension = this._editorSize.getContentSize();
        return new Dimension(dimension.width, dimension.height + 10 * this.getLineHeight());
    }

    protected void resetContentSize() {
        if (this._editorSize != null) {
            this._editorSize.reset();
        }
    }

    @Override
    public void configureStyledLabel(StyledLabel styledLabel, Object object) {
        styledLabel.clearStyleRanges();
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof FindResult) {
            FindResult findResult = (FindResult)object;
            String string = findResult.getStyledText();
            if (string == null) {
                CaretPosition caretPosition = this.offsetToModelPosition(findResult.getStart());
                stringBuffer.append("{(").append(caretPosition.line + 1).append(", ").append(caretPosition.column + 1).append(") :italic, f:gray}");
                stringBuffer.append(" ");
                int n = this.getLineStartOffset(caretPosition.line);
                int n2 = findResult.getStart() - n;
                int n3 = findResult.getEnd() - findResult.getStart();
                String string2 = this.getText(n, this.getLineEndOffsetExcludeLineBreak(caretPosition.line));
                if (string2.length() >= n2 + n3) {
                    stringBuffer.append(StyledLabelBuilder.parseToVoidStyledTextConfusion(string2.substring(0, n2)));
                    String string3 = string2.substring(n2, n2 + n3);
                    string3 = string3.replaceAll("\\:", "\\\\:");
                    stringBuffer.append("{").append(string3);
                    if (stringBuffer.charAt(stringBuffer.length() - 1) == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(":bold}");
                    stringBuffer.append(StyledLabelBuilder.parseToVoidStyledTextConfusion(string2.substring(n2 + n3)));
                } else {
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
            }
            StyledLabelBuilder.setStyledText(styledLabel, string);
            findResult.setStyledText(string);
        } else if (object instanceof FindResults) {
            FindResults findResults = (FindResults)object;
            stringBuffer.append(findResults.getName());
            int n = stringBuffer.length();
            int n4 = findResults.getNumberOfFindResults();
            stringBuffer.append(" (");
            if (n4 > 1) {
                stringBuffer.append(n4).append(" ").append(this.getResourceString("FindAndReplace.usages"));
            } else if (n4 == 1) {
                stringBuffer.append(n4).append(" ").append(this.getResourceString("FindAndReplace.usage"));
            } else if (n4 == 0) {
                stringBuffer.append(this.getResourceString("FindAndReplace.noUsages"));
            }
            stringBuffer.append(")");
            styledLabel.setText(stringBuffer.toString());
            styledLabel.addStyleRange(new StyleRange(n, stringBuffer.length() - n, 2, Color.GRAY));
        } else {
            stringBuffer.append(object);
        }
    }

    private ResourceBundle getResourceBundle() {
        return CodeEditorResource.getResourceBundle(this.getLocale());
    }

    public String getResourceString(String string) {
        if (string != null && string.startsWith("FindAndReplace")) {
            return FindAndReplaceResource.getResourceBundle(this.getLocale()).getString(string);
        }
        return this.getResourceBundle().getString(string);
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        int n2 = this.offsetToViewPosition((int)n).line;
        int n3 = this.offsetToX(n);
        int n4 = this.lineToY(n2);
        return new Rectangle(n3, n4 += this.getPainter().getFontMetrics().getLeading() + this.getPainter().getFontMetrics().getMaxDescent(), this._painter.getFontMetrics().charWidth('w'), this.getLineHeight());
    }

    public Rectangle modelToView(int n, int n2) throws BadLocationException, IllegalArgumentException {
        int n3 = this.offsetToViewPosition((int)n).line;
        int n4 = this.offsetToViewPosition((int)n2).line;
        int n5 = this.offsetToX(n);
        int n6 = this.offsetToX(n2);
        if (n3 != n4 && n5 != n6) {
            throw new IllegalArgumentException("The start and end offset must be one the same visible line");
        }
        int n7 = this.lineToY(n3);
        n7 += this.getPainter().getFontMetrics().getLeading() + this.getPainter().getFontMetrics().getMaxDescent();
        if (n6 == n5 || this.getLineStartOffset(this.getLineNumber(n)) == n && n2 == this.getDocumentLength()) {
            return new Rectangle(0, n7, this.getPainter().getWidth(), this.getLineHeight());
        }
        return new Rectangle(n5, n7, n6 - n5, this.getLineHeight());
    }

    public Highlighter getHighlighter() {
        return this._highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this._highlighter != null) {
            this._highlighter.deinstall(this);
        }
        Highlighter highlighter2 = this._highlighter;
        this._highlighter = highlighter;
        if (this._highlighter != null) {
            this._highlighter.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    public Highlighter getFixedHighlighter() {
        return this._fixedHighlighter;
    }

    public void setFixedHighlighter(Highlighter highlighter) {
        if (this._fixedHighlighter != null) {
            this._fixedHighlighter.deinstall(this);
        }
        Highlighter highlighter2 = this._fixedHighlighter;
        this._fixedHighlighter = highlighter;
        if (this._fixedHighlighter != null) {
            this._fixedHighlighter.install(this);
        }
        this.firePropertyChange("fixedHighlighter", highlighter2, highlighter);
    }

    protected Highlighter createHighlighter() {
        return new DefaultUIResourceHighlighter();
    }

    public ColumnGuide[] getColumnGuides() {
        List<ColumnGuide> list = this.internalGetColumnGuides();
        return list.toArray(new ColumnGuide[list.size()]);
    }

    protected List<ColumnGuide> internalGetColumnGuides() {
        if (this._columnGuides == null) {
            this._columnGuides = new ArrayList<ColumnGuide>();
        }
        return this._columnGuides;
    }

    public void addColumnGuide(ColumnGuide columnGuide) {
        this.internalGetColumnGuides().add(columnGuide);
        this.getPainter().repaint();
    }

    public void removeColumnGuide(ColumnGuide columnGuide) {
        this.internalGetColumnGuides().remove(columnGuide);
        this.getPainter().repaint();
    }

    public void removeAllColumnGuides() {
        this.internalGetColumnGuides().clear();
        this.getPainter().repaint();
    }

    public void escape() {
        if (this.getSelectionModel().hasSelection()) {
            this.getSelectionModel().clearSelection();
        } else if (this.getHighlighter() != null) {
            this.getHighlighter().removeAllHighlights();
        }
    }

    public void loadActionMap() {
        ActionMap actionMap = this.getActionMap();
        class ActionDelegate
        extends AbstractAction {
            private Action sharedAction;
            private static final long serialVersionUID = 7860792901523776985L;

            ActionDelegate(Action action) {
                this.sharedAction = action;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.sharedAction.actionPerformed(actionEvent);
            }
        }
        actionMap.put("copy", new ActionDelegate(InputHandler.CLIP_COPY));
        actionMap.put("cut", new ActionDelegate(InputHandler.CLIP_CUT));
        actionMap.put("paste", new ActionDelegate(InputHandler.CLIP_PASTE));
        actionMap.put("delete", new ActionDelegate(InputHandler.DELETE));
        actionMap.put("redo", new ActionDelegate(InputHandler.REDO));
        actionMap.put("undo", new ActionDelegate(InputHandler.UNDO));
        actionMap.put("selectAll", new ActionDelegate(InputHandler.SELECT_ALL));
    }

    private Action getAction(String string) {
        ActionMap actionMap = this.getActionMap();
        return actionMap.get(string);
    }

    public void setCaretPosition(int n) {
        this.getCaretModel().setOffset(n);
    }

    public int getCaretPosition() {
        return this.getCaretModel().getOffset();
    }

    public JScrollBar getVerticalScrollBar() {
        return this._verticalScrollBar;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this._horizontalScrollBar;
    }

    public int getCorrespondingColumn(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n3 - n2;
        if (n5 != 0) {
            int n6;
            int n7;
            int n8;
            String string = null;
            if (n2 < this.getLineCount()) {
                string = this.getLineText(n2);
            }
            if (string != null) {
                n8 = 0;
                for (n7 = 0; n7 < string.length() && n7 < n; ++n7) {
                    int n9 = n6 = string.charAt(n7) == '\t' ? 1 : 0;
                    if (n6 != 0) {
                        n4 += this.getTabSize() - n8 % this.getTabSize() - 1;
                        n8 = 0;
                        continue;
                    }
                    ++n8;
                }
            }
            if (n3 < this.getLineCount()) {
                string = this.getLineText(n3);
            }
            if (string != null) {
                n7 = 0;
                n8 = 0;
                int n10 = 0;
                for (n6 = 0; n6 < string.length() && n8 < n4; ++n6) {
                    int n11;
                    int n12 = n11 = string.charAt(n6) == '\t' ? 1 : 0;
                    if (n11 != 0) {
                        n8 = n7 == 0 ? (n8 += this.getTabSize() - n10 % this.getTabSize()) : (n8 += this.getTabSize());
                        n10 = 0;
                    } else {
                        ++n8;
                        ++n10;
                    }
                    n7 = n11;
                }
                if (n8 < n4) {
                    n6 += n4 - n8;
                }
                return n6;
            }
        }
        return n4;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this._inputMethodSupport == null) {
            this._inputMethodSupport = new InputMethodSupport(this);
        }
        return new InputMethodHandleSwingThreadWrapper(this._inputMethodSupport);
    }

    public void setOverlayVisible(boolean bl) {
        Overlayable overlayable = OverlayableUtils.getOverlayable(this);
        if (overlayable != null) {
            JComponent[] jComponentArray;
            for (JComponent jComponent : jComponentArray = overlayable.getOverlayComponents()) {
                if (!(jComponent instanceof InfiniteProgressPanel)) continue;
                if (bl) {
                    ((InfiniteProgressPanel)jComponent).start();
                    continue;
                }
                ((InfiniteProgressPanel)jComponent).stop();
            }
        }
    }

    public JComponent createOverlay() {
        DefaultOverlayable defaultOverlayable = new DefaultOverlayable(this);
        InfiniteProgressPanel infiniteProgressPanel = new InfiniteProgressPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(20, 20);
            }
        };
        defaultOverlayable.addOverlayComponent(infiniteProgressPanel);
        infiniteProgressPanel.stop();
        defaultOverlayable.setOverlayVisible(false);
        return defaultOverlayable;
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        super.repaint(l, n, n2, n3, n4);
        OverlayableUtils.repaintOverlayable(this);
    }

    void logFoldingSpanErrorInfo(String string, FoldingSpan foldingSpan) {
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append("\r\n");
            if (foldingSpan != null) {
                String string2 = this.getText(foldingSpan.getEndOffset() - 1, 2);
                stringBuffer.append("span is ( ").append(foldingSpan.getStartOffset()).append(", ").append(foldingSpan.getEndOffset()).append(").").append(string2.length() == 2 && string2.charAt(0) == '\r' && string2.charAt(1) == '\n').append("\r\n");
            }
            stringBuffer.append("Folding Model is:\r\n");
            stringBuffer.append(this.getFoldingModel());
            LOGGER.fine(stringBuffer.toString());
        }
    }

    protected void customizeDialog(StandardDialog standardDialog) {
    }

    protected void customizeDialogData(StandardDialog standardDialog) {
    }

    public static void clearClipboards() {
        _clipboards.clear();
    }

    public boolean isAdjustColumnSelectionOnMouseEvent() {
        return this._adjustColumnSelectionOnMouseEvent;
    }

    public void setAdjustColumnSelectionOnMouseEvent(boolean bl) {
        this._adjustColumnSelectionOnMouseEvent = bl;
    }

    public void dispose() {
        if (this.getMarkerArea() != null) {
            this.getMarkerArea().dispose();
        }
        if (this._inputMethodSupport instanceof InputMethodSupport) {
            this.removeInputMethodListener((InputMethodSupport)this._inputMethodSupport);
        }
        this.setDocument(null);
    }

    public boolean isAutoIndent() {
        return this._autoIndent;
    }

    public void setAutoIndent(boolean bl) {
        this._autoIndent = bl;
    }

    protected boolean isIntegerScaleFactor() {
        Graphics2D graphics2D = (Graphics2D)this._painter.getGraphics();
        return graphics2D == null || JideSwingUtilities.isIntegerScaleFactor(graphics2D);
    }

    protected int getFractionalOffsetToX(int n) {
        Token token;
        Serializable serializable;
        TokenMarker tokenMarker = this.getTokenMarker();
        int n2 = this.getLineNumber(n);
        if (n2 < 0 || n2 >= this.getLineCount()) {
            return this._horizontalOffset;
        }
        if (n == 0 && n2 == 0 || !this.getLineText(n2, this.lineSegment)) {
            return this._horizontalOffset;
        }
        int n3 = n - this.getLineStartOffset(n2);
        int n4 = this.lineSegment.offset;
        int n5 = this._horizontalOffset;
        if (tokenMarker != null) {
            serializable = this._painter;
            if (((CodeEditorPainter)serializable).getCurrentLineIndex() == n2 && ((CodeEditorPainter)serializable).getCurrentLineTokens() != null) {
                token = ((CodeEditorPainter)serializable).getCurrentLineTokens();
            } else {
                ((CodeEditorPainter)serializable).setCurrentLineIndex(n2);
                token = tokenMarker.markTokens(this.lineSegment, n2);
                ((CodeEditorPainter)serializable).setCurrentLineTokens(token);
            }
        } else {
            token = new Token(this.lineSegment.count, 0);
        }
        serializable = this._painter.getFont();
        SyntaxStyleSchema syntaxStyleSchema = this.getStyles();
        byte by;
        while ((by = token.id) != 127) {
            FontMetrics fontMetrics;
            SyntaxStyle syntaxStyle = syntaxStyleSchema.getStyle(by);
            Graphics2D graphics2D = (Graphics2D)this._painter.getGraphics();
            if (graphics2D == null) {
                fontMetrics = this._painter.getFontMetrics();
            } else {
                if (syntaxStyle == null || by == 0 && syntaxStyle.getForeground() == null) {
                    if (!((Font)serializable).equals(graphics2D.getFont())) {
                        graphics2D.setFont((Font)serializable);
                    }
                } else {
                    syntaxStyle.setGraphicsFlags(graphics2D, (Font)serializable);
                }
                fontMetrics = graphics2D.getFontMetrics();
            }
            int n6 = token.length;
            if (n3 + n4 < this.lineSegment.offset + n6) {
                this.lineSegment.count = n3 - (this.lineSegment.offset - n4);
                return n5 + this.getTabbedTextWidth(this.lineSegment, fontMetrics, graphics2D);
            }
            this.lineSegment.count = n6;
            n5 += this.getTabbedTextWidth(this.lineSegment, fontMetrics, graphics2D);
            this.lineSegment.offset += n6;
            token = token.next;
        }
        return n5;
    }

    private int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, Graphics2D graphics2D) {
        if (segment.count <= 0) {
            return 0;
        }
        String string = segment.toString();
        double d = JideSwingUtilities.getScaleFactor(graphics2D);
        double d2 = (double)fontMetrics.stringWidth(" ") * d;
        double d3 = Math.ceil(d2) - d2;
        double d4 = d3 / d;
        int n = fontMetrics.stringWidth(string);
        int n2 = StringUtils.countChar(' ', string);
        return (int)Math.round((double)n - (double)n2 * d4);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(128)) {
            Lm.showInvalidProductMessage(CodeEditor.class.getName(), 128);
        }
        LOGGER = Logger.getLogger(CodeEditor.class.getName());
        LEFT_OF_SCROLLBAR = "los";
        CENTER = "center";
        RIGHT = "right";
        LEFT = "left";
        BOTTOM = "bottom";
        insets = new Insets(1, 1, 1, 1);
    }

    private static class InputMethodHandleSwingThreadWrapper
    implements InputMethodRequests {
        private final InputMethodRequests myDelegate;

        private InputMethodHandleSwingThreadWrapper(InputMethodRequests inputMethodRequests) {
            this.myDelegate = inputMethodRequests;
        }

        @Override
        public Rectangle getTextLocation(final TextHitInfo textHitInfo) {
            if (EventQueue.isDispatchThread()) {
                return this.myDelegate.getTextLocation(textHitInfo);
            }
            final Rectangle[] rectangleArray = new Rectangle[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        rectangleArray[0] = myDelegate.getTextLocation(textHitInfo);
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return rectangleArray[0];
        }

        @Override
        public TextHitInfo getLocationOffset(final int n, final int n2) {
            if (EventQueue.isDispatchThread()) {
                return this.myDelegate.getLocationOffset(n, n2);
            }
            final TextHitInfo[] textHitInfoArray = new TextHitInfo[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        textHitInfoArray[0] = myDelegate.getLocationOffset(n, n2);
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return textHitInfoArray[0];
        }

        @Override
        public int getInsertPositionOffset() {
            if (EventQueue.isDispatchThread()) {
                return this.myDelegate.getInsertPositionOffset();
            }
            final int[] nArray = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        nArray[0] = myDelegate.getInsertPositionOffset();
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return nArray[0];
        }

        @Override
        public AttributedCharacterIterator getCommittedText(final int n, final int n2, final AttributedCharacterIterator.Attribute[] attributeArray) {
            if (EventQueue.isDispatchThread()) {
                return n <= n2 ? this.myDelegate.getCommittedText(n, n2, attributeArray) : this.myDelegate.getCommittedText(n2, n, attributeArray);
            }
            final AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        attributedCharacterIteratorArray[0] = n <= n2 ? myDelegate.getCommittedText(n, n2, attributeArray) : myDelegate.getCommittedText(n2, n, attributeArray);
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return attributedCharacterIteratorArray[0];
        }

        @Override
        public int getCommittedTextLength() {
            if (EventQueue.isDispatchThread()) {
                return this.myDelegate.getCommittedTextLength();
            }
            final int[] nArray = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        nArray[0] = myDelegate.getCommittedTextLength();
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return nArray[0];
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(final AttributedCharacterIterator.Attribute[] attributeArray) {
            if (EventQueue.isDispatchThread()) {
                return this.myDelegate.getSelectedText(attributeArray);
            }
            final AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        attributedCharacterIteratorArray[0] = myDelegate.getSelectedText(attributeArray);
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getLocalizedMessage());
            }
            return attributedCharacterIteratorArray[0];
        }
    }

    private class SearchAllHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public SearchAllHighlightPainter(Color color) {
            super(color);
        }
    }

    public static class DefaultUIResourceHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    private class EditorSize {
        private boolean _recalculateNeeded;
        private Dimension _size;
        private IntArrayList _cache;
        private boolean _caretMaxWidth;

        private EditorSize() {
        }

        public void reset() {
            if (CodeEditor.this.getDocument() instanceof LazyLoadDocument) {
                this._recalculateNeeded = true;
                return;
            }
            int n = CodeEditor.this.getVisualLineCount();
            this._cache = new IntArrayList(n + 300);
            int[] nArray = new int[n];
            Arrays.fill(nArray, -1);
            this._cache.add(nArray);
            this._recalculateNeeded = true;
        }

        public void documentChanged(DocumentEvent documentEvent) {
            if (CodeEditor.this.getDocument() instanceof LazyLoadDocument) {
                this._recalculateNeeded = true;
                return;
            }
            int n = CodeEditor.this.offsetToViewPosition((int)documentEvent.getOffset()).line;
            this._recalculateNeeded = true;
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(CodeEditor.this.getDocument().getDefaultRootElement());
            int n2 = 0;
            if (elementChange != null && elementChange.getChildrenAdded() != null && elementChange.getChildrenRemoved() != null) {
                n2 = elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
            }
            boolean bl = false;
            if (n < 0) {
                bl = true;
            } else if (n2 > 0) {
                if (n >= 0 && n < this._cache.size()) {
                    this._cache.set(n, -1);
                } else if (n + 1 >= this._cache.size()) {
                    n = this._cache.size() - 1;
                }
                int[] nArray = new int[n2];
                Arrays.fill(nArray, -1);
                this._cache.insert(n + 1, nArray);
            } else if (n2 < 0 && n - n2 < this._cache.size()) {
                if (n >= 0 && n < this._cache.size() - 1) {
                    this._cache.set(n, -1);
                    this._cache.remove(n + 1, -n2);
                } else {
                    bl = true;
                }
            } else if (n2 != 0) {
                bl = true;
            } else if (n >= 0 && n < this._cache.size()) {
                this._cache.set(n, -1);
            } else {
                bl = true;
            }
            if (this._cache.size() != CodeEditor.this.getVisualLineCount()) {
                bl = true;
            }
            if (bl) {
                this.reset();
            }
            this._recalculateNeeded = true;
        }

        private void recalculate() {
            int n;
            int n2;
            if (!this._recalculateNeeded) {
                return;
            }
            SyntaxDocument syntaxDocument = CodeEditor.this.getDocument();
            if (syntaxDocument instanceof LazyLoadDocument) {
                int n3 = CodeEditor.this._painter.getFontMetrics().charWidth('w');
                this._size = new Dimension(((LazyLoadDocument)syntaxDocument).getMaxLineLength() * n3, CodeEditor.this.getLineHeight() * CodeEditor.this.getLineCount());
                if (this._size.width != 0 && this._size.height != 0) {
                    this._recalculateNeeded = false;
                }
                return;
            }
            int n4 = this._cache.size();
            int n5 = CodeEditor.this.getDocument().getLength();
            int n6 = CodeEditor.this._painter.getFontMetrics().charWidth('w');
            for (n2 = 0; n2 < n4; ++n2) {
                if (this._cache.getQuick(n2) != -1) continue;
                n = CodeEditor.this.modelPositionToOffset(CodeEditor.this.viewToModelPosition(new CaretPosition(n2 + 1, 0)));
                this._cache.set(n2, CodeEditor.this.offsetToX(Math.min(n, n5) - 1) - CodeEditor.this.getHorizontalOffset() + n6);
            }
            n2 = n6;
            for (n = 0; n < n4; ++n) {
                n2 = Math.max(n2, this._cache.getQuick(n));
            }
            CaretPosition caretPosition = CodeEditor.this.getCaretModel().getViewPosition();
            int n7 = CodeEditor.this.columnToX(caretPosition.line, caretPosition.column);
            int n8 = n7 - CodeEditor.this.getHorizontalOffset();
            if (n8 > n2) {
                n2 = n8;
                this._caretMaxWidth = true;
            } else {
                this._caretMaxWidth = false;
            }
            this._size = new Dimension(n2, CodeEditor.this.getLineHeight() * n4);
            this._recalculateNeeded = false;
        }

        public Dimension getContentSize() {
            this.recalculate();
            return this._size;
        }
    }

    private class MessagePopupBorder
    implements Border {
        private MessagePopupBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
            graphics.drawLine(0, n4 - 1, n3, n4 - 1);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4);
            graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
            graphics.drawLine(0, 0, n3, 0);
            graphics.drawLine(0, 0, 0, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    class MouseWheelHandler
    implements MouseWheelListener {
        MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JScrollBar jScrollBar = CodeEditor.this.getVerticalScrollBar();
            int n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
            boolean bl = true;
            if (mouseWheelEvent.isShiftDown() && SystemInfo.isAnyMac()) {
                jScrollBar = CodeEditor.this.getHorizontalScrollBar();
                bl = false;
            } else if (jScrollBar == null || !jScrollBar.isVisible()) {
                jScrollBar = CodeEditor.this.getHorizontalScrollBar();
                if (jScrollBar == null || !jScrollBar.isVisible()) {
                    return;
                }
                bl = false;
            }
            mouseWheelEvent.consume();
            if (mouseWheelEvent.getScrollType() == 0) {
                int n2;
                int n3 = Math.abs(mouseWheelEvent.getUnitsToScroll());
                boolean bl2 = Math.abs(mouseWheelEvent.getWheelRotation()) == 1;
                boolean bl3 = CodeEditor.this.getComponentOrientation().isLeftToRight();
                int n4 = jScrollBar.getMinimum();
                int n5 = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent();
                if (bl2) {
                    int n6 = n2 = bl ? CodeEditor.this.getVisibleLines() : 20;
                    if (n < 0) {
                        n4 = Math.max(n4, jScrollBar.getValue() - n2);
                    } else {
                        n5 = Math.min(n5, jScrollBar.getValue() + n2);
                    }
                }
                if (!bl3 && !bl) {
                    n = -n;
                }
                n2 = bl ? CodeEditor.this.getFirstLine() : -CodeEditor.this.getHorizontalOffset();
                for (int i = 0; i < n3; ++i) {
                    int n7;
                    int n8 = n7 = bl ? 1 : 4;
                    if (n < 0) {
                        if ((n2 -= n7) > n4) continue;
                        n2 = n4;
                        break;
                    }
                    if ((n2 += n7) < n5) continue;
                    n2 = n5;
                    break;
                }
                if (bl) {
                    CodeEditor.this.setFirstLine(n2);
                } else {
                    CodeEditor.this.setHorizontalOffset(-n2);
                }
            } else if (mouseWheelEvent.getScrollType() == 1) {
                int n9 = CodeEditor.this.getVisibleLines() * (n > 0 ? 1 : -1);
                CodeEditor.this.setFirstLine(CodeEditor.this.getFirstLine() + n9);
            }
        }
    }

    class CaretUndo
    extends AbstractUndoableEdit {
        private int start;
        private int end;
        private static final long serialVersionUID = -2565588001384646576L;

        CaretUndo(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public String getPresentationName() {
            return "caret move";
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            CodeEditor.this.select(this.start, this.end);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            CodeEditor.this.select(this.start, this.end);
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof CaretUndo) {
                CaretUndo caretUndo = (CaretUndo)undoableEdit;
                this.start = caretUndo.start;
                this.end = caretUndo.end;
                caretUndo.die();
                return true;
            }
            return false;
        }
    }

    class MouseHandler
    implements MouseInputListener {
        private boolean _dragging = false;
        private boolean _dragged = false;
        private transient Cursor _savedCursor = null;

        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            if (!CodeEditor.this.isEnabled()) {
                return;
            }
            boolean bl = CodeEditor.this.requestFocusInWindow();
            if (!bl) {
                object = new Runnable(){

                    @Override
                    public void run() {
                        CodeEditor.this.requestFocusInWindow();
                    }
                };
                SwingUtilities.invokeLater((Runnable)object);
            }
            CodeEditor.this.setCaretVisible(true);
            if (mouseEvent.isPopupTrigger() && (object = CodeEditor.this.getComponentPopupMenu()) != null) {
                ((JPopupMenu)object).show(CodeEditor.this._painter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n;
                int n2;
                int n3 = CodeEditor.this.yToLine(mouseEvent.getY());
                if (n3 >= CodeEditor.this.getVisualLineCount()) {
                    CodeEditor.this.getSelectionModel().clearSelection();
                    int n4 = Math.max(CodeEditor.this.xToColumn(CodeEditor.this.getVisualLineCount() - 1, mouseEvent.getX()), CodeEditor.this.offsetToViewPosition((int)CodeEditor.this.getDocumentLength()).column);
                    if (CodeEditor.this.isVirtualSpaceAllowed()) {
                        CodeEditor.this.getCaretModel().setViewPosition(new CaretPosition(CodeEditor.this.getVisualLineCount() - 1, n4));
                    } else {
                        CodeEditor.this.getCaretModel().setOffset(CodeEditor.this.getDocumentLength());
                    }
                    return;
                }
                if (CodeEditor.this.isVirtualSpaceAllowed()) {
                    n2 = CodeEditor.this.xToColumn(n3, mouseEvent.getX());
                    CaretPosition caretPosition = CodeEditor.this.viewToModelPosition(new CaretPosition(n3, n2));
                    n = CodeEditor.this.modelPositionToOffset(caretPosition);
                } else {
                    n = CodeEditor.this.xToOffset(n3, mouseEvent.getX());
                    CaretPosition caretPosition = CodeEditor.this.offsetToModelPosition(n);
                    n2 = CodeEditor.this.modelToViewPosition((CaretPosition)caretPosition).column;
                }
                switch (mouseEvent.getClickCount()) {
                    case 1: {
                        this.doSingleClick(mouseEvent, n3, n2, n);
                        CodeEditor.this._lineSelection = -1;
                        break;
                    }
                    case 2: {
                        if (!SwingUtilities.isLeftMouseButton(mouseEvent) && !SwingUtilities.isMiddleMouseButton(mouseEvent)) break;
                        try {
                            this.doDoubleClick(mouseEvent, n3, n2, n);
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.warning(badLocationException.getLocalizedMessage());
                        }
                        CodeEditor.this._lineSelection = -1;
                        break;
                    }
                    case 3: {
                        if (!SwingUtilities.isLeftMouseButton(mouseEvent) && !SwingUtilities.isMiddleMouseButton(mouseEvent)) break;
                        this.doTripleClick(mouseEvent, n3, n2, n);
                        CodeEditor.this._lineSelection = n3;
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if (!CodeEditor.this.isEnabled()) {
                return;
            }
            if (mouseEvent.isPopupTrigger() && (jPopupMenu = CodeEditor.this.getComponentPopupMenu()) != null) {
                jPopupMenu.show(CodeEditor.this._painter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this._dragging && this._dragged) {
                    int n = CodeEditor.this.xyToOffset(mouseEvent.getX(), mouseEvent.getY());
                    CodeEditor.this.dragSelectedTextTo(n, mouseEvent);
                    if (this._savedCursor != null) {
                        CodeEditor.this._painter.setCursor(this._savedCursor);
                    }
                } else if (this._dragging && !this._dragged) {
                    CodeEditor.this.getSelectionModel().clearSelection();
                }
                this._dragging = false;
                this._dragged = false;
                CodeEditor.this._lineSelection = -1;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if (!CodeEditor.this.isEnabled()) {
                return;
            }
            if (mouseEvent.isPopupTrigger() && (jPopupMenu = CodeEditor.this.getComponentPopupMenu()) != null) {
                jPopupMenu.show(CodeEditor.this._painter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            if (!CodeEditor.this.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (SystemInfo.isJdk15Above() && (jPopupMenu = CodeEditor.this.getComponentPopupMenu()) != null && jPopupMenu.isVisible()) {
                return;
            }
            int n = CodeEditor.this.xyToOffset(mouseEvent.getX(), mouseEvent.getY());
            if (SwingUtilities.isLeftMouseButton(mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                if (this._dragging) {
                    if (!this._dragged) {
                        this._savedCursor = CodeEditor.this._painter.getCursor();
                        CodeEditor.this._painter.setCursor(JideCursors.getPredefinedCursor(33));
                    }
                    this._dragged = true;
                    CodeEditor.this.getCaretModel().setOffset(n);
                    CodeEditor.this.scrollToCaret();
                } else {
                    int n2 = CodeEditor.this.yToLine(mouseEvent.getY());
                    if (n2 >= CodeEditor.this.getLineCount()) {
                        return;
                    }
                    int n3 = CodeEditor.this.xToColumn(n2, mouseEvent.getX());
                    if (CodeEditor.this.isAdjustColumnSelectionOnMouseEvent()) {
                        CodeEditor.this.setSelectionRectangular(CodeEditor.this.isColumnSelectionMode(mouseEvent));
                    }
                    CodeEditor.this.select(n, n2, n3);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this._dragged = false;
            this._dragging = false;
            this._savedCursor = null;
        }

        private void doSingleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            if ((mouseEvent.getModifiers() & 1) != 0) {
                if (CodeEditor.this.isAdjustColumnSelectionOnMouseEvent()) {
                    CodeEditor.this.getSelectionModel().setColumnSelectionMode(CodeEditor.this.isColumnSelectionMode(mouseEvent));
                }
                if (CodeEditor.this.isSelectionRectangular()) {
                    CodeEditor.this.select(CodeEditor.this.getMarkViewPosition(), new CaretPosition(n, n2));
                } else {
                    int n4 = CodeEditor.this.getAnchorSelectionOffset();
                    int n5 = CodeEditor.this.getLeadSelectionOffset();
                    if (n3 < n4) {
                        CodeEditor.this.select(Math.max(n4, n5), n3);
                    } else {
                        CodeEditor.this.select(Math.min(n4, n5), n3);
                    }
                }
            } else {
                TransferHandler transferHandler = null;
                Transferable transferable = null;
                CodeEditor codeEditor = null;
                if (SwingUtilities.isMiddleMouseButton(mouseEvent) && mouseEvent.getSource() instanceof CodeEditorPainter && (codeEditor = ((CodeEditorPainter)mouseEvent.getSource()).getCodeEditor()) != null) {
                    try {
                        Toolkit toolkit = codeEditor.getToolkit();
                        Clipboard clipboard = toolkit.getSystemSelection();
                        if (clipboard != null && (transferHandler = codeEditor.getTransferHandler()) != null) {
                            try {
                                transferable = clipboard.getContents(null);
                            }
                            catch (IllegalStateException illegalStateException) {
                                UIManager.getLookAndFeel().provideErrorFeedback(codeEditor);
                            }
                        }
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
                if (n3 <= CodeEditor.this.getSelectionStart() || n3 >= CodeEditor.this.getSelectionEnd()) {
                    CodeEditor.this.getSelectionModel().clearSelection();
                } else if (CodeEditor.this.isEnabled()) {
                    this._dragging = true;
                }
                CodeEditor.this.getCaretModel().setViewPosition(new CaretPosition(n, n2));
                CodeEditor.this.setMagicCaretPosition(CodeEditor.this.columnToX(n, n2));
                if (transferable != null && transferHandler != null && codeEditor != null) {
                    transferHandler.importData(codeEditor, transferable);
                }
            }
        }

        private void doDoubleClick(MouseEvent mouseEvent, int n, int n2, int n3) throws BadLocationException {
            int n4;
            int n5;
            if (CodeEditor.this.isAdjustColumnSelectionOnMouseEvent()) {
                CodeEditor.this.getSelectionModel().setColumnSelectionMode(CodeEditor.this.isColumnSelectionMode(mouseEvent));
            }
            if (CodeEditor.this.getLineLength(n5 = CodeEditor.this.viewToModelLine(n)) == 0) {
                return;
            }
            try {
                n4 = TextUtils.findMatchingBracket(CodeEditor.this._document, Math.max(0, n3 - 1));
                if (n4 != -1) {
                    int n6 = CodeEditor.this.getMarkPosition();
                    if (n4 > n6) {
                        ++n4;
                        --n6;
                    }
                    CodeEditor.this.select(n6, n4);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                LOGGER.warning(badLocationException.getLocalizedMessage());
            }
            n4 = CodeEditor.this.getLineStartOffset(n5);
            FoldingState foldingState = new FoldingState(CodeEditor.this, n4);
            int n7 = CodeEditor.this.getLineEndOffset(n5);
            if (n7 >= foldingState.getEndOffset() && n4 > foldingState.getStartOffset()) {
                foldingState.advance();
            } else if (n7 >= foldingState.getEndOffset() && n4 == foldingState.getStartOffset() && foldingState.getCurrentFold() == null) {
                foldingState.advance();
            }
            if (foldingState.getCurrentFold() != null && foldingState.getStartOffset() - n4 < n2) {
                n5 = CodeEditor.this.viewToModelLine(n + 1) - 1;
                n4 = CodeEditor.this.getLineStartOffset(n5);
            }
            String string = CodeEditor.this.getLineText(n5);
            int n8 = 0;
            int n9 = string.length();
            int n10 = CodeEditor.this.getLineEndOffsetExcludeLineBreak(n5);
            if (string.length() > 0) {
                if (n2 <= n10) {
                    int n11;
                    int n12 = n3 - n4;
                    if (n12 < 1) {
                        LOGGER.fine("CodeEditor: column should not be less than 1");
                        n12 = 1;
                    } else if (n12 > string.length()) {
                        LOGGER.fine("CodeEditor: column should not be larger than the line length");
                        n12 = string.length();
                    }
                    char c = string.charAt(n12 - 1);
                    String string2 = (String)CodeEditor.this._document.getProperty("nonwordDelimiters");
                    if (string2 == null) {
                        string2 = "";
                    }
                    boolean bl = !Character.isLetterOrDigit(c) && string2.indexOf(c) == -1;
                    for (n11 = n12 - 1; n11 >= 0; --n11) {
                        c = string.charAt(n11);
                        if (!(bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1))) continue;
                        n8 = n11 + 1;
                        break;
                    }
                    for (n11 = n12; n11 < string.length(); ++n11) {
                        c = string.charAt(n11);
                        if (!(bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1))) continue;
                        n9 = n11;
                        break;
                    }
                } else {
                    n8 = CodeEditor.this.getLineStartOffsetNoSpace(n5) - n4;
                }
                CodeEditor.this.select(n4 + n8, n4 + n9);
            }
        }

        private void doTripleClick(MouseEvent mouseEvent, int n, int n2, int n3) {
            int n4 = CodeEditor.this.getLineStartOffset(CodeEditor.this.viewToModelLine(n));
            int n5 = CodeEditor.this.getLineEndOffset(CodeEditor.this.viewToModelLine(n + 1) - 1);
            if (n4 >= 0 && n5 >= n4) {
                CodeEditor.this.select(n4, n5 + 1);
            }
            CodeEditor.this.getCaretModel().setViewPosition(new CaretPosition(n, n2));
            CodeEditor.this.setMagicCaretPosition(CodeEditor.this.columnToX(n, n2));
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            CodeEditor.this.setCaretVisible(true);
            CodeEditor.this.blinkCaret();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CodeEditor.this.setCaretVisible(false);
        }
    }

    class DocumentHandler
    implements DocumentListener,
    PageLoadListener {
        DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            CodeEditor.this.documentChanged(documentEvent);
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            if (!CodeEditor.this.getSelectionModel().hasSelection()) {
                CodeEditor.this.select(n + n2, n + n2);
            } else {
                int n3 = CodeEditor.this.getSelectionStart() > n || CodeEditor.this.getSelectionStart() == CodeEditor.this.getSelectionEnd() && CodeEditor.this.getSelectionStart() == n ? CodeEditor.this.getSelectionStart() + n2 : CodeEditor.this.getSelectionStart();
                int n4 = CodeEditor.this.getSelectionEnd() >= n ? CodeEditor.this.getSelectionEnd() + n2 : CodeEditor.this.getSelectionEnd();
                CodeEditor.this.select(n3, n4);
            }
            CodeEditor.this.getPainter().invalidateLineRange(CodeEditor.this.getFirstLine(), CodeEditor.this.getFirstLine() + CodeEditor.this.getVisibleLines());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            CodeEditor.this.documentChanged(documentEvent);
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            if (!CodeEditor.this.getSelectionModel().hasSelection()) {
                CodeEditor.this.select(n, n);
            } else {
                int n3 = CodeEditor.this.getSelectionStart();
                int n4 = CodeEditor.this.getSelectionEnd();
                int n5 = n3 > n ? (n3 > n + n2 ? n3 - n2 : n) : n3;
                int n6 = n4 > n ? (n4 > n + n2 ? n4 - n2 : n) : n4;
                CodeEditor.this.select(n5, n6);
            }
            CodeEditor.this.getPainter().invalidateLineRange(CodeEditor.this.getFirstLine(), CodeEditor.this.getFirstLine() + CodeEditor.this.getVisibleLines());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            CodeEditor.this.getPainter().invalidateLineRange(CodeEditor.this.getFirstLine(), CodeEditor.this.getFirstLine() + CodeEditor.this.getVisibleLines());
        }

        @Override
        public void pageLoadingStart(PageLoadEvent pageLoadEvent) {
            if (pageLoadEvent.isPageLoadThread()) {
                CodeEditor.this.setOverlayVisible(true);
                CodeEditor.this.setContentVisible(false);
                CodeEditor.this.repaint();
            }
        }

        @Override
        public void pageLoaded(PageLoadEvent pageLoadEvent) {
            if (pageLoadEvent.isPageLoadThread()) {
                CodeEditor.this.setOverlayVisible(false);
                CodeEditor.this.setContentVisible(true);
                CodeEditor.this.repaint();
            }
        }

        @Override
        public void pageLoadFailed(PageLoadEvent pageLoadEvent) {
            CodeEditor.this.pageLoadFailedHandling(pageLoadEvent);
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (CodeEditor.this.getDocument() == null) {
                return;
            }
            CodeEditor.this.recalculateVisibleLines();
            CodeEditor.this._scrollBarsInitialized = true;
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(final AdjustmentEvent adjustmentEvent) {
            if (!CodeEditor.this._scrollBarsInitialized) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (adjustmentEvent.getAdjustable() == CodeEditor.this._verticalScrollBar) {
                        CodeEditor.this.setFirstLine(CodeEditor.this._verticalScrollBar.getValue());
                    } else {
                        CodeEditor.this.setHorizontalOffset(-CodeEditor.this._horizontalScrollBar.getValue());
                    }
                }
            });
            if (!CodeEditor.this.isDelayContentsOnLoading() || !(CodeEditor.this.getDocument() instanceof LazyLoadDocument) || CodeEditor.this.getDocument().isLineLoaded(CodeEditor.this._verticalScrollBar.getValue())) {
                return;
            }
            if (CodeEditor.this._repaintTimer == null) {
                CodeEditor.this._repaintTimer = CodeEditor.this.createRepaintTimer();
            }
            CodeEditor.this._repaintTimer.restart();
            CodeEditor.this.setContentVisible(false);
        }
    }

    class ScrollLayout
    implements LayoutManager {
        private Component left;
        private Component center;
        private Component right;
        private Component bottom;
        private Vector<Component> leftOfScrollBar = new Vector();

        ScrollLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLayoutComponent(String string, Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (string.equals(CENTER)) {
                    this.center = component;
                } else if (string.equals(RIGHT)) {
                    this.right = component;
                } else if (string.equals(BOTTOM)) {
                    this.bottom = component;
                } else if (string.equals(LEFT)) {
                    this.left = component;
                } else if (string.equals(LEFT_OF_SCROLLBAR)) {
                    this.leftOfScrollBar.addElement(component);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLayoutComponent(Component component) {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (this.center == component) {
                    this.center = null;
                }
                if (this.right == component) {
                    this.right = null;
                }
                if (this.bottom == component) {
                    this.bottom = null;
                }
                if (this.left == component) {
                    this.left = null;
                } else {
                    this.leftOfScrollBar.removeElement(component);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension;
                Dimension dimension2 = new Dimension();
                Insets insets = CodeEditor.this.getInsets();
                dimension2.width = insets.left + insets.right;
                dimension2.height = insets.top + insets.bottom;
                Dimension dimension3 = this.center.getPreferredSize();
                dimension2.width += dimension3.width;
                dimension2.height += dimension3.height;
                if (this.right.isVisible()) {
                    dimension = this.right.getPreferredSize();
                    dimension2.width += dimension.width;
                }
                if (this.bottom.isVisible()) {
                    dimension = this.bottom.getPreferredSize();
                    dimension2.height += dimension.height;
                }
                if (this.left != null) {
                    dimension = this.left.getPreferredSize();
                    dimension2.width += dimension.width;
                }
                return dimension2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension;
                Dimension dimension2 = new Dimension();
                Insets insets = CodeEditor.this.getInsets();
                dimension2.width = insets.left + insets.right;
                dimension2.height = insets.top + insets.bottom;
                Dimension dimension3 = this.center.getMinimumSize();
                dimension2.width += dimension3.width;
                dimension2.height += dimension3.height;
                if (this.right.isVisible()) {
                    dimension = this.right.getMinimumSize();
                    dimension2.width += dimension.width;
                }
                if (this.bottom.isVisible()) {
                    dimension = this.bottom.getMinimumSize();
                    dimension2.height += dimension.height;
                }
                if (this.left != null) {
                    dimension = this.left.getMinimumSize();
                    dimension2.width += dimension.width;
                }
                return dimension2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = container.getSize();
                Insets insets = container.getInsets();
                int n = insets.top;
                int n2 = insets.left;
                int n3 = insets.bottom;
                int n4 = insets.right;
                int n5 = this.left != null ? this.left.getPreferredSize().width : 0;
                int n6 = this.right != null && this.right.isVisible() ? this.right.getPreferredSize().width : 0;
                int n7 = this.bottom != null && this.bottom.isVisible() ? this.bottom.getPreferredSize().height : 0;
                int n8 = dimension.width - n6 - n2 - n4 - n5;
                int n9 = dimension.height - n7 - n - n3;
                if (this.left != null) {
                    this.left.setBounds(n2, n, n5, n9);
                }
                n2 += n5;
                if (this.center != null) {
                    this.center.setBounds(n2, n, n8, n9);
                }
                if (this.right != null && this.right.isVisible()) {
                    this.right.setBounds(n2 + n8, n, n6, n9);
                }
                for (Component component : this.leftOfScrollBar) {
                    Dimension dimension2 = component.getPreferredSize();
                    component.setBounds(n2, n + n9, dimension2.width, n7);
                    n2 += dimension2.width;
                }
                if (this.bottom != null && this.bottom.isVisible()) {
                    this.bottom.setBounds(n2, n + n9, dimension.width - n6 - n2 - n4, n7);
                }
            }
        }
    }
}

