/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.TdiDockingManager;
import com.jidesoft.document.TdiGroup;
import com.jidesoft.document.TdiUtils;
import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class TdiMouseInputAdapter
extends MouseInputAdapter
implements SwingConstants {
    private boolean _discardRelease = false;
    private DocumentPane _documentPane;
    private JComponent _tdiGroup;
    private TdiDockingManager _dockingManager;
    private Rectangle[] _savedTabRects;

    public TdiMouseInputAdapter(JComponent jComponent) {
        this._tdiGroup = jComponent;
    }

    public void dispose() {
        this._tdiGroup = null;
        this._documentPane = null;
        this._savedTabRects = null;
        this._dockingManager = null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showContextMenu(mouseEvent);
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this._documentPane == null) {
            this._documentPane = (DocumentPane)this._tdiGroup.getParent();
            this._dockingManager = this._documentPane.getTdiDockingManager();
        }
        if (this._documentPane == null) {
            return;
        }
        if (this._documentPane.isReorderAllowed()) {
            TdiGroup tdiGroup = (TdiGroup)this._tdiGroup;
            this._dockingManager.beginDragging(this._documentPane, tdiGroup, tdiGroup.getUI().tabForCoordinate(tdiGroup, mouseEvent.getX(), mouseEvent.getY()));
            this._savedTabRects = new Rectangle[tdiGroup.getTabCount()];
            for (int i = 0; i < this._savedTabRects.length; ++i) {
                this._savedTabRects[i] = tdiGroup.getUI().getTabBounds(tdiGroup, i);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point;
        Serializable serializable;
        Component component;
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this._documentPane == null) {
            return;
        }
        if (this._documentPane.isReorderAllowed() && (component = ((JideTabbedPaneUI)(serializable = (JideTabbedPane)mouseEvent.getSource()).getUI()).getTabPanel()).contains(point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), component))) {
            this._dockingManager.pauseDragging();
            TdiGroup tdiGroup = (TdiGroup)TdiUtils.getGroupOf((Component)mouseEvent.getSource(), this._documentPane);
            if (tdiGroup != null && mouseEvent.getSource() == tdiGroup && tdiGroup.getTabCount() > 1 && this._savedTabRects != null) {
                int n = -1;
                for (int i = 0; i < this._savedTabRects.length; ++i) {
                    if (!this._savedTabRects[i].contains(mouseEvent.getPoint())) continue;
                    n = i;
                    break;
                }
                if (n != -1 && n != tdiGroup.getSelectedIndex()) {
                    DocumentComponent documentComponent = this._documentPane.getDocument(this._documentPane.getNameOf(tdiGroup.getSelectedDocument()));
                    DocumentComponent documentComponent2 = this._documentPane.getDocument(this._documentPane.getNameOf(tdiGroup.getDocumentAt(n)));
                    if (documentComponent.allowMoving() && (this._documentPane.isDragPassUnmovableAllowed() || documentComponent2.allowMoving())) {
                        documentComponent.fireDocumentComponentEvent(6004);
                        tdiGroup.moveSelectedTabTo(n);
                        for (int i = 0; i < tdiGroup.getTabCount(); ++i) {
                            Component component2 = tdiGroup.getComponentAt(i);
                            tdiGroup.updateTitle(this._documentPane.getDocument(this._documentPane.getNameOf(component2)));
                        }
                        documentComponent.fireDocumentComponentEvent(6005);
                    }
                }
            }
            return;
        }
        serializable = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), this._documentPane);
        if (this._documentPane != null) {
            this._dockingManager.drag(this._documentPane, ((Point)serializable).x, ((Point)serializable).y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showContextMenu(mouseEvent);
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this._documentPane == null) {
            return;
        }
        if (this._discardRelease) {
            this._discardRelease = false;
        } else {
            this._dockingManager.endDragging((Component)mouseEvent.getSource(), mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._documentPane == null) {
            Container container = this._tdiGroup.getParent();
            this._documentPane = container instanceof DocumentPane ? (DocumentPane)container : ((FloatingDocumentContainer)((Object)this._tdiGroup.getTopLevelAncestor())).getDocumentPane();
            this._dockingManager = this._documentPane.getTdiDockingManager();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._documentPane == null) {
            this._documentPane = (DocumentPane)this._tdiGroup.getParent();
            this._dockingManager = this._documentPane.getTdiDockingManager();
        }
        if (this._documentPane == null) {
            return;
        }
        this._documentPane.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showContextMenu(mouseEvent);
        }
    }

    private void showContextMenu(MouseEvent mouseEvent) {
        int n;
        Component component = (Component)mouseEvent.getSource();
        TdiGroup tdiGroup = (TdiGroup)TdiUtils.getGroupOf(component, this._documentPane);
        if (tdiGroup != null && (n = tdiGroup.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY())) >= 0 && n < tdiGroup.getTabCount()) {
            Component component2 = tdiGroup.getComponentAt(n);
            this._dockingManager.showContextMenu(component, mouseEvent.getPoint(), tdiGroup, component2, true);
        }
    }
}

